/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.dialogs.ExpansionType;
import org.eclipse.gmf.runtime.diagram.ui.commands.PopupMenuCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ElementTypeLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.ShowRelatedElementsRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.ConnectionCreationTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConnectionHandleTool
extends ConnectionCreationTool
implements DragTracker {
    private static final int NO_RELATED_ELEMENTS_DISPLAY_TIME = 2000;
    private ConnectionHandle connectionHandle;
    static /* synthetic */ Class class$0;

    public ConnectionHandleTool(ConnectionHandle connectionHandle) {
        this.connectionHandle = connectionHandle;
    }

    protected Request createTargetRequest() {
        if (this.getConnectionHandle().isIncoming()) {
            CreateUnspecifiedTypeConnectionRequest request = new CreateUnspecifiedTypeConnectionRequest(ModelingAssistantService.getInstance().getRelTypesOnTarget((IAdaptable)this.getConnectionHandle().getOwner()), true, this.getPreferencesHint());
            request.setDirectionReversed(true);
            return request;
        }
        return new CreateUnspecifiedTypeConnectionRequest(ModelingAssistantService.getInstance().getRelTypesOnSource((IAdaptable)this.getConnectionHandle().getOwner()), true, this.getPreferencesHint());
    }

    protected Command getCommand() {
        if (this.getConnectionHandle().isIncoming()) {
            CreateUnspecifiedTypeConnectionRequest unspecifiedTypeRequest = (CreateUnspecifiedTypeConnectionRequest)this.getTargetRequest();
            unspecifiedTypeRequest.setDirectionReversed(true);
        }
        return super.getCommand();
    }

    protected boolean handleButtonUp(int button) {
        if (this.getDragMoveDelta().equals(0, 0)) {
            return true;
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleDoubleClick(int button) {
        this.eraseSourceFeedback();
        this.setAvoidDeactivation(true);
        List relatedShapes = this.executeShowRelatedElementsCommand();
        if (relatedShapes != null && relatedShapes.size() < 2) {
            this.signalNoRelatedElements();
        }
        this.setAvoidDeactivation(false);
        this.deactivate();
        return true;
    }

    protected List executeShowRelatedElementsCommand() {
        List popupContent;
        IGraphicalEditPart targetEP = (IGraphicalEditPart)this.getTargetEditPart();
        DiagramEditPart diagramEP = ((DiagramEditDomain)targetEP.getDiagramEditDomain()).getDiagramEditorPart().getDiagramEditPart();
        List list = popupContent = this.getConnectionHandle().isIncoming() ? ModelingAssistantService.getInstance().getRelTypesForSREOnTarget((IAdaptable)targetEP) : ModelingAssistantService.getInstance().getRelTypesForSREOnSource((IAdaptable)targetEP);
        if (popupContent.isEmpty()) {
            return null;
        }
        ElementTypeLabelProvider labelProvider = new ElementTypeLabelProvider(){

            public String getText(Object element) {
                String elementName = super.getText(element);
                if (element instanceof IElementType) {
                    String theInputStr = DiagramUIMessages.ConnectionHandle_Popup_ShowRelatedXRelationships;
                    String text = NLS.bind((String)theInputStr, (Object)elementName);
                    return text;
                }
                return elementName;
            }
        };
        PopupMenu popupMenu = new PopupMenu(popupContent, (ILabelProvider)labelProvider);
        PopupMenuCommand popupCmd = new PopupMenuCommand("", Display.getCurrent().getActiveShell(), popupMenu);
        try {
            popupCmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            DiagramUIPlugin diagramUIPlugin = DiagramUIPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIPlugin, (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"executeShowRelatedElementsCommand", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeShowRelatedElementsCommand", (Throwable)e);
            return null;
        }
        if (!popupCmd.getCommandResult().getStatus().isOK()) {
            return null;
        }
        Object result = popupCmd.getCommandResult().getReturnValue();
        if (result instanceof IElementType) {
            ExpansionType expansionType = this.getConnectionHandle().isIncoming() ? ExpansionType.INCOMING : ExpansionType.OUTGOING;
            ShowRelatedElementsRequest showRelatedRequest = new ShowRelatedElementsRequest(Collections.singletonList(targetEP), Collections.singletonList(result), false, 1, expansionType);
            Command sreCommand = diagramEP.getCommand(showRelatedRequest);
            if (sreCommand == null) {
                return null;
            }
            CompoundCommand cc = new CompoundCommand(sreCommand.getLabel());
            cc.add(sreCommand);
            ArrangeRequest request = new ArrangeRequest("arrange_deferred");
            request.setViewAdaptersToArrange(showRelatedRequest.getRelatedShapes());
            Command arrangeCommand = diagramEP.getCommand(request);
            cc.add(arrangeCommand);
            this.executeWithProgressMonitor((Command)cc);
            return showRelatedRequest.getRelatedShapes();
        }
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"To Be Implemented", (String)"The Show Related Elements Dialog will popup.");
        return null;
    }

    protected void executeWithProgressMonitor(final Command command) {
        final DiagramCommandStack commandStack = ((IGraphicalEditPart)this.getTargetEditPart()).getDiagramEditDomain().getDiagramCommandStack();
        try {
            new ProgressMonitorDialog(null).run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    commandStack.execute(command, monitor);
                }
            });
        }
        catch (InvocationTargetException ite) {
            DiagramUIPlugin diagramUIPlugin = DiagramUIPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIPlugin, (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"executeWithProgressMonitor", (Throwable)ite);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"executeWithProgressMonitor", (Throwable)ite);
        }
        catch (InterruptedException ie) {
            DiagramUIPlugin diagramUIPlugin = DiagramUIPlugin.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((Plugin)diagramUIPlugin, (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, (Class)clazz, (String)"executeWithProgressMonitor", (Throwable)ie);
        }
    }

    protected void signalNoRelatedElements() {
        this.getConnectionHandle().addErrorIcon();
        Display.getCurrent().timerExec(2000, new Runnable(){

            public void run() {
                ConnectionHandleTool.this.getConnectionHandle().removeErrorIcon();
            }
        });
    }

    protected ConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }
}

