/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.part;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditorInput;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;

public class GMFMapMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        IEditorInput editorInput;
        try {
            editorInput = editorRef.getEditorInput();
        }
        catch (PartInitException partInitException) {
            return false;
        }
        if (editorInput.equals(input)) {
            return true;
        }
        IEditorPart editor = editorRef.getEditor(false);
        if (input instanceof DiagramEditorInput && editor instanceof GMFMapDiagramEditor) {
            Diagram editorDiagram = ((GMFMapDiagramEditor)editor).getDiagram();
            Diagram otherDiagram = ((DiagramEditorInput)input).getDiagram();
            return this.equals(editorDiagram, otherDiagram);
        }
        return false;
    }

    private boolean equals(Diagram editorDiagram, Diagram otherDiagram) {
        Resource editorResource = editorDiagram.eResource();
        Resource otherResource = otherDiagram.eResource();
        if (editorResource != null && otherResource != null) {
            URI editorURI = editorResource.getURI();
            URI otherURI = otherResource.getURI();
            String editorURIFragment = editorResource.getURIFragment((EObject)editorDiagram);
            String otherURIFragment = otherResource.getURIFragment((EObject)otherDiagram);
            return editorURI.equals((Object)otherURI) && editorURIFragment.equals(otherURIFragment);
        }
        return false;
    }
}

