/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import junit.framework.TestCase;
import org.eclipse.gmf.tests.JobTracker;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.swt.widgets.Display;

public abstract class CleanupTest
extends TestCase {
    public CleanupTest(String name) {
        super(name);
    }

    protected abstract void performCleanup() throws Exception;

    protected final void runTest() throws Throwable {
        try {
            JobTracker jt = new JobTracker();
            jt.start();
            this.performCleanup();
            jt.freeze();
            if (!Utils.dispatchDisplayMessages(jt.getNonEmptyCondition(), 10)) {
                System.err.println("Timeout while waiting for jobs to complete");
            }
            jt.stop();
            final boolean[] waitForLegacyActionPersistence = new boolean[]{true};
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    waitForLegacyActionPersistence[0] = false;
                }
            });
            Utils.dispatchDisplayMessages(waitForLegacyActionPersistence, 10);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            CleanupTest.fail((String)("cleanup failed:" + ex.getClass().getSimpleName() + ":" + ex.getMessage()));
        }
    }
}

