/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.Path;
import org.eclipse.draw2d.graph.ShortestPathRouter;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.draw2d.ui.graph.GraphUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EdgesRouter {
    private DirectedGraph g;
    private static int OBSTACLE_WIDTH = 10000;

    public EdgesRouter(DirectedGraph g) {
        this.g = g;
    }

    void routeEdges() {
        int i = 0;
        while (i < this.g.nodes.size()) {
            this.routeEdgesFromNode(this.g.nodes.getNode(i));
            ++i;
        }
    }

    private void routeEdgesFromNode(Node n) {
        ArrayList<Edge> leftEdges = new ArrayList<Edge>();
        ArrayList<Edge> rightEdges = new ArrayList<Edge>();
        int rankHeight = GraphUtilities.getRankHeightFromNode(n, this.g);
        int i = 0;
        while (i < n.outgoing.size()) {
            Edge e = n.outgoing.getEdge(i);
            if (this.shouldAccountForObstaclesInSourceRank(e, rankHeight)) {
                Node guideNode = e.vNodes == null ? e.target : e.vNodes.getNode(0);
                int diff = guideNode.x + guideNode.getOffsetIncoming() - e.source.x - e.source.getOffsetOutgoing();
                if (n.getLeft() != null && diff < 0) {
                    leftEdges.add(e);
                } else if (n.getRight() != null && diff > 0) {
                    rightEdges.add(e);
                } else {
                    this.routeEdge(e, null);
                }
            } else {
                this.routeEdge(e, null);
            }
            ++i;
        }
        Collections.sort(leftEdges, new EdgeComparator(false));
        Collections.sort(rightEdges, new EdgeComparator(true));
        this.routeLeftEdges(leftEdges, n);
        this.routeRightEdges(rightEdges, n);
    }

    private boolean shouldAccountForObstaclesInSourceRank(Edge e, int rankHeight) {
        if (rankHeight == e.source.height) {
            return false;
        }
        if (e instanceof ConstrainedEdge) {
            ConstrainedEdge ce = (ConstrainedEdge)e;
            if (ce.startingRoutedPoints.size() > 0) {
                return false;
            }
        }
        return true;
    }

    private void routeEdge(Edge e, Rectangle extraObstacle) {
        if (e instanceof ConstrainedEdge && ((ConstrainedEdge)e).getStyle().equals(ConstrainedEdge.ORTHOGONAL_ROUTING_STYLE)) {
            this.routeOrthogonalEdge((ConstrainedEdge)e);
        } else {
            this.routeDefaultEdge(e, extraObstacle);
        }
    }

    private void routeOrthogonalEdge(ConstrainedEdge edge) {
        Point lastPt;
        PointList points = new PointList();
        if (edge.startingRoutedPoints.size() == 0) {
            points.addPoint(edge.start);
        } else {
            points.addAll(edge.startingRoutedPoints);
        }
        Node previousNode = edge.source;
        if (edge.vNodes != null) {
            int i = 0;
            while (i < edge.vNodes.size()) {
                Node vNode = edge.vNodes.getNode(i);
                int prevPtX = points.getLastPoint().x;
                int nextPtX = vNode.x + vNode.width / 2;
                if (prevPtX != nextPtX) {
                    int rankBottomY = previousNode.y + GraphUtilities.getRankHeightFromNode(previousNode, this.g);
                    int midY = rankBottomY + (vNode.y - rankBottomY) / 2;
                    points.addPoint(prevPtX, midY);
                    points.addPoint(nextPtX, midY);
                }
                previousNode = vNode;
                ++i;
            }
        }
        Point prevPt = points.getLastPoint();
        Point point = lastPt = edge.endingRoutedPoints.size() == 0 ? edge.end : edge.endingRoutedPoints.getFirstPoint();
        if (prevPt.x != lastPt.x) {
            int rankBottomY = previousNode.y + GraphUtilities.getRankHeightFromNode(previousNode, this.g);
            int midY = rankBottomY + (lastPt.y - rankBottomY) / 2;
            points.addPoint(prevPt.x, midY);
            points.addPoint(lastPt.x, midY);
        }
        if (edge.endingRoutedPoints.size() > 0) {
            points.addAll(edge.endingRoutedPoints);
        } else {
            points.addPoint(edge.end);
        }
        edge.getPoints().removeAllPoints();
        edge.getPoints().addAll(points);
    }

    private Point getPathStartPoint(Edge e) {
        if (e instanceof ConstrainedEdge) {
            ConstrainedEdge ce = (ConstrainedEdge)e;
            if (ce.startingRoutedPoints.size() != 0) {
                return ce.startingRoutedPoints.getLastPoint();
            }
        }
        if (e.start == null) {
            e.start = new Point(e.source.x + e.source.getOffsetOutgoing(), e.source.y + e.source.height);
        }
        return e.start;
    }

    private Point getPathEndPoint(Edge e) {
        if (e instanceof ConstrainedEdge) {
            ConstrainedEdge ce = (ConstrainedEdge)e;
            if (ce.endingRoutedPoints.size() != 0) {
                return ce.endingRoutedPoints.getFirstPoint();
            }
        }
        if (e.end == null) {
            e.end = new Point(e.target.x + e.target.getOffsetIncoming(), e.target.y);
        }
        return e.end;
    }

    private void routeDefaultEdge(Edge edge, Rectangle extraObstacle) {
        ConstrainedEdge ce;
        ShortestPathRouter router = new ShortestPathRouter();
        Path path = new Path(this.getPathStartPoint(edge), this.getPathEndPoint(edge));
        router.addPath(path);
        if (extraObstacle != null) {
            router.addObstacle(extraObstacle);
        }
        if (edge.vNodes != null) {
            int i = 0;
            while (i < edge.vNodes.size()) {
                int height;
                int width;
                Node node = edge.vNodes.getNode(i);
                int rankHeight = GraphUtilities.getRankHeightFromNode(node, this.g);
                if (node.getLeft() != null) {
                    int right = node.getLeft().x + node.getLeft().width + this.g.getPadding((Node)node.getLeft()).right + edge.getPadding();
                    width = Math.max(right, OBSTACLE_WIDTH);
                    height = Math.max(rankHeight, 2);
                    router.addObstacle(new Rectangle(right - width, node.getLeft().y, width, height));
                }
                if (node.getRight() != null) {
                    int left = node.getRight().x - this.g.getPadding((Node)node.getRight()).left - edge.getPadding();
                    width = Math.max(this.g.getLayoutSize().width - left, OBSTACLE_WIDTH);
                    height = Math.max(rankHeight, 2);
                    router.addObstacle(new Rectangle(left, node.getRight().y, width, height));
                }
                ++i;
            }
        }
        router.setSpacing(0);
        router.solve();
        edge.getPoints().removeAllPoints();
        ConstrainedEdge constrainedEdge = ce = edge instanceof ConstrainedEdge ? (ConstrainedEdge)edge : null;
        if (ce != null) {
            int i = 0;
            while (i < ce.startingRoutedPoints.size() - 1) {
                edge.getPoints().addPoint(ce.startingRoutedPoints.getPoint(i));
                ++i;
            }
        }
        edge.getPoints().addAll(path.getPoints());
        if (ce != null) {
            int i = 1;
            while (i < ce.endingRoutedPoints.size()) {
                edge.getPoints().addPoint(ce.endingRoutedPoints.getPoint(i));
                ++i;
            }
        }
    }

    private void addSourceObstacle(Edge e, float ratio, boolean leftEdge, ShortestPathRouter router) {
        int rankHeight = GraphUtilities.getRankHeightFromNode(e.source, this.g);
        if (leftEdge && e.source.getLeft() != null) {
            int leftX = e.source.getLeft().x + e.source.getLeft().width + this.g.getPadding((Node)e.source.getLeft()).right;
            int rightX = e.source.x + e.source.getOffsetOutgoing();
            int uniformObstacle = (int)((float)leftX * (1.0f - ratio) + ratio * (float)rightX);
            int obstacleRightX = Math.min(e.start.x - 1, uniformObstacle);
            int width = Math.max(obstacleRightX, OBSTACLE_WIDTH);
            int height = Math.max(rankHeight, 2);
            router.addObstacle(new Rectangle(obstacleRightX - width, e.source.getLeft().y, width, height));
        } else if (e.source.getRight() != null) {
            int leftX = e.source.x + e.source.getOffsetOutgoing();
            int rightX = e.source.getRight().x - this.g.getPadding((Node)e.source.getRight()).left;
            int uniformObstacle = (int)((float)rightX * (1.0f - ratio) + ratio * (float)leftX);
            int obstacleLeftX = Math.max(e.start.x + 1, uniformObstacle);
            int width = Math.max(this.g.getLayoutSize().width - obstacleLeftX, OBSTACLE_WIDTH);
            int height = Math.max(rankHeight, 2);
            router.addObstacle(new Rectangle(obstacleLeftX, e.source.getRight().y, width, height));
        }
    }

    private void routeLeftEdges(List<Edge> edges, Node n) {
        if (edges.isEmpty()) {
            return;
        }
        int rankHeight = GraphUtilities.getRankHeightFromNode(n, this.g);
        int obstacleX = n.getLeft().x + n.getLeft().width + this.g.getPadding((Node)n.getLeft()).right;
        int median = n.x + n.getOffsetOutgoing();
        int i = 0;
        while (i < edges.size()) {
            Edge e = edges.get(i);
            if (e instanceof ConstrainedEdge && ConstrainedEdge.ORTHOGONAL_ROUTING_STYLE.equals(((ConstrainedEdge)e).getStyle())) {
                this.routeEdge(e, null);
                obstacleX = e.start.x;
            } else {
                int offset = Math.min(e.getPadding(), Math.abs(obstacleX - median) / (edges.size() + 1 - i));
                obstacleX = Math.min(obstacleX + offset, e.start.x - 1);
                int width = Math.max(obstacleX, OBSTACLE_WIDTH);
                int height = Math.max(rankHeight, 2);
                this.routeEdge(e, new Rectangle(obstacleX - width, e.source.getLeft().y, width, height));
            }
            ++i;
        }
    }

    private void routeRightEdges(List<Edge> edges, Node n) {
        if (edges.isEmpty()) {
            return;
        }
        int rankHeight = GraphUtilities.getRankHeightFromNode(n, this.g);
        int obstacleX = n.getRight().x - this.g.getPadding((Node)n.getRight()).left;
        int median = n.x + n.getOffsetOutgoing();
        int i = 0;
        while (i < edges.size()) {
            Edge e = edges.get(i);
            if (e instanceof ConstrainedEdge && ConstrainedEdge.ORTHOGONAL_ROUTING_STYLE.equals(((ConstrainedEdge)e).getStyle())) {
                this.routeEdge(e, null);
                obstacleX = e.start.x;
            } else {
                int offset = Math.min(e.getPadding(), Math.abs(obstacleX - median) / (edges.size() + 1 - i));
                obstacleX = Math.max(obstacleX - offset, e.start.x + 1);
                int width = Math.max(this.g.getLayoutSize().width - obstacleX, OBSTACLE_WIDTH);
                int height = Math.max(rankHeight, 2);
                this.routeEdge(e, new Rectangle(obstacleX, e.source.getRight().y, width, height));
            }
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EdgeComparator
    implements Comparator<Edge> {
        private boolean reverse;

        public EdgeComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(Edge e1, Edge e2) {
            Node guideNode1 = e1.vNodes == null ? e1.target : e1.vNodes.getNode(0);
            Node guideNode2 = e2.vNodes == null ? e2.target : e2.vNodes.getNode(0);
            int diff = guideNode1.x + guideNode1.getOffsetIncoming() - guideNode2.x - guideNode2.getOffsetIncoming();
            return this.reverse ? -diff : diff;
        }
    }
}

