/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.services.palette;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gmf.runtime.common.core.service.AbstractProviderConfiguration;
import org.eclipse.ui.IEditorPart;

public class PaletteProviderConfiguration
extends AbstractProviderConfiguration {
    private static final String EDITOR = "editor";
    private static final String CONTENT = "content";
    private EditorDescriptor editor;
    private AbstractProviderConfiguration.ObjectDescriptor content;

    public static PaletteProviderConfiguration parse(IConfigurationElement configElement) {
        Assert.isNotNull((Object)configElement, (String)"null provider configuration element");
        return new PaletteProviderConfiguration(configElement);
    }

    private PaletteProviderConfiguration(IConfigurationElement configElement) {
        IConfigurationElement[] configChildren = configElement.getChildren(EDITOR);
        if (configChildren.length > 0) {
            this.editor = new EditorDescriptor(configChildren[0]);
        }
        if ((configChildren = configElement.getChildren(CONTENT)).length > 0) {
            this.content = new AbstractProviderConfiguration.ObjectDescriptor(configChildren[0]);
        }
    }

    public boolean supports(IEditorPart targetEditor, Object targetContent) {
        if (this.editor != null && !this.editor.sameAs(targetEditor)) {
            return false;
        }
        return this.content == null || this.content.sameAs(targetContent);
    }

    private static class EditorDescriptor
    extends AbstractProviderConfiguration.ObjectDescriptor {
        private final String targetId;

        public EditorDescriptor(IConfigurationElement configElement) {
            super(configElement);
            this.targetId = configElement.getAttribute("id");
        }

        public boolean sameAs(Object object) {
            if (!(object instanceof IEditorPart)) {
                return false;
            }
            if (this.targetId != null && !this.targetId.equals(((IEditorPart)object).getSite().getId())) {
                return false;
            }
            return super.sameAs(object);
        }
    }
}

