/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContextImpl;
import org.eclipse.gmf.internal.xpand.expression.PolymorphicResolver;
import org.eclipse.gmf.internal.xpand.expression.TypeNameUtil;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.model.AdvicedDefinition;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.ProtectedRegionResolver;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandExecutionContextImpl
extends ExecutionContextImpl
implements XpandExecutionContext {
    protected final Output output;
    protected final ProtectedRegionResolver protectedRegionResolver;
    private final List<XpandAdvice> registeredAdvices = new ArrayList<XpandAdvice>();

    public XpandExecutionContextImpl(ResourceManager resourceManager, Output output, ProtectedRegionResolver prs) {
        this(resourceManager, output, prs, null);
    }

    public XpandExecutionContextImpl(ResourceManager resourceManager, Output output, ProtectedRegionResolver prs, Collection<Variable> globalVars) {
        super(resourceManager, globalVars);
        this.output = output;
        this.protectedRegionResolver = prs;
    }

    protected XpandExecutionContextImpl(ResourceManager resourceManager, ResourceMarker currentResource, Collection<Variable> vars, Collection<Variable> globalVars, Output output, ProtectedRegionResolver protectedRegionResolver) {
        super(resourceManager, currentResource, vars, globalVars);
        this.output = output;
        this.protectedRegionResolver = protectedRegionResolver;
    }

    private XpandExecutionContextImpl(XpandExecutionContextImpl original) {
        super(original);
        this.output = original.output;
        this.protectedRegionResolver = original.protectedRegionResolver;
    }

    @Override
    public XpandExecutionContextImpl cloneContext() {
        XpandExecutionContextImpl result = new XpandExecutionContextImpl(this);
        result.registeredAdvices.addAll(this.registeredAdvices);
        return result;
    }

    @Override
    public XpandDefinition findDefinition(String name, EClassifier target, EClassifier[] paramTypes) {
        XpandResource tpl = null;
        tpl = name.indexOf("::") != -1 ? this.findTemplate(TypeNameUtil.withoutLastSegment(name)) : (XpandResource)this.currentResource();
        if (tpl == null) {
            return null;
        }
        XpandExecutionContext ctx = (XpandExecutionContext)this.cloneWithResource(tpl);
        XpandDefinition def = this.findDefinition(tpl.getDefinitions(), name, target, paramTypes, ctx);
        if (def == null) {
            return null;
        }
        int x = this.registeredAdvices.size() - 1;
        while (x >= 0) {
            XpandAdvice adv = this.registeredAdvices.get(x);
            if (adv.matches(def, this)) {
                def = new AdvicedDefinition(adv, def);
            }
            --x;
        }
        return def;
    }

    public void registerAdvices(String fullyQualifiedName) {
        XpandAdvice[] as;
        XpandResource tpl = this.findTemplate(fullyQualifiedName);
        if (tpl == null) {
            throw new RuntimeException("Couldn't find template : " + fullyQualifiedName);
        }
        XpandAdvice[] xpandAdviceArray = as = tpl.getAdvices();
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            XpandAdvice advice = xpandAdviceArray[n2];
            if (this.registeredAdvices.contains(advice)) {
                Activator.logWarn("advice " + advice.toString() + " allready registered!");
            } else {
                this.registeredAdvices.add(advice);
            }
            ++n2;
        }
    }

    @Override
    public ProtectedRegionResolver getProtectedRegionResolver() {
        return this.protectedRegionResolver;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    protected String[] getImportedNamespaces() {
        if (this.currentResource() instanceof XpandResource) {
            return ((XpandResource)this.currentResource()).getImportedNamespaces();
        }
        return super.getImportedNamespaces();
    }

    @Override
    protected String[] getImportedExtensions() {
        if (this.currentResource() instanceof XpandResource) {
            return ((XpandResource)this.currentResource()).getImportedExtensions();
        }
        return super.getImportedExtensions();
    }

    @Override
    public XpandResource findTemplate(String templateName) {
        List<String> possibleNames = this.getPossibleNames(templateName, this.getImportedNamespaces());
        for (String name : possibleNames) {
            XpandResource tpl = this.getResourceManager().loadXpandResource(name);
            if (tpl == null) continue;
            this.installAspectsFor(templateName);
            return tpl;
        }
        return null;
    }

    private void installAspectsFor(String templateName) {
        String aspectsTemplateName = "aspects::" + templateName;
        XpandResource aspects = this.getResourceManager().loadXpandResource(aspectsTemplateName);
        if (aspects != null) {
            this.registeredAdvices.addAll((Collection<XpandAdvice>)Arrays.asList(aspects.getAdvices()));
        }
    }

    private List<String> getPossibleNames(String name, String[] importedNs) {
        String typeName = TypeNameUtil.getTypeName(name);
        String typesMetamodelName = TypeNameUtil.getMetaModelName(name);
        String collectionTypeName = TypeNameUtil.getCollectionTypeName(name);
        ArrayList<String> result = new ArrayList<String>();
        result.add(name);
        String[] stringArray = importedNs;
        int n = importedNs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            StringBuffer s = new StringBuffer();
            if (collectionTypeName != null) {
                s.append(collectionTypeName).append("[");
            }
            if (typesMetamodelName != null) {
                s.append(typesMetamodelName).append("!");
            }
            s.append(string).append("::").append(typeName);
            if (collectionTypeName != null) {
                s.append("]");
            }
            result.add(s.toString());
            ++n2;
        }
        return result;
    }

    private XpandDefinition findDefinition(XpandDefinition[] definitions, String name, EClassifier target, EClassifier[] paramTypes, XpandExecutionContext ctx) {
        if (paramTypes == null) {
            paramTypes = new EClassifier[]{};
        }
        String unqualifiedName = TypeNameUtil.getLastSegment(name);
        HashMap<XpandDefinition, List<EClassifier>> resolvedDefs = new HashMap<XpandDefinition, List<EClassifier>>();
        XpandDefinition[] xpandDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            XpandDefinition def = xpandDefinitionArray[n2];
            if (def.getName().equals(unqualifiedName) && def.getParams().length == paramTypes.length) {
                LinkedList<EClassifier> defsParamTypes = new LinkedList<EClassifier>();
                EClassifier t = null;
                boolean complete = true;
                int j = 0;
                while (j < paramTypes.length && complete) {
                    t = ctx.getTypeForName(def.getParams()[j].getType().getValue());
                    if (t == null) {
                        complete = false;
                    }
                    defsParamTypes.add(t);
                    ++j;
                }
                t = ctx.getTypeForName(def.getTargetType());
                if (t == null) {
                    complete = false;
                } else {
                    defsParamTypes.addFirst(t);
                }
                if (complete) {
                    resolvedDefs.put(def, defsParamTypes);
                }
            }
            ++n2;
        }
        return PolymorphicResolver.filterDefinition(resolvedDefs, target, Arrays.asList(paramTypes));
    }
}

