/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor.scan;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XpandKeywordRule
implements IRule {
    private final IToken token;
    private final String[] keywords;

    public XpandKeywordRule(IToken token, String[] keywords) {
        this.token = token;
        this.keywords = keywords;
    }

    private boolean isKeyword(String word) {
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (w.equals(word)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean keywordExists(String prefix) {
        String[] stringArray = this.keywords;
        int n = this.keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (w.startsWith(prefix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        StringBuilder buff = new StringBuilder();
        boolean stopReading = false;
        int reads = 0;
        while (!stopReading) {
            ++reads;
            char c = (char)scanner.read();
            if (buff.length() > 0 && !Character.isJavaIdentifierPart(c) && this.isKeyword(buff.toString()) && !this.keywordExists(String.valueOf(buff.toString()) + c)) {
                scanner.unread();
                return this.token;
            }
            buff.append(c);
            boolean bl = stopReading = !this.keywordExists(buff.toString());
        }
        int i = 0;
        while (i < reads) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }
}

