/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public class DiagramEditingDomainTestCase
extends TestCase {
    EClass eCls;

    public void testDiagramEventBrokerAsSpecialListener() {
        final TransactionalEditingDomain domain = DiagramEditingDomainFactory.getInstance().createEditingDomain();
        final Resource r = domain.getResourceSet().createResource(URI.createURI((String)"file:///foo.logic2"));
        this.eCls = EcoreFactory.eINSTANCE.createEClass();
        this.eCls.setName("");
        try {
            new AbstractTransactionalCommand(domain, "Setup", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    r.getContents().add((Object)DiagramEditingDomainTestCase.this.eCls);
                    return CommandResult.newOKCommandResult();
                }
            }.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            DiagramEditingDomainTestCase.fail();
        }
        DiagramEventBroker.startListening((TransactionalEditingDomain)domain);
        DiagramEventBroker.getInstance((TransactionalEditingDomain)domain).addNotificationListener((EObject)this.eCls, new NotificationListener(){

            public void notifyChanged(Notification notification) {
                if (notification.getNotifier() == DiagramEditingDomainTestCase.this.eCls && notification.getFeature() == EcorePackage.eINSTANCE.getENamedElement_Name()) {
                    try {
                        new AbstractTransactionalCommand(domain, "Add Attribute", null){

                            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                (this).DiagramEditingDomainTestCase.this.eCls.getEStructuralFeatures().add((Object)EcoreFactory.eINSTANCE.createEAttribute());
                                return CommandResult.newOKCommandResult();
                            }
                        }.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    }
                    catch (ExecutionException executionException) {
                        DiagramEditingDomainTestCase.fail();
                    }
                }
            }
        });
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(domain, "Set Name", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                DiagramEditingDomainTestCase.this.eCls.setName("foo");
                return CommandResult.newOKCommandResult();
            }
        };
        final boolean[] regularListenerWasCalled = new boolean[1];
        final boolean[] notificationsWereEmpty = new boolean[1];
        regularListenerWasCalled[0] = false;
        notificationsWereEmpty[0] = true;
        domain.addResourceSetListener((ResourceSetListener)new ResourceSetListenerImpl(){

            public boolean isPostcommitOnly() {
                return true;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                regularListenerWasCalled[0] = true;
                notificationsWereEmpty[0] = event.getNotifications().isEmpty();
            }
        });
        try {
            cmd.execute((IProgressMonitor)new NullProgressMonitor(), null);
            cmd.undo((IProgressMonitor)new NullProgressMonitor(), null);
            cmd.redo((IProgressMonitor)new NullProgressMonitor(), null);
            cmd.undo((IProgressMonitor)new NullProgressMonitor(), null);
            cmd.redo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            DiagramEditingDomainTestCase.fail();
        }
        DiagramEditingDomainTestCase.assertSame((Object)this.eCls.eResource(), (Object)r);
        DiagramEditingDomainTestCase.assertEquals((int)3, (int)this.eCls.getEStructuralFeatures().size());
        DiagramEditingDomainTestCase.assertTrue((boolean)regularListenerWasCalled[0]);
        DiagramEditingDomainTestCase.assertFalse((boolean)notificationsWereEmpty[0]);
    }

    public static Test suite() {
        return new TestSuite(DiagramEditingDomainTestCase.class);
    }
}

