/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetPropertyCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class CanonicalTestFixture
extends LogicTestFixture {
    static /* synthetic */ Class class$0;

    public void destroy(EObject eObject) {
        DestroyElementRequest destroy = new DestroyElementRequest(this.getEditingDomain(), eObject, false);
        IElementType context = ElementTypeRegistry.getInstance().getElementType(destroy.getEditHelperContext());
        this.execute(context.getEditCommand((IEditCommandRequest)destroy));
    }

    public void setCollapsed(IResizableCompartmentEditPart rep, boolean collapse) {
        SetPropertyCommand spc = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)((View)rep.getModel())), Properties.ID_COLLAPSED, Properties.ID_COLLAPSED, (Object)collapse);
        this.execute((ICommand)spc);
        CanonicalTestFixture.assertEquals((String)"Enexpected collapsed value", (boolean)collapse, (boolean)((Boolean)rep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed())));
    }

    public void setVisible(IGraphicalEditPart gep, boolean visible) {
        SetPropertyCommand spc = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)((View)gep.getModel())), Properties.ID_ISVISIBLE, Properties.ID_ISVISIBLE, (Object)visible);
        this.execute((ICommand)spc);
        CanonicalTestFixture.assertEquals((String)"Enexpected visible value", (boolean)visible, (boolean)((Boolean)gep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible())));
    }

    public void setVisible(View view, boolean visible) {
        SetPropertyCommand spc = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)view), Properties.ID_ISVISIBLE, Properties.ID_ISVISIBLE, (Object)visible);
        this.execute((ICommand)spc);
        CanonicalTestFixture.assertEquals((String)"Enexpected visible value", (boolean)visible, (boolean)((Boolean)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Visible())));
    }

    public void enableCanonical(IGraphicalEditPart gep, boolean enabled) {
        SetPropertyCommand spc = new SetPropertyCommand(this.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)((View)gep.getModel())), Properties.ID_ISCANONICAL, Properties.ID_ISCANONICAL, (Object)enabled);
        this.execute((ICommand)spc);
        CanonicalTestFixture.assertEquals((String)"Unexpected canonical value", (boolean)enabled, (boolean)((Boolean)gep.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getCanonicalStyle_Canonical())));
    }

    public List getShapes(EClass eClass, EditPart editPart) {
        ArrayList<IAdaptable> retval = new ArrayList<IAdaptable>();
        Iterator children = editPart.getChildren().iterator();
        while (children.hasNext()) {
            EObject eObject;
            View view;
            IAdaptable child = (IAdaptable)children.next();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.gmf.runtime.notation.View");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((view = (View)child.getAdapter((Class)clazz)) == null || !eClass.equals((eObject = ViewUtil.resolveSemanticElement((View)view)).eClass())) continue;
            retval.add(child);
        }
        return retval;
    }

    public List getShapes(EClass eClass) {
        return this.getShapes(eClass, (EditPart)this.getDiagramEditPart());
    }

    public void makeModelReadOnly(boolean readOnly) {
        IFile file = this.getDiagramFile();
        CanonicalTestFixture.assertNotNull((String)"file expected.", (Object)file);
        ResourceAttributes resourceAttributes = file.getResourceAttributes();
        resourceAttributes.setReadOnly(readOnly);
        try {
            file.setResourceAttributes(resourceAttributes);
        }
        catch (CoreException coreException) {}
        CanonicalTestFixture.println(file.getFullPath() + ".isReadOnly() == " + file.isReadOnly());
    }

    public void closeDiagramEditor(boolean save) {
        IWorkbenchPage page = this.getDiagramWorkbenchPart().getSite().getPage();
        if (page != null) {
            this.getDiagramWorkbenchPart().getSite().getPage();
            page.closeEditor((IEditorPart)this.getDiagramWorkbenchPart(), save);
            this.setDiagramWorkbenchPart(null);
            CanonicalTestFixture.assertNull((String)"unexpected editor", (Object)page.findEditor((IEditorInput)new FileEditorInput(this.getDiagramFile())));
        }
    }

    public IGraphicalEditPart getCanonicalCompartment(int index) {
        List circuits = this.getShapes(SemanticPackage.eINSTANCE.getCircuit());
        CanonicalTestFixture.assertTrue((String)"Failed to create circuit shapes.", (!circuits.isEmpty() ? 1 : 0) != 0);
        IGraphicalEditPart circuitEP = (IGraphicalEditPart)circuits.get(index);
        IGraphicalEditPart logicCompartment = circuitEP.getChildBySemanticHint("LogicCompartment");
        return logicCompartment;
    }
}

