/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.common.core.internal.service;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.ExecutionStrategy;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.IProviderPolicy;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.core.service.ProviderPriority;
import org.eclipse.gmf.runtime.common.core.service.Service;

public class ServiceTest
extends TestCase {
    private Fixture fixture = null;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        TestRunner.run((Test)ServiceTest.suite());
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.common.core.internal.service.ServiceTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ServiceTest(String name) {
        super(name);
    }

    protected Fixture getFixture() {
        return this.fixture;
    }

    private void setFixture(Fixture fixture) {
        this.fixture = fixture;
    }

    protected void setUp() {
        this.setFixture(new Fixture());
    }

    public void test_providerChanged() {
        this.getFixture().addProviderChangeListener(new IProviderChangeListener(){

            public final void providerChanged(ProviderChangeEvent event) {
                ServiceTest.assertEquals((Object)((Object)ServiceTest.this.getFixture()), (Object)event.getSource());
                throw new RuntimeException();
            }
        });
        try {
            this.getFixture().providerChanged(new ProviderChangeEvent((IProvider)this.getFixture()));
            ServiceTest.fail();
        }
        catch (Exception exception) {}
    }

    public void test_provides() {
        ExecutionStrategy strategy = new ExecutionStrategy("Dummy"){
            private static final long serialVersionUID = 1L;

            public List execute(Service service, IOperation operation) {
                return Collections.EMPTY_LIST;
            }
        };
        IOperation operation = new IOperation(){

            public Object execute(IProvider provider) {
                return null;
            }
        };
        ServiceTest.assertTrue((!this.getFixture().provides(operation) ? 1 : 0) != 0);
        AbstractProvider trueProvider = new AbstractProvider(){

            public boolean provides(IOperation op) {
                return true;
            }
        };
        Fixture.ProviderDescriptor trueProviderDescriptor = new Fixture.ProviderDescriptor((IProvider)trueProvider);
        this.getFixture().addFixtureProvider(ProviderPriority.MEDIUM, trueProviderDescriptor);
        ServiceTest.assertTrue((boolean)this.getFixture().provides(operation));
        List cachedProviders = this.getFixture().getFixtureProviders(strategy, ProviderPriority.MEDIUM, operation);
        ServiceTest.assertTrue((trueProvider == cachedProviders.get(0) ? 1 : 0) != 0);
        AbstractProvider falseProvider = new AbstractProvider(){

            public boolean provides(IOperation op) {
                return false;
            }
        };
        Fixture.ProviderDescriptor falseProviderDescriptor = new Fixture.ProviderDescriptor((IProvider)falseProvider);
        this.getFixture().addFixtureProvider(ProviderPriority.MEDIUM, falseProviderDescriptor);
        ServiceTest.assertTrue((boolean)this.getFixture().provides(operation));
        ServiceTest.assertTrue((cachedProviders != this.getFixture().getFixtureProviders(strategy, ProviderPriority.MEDIUM, operation) ? 1 : 0) != 0);
        ServiceTest.assertTrue((trueProvider == this.getFixture().getFixtureProviders(strategy, ProviderPriority.MEDIUM, operation).get(0) ? 1 : 0) != 0);
        this.getFixture().removeFixtureProvider(trueProviderDescriptor);
        ServiceTest.assertTrue((!this.getFixture().provides(operation) ? 1 : 0) != 0);
        this.getFixture().removeFixtureProvider(falseProviderDescriptor);
        ServiceTest.assertTrue((!this.getFixture().provides(operation) ? 1 : 0) != 0);
    }

    protected static class Fixture
    extends Service {
        protected Fixture() {
            super(true);
        }

        protected List getFixtureProviders(ExecutionStrategy strategy, ProviderPriority priority, IOperation operation) {
            return super.getProviders(strategy, priority, operation);
        }

        protected void addFixtureProvider(ProviderPriority priority, Service.ProviderDescriptor provider) {
            super.addProvider(priority, provider);
        }

        protected void removeFixtureProvider(Service.ProviderDescriptor provider) {
            super.removeProvider(provider);
        }

        protected static class ProviderDescriptor
        extends Service.ProviderDescriptor {
            protected ProviderDescriptor(IProvider provider) {
                super(null);
                this.provider = provider;
                provider.addProviderChangeListener((IProviderChangeListener)this);
            }

            public IProvider getProvider() {
                return this.provider;
            }

            protected IProviderPolicy getPolicy() {
                return null;
            }
        }
    }
}

