/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupportFactory;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteTarget;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardSupportManager;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.DefaultClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.PasteOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SerializationEMFResource;

public class ClipboardUtil {
    public static final String MERGE_HINT_WEAK = "*merge=weak";
    public static final String MERGE_HINT_STRONG = "*merge=strong";
    public static final String RECYCLE_HINT_ID = "*recycle=id";
    public static final String IGNORE_RECYCLE_HINT_ID = "*ignore_recycle=id";
    public static final String PASTE_TO_TARGET_PARENT = "*paste=parent";
    public static final String HARVESTED_ELEMENT = "*paste=harvest";
    private static final String PASTE_SELECTION_FROM_STRING = "pasteElementsFromString";
    private static final String COPY_SELECTION_TO_STRING = "copyElementsToString";
    static /* synthetic */ Class class$0;

    private ClipboardUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String copyElementsToString(Collection eObjects, Map hints, IProgressMonitor monitor) {
        try {
            block7: {
                String string;
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask("copy", 100);
                    EObject first = eObjects.isEmpty() ? null : (EObject)eObjects.iterator().next();
                    eObjects = ClipboardSupportUtil.getCopyElements(eObjects);
                    if (eObjects.isEmpty()) break block7;
                    if (hints == null) {
                        hints = Collections.EMPTY_MAP;
                    }
                    CopyOperation copyOperation = new CopyOperation(monitor, ClipboardUtil.createClipboardSupport(first.eClass()), eObjects, hints);
                    string = copyOperation.copy();
                    Object var5_7 = null;
                }
                catch (Exception ex) {
                    ClipboardUtil.handleException(ex, COPY_SELECTION_TO_STRING);
                }
                monitor.done();
                return string;
            }
            Object var5_9 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return null;
    }

    public static Collection pasteElementsFromString(String string, EObject targetElement, Map hints, IProgressMonitor monitor) {
        return ClipboardUtil.pasteElementsFromStringDelagate(string, new PasteTarget(targetElement), hints, monitor);
    }

    public static Collection pasteElementsFromString(String string, Resource targetElement, Map hints, IProgressMonitor monitor) {
        return ClipboardUtil.pasteElementsFromStringDelagate(string, new PasteTarget(targetElement), hints, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection pasteElementsFromStringDelagate(String string, PasteTarget targetElement, Map hints, IProgressMonitor monitor) {
        Set result;
        block8: {
            Set set;
            block7: {
                result = null;
                try {
                    try {
                        IClipboardSupport helper;
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask("paste", 100);
                        IClipboardSupport iClipboardSupport = helper = targetElement.isResource() ? DefaultClipboardSupport.getInstance() : ClipboardUtil.createClipboardSupport(((EObject)targetElement.getObject()).eClass());
                        if (string.length() == 0) {
                            set = Collections.EMPTY_SET;
                            Object var7_8 = null;
                            break block7;
                        }
                        PasteOperation pasteProcess = new PasteOperation(monitor, helper, string, targetElement, SerializationEMFResource.LOAD_OPTIONS, hints);
                        pasteProcess.paste();
                        result = pasteProcess.getPastedElementSet();
                        helper.performPostPasteProcessing(result);
                    }
                    catch (Exception ex) {
                        ClipboardUtil.handleException(ex, PASTE_SELECTION_FROM_STRING);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return set;
        }
        Object var7_10 = null;
        monitor.done();
        return result;
    }

    private static void handleException(Exception ex, String methodname) {
        Class<?> clazz;
        block7: {
            block6: {
                if (!(ex instanceof OperationCanceledException)) break block6;
                clazz = class$0;
                if (clazz != null) break block7;
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                break block7;
            }
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClipboardPlugin.throwing(clazz2, methodname, ex);
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new RuntimeException("Copy-Paste General Error", ex);
        }
        ClipboardPlugin.catching(clazz, methodname, ex);
    }

    public static IClipboardSupport createClipboardSupport(EClass eClass) {
        IClipboardSupport result = DefaultClipboardSupport.getInstance();
        EPackage ePackage = eClass.getEPackage();
        IClipboardSupportFactory factory = ClipboardSupportManager.lookup(ePackage);
        if (factory != null) {
            result = factory.newClipboardSupport(ePackage);
        }
        return result;
    }
}

