/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.xpand.BufferOutput;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.XpandFacade;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.model.Output;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandTextEmitter
implements TextEmitter {
    private final ResourceManager myResourceManager;
    private final String myTemplateFQN;
    private final ClassLoader myContext;
    private final List<Variable> myGlobals;

    public XpandTextEmitter(ResourceManager manager, String templateFQN, ClassLoader context) {
        this(manager, templateFQN, context, null);
    }

    public XpandTextEmitter(ResourceManager manager, String templateFQN, ClassLoader context, Map<String, Object> globals) {
        assert (manager != null && templateFQN != null);
        this.myResourceManager = manager;
        this.myTemplateFQN = templateFQN;
        this.myContext = context;
        if (globals != null && globals.size() > 0) {
            this.myGlobals = new ArrayList<Variable>(globals.size());
            for (Map.Entry<String, Object> e : globals.entrySet()) {
                this.myGlobals.add(new Variable(e.getKey(), e.getValue()));
            }
        } else {
            this.myGlobals = Collections.emptyList();
        }
    }

    @Override
    public String generate(IProgressMonitor monitor, Object[] arguments) throws InterruptedException, InvocationTargetException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            StringBuilder result = new StringBuilder();
            new XpandFacade(this.createContext(result)).evaluate(this.myTemplateFQN, this.extractTarget(arguments), this.extractArguments(arguments));
            return result.toString();
        }
        catch (EvaluationException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    protected Object extractTarget(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        return arguments[0];
    }

    protected Object[] extractArguments(Object[] arguments) {
        assert (arguments != null && arguments.length > 0);
        ArrayList<Object> res = new ArrayList<Object>(arguments.length);
        int i = 1;
        while (i < arguments.length) {
            if (!(arguments[i] instanceof ImportAssistant)) {
                res.add(arguments[i]);
            }
            ++i;
        }
        return res.toArray();
    }

    private XpandExecutionContext createContext(StringBuilder result) {
        BufferOutput output = new BufferOutput(result);
        return ContextFactory.createXpandContext((ResourceManager)this.myResourceManager, (Output)output, this.myGlobals, (ClassLoader)this.myContext);
    }
}

