/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.importer.ui.GenModelReloadActionDelegate;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;

class StaleGenModelDetector {
    private final GenModel myGenModel;
    private boolean shouldRefresh = false;
    private URI myOutdatedResource;
    private Date myOutdatedResourceTimeStamp;
    private Date myGenModelTimeStamp;

    public StaleGenModelDetector(GenModel genModel) {
        assert (genModel != null);
        this.myGenModel = genModel;
    }

    public boolean isStale() {
        if (this.myGenModel.eResource() == null) {
            return false;
        }
        URI genModelURI = this.myGenModel.eResource().getURI();
        if (!StaleGenModelDetector.isFileURI(genModelURI)) {
            return false;
        }
        HashSet<URI> ecoreURIs = new HashSet<URI>();
        for (GenPackage next : this.myGenModel.getAllGenAndUsedGenPackagesWithClassifiers()) {
            URI uri;
            if (next.getEcorePackage().eResource() == null || !StaleGenModelDetector.isFileURI(uri = next.getEcorePackage().eResource().getURI())) continue;
            ecoreURIs.add(uri);
        }
        Date genModelTimeStamp = StaleGenModelDetector.timestamp(genModelURI);
        for (URI uri : ecoreURIs) {
            Date ts = StaleGenModelDetector.timestamp(uri);
            if (!new Date(genModelTimeStamp.getTime() + 3000L).before(ts)) continue;
            this.myOutdatedResource = uri;
            this.myOutdatedResourceTimeStamp = ts;
            this.myGenModelTimeStamp = genModelTimeStamp;
            return true;
        }
        return false;
    }

    private static boolean isFileURI(URI uri) {
        return "platform".equals(uri.scheme()) && "resource".equals(uri.segment(0));
    }

    private static Date timestamp(URI uri) {
        IFile f = StaleGenModelDetector.getFile(uri);
        if (!f.exists()) {
            return new Date(0L);
        }
        return new Date(f.getLocalTimeStamp());
    }

    private static IFile getFile(URI platformFileUri) {
        IPath p = new Path(platformFileUri.path()).removeFirstSegments(1);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(p);
    }

    public IStatus queryUser(Shell shell) {
        String[] btns;
        int r;
        String msg = "GenModel seems to be stale, would you like to try to reload it?";
        if (this.myOutdatedResource != null) {
            String format = "\n Resource {0} is newer ({1,date}) than genmodel ({2,date})";
            msg = String.valueOf(msg) + MessageFormat.format(format, this.myOutdatedResource, this.myOutdatedResourceTimeStamp, this.myGenModelTimeStamp);
        }
        if ((r = new MessageDialog(shell, "Stale GenModel", null, msg, 3, btns = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0).open()) == 2) {
            return Status.CANCEL_STATUS;
        }
        this.shouldRefresh = r == 0;
        return Status.OK_STATUS;
    }

    public void forceRefresh() {
        this.shouldRefresh = true;
    }

    public GenModel refresh() {
        if (!this.shouldRefresh) {
            return this.myGenModel;
        }
        IFile genModelFile = this.getFile();
        GenModelReloadActionDelegate action = new GenModelReloadActionDelegate();
        Action uiAction = new Action(){};
        action.selectionChanged((IAction)uiAction, (ISelection)new StructuredSelection((Object)genModelFile));
        action.run((IAction)uiAction);
        return this.rereadResource();
    }

    private GenModel rereadResource() {
        Resource res = this.myGenModel.eResource();
        Map loadOptions = res.getResourceSet().getLoadOptions();
        res.unload();
        try {
            res.load(loadOptions);
            return (GenModel)res.getContents().get(0);
        }
        catch (IOException ex) {
            CodeGenUIPlugin.getDefault().getLog().log(CodeGenUIPlugin.createError("Failed to reread genmodel resource", ex));
            return this.myGenModel;
        }
    }

    private IFile getFile() {
        return StaleGenModelDetector.getFile(this.myGenModel.eResource().getURI());
    }
}

