/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.search.ecore.Activator;
import org.eclipse.emf.search.ecore.l10n.Messages;
import org.eclipse.emf.search.ecore.regex.AbstractModelSearchQueryTextualExpressionMatchingHelper;
import org.eclipse.emf.search.ecore.regex.PatternSyntaxException;

public final class ModelSearchQueryTextualExpressionMatchingHelper
extends AbstractModelSearchQueryTextualExpressionMatchingHelper {
    private static ModelSearchQueryTextualExpressionMatchingHelper instance;

    public static ModelSearchQueryTextualExpressionMatchingHelper getInstance() {
        return instance == null ? (instance = new ModelSearchQueryTextualExpressionMatchingHelper()) : instance;
    }

    boolean lookAtWithCaseSensitiveStrategy(String text, String pattern) {
        return this.evaluate(text, pattern, true, false, MatchingStrategy.PARTIAL);
    }

    boolean lookAtWithNormalTextStrategy(String text, String pattern) {
        return this.evaluate(text, pattern, false, false, MatchingStrategy.PARTIAL);
    }

    boolean lookAtWithRegularExpressionStrategy(String text, String pattern) {
        return this.evaluate(text, pattern, false, true, MatchingStrategy.PARTIAL);
    }

    boolean matchWithCaseSensitiveStrategy(String text, String pattern) {
        return this.evaluate(text, pattern, true, false, MatchingStrategy.PERFECT);
    }

    boolean matchWithNormalTextStrategy(String text, String pattern) {
        return this.evaluate(text, pattern, false, false, MatchingStrategy.PERFECT);
    }

    boolean matchWithRegularExpressionStrategy(String text, String pattern) {
        return this.evaluate(text, pattern, false, true, MatchingStrategy.PERFECT);
    }

    private boolean evaluate(String text, String pattern, boolean isCaseSensitive, boolean isRegex, MatchingStrategy strategy) {
        Pattern p;
        text = text == null ? "" : text;
        try {
            p = ModelSearchQueryTextualExpressionMatchingHelper.createPattern(pattern, isCaseSensitive, isRegex);
        }
        catch (PatternSyntaxException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.search.ecore", 0, Messages.getString("ModelSearchQueryTextualExpressionMatchingHelper.InvalidPatternMessageError0"), (Throwable)e));
            return false;
        }
        Matcher m = p.matcher(text);
        switch (strategy) {
            case PARTIAL: {
                return m.lookingAt();
            }
            case PERFECT: {
                return m.matches();
            }
        }
        return false;
    }

    public static Pattern createPattern(String pattern, boolean isCaseSensitive, boolean isRegexSearch) throws PatternSyntaxException {
        if (!isRegexSearch) {
            pattern = ModelSearchQueryTextualExpressionMatchingHelper.toRegexPattern(pattern);
        }
        if (!isCaseSensitive) {
            return Pattern.compile(pattern, 74);
        }
        return Pattern.compile(pattern, 8);
    }

    private static String toRegexPattern(String pattern) {
        int patternLength = pattern.length();
        StringBuffer result = new StringBuffer(patternLength);
        boolean escaped = false;
        boolean quoting = false;
        int i = 0;
        while (i < patternLength) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '*': {
                    if (!escaped && quoting) {
                        result.append("\\E");
                        quoting = false;
                    }
                    result.append(".*");
                    escaped = false;
                    break;
                }
                case '?': {
                    if (!escaped && quoting) {
                        result.append("\\E");
                        quoting = false;
                    }
                    result.append(".");
                    escaped = false;
                    break;
                }
                case '\\': {
                    if (!escaped) {
                        escaped = true;
                        break;
                    }
                    escaped = false;
                    if (quoting) {
                        result.append("\\E");
                        quoting = false;
                    }
                    result.append("\\\\");
                    break;
                }
                default: {
                    if (!quoting) {
                        result.append("\\Q");
                        quoting = true;
                    }
                    if (escaped && ch != '*' && ch != '?' && ch != '\\') {
                        result.append('\\');
                    }
                    result.append(ch);
                    escaped = ch == '\\';
                }
            }
            ++i;
        }
        if (quoting) {
            result.append("\\E");
        }
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MatchingStrategy {
        PERFECT,
        PARTIAL;

    }
}

