/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.regex;

import org.eclipse.emf.search.ecore.regex.IModelSearchQueryTextualExpressionMatchingHelper;
import org.eclipse.emf.search.ecore.regex.ModelSearchQueryTextualExpressionEnum;

public abstract class AbstractModelSearchQueryTextualExpressionMatchingHelper
implements IModelSearchQueryTextualExpressionMatchingHelper {
    public boolean match(String text, String pattern, ModelSearchQueryTextualExpressionEnum matchingStrategy) {
        switch (matchingStrategy) {
            case CASE_SENSITIVE: {
                return this.matchWithCaseSensitiveStrategy(text, pattern);
            }
            case REGULAR_EXPRESSION: {
                return this.matchWithRegularExpressionStrategy(text, pattern);
            }
            case NORMAL_TEXT: {
                return this.matchWithNormalTextStrategy(text, pattern);
            }
        }
        return false;
    }

    public boolean lookAt(String text, String pattern, ModelSearchQueryTextualExpressionEnum matchingStrategy) {
        switch (matchingStrategy) {
            case CASE_SENSITIVE: {
                return this.lookAtWithCaseSensitiveStrategy(text, pattern);
            }
            case REGULAR_EXPRESSION: {
                return this.lookAtWithRegularExpressionStrategy(text, pattern);
            }
            case NORMAL_TEXT: {
                return this.lookAtWithNormalTextStrategy(text, pattern);
            }
        }
        return false;
    }

    abstract boolean matchWithCaseSensitiveStrategy(String var1, String var2);

    abstract boolean matchWithNormalTextStrategy(String var1, String var2);

    abstract boolean matchWithRegularExpressionStrategy(String var1, String var2);

    abstract boolean lookAtWithCaseSensitiveStrategy(String var1, String var2);

    abstract boolean lookAtWithNormalTextStrategy(String var1, String var2);

    abstract boolean lookAtWithRegularExpressionStrategy(String var1, String var2);
}

