/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.ecore.common.ui.dialogs;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.eval.IModelSearchQueryEvaluator;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.ecore.common.ui.Activator;
import org.eclipse.emf.search.ecore.common.ui.dialogs.AbstractModelSearchFilteredMetaElementsSelectionDialog;
import org.eclipse.emf.search.ecore.common.utils.EcoreCommonUtils;
import org.eclipse.emf.search.ecore.evaluators.EcoreTextualModelSearchQueryEvaluator;
import org.eclipse.emf.search.ecore.ui.handlers.EcoreEditorSelectionHandler;
import org.eclipse.emf.search.ui.handlers.IModelElementEditorSelectionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelSearchFilteredEPackageSelectionDialog
extends AbstractModelSearchFilteredMetaElementsSelectionDialog {
    public ModelSearchFilteredEPackageSelectionDialog(Shell shell, boolean multi) {
        super(shell, multi);
    }

    @Override
    protected boolean isAMetaElementToConsider(Object item) {
        if (item instanceof IModelResultEntry) {
            return ((IModelResultEntry)item).getSource() instanceof EPackage;
        }
        return false;
    }

    @Override
    protected EClassifier getMetaElementParticipant() {
        return EcorePackage.Literals.EPACKAGE;
    }

    @Override
    protected IModelSearchQueryEvaluator<IModelSearchQuery, Resource> getModelQueryEvaluator() {
        return new EcoreTextualModelSearchQueryEvaluator();
    }

    @Override
    protected String getModelSearchEngineID() {
        return "org.eclipse.emf.search.ecoreSearchEngine";
    }

    @Override
    public String getElementName(Object item) {
        if (item instanceof IModelResultEntry && ((IModelResultEntry)item).getSource() instanceof ENamedElement) {
            return ((ENamedElement)((IModelResultEntry)item).getSource()).getName();
        }
        return "";
    }

    @Override
    public String getModelResultFullyQualifiedName(IModelResultEntry entry) {
        String txt = "";
        if (entry != null) {
            for (IModelResultEntry e : entry.getHierarchyFromRootToLeaf()) {
                if (e == null || !(e.getSource() instanceof ENamedElement)) continue;
                txt = String.valueOf(((ENamedElement)e.getSource()).getName()) + "." + txt;
            }
        }
        return txt.endsWith(".") ? txt.substring(0, txt.lastIndexOf(".")) : txt;
    }

    @Override
    protected IModelElementEditorSelectionHandler getModelEditorSelectionHandler() {
        return new EcoreEditorSelectionHandler();
    }

    @Override
    protected List<AdapterFactory> getMetaElementComposeableAdapterFactories() {
        return EcoreCommonUtils.getMetaElementComposeableAdapterFactories();
    }

    protected IDialogSettings getDialogSettings() {
        return Activator.getDefault().getDialogSettings();
    }
}

