/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.utils;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ModelSearchImagesUtil {
    private static Map<URL, ImageDescriptor> imageDescriptorMap = new HashMap<URL, ImageDescriptor>();
    private static Map<URL, Image> imageMap = new HashMap<URL, Image>();
    public static ImageDescriptor MISSING_IMG_DESC = ImageDescriptor.getMissingImageDescriptor();

    static {
        MISSING_IMG_DESC.getImageData().scaledTo(16, 16);
    }

    public static Image getImage(URL url) {
        if (imageMap.containsKey(url)) {
            return imageMap.get(url);
        }
        Image image = ModelSearchImagesUtil.getImageDescriptor(url).createImage();
        imageMap.put(url, image);
        return image;
    }

    public static Image getImage(Bundle bundle, String imagePath) {
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(imagePath), null);
            if (imageMap.containsKey(url)) {
                return imageMap.get(url);
            }
            Image image = ModelSearchImagesUtil.getImageDescriptor(bundle, imagePath).createImage();
            imageMap.put(url, image);
            return image;
        }
        return MISSING_IMG_DESC.createImage();
    }

    public static ImageDescriptor getImageDescriptor(Bundle bundle, String imagePath) {
        ImageDescriptor desc = MISSING_IMG_DESC;
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(imagePath), null);
            if (imageDescriptorMap.containsKey(url)) {
                desc = imageDescriptorMap.get(url);
            } else {
                desc = ImageDescriptor.createFromURL((URL)url);
                imageDescriptorMap.put(url, desc);
            }
        }
        return desc;
    }

    public static ImageDescriptor getImageDescriptor(URL url) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        if (imageDescriptorMap.containsKey(url)) {
            desc = imageDescriptorMap.get(url);
        } else {
            desc = ImageDescriptor.createFromURL((URL)url);
            imageDescriptorMap.put(url, desc);
        }
        return desc;
    }
}

