/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.results;

import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.search.ui.text.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelSearchResultEntry
extends Match
implements IModelResultEntry {
    protected Object target;
    protected Object source;
    protected IModelResultEntry parent;
    protected boolean matchedOnce;
    private Collection<Object> children;

    public AbstractModelSearchResultEntry(IModelResultEntry p, Object t, Object s, boolean m) {
        super((Object)p, -1, -1);
        this.target = t;
        this.source = s;
        this.parent = p;
        this.children = new HashSet<Object>();
        this.setMatchedOnce(m);
    }

    @Override
    public Collection<Object> getResults() {
        return this.children;
    }

    @Override
    public void addChildren(IModelResultEntry e) {
        this.children.add(e);
    }

    @Override
    public void removeChildren(IModelResultEntry e) {
        this.children.remove(e);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public IModelResultEntry getParent() {
        return this.parent;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public void setParent(IModelResultEntry p) {
        this.parent = p;
    }

    @Override
    public boolean wasMatchedAtleastOnce() {
        return this.matchedOnce;
    }

    @Override
    public void setMatchedOnce(boolean matchedOnce) {
        this.matchedOnce = matchedOnce;
    }

    @Override
    public Stack<IModelResultEntry> getHierarchyFromRootToLeaf() {
        Stack<IModelResultEntry> hierarchy = new Stack<IModelResultEntry>();
        this.getHierarchyFromRootToLeaf(this, hierarchy);
        return hierarchy;
    }

    private void getHierarchyFromRootToLeaf(IModelResultEntry e, Stack<IModelResultEntry> hierarchy) {
        if (e instanceof IModelResultEntry) {
            hierarchy.push(e);
            this.getHierarchyFromRootToLeaf(e.getParent(), hierarchy);
        }
    }

    public abstract String getModelResultFullyQualifiedName();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractModelSearchResultEntry other = (AbstractModelSearchResultEntry)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.target == null ? other.target != null : !this.target.equals(other.target)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

