/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.core.internal.replace.provisional;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.search.core.engine.IModelSearchQuery;
import org.eclipse.emf.search.core.internal.replace.provisional.IModelSearchReplaceHandler;
import org.eclipse.emf.search.core.internal.replace.provisional.ModelSearchResultOccurenceChange;
import org.eclipse.emf.search.core.results.IModelResultEntry;
import org.eclipse.emf.search.core.results.IModelSearchResult;
import org.eclipse.emf.search.l10n.Messages;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ModelSearchResultCompositeChange
extends CompositeChange {
    private Resource resource;
    IModelSearchQuery modelSearchQuery;
    private IModelSearchResult modelSearchResult;
    private Collection<IModelResultEntry> occurences;
    private String oldValueReplaced;
    private String newReplaceValue;
    private IModelSearchReplaceHandler replaceHandler;

    public ModelSearchResultCompositeChange(IModelSearchQuery query, Resource target, IModelSearchReplaceHandler handler, String stringReplace) {
        super(Messages.getString("ModelSearchResultCompositeChange.ModelSearchChangeLabel.0"));
        this.resource = target;
        this.modelSearchQuery = query;
        this.modelSearchResult = query.getModelSearchResult();
        this.replaceHandler = handler;
        this.occurences = this.modelSearchResult.getResultsFlatennedForFile(target);
        this.newReplaceValue = stringReplace;
        for (IModelResultEntry occurence : this.occurences) {
            this.add(new ModelSearchResultOccurenceChange(occurence, handler));
        }
    }

    public Object getModifiedElement() {
        return this.resource;
    }

    public String getName() {
        String targetName = String.valueOf(Messages.getString("ModelSearchResultCompositeChange.ModelSearchChangeLabel.1")) + this.resource.getURI().toString() + Messages.getString("ModelSearchResultCompositeChange.ModelSearchChangeLabel.2") + this.modelSearchResult.getMatchesNumberForFile(this.resource) + Messages.getString("ModelSearchResultCompositeChange.ModelSearchChangeLabel.3");
        return targetName;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        TransactionalEditingDomain domain = TransactionalEditingDomainImpl.FactoryImpl.INSTANCE.getEditingDomain(this.resource.getResourceSet());
        if (!(domain instanceof EditingDomain)) {
            domain = TransactionalEditingDomainImpl.FactoryImpl.INSTANCE.createEditingDomain(this.resource.getResourceSet());
        }
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                for (IModelResultEntry occurence : ModelSearchResultCompositeChange.this.occurences) {
                    if (!(occurence.getSource() instanceof EObject)) continue;
                    ModelSearchResultCompositeChange.this.replaceHandler.handleReplace((EObject)occurence.getSource(), ModelSearchResultCompositeChange.this.modelSearchQuery, ModelSearchResultCompositeChange.this.newReplaceValue);
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("SAVE_ONLY_IF_CHANGED", "FILE_BUFFER");
                    try {
                        ModelSearchResultCompositeChange.this.resource.save(options);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        return new ModelSearchResultCompositeChange(this.modelSearchQuery, this.resource, this.replaceHandler, this.oldValueReplaced);
    }
}

