/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ui.viewer.structure;

import java.util.ArrayList;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.emf.compare.EMFCompareException;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.ModelInputSnapshot;
import org.eclipse.emf.compare.diff.metamodel.util.DiffAdapterFactory;
import org.eclipse.emf.compare.ui.EMFCompareUIMessages;
import org.eclipse.emf.compare.ui.internal.ModelComparator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class ModelStructureContentProvider
implements ITreeContentProvider {
    ModelInputSnapshot snapshot;
    private final CompareConfiguration configuration;
    private DiffModel diffInput;

    public ModelStructureContentProvider(CompareConfiguration compareConfiguration) {
        this.configuration = compareConfiguration;
    }

    public void dispose() {
        ModelComparator.removeComparator(this.configuration);
        this.diffInput = null;
        this.snapshot = null;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = null;
        if (parentElement instanceof EObject) {
            ArrayList<EObject> childrenList = new ArrayList<EObject>();
            for (EObject child : ((EObject)parentElement).eContents()) {
                if (DiffAdapterFactory.shouldBeHidden((EObject)child)) continue;
                childrenList.add(child);
            }
            children = childrenList.toArray();
        }
        return children;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = null;
        if (inputElement instanceof DiffModel) {
            elements = ((DiffModel)inputElement).getOwnedElements().toArray();
        } else {
            try {
                elements = this.diffInput.getOwnedElements().toArray();
            }
            catch (NullPointerException nullPointerException) {
                throw new EMFCompareException(EMFCompareUIMessages.getString("ModelStructureContentProvider.inputException"));
            }
        }
        return elements;
    }

    public Object getParent(Object element) {
        EObject parent = null;
        if (element instanceof EObject) {
            parent = ((EObject)element).eContainer();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof EObject) {
            hasChildren = !((EObject)element).eContents().isEmpty();
        }
        return hasChildren;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ((TreeViewer)viewer).getTree().clearAll(true);
        ModelComparator comparator = ModelComparator.getComparator(this.configuration);
        if (newInput instanceof ModelInputSnapshot) {
            this.snapshot = (ModelInputSnapshot)newInput;
        } else if (comparator.getComparisonResult() != null) {
            this.snapshot = comparator.getComparisonResult();
        } else if (oldInput != newInput && newInput instanceof ICompareInput) {
            comparator.loadResources((ICompareInput)newInput);
            this.snapshot = comparator.compare(this.configuration);
        }
        this.diffInput = this.snapshot.getDiff();
    }
}

