/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mint.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupAdapterImpl
extends AdapterImpl {
    protected NotifierEList targets;

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (target instanceof EObject) {
            this.addGroupTargets(this.getGroupTargets((EObject)target));
        }
    }

    public void unsetTarget(Notifier target) {
        if (target instanceof EObject) {
            this.removeGroupTargets(this.getGroupTargets((EObject)target));
        }
        super.unsetTarget(target);
    }

    public void dispose() {
        Notifier oldTarget = this.target;
        this.target = null;
        if (oldTarget != null) {
            oldTarget.eAdapters().remove((Object)this);
        }
    }

    public void notifyChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        Object feature = msg.getFeature();
        if (notifier instanceof EObject && feature instanceof EReference) {
            EObject object = (EObject)notifier;
            EReference ref = (EReference)feature;
            switch (msg.getEventType()) {
                case 3: {
                    if (!this.isGroupReference(object, ref)) break;
                    List<EObject> values = Collections.singletonList((EObject)msg.getNewValue());
                    this.addGroupTargets(values);
                    break;
                }
                case 5: {
                    if (!this.isGroupReference(object, ref)) break;
                    List values = (List)msg.getNewValue();
                    this.addGroupTargets(values);
                    break;
                }
                case 4: {
                    if (!this.isGroupReference(object, ref)) break;
                    List<EObject> values = Collections.singletonList((EObject)msg.getOldValue());
                    this.removeGroupTargets(values);
                    break;
                }
                case 6: {
                    if (!this.isGroupReference(object, ref)) break;
                    List values = (List)msg.getOldValue();
                    this.removeGroupTargets(values);
                    break;
                }
                case 1: {
                    List<EObject> values;
                    if (!this.isGroupReference(object, ref)) break;
                    if (msg.getOldValue() != null) {
                        values = Collections.singletonList((EObject)msg.getOldValue());
                        this.removeGroupTargets(values);
                    }
                    if (msg.getNewValue() == null) break;
                    values = Collections.singletonList((EObject)msg.getNewValue());
                    this.addGroupTargets(values);
                    break;
                }
                case 2: {
                    if (!this.isGroupReference(object, ref) || msg.getOldValue() == null) break;
                    List<EObject> values = Collections.singletonList((EObject)msg.getOldValue());
                    this.removeGroupTargets(values);
                }
            }
        }
    }

    protected NotificationForwarder createNotificationForwarder() {
        return new NotificationForwarder();
    }

    protected void addGroupTargets(List<? extends Notifier> groupTargets) {
        for (Notifier notifier : groupTargets) {
            if (notifier == this.target || EcoreUtil.getExistingAdapter((Notifier)notifier, (Object)((Object)this)) != null) continue;
            notifier.eAdapters().add((Object)this.createNotificationForwarder());
        }
    }

    protected void removeGroupTargets(List<? extends Notifier> groupTargets) {
        for (Notifier notifier : groupTargets) {
            ArrayList<Adapter> adapters = new ArrayList<Adapter>();
            for (Adapter adapter : notifier.eAdapters()) {
                if (!adapter.isAdapterForType((Object)this)) continue;
                adapters.add(adapter);
            }
            notifier.eAdapters().removeAll(adapters);
        }
    }

    protected List<EObject> getGroupTargets(EObject object) {
        BasicEList.FastCompare list = new BasicEList.FastCompare();
        List<EReference> refs = this.getGroupReferences(object);
        for (EReference ref : refs) {
            Object value = object.eGet((EStructuralFeature)ref);
            if (ref.isMany()) {
                EList values = (EList)value;
                list.addAll((Collection)values);
                continue;
            }
            if (value == null) continue;
            list.add((Object)((EObject)value));
        }
        return list;
    }

    protected boolean isGroupReference(EObject object, EReference ref) {
        List<EReference> list = this.getGroupReferences(object);
        if (list != null) {
            return list.contains(ref);
        }
        return false;
    }

    protected abstract List<EReference> getGroupReferences(EObject var1);

    protected Notifier getRootTarget() {
        return this.getTarget();
    }

    protected class NotificationForwarder
    extends AdapterImpl {
        protected NotificationForwarder() {
        }

        public void setTarget(Notifier target) {
            super.setTarget(target);
            if (target instanceof EObject) {
                GroupAdapterImpl.this.addGroupTargets(GroupAdapterImpl.this.getGroupTargets((EObject)target));
            }
        }

        public void unsetTarget(Notifier target) {
            if (target instanceof EObject) {
                GroupAdapterImpl.this.removeGroupTargets(GroupAdapterImpl.this.getGroupTargets((EObject)target));
            }
            super.unsetTarget(target);
        }

        public boolean isAdapterForType(Object type) {
            return type == GroupAdapterImpl.this;
        }

        public void notifyChanged(Notification msg) {
            GroupAdapterImpl.this.notifyChanged(msg);
        }

        public void dispose() {
            Notifier oldTarget = this.target;
            this.target = null;
            if (oldTarget != null) {
                oldTarget.eAdapters().remove((Object)this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NotifierEList
    extends BasicEList.FastCompare<Notifier> {
        protected NotifierEList() {
        }

        protected boolean canContainNull() {
            return false;
        }
    }
}

