/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.aggregation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class AggregationExample {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/aggregation";

    public static void run(String path) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("aggregation.henshin", false);
        EGraphImpl graph = new EGraphImpl(resourceSet.getResource("family.xmi"));
        EObject family = (EObject)graph.getRoots().get(0);
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine);
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("calcMemberCount"));
        InterpreterUtil.executeOrDie((UnitApplication)app);
        int memberCount = (Integer)family.eGet(family.eClass().getEStructuralFeature("memberCount"));
        System.out.println("Calculated " + memberCount + " family members");
        if (memberCount != 4) {
            throw new RuntimeException("Expected 4 family members");
        }
        app.setUnit(module.getUnit("calcAverageAge"));
        InterpreterUtil.executeOrDie((UnitApplication)app);
        double averageAge = (Double)family.eGet(family.eClass().getEStructuralFeature("averageAge"));
        System.out.println("Calculated " + averageAge + " as average age");
        if (averageAge != 20.0) {
            throw new RuntimeException("Expected average age of 20");
        }
    }

    public static void main(String[] args) {
        AggregationExample.run(PATH);
    }
}

