/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis.agt;

import agg.attribute.AttrContext;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.HandlerType;
import agg.attribute.handler.impl.javaExpr.JexExpr;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.attribute.parser.javaExpr.ASTId;
import agg.attribute.parser.javaExpr.ASTPrimaryExpression;
import agg.attribute.parser.javaExpr.SimpleNode;
import agg.parser.SimpleExcludePair;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.ColimDiagram;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Completion_NAC;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.TypeException;
import agg.xt_basis.agt.AmalgamatedRule;
import agg.xt_basis.agt.AmalgamationDataOfSingleKernelMatch;
import agg.xt_basis.agt.AmalgamationRuleData;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import agg.xt_basis.agt.RuleScheme;
import agg.xt_basis.csp.Completion_CSP;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Covering {
    private final BaseFactory bf = BaseFactory.theFactory();
    private GraGra gragra;
    private RuleScheme ruleScheme;
    private List<Rule> multiRules;
    private Graph hostGraph;
    private final MorphCompletionStrategy strategy = new Completion_InjCSP();
    private final List<AmalgamationDataOfSingleKernelMatch> amalgamationData;
    private final Hashtable<GraphObject, GraphObject> amalgamLHS2kernelLHS;
    private final Hashtable<GraphObject, GraphObject> amalgamRHS2kernelRHS;
    private Graph leftColimGraph;
    private Graph rightColimGraph;
    private final List<List<GraphObject>> disjointObjects;
    private AmalgamatedRule amalgamatedRule;
    protected Match amalgamatedMatch;
    private Rule kernelRule;
    private Match kernelMatch;
    private List<GraphObject> localDisjointObjs;
    private String errorMsg = "";
    private AmalgamationRuleData lastKernelData;
    private AmalgamationDataOfSingleKernelMatch lastDataOfSKM;

    public Covering(RuleScheme rs, Graph hostGraph, MorphCompletionStrategy s) {
        this.ruleScheme = rs;
        this.kernelRule = this.ruleScheme.getKernelRule();
        this.hostGraph = hostGraph;
        if (s != null) {
            this.strategy.getProperties().set(0, s.getProperties().get(0));
            this.strategy.getProperties().set(1, s.getProperties().get(1));
            this.strategy.getProperties().set(2, s.getProperties().get(2));
            this.strategy.getProperties().set(3, s.getProperties().get(3));
            this.strategy.getProperties().set(4, s.getProperties().get(4));
            this.strategy.getProperties().set(5, s.getProperties().get(5));
            this.strategy.setRandomisedDomain(s.isRandomisedDomain());
        }
        this.amalgamationData = new Vector<AmalgamationDataOfSingleKernelMatch>();
        this.disjointObjects = new Vector<List<GraphObject>>();
        this.amalgamRHS2kernelRHS = new Hashtable();
        this.amalgamLHS2kernelLHS = new Hashtable();
    }

    public AmalgamatedRule getAmalgamatedRule() {
        return this.amalgamatedRule;
    }

    public Match getAmalgamatedMatch() {
        return this.amalgamatedMatch;
    }

    public boolean amalgamate() {
        boolean result = false;
        this.multiRules = this.getEnabledMultiRules(this.ruleScheme.getMultiRules());
        boolean oneMultiRuleMatchExists = false;
        this.getKernelMatch();
        boolean hasKernelMatchCompletion = true;
        while (hasKernelMatchCompletion) {
            boolean kernelsteps = false;
            while ((!result || this.ruleScheme.parallelKernelMatch()) && hasKernelMatchCompletion) {
                hasKernelMatchCompletion = this.kernelMatch.nextCompletionWithConstantsChecking();
                if (!hasKernelMatchCompletion || !this.kernelMatch.isValid()) continue;
                kernelsteps = true;
                result = this.createAmalgamationData();
                if (result) {
                    oneMultiRuleMatchExists = true;
                    if (!this.ruleScheme.parallelKernelMatch()) break;
                    this.clearMultiRuleMatches();
                    continue;
                }
                this.clearMultiRuleMatches();
            }
            if (!result && this.ruleScheme.atLeastOneMultiMatchRequired()) continue;
            if (!kernelsteps && this.kernelMatch.isTotal() && this.kernelMatch.isAttrConditionSatisfied() && this.kernelMatch.areNACsSatisfied() && this.kernelMatch.arePACsSatisfied() && this.kernelRule.evalFormula() && this.kernelMatch.isValid() && !(result = this.createAmalgamationData()) && !this.ruleScheme.parallelKernelMatch()) {
                this.clearMultiRuleMatches();
            }
            if (!result && !this.ruleScheme.parallelKernelMatch() && this.kernelMatch.isValid() && this.lastDataOfSKM != null) {
                this.lastDataOfSKM.put(this.kernelRule, this.lastKernelData);
                this.amalgamationData.add(this.lastDataOfSKM);
                if (!this.multiRules.contains(this.kernelRule)) {
                    this.multiRules.add(this.kernelRule);
                }
                result = true;
            }
            if (result) {
                this.createLkernLinst_RkernRinstMorphs(this.amalgamationData);
                this.createInstanceRules(this.amalgamationData);
                if (this.computeColimLeft() && this.computeColimRight() && this.constructAmalgamatedRule()) {
                    this.amalgamatedMatch = this.constructAmalgamatedMatch(this.amalgamatedRule);
                    if (this.amalgamatedMatch != null) {
                        this.amalgamatedRule.adaptAttrContextValues(this.amalgamatedMatch.getAttrContext());
                        this.ruleScheme.setAmalgamatedRule(this.amalgamatedRule);
                        result = true;
                    } else {
                        this.amalgamatedRule.dispose();
                        this.amalgamatedRule = null;
                        result = false;
                    }
                }
            }
            if (result) break;
            this.clear();
            this.clearMultiRuleMatches();
        }
        this.ruleScheme.clearMatches();
        this.clear();
        return result;
    }

    private boolean createAmalgamationData() {
        boolean result = false;
        AmalgamationRuleData kernelData = this.createInstMatchDuetoKernelMatch(this.kernelMatch, this.kernelRule);
        if (kernelData == null) {
            return false;
        }
        AmalgamationDataOfSingleKernelMatch dataOfSKM = new AmalgamationDataOfSingleKernelMatch(kernelData);
        this.lastKernelData = kernelData;
        this.lastDataOfSKM = dataOfSKM;
        this.localDisjointObjs = new Vector<GraphObject>();
        boolean atLeastOneRule = false;
        boolean matchValid = true;
        int i = 0;
        while (i < this.multiRules.size()) {
            Rule rule = this.multiRules.get(i);
            if (!(rule instanceof KernelRule)) {
                Match multiMatch = this.getPartialMultiMatch((MultiRule)rule);
                if (multiMatch != null) {
                    matchValid = this.createInstMultiMatchesDuetoKernelMatch(multiMatch, (MultiRule)rule, dataOfSKM);
                }
                atLeastOneRule = atLeastOneRule || matchValid && !dataOfSKM.isEmpty(rule);
            }
            ++i;
        }
        if (atLeastOneRule) {
            this.amalgamationData.add(dataOfSKM);
            result = true;
        } else if (this.multiRules.isEmpty()) {
            result = true;
        }
        if (!result && !this.ruleScheme.parallelKernelMatch()) {
            this.clearMultiRuleMatches();
        }
        if (this.multiRules.isEmpty() || !atLeastOneRule && !this.ruleScheme.atLeastOneMultiMatchRequired()) {
            dataOfSKM.put(this.kernelRule, kernelData);
            this.amalgamationData.add(dataOfSKM);
            if (!this.multiRules.contains(this.kernelRule)) {
                this.multiRules.add(this.kernelRule);
            }
            result = true;
        }
        if (!result || this.ruleScheme.parallelKernelMatch()) {
            this.clearMultiRuleMatches();
        }
        return result;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    private List<Rule> getEnabledMultiRules(List<Rule> multis) {
        this.multiRules = new Vector<Rule>(multis.size());
        int i = 0;
        while (i < multis.size()) {
            MultiRule multiRule = (MultiRule)multis.get(i);
            if (multiRule.isEnabled()) {
                this.multiRules.add(multiRule);
            }
            ++i;
        }
        return this.multiRules;
    }

    private void clear() {
        this.disjointObjects.clear();
        this.amalgamationData.clear();
    }

    private void clearMultiRuleMatches() {
        int i = 0;
        while (i < this.multiRules.size()) {
            MultiRule multiRule;
            if (this.multiRules.get(i) instanceof MultiRule && (multiRule = (MultiRule)this.multiRules.get(i)).getMatch() != null) {
                multiRule.getMatch().dispose();
                multiRule.setMatch(null);
            }
            ++i;
        }
    }

    private boolean createInstMultiMatchesDuetoKernelMatch(Match multiMatch, MultiRule multiRule, AmalgamationDataOfSingleKernelMatch dataOfSKM) {
        this.errorMsg = "";
        boolean valid = false;
        while (multiMatch.nextCompletion()) {
            if (!multiMatch.isValid()) continue;
            valid = true;
            this.makeInstMultiMatchDuetoKernelMatch(multiMatch, multiRule, dataOfSKM);
        }
        if (!valid && multiMatch.isTotal() && multiMatch.isAttrConditionSatisfied() && multiMatch.areNACsSatisfied() && multiMatch.arePACsSatisfied() && multiRule.evalFormula() && multiMatch.isValid()) {
            this.makeInstMultiMatchDuetoKernelMatch(multiMatch, multiRule, dataOfSKM);
            valid = true;
        }
        multiMatch.clear();
        return valid;
    }

    private boolean makeInstMultiMatchDuetoKernelMatch(Match multiMatch, MultiRule multiRule, AmalgamationDataOfSingleKernelMatch dataOfSKM) {
        boolean nextComplMayExist = true;
        if (this.ruleScheme.disjointMultiMatches()) {
            if (!this.isDisjoint(multiMatch, multiRule)) {
                nextComplMayExist = false;
            } else {
                this.disjointObjects.add(this.localDisjointObjs);
            }
        } else if (!this.isDeleteUseConflictFree(multiMatch, multiRule, dataOfSKM)) {
            nextComplMayExist = false;
        }
        if (nextComplMayExist) {
            AmalgamationRuleData data = new AmalgamationRuleData(multiRule);
            data.isoCopyLeft = multiRule.getLeft().isomorphicCopy();
            data.isoCopyRight = multiRule.getRight().isomorphicCopy();
            nextComplMayExist = false;
            if (data.isoCopyLeft != null && data.isoCopyRight != null) {
                data.instMatch = this.makeInstanceMatchOfRuleMatch(data.isoCopyLeft, multiMatch);
                if (data.instMatch == null) {
                    data.isoCopyLeft.dispose();
                    data.isoCopyRight.dispose();
                    data = null;
                } else {
                    dataOfSKM.put(multiRule, data);
                }
            } else {
                data = null;
            }
        }
        return nextComplMayExist;
    }

    private boolean isDisjoint(Rule rule, List<GraphObject> owns) {
        if (!owns.isEmpty()) {
            int k = 0;
            while (k < owns.size()) {
                GraphObject obj = owns.get(k);
                int i = 0;
                while (i < this.disjointObjects.size()) {
                    List<GraphObject> list = this.disjointObjects.get(i);
                    if (list.contains(obj)) {
                        this.errorMsg = "Rule:  " + rule.getName() + "  - (multi) disjoint match failed.";
                        return false;
                    }
                    ++i;
                }
                ++k;
            }
        }
        return true;
    }

    private boolean isDisjoint(Match multiMatch, MultiRule rule) {
        Vector<GraphObject> owns = new Vector<GraphObject>();
        Enumeration<GraphObject> objs = multiMatch.getDomain();
        while (objs.hasMoreElements()) {
            GraphObject obj = objs.nextElement();
            if (rule.isTargetOfEmbeddingLeft(obj)) continue;
            owns.add(multiMatch.getImage(obj));
        }
        if (!owns.isEmpty()) {
            boolean localdisjointOK = true;
            int k = 0;
            while (k < owns.size()) {
                GraphObject obj = (GraphObject)owns.get(k);
                if (this.localDisjointObjs.contains(obj)) {
                    this.errorMsg = "Rule:  " + rule.getName() + "  - (multi) disjoint match failed.";
                    localdisjointOK = false;
                    break;
                }
                ++k;
            }
            if (localdisjointOK && this.isDisjoint(rule, owns)) {
                this.localDisjointObjs.addAll(owns);
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isDeleteUseConflictFree(Match multiMatch, MultiRule rule, AmalgamationDataOfSingleKernelMatch askMultiMatchData) {
        Vector<GraphObject> owns = new Vector<GraphObject>();
        Enumeration<GraphObject> objs = multiMatch.getDomain();
        while (objs.hasMoreElements()) {
            GraphObject obj = objs.nextElement();
            if (rule.isTargetOfEmbeddingLeft(obj)) continue;
            owns.add(multiMatch.getImage(obj));
        }
        if (!owns.isEmpty()) {
            Enumeration<Rule> keys = askMultiMatchData.getData().keys();
            while (keys.hasMoreElements()) {
                Rule r = keys.nextElement();
                List<AmalgamationRuleData> datas = askMultiMatchData.getData().get(r);
                int i = 0;
                while (i < datas.size()) {
                    OrdinaryMorphism m = datas.get((int)i).instMatch;
                    OrdinaryMorphism iso = datas.get((int)i).isoCopyLeft;
                    if (iso != null && iso.getSource() == r.getLeft()) {
                        int k = 0;
                        while (k < owns.size()) {
                            GraphObject obj1;
                            GraphObject obj = (GraphObject)owns.get(k);
                            if (m.getInverseImage(obj).hasMoreElements() && iso.getInverseImage(obj1 = m.getInverseImage(obj).nextElement()).hasMoreElements()) {
                                GraphObject obj2 = iso.getInverseImage(obj1).nextElement();
                                if (r.getImage(obj2) == null) {
                                    if (this.ruleScheme.checkDeleteUseConflictRequired()) {
                                        this.errorMsg = "Rule:  " + rule.getName() + "  has use-delete conflict with rule:  " + r.getName();
                                        return false;
                                    }
                                } else if (rule.getImage(multiMatch.getInverseImage(obj).nextElement()) == null) {
                                    if (this.ruleScheme.checkDeleteUseConflictRequired()) {
                                        this.errorMsg = "Rule:  " + rule.getName() + "  causes delete-use conflict.";
                                        return false;
                                    }
                                    if (obj2.isNode()) {
                                        GraphObject img2 = r.getImage(obj2);
                                        Iterator<Arc> arcs = ((Node)img2).getOutgoingArcs();
                                        while (arcs.hasNext()) {
                                            if (r.getInverseImage(arcs.next()).hasMoreElements()) continue;
                                            this.errorMsg = "Rule:  " + rule.getName() + "  causes delete-use conflict.";
                                            return false;
                                        }
                                        arcs = ((Node)img2).getIncomingArcs();
                                        while (arcs.hasNext()) {
                                            if (r.getInverseImage(arcs.next()).hasMoreElements()) continue;
                                            this.errorMsg = "Rule:  " + rule.getName() + "  causes delete-use conflict.";
                                            return false;
                                        }
                                    }
                                }
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    private boolean deleteUseConflictFound() {
        boolean result = false;
        this.ruleScheme.propagateApplCondsOfKernelToMultiRules();
        List<Rule> list = this.ruleScheme.getMultiRules();
        int i = list.size() - 1;
        while (i >= 0 && !result) {
            Rule r1 = list.get(i);
            if (r1.isEnabled()) {
                int j = 0;
                while (j < list.size() && !result) {
                    Rule r2 = list.get(j);
                    if (r2.isEnabled() && r1 != r2 && this.delUseConflictFound((MultiRule)r1, (MultiRule)r2)) {
                        result = true;
                    }
                    ++j;
                }
            }
            --i;
        }
        this.ruleScheme.removeShiftedApplConditionsFromMultiRules();
        return result;
    }

    private boolean delUseConflictFound(MultiRule r1, MultiRule r2) {
        SimpleExcludePair cp = new SimpleExcludePair();
        cp.setGraGra(this.gragra);
        cp.setMorphismCompletionStrategy(this.strategy);
        cp.enableStrongAttrCheck(true);
        cp.enableEqualVariableNameOfAttrMapping(true);
        boolean result = false;
        try {
            Object conflicts = cp.isCritical(0, r1, r2);
            if (conflicts != null && !((Vector)conflicts).isEmpty()) {
                int i = 0;
                while (i < ((Vector)conflicts).size() && !result) {
                    OrdinaryMorphism om1 = (OrdinaryMorphism)((Pair)((Pair)((Vector)conflicts).get((int)i)).first).first;
                    OrdinaryMorphism om2 = (OrdinaryMorphism)((Pair)((Pair)((Vector)conflicts).get((int)i)).first).second;
                    if (this.isMultiObjConflict(r1, om1) || this.isMultiObjConflict(r2, om2)) {
                        this.errorMsg = "Some multi rules are not conflict free ( ".concat(r1.getName().concat(" , ").concat(r2.getName()).concat(" )"));
                        result = true;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private boolean isMultiObjConflict(MultiRule r, OrdinaryMorphism om) {
        Enumeration<GraphObject> dom = om.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject obj = dom.nextElement();
            if (!om.getImage(obj).isCritical() || r.getEmbeddingLeft().getInverseImage(obj).hasMoreElements()) continue;
            return true;
        }
        return false;
    }

    private AmalgamationRuleData createInstMatchDuetoKernelMatch(Match match, Rule rule) {
        AmalgamationRuleData data = new AmalgamationRuleData(rule);
        data.isoCopyLeft = rule.getLeft().isomorphicCopy();
        data.isoCopyRight = rule.getRight().isomorphicCopy();
        if (data.isoCopyLeft != null && data.isoCopyRight != null) {
            data.instMatch = this.makeInstanceMatchOfRuleMatch(data.isoCopyLeft, match);
            if (data.instMatch == null) {
                data.isoCopyLeft.dispose();
                data.isoCopyRight.dispose();
                data = null;
            }
        } else {
            data = null;
        }
        return data;
    }

    private void createLkernLinst_RkernRinstMorphs(List<AmalgamationDataOfSingleKernelMatch> amalgamData) {
        int j = 0;
        while (j < this.amalgamationData.size()) {
            AmalgamationDataOfSingleKernelMatch dataOfSKM = this.amalgamationData.get(j);
            AmalgamationRuleData kerneldata = dataOfSKM.getKernelData();
            int i = 0;
            while (i < this.multiRules.size()) {
                Hashtable<Rule, List<AmalgamationRuleData>> amalgamationRuleData;
                List<AmalgamationRuleData> datas;
                Rule rule = this.multiRules.get(i);
                if (!dataOfSKM.isEmpty(rule) && !(datas = (amalgamationRuleData = dataOfSKM.getData()).get(rule)).isEmpty()) {
                    boolean failed = false;
                    int k = 0;
                    while (k < datas.size() && !failed) {
                        AmalgamationRuleData data = datas.get(k);
                        if (data.isoCopyLeft != null && data.isoCopyRight != null) {
                            OrdinaryMorphism embLeft = null;
                            OrdinaryMorphism embRight = null;
                            if (rule instanceof MultiRule) {
                                embLeft = ((MultiRule)rule).getEmbeddingLeft();
                                embRight = ((MultiRule)rule).getEmbeddingRight();
                            } else {
                                embLeft = data.isoCopyLeft;
                                embRight = data.isoCopyRight;
                            }
                            data.LkernelLinst = rule instanceof MultiRule ? this.bf.createMorphism(kerneldata.isoCopyLeft.getImage(), data.isoCopyLeft.getImage()) : data.isoCopyLeft;
                            Enumeration<GraphObject> embLeftDomain = embLeft.getDomain();
                            while (embLeftDomain.hasMoreElements()) {
                                GraphObject domElem = embLeftDomain.nextElement();
                                GraphObject obj = null;
                                GraphObject img = null;
                                if (!(rule instanceof MultiRule)) continue;
                                obj = kerneldata.isoCopyLeft.getImage(domElem);
                                img = data.isoCopyLeft.getImage(embLeft.getImage(domElem));
                                try {
                                    data.LkernelLinst.addMapping(obj, img);
                                    this.adoptEntriesWhereEmpty(data.LkernelLinst, obj, img, null);
                                }
                                catch (BadMappingException ex) {
                                    failed = true;
                                    break;
                                }
                            }
                            if (!failed) {
                                data.RkernelRinst = rule instanceof MultiRule ? this.bf.createMorphism(kerneldata.isoCopyRight.getImage(), data.isoCopyRight.getImage()) : data.isoCopyRight;
                                Enumeration<GraphObject> embRightDomain = embRight.getDomain();
                                while (embRightDomain.hasMoreElements()) {
                                    GraphObject domElem = embRightDomain.nextElement();
                                    GraphObject obj = null;
                                    GraphObject img = null;
                                    if (!(rule instanceof MultiRule)) continue;
                                    obj = kerneldata.isoCopyRight.getImage(domElem);
                                    img = data.isoCopyRight.getImage(embRight.getImage(domElem));
                                    try {
                                        data.RkernelRinst.addMapping(obj, img);
                                        this.adoptEntriesWhereEmpty(data.RkernelRinst, obj, img, null);
                                    }
                                    catch (BadMappingException ex) {
                                        failed = true;
                                        break;
                                    }
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    private void createInstanceRules(List<AmalgamationDataOfSingleKernelMatch> amalgamData) {
        int i = 0;
        while (i < this.multiRules.size()) {
            Rule rule = this.multiRules.get(i);
            Vector<AmalgamationRuleData> datas = new Vector<AmalgamationRuleData>();
            int j = 0;
            while (j < amalgamData.size()) {
                if (amalgamData.get(j).getRuleData(rule) != null) {
                    datas.addAll(amalgamData.get(j).getRuleData(rule));
                }
                ++j;
            }
            int k = 0;
            while (k < datas.size()) {
                AmalgamationRuleData data = (AmalgamationRuleData)datas.get(k);
                OrdinaryMorphism instRuleMorph = this.makeInstanceMorphism(data.isoCopyLeft.getTarget(), data.isoCopyRight.getTarget());
                instRuleMorph.addToAttrContextFromList(rule.getInputParametersLeft(), true);
                instRuleMorph.addToAttrContextFromList(rule.getInputParametersRight(), true);
                instRuleMorph.adaptAttrContextValues(rule.getAttrContext());
                boolean mapOK = true;
                Enumeration<GraphObject> dom = rule.getDomain();
                while (dom.hasMoreElements()) {
                    GraphObject obj = dom.nextElement();
                    GraphObject img = rule.getImage(obj);
                    GraphObject objLeft = data.isoCopyLeft.getImage(obj);
                    GraphObject objRight = data.isoCopyRight.getImage(img);
                    if (instRuleMorph.getImage(objLeft) != null) continue;
                    try {
                        instRuleMorph.addMapping(objLeft, objRight);
                        this.adoptEntriesWhereEmpty(instRuleMorph, objLeft, objRight, img);
                    }
                    catch (BadMappingException ex) {
                        mapOK = false;
                        break;
                    }
                }
                if (mapOK) {
                    data.instRule = this.bf.constructRuleFromMorph(instRuleMorph);
                    data.instRule.setName(String.valueOf(rule.getName()) + k);
                    data.instRule.addToAttrContext((VarTuple)data.instMatch.getAttrContext().getVariables());
                    data.instRule.adaptAttrContextValues(data.instMatch.getAttrContext());
                    if (k > 0) {
                        this.renameVariables(this.kernelRule, data.instRule, k);
                    }
                    this.tryToSetAttrValuesOfMorph(data.instRule);
                }
                ++k;
            }
            ++i;
        }
    }

    private boolean computeColimLeft() {
        AttrContext aRuleContext = AttrTupleManager.getDefaultManager().newContext(0);
        AttrContext aLeftContext = AttrTupleManager.getDefaultManager().newLeftContext(aRuleContext);
        this.leftColimGraph = BaseFactory.theFactory().createGraph(this.kernelRule.getTypeSet());
        this.leftColimGraph.setAttrContext(aLeftContext);
        ColimDiagram colimL = new ColimDiagram(this.leftColimGraph);
        colimL.addNode(this.leftColimGraph);
        int j = 0;
        while (j < this.amalgamationData.size()) {
            AmalgamationDataOfSingleKernelMatch askMatchdata = this.amalgamationData.get(j);
            AmalgamationRuleData kernelData = askMatchdata.getKernelData();
            colimL.addNode(kernelData.isoCopyLeft.getImage());
            Enumeration<Rule> keys = askMatchdata.getData().keys();
            while (keys.hasMoreElements()) {
                Rule rule = keys.nextElement();
                List<AmalgamationRuleData> datas = askMatchdata.getData().get(rule);
                int i = 0;
                while (i < datas.size()) {
                    AmalgamationRuleData data = datas.get(i);
                    if (data.LkernelLinst != null) {
                        OrdinaryMorphism colimedge = data.LkernelLinst;
                        if (rule instanceof KernelRule) {
                            colimL.addNode(this.kernelRule.getLeft());
                            colimL.addEdge(kernelData.isoCopyLeft);
                        } else {
                            colimL.addNode(colimedge.getImage());
                        }
                        colimL.addEdge(colimedge);
                        data.leftRequestEdge = new OrdinaryMorphism(colimedge.getImage(), this.leftColimGraph, AttrTupleManager.getDefaultManager().newContext(0));
                        colimL.requestEdge(data.leftRequestEdge);
                    }
                    ++i;
                }
            }
            ++j;
        }
        try {
            colimL.computeColimit(true);
        }
        catch (TypeException ex) {
            this.errorMsg = "Construction of the LHS of the amalgamated rule failed.";
            return false;
        }
        return true;
    }

    private boolean computeColimRight() {
        AttrContext aRuleContext = AttrTupleManager.getDefaultManager().newContext(0);
        AttrContext aRightContext = AttrTupleManager.getDefaultManager().newRightContext(aRuleContext);
        this.rightColimGraph = BaseFactory.theFactory().createGraph(this.kernelRule.getTypeSet());
        this.rightColimGraph.setAttrContext(aRightContext);
        ColimDiagram colimR = new ColimDiagram(this.rightColimGraph);
        colimR.addNode(this.rightColimGraph);
        int j = 0;
        while (j < this.amalgamationData.size()) {
            AmalgamationDataOfSingleKernelMatch askMatchdata = this.amalgamationData.get(j);
            AmalgamationRuleData kernelData = askMatchdata.getKernelData();
            colimR.addNode(kernelData.isoCopyRight.getImage());
            Enumeration<Rule> keys = askMatchdata.getData().keys();
            while (keys.hasMoreElements()) {
                Rule rule = keys.nextElement();
                List<AmalgamationRuleData> datas = askMatchdata.getData().get(rule);
                int i = 0;
                while (i < datas.size()) {
                    AmalgamationRuleData data = datas.get(i);
                    if (data.RkernelRinst != null) {
                        OrdinaryMorphism colimedge = data.RkernelRinst;
                        if (rule instanceof KernelRule) {
                            colimR.addNode(this.kernelRule.getRight());
                            colimR.addEdge(kernelData.isoCopyRight);
                        } else {
                            colimR.addNode(colimedge.getImage());
                        }
                        colimR.addEdge(colimedge);
                        data.rightRequestEdge = new OrdinaryMorphism(colimedge.getImage(), this.rightColimGraph, AttrTupleManager.getDefaultManager().newContext(0));
                        colimR.requestEdge(data.rightRequestEdge);
                    }
                    ++i;
                }
            }
            ++j;
        }
        try {
            colimR.computeColimit(true);
        }
        catch (TypeException ex) {
            this.errorMsg = "Construction of the RHS of the amalgamated rule failed.";
            return false;
        }
        return true;
    }

    private boolean constructAmalgamatedRule() {
        OrdinaryMorphism amalgamMorph = this.makeInstanceMorphism(this.leftColimGraph, this.rightColimGraph);
        int j = 0;
        while (j < this.amalgamationData.size()) {
            boolean stored = false;
            AmalgamationDataOfSingleKernelMatch askMatchdata = this.amalgamationData.get(j);
            Enumeration<Rule> keys = askMatchdata.getData().keys();
            while (keys.hasMoreElements()) {
                Rule rule = keys.nextElement();
                List<AmalgamationRuleData> datas = askMatchdata.getData().get(rule);
                int i = 0;
                while (i < datas.size()) {
                    AmalgamationRuleData data = datas.get(i);
                    if (data.leftRequestEdge != null) {
                        Enumeration<GraphObject> dom = data.instRule.getDomain();
                        while (dom.hasMoreElements()) {
                            GraphObject obj = dom.nextElement();
                            GraphObject img = data.instRule.getImage(obj);
                            GraphObject objLeft = data.leftRequestEdge.getImage(obj);
                            GraphObject objRight = data.rightRequestEdge.getImage(img);
                            if (objLeft == null || objRight == null || amalgamMorph.getImage(objLeft) != null) continue;
                            try {
                                amalgamMorph.addMapping(objLeft, objRight);
                                GraphObject origRight = data.isoCopyRight.getInverseImage(img).nextElement();
                                this.adoptEntriesWhereEmpty(amalgamMorph, objLeft, objRight, origRight);
                            }
                            catch (BadMappingException ex) {
                                this.errorMsg = "Amalgamated rule failed.\n" + ex.getMessage();
                                return false;
                            }
                        }
                        if (!stored) {
                            this.storeMappingAmalgamObjToKernelObj(data);
                            stored = true;
                        }
                        this.setAttrContext(data.instRule, amalgamMorph);
                    }
                    ++i;
                }
            }
            ++j;
        }
        this.setAttrContext(this.kernelRule, amalgamMorph);
        this.amalgamatedRule = new AmalgamatedRule(amalgamMorph);
        this.amalgamatedRule.setName(String.valueOf(this.ruleScheme.getName()) + "-Amalgamation");
        return true;
    }

    private void storeMappingAmalgamObjToKernelObj(AmalgamationRuleData data) {
        GraphObject kernel;
        GraphObject objAmalgam;
        GraphObject kernelObj;
        for (GraphObject graphObject : data.instRule.getLeft().getNodesSet()) {
            if (!data.LkernelLinst.getInverseImage(graphObject).hasMoreElements()) continue;
            kernelObj = data.LkernelLinst.getInverseImage(graphObject).nextElement();
            objAmalgam = data.leftRequestEdge.getImage(graphObject);
            if (kernelObj == null || objAmalgam == null || !this.lastKernelData.isoCopyLeft.getInverseImage(kernelObj).hasMoreElements()) continue;
            kernel = this.lastKernelData.isoCopyLeft.getInverseImage(kernelObj).nextElement();
            this.amalgamLHS2kernelLHS.put(objAmalgam, kernel);
        }
        for (GraphObject graphObject : data.instRule.getLeft().getArcsSet()) {
            if (!data.LkernelLinst.getInverseImage(graphObject).hasMoreElements()) continue;
            kernelObj = data.LkernelLinst.getInverseImage(graphObject).nextElement();
            objAmalgam = data.leftRequestEdge.getImage(graphObject);
            if (kernelObj == null || objAmalgam == null || !this.lastKernelData.isoCopyLeft.getInverseImage(kernelObj).hasMoreElements()) continue;
            kernel = this.lastKernelData.isoCopyLeft.getInverseImage(kernelObj).nextElement();
            this.amalgamLHS2kernelLHS.put(objAmalgam, kernel);
        }
        for (GraphObject graphObject : data.instRule.getRight().getNodesSet()) {
            if (!data.RkernelRinst.getInverseImage(graphObject).hasMoreElements()) continue;
            kernelObj = data.RkernelRinst.getInverseImage(graphObject).nextElement();
            objAmalgam = data.rightRequestEdge.getImage(graphObject);
            if (kernelObj == null || objAmalgam == null || !this.lastKernelData.isoCopyRight.getInverseImage(kernelObj).hasMoreElements()) continue;
            kernel = this.lastKernelData.isoCopyRight.getInverseImage(kernelObj).nextElement();
            this.amalgamRHS2kernelRHS.put(objAmalgam, kernel);
        }
        for (GraphObject graphObject : data.instRule.getRight().getArcsSet()) {
            if (!data.RkernelRinst.getInverseImage(graphObject).hasMoreElements()) continue;
            kernelObj = data.RkernelRinst.getInverseImage(graphObject).nextElement();
            objAmalgam = data.rightRequestEdge.getImage(graphObject);
            if (kernelObj == null || objAmalgam == null || !this.lastKernelData.isoCopyRight.getInverseImage(kernelObj).hasMoreElements()) continue;
            kernel = this.lastKernelData.isoCopyRight.getInverseImage(kernelObj).nextElement();
            this.amalgamRHS2kernelRHS.put(objAmalgam, kernel);
        }
    }

    public Hashtable<GraphObject, GraphObject> getMappingAmalgamToKernelRule() {
        return this.amalgamRHS2kernelRHS;
    }

    public Hashtable<GraphObject, GraphObject> getLHSMappingAmalgamToKernelRule() {
        return this.amalgamLHS2kernelLHS;
    }

    public Hashtable<GraphObject, GraphObject> getRHSMappingAmalgamToKernelRule() {
        return this.amalgamRHS2kernelRHS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Match constructAmalgamatedMatch(Rule amalgamRule) {
        Match m = this.bf.createMatch(amalgamRule, this.hostGraph);
        amalgamRule.setMatch(m);
        boolean mapOK = true;
        int j = 0;
        while (mapOK && j < this.amalgamationData.size()) {
            AmalgamationDataOfSingleKernelMatch askMatchdata = this.amalgamationData.get(j);
            Enumeration<Rule> keys = askMatchdata.getData().keys();
            block5: while (mapOK && keys.hasMoreElements()) {
                Rule rule = keys.nextElement();
                List<AmalgamationRuleData> datas = askMatchdata.getData().get(rule);
                int i = 0;
                while (i < datas.size() && mapOK) {
                    AmalgamationRuleData data = datas.get(i);
                    if (data.leftRequestEdge != null) {
                        GraphObject imgL;
                        GraphObject imgG;
                        GraphObject imgLi;
                        for (GraphObject graphObject : data.LkernelLinst.getOriginal().getNodesSet()) {
                            imgLi = data.LkernelLinst.getImage(graphObject);
                            imgG = data.instMatch.getImage(imgLi);
                            imgL = data.leftRequestEdge.getImage(imgLi);
                            try {
                                if (imgL == null || imgG == null) continue;
                                m.addMapping(imgL, imgG);
                            }
                            catch (BadMappingException ex) {
                                mapOK = false;
                                break;
                            }
                        }
                        for (GraphObject graphObject : data.LkernelLinst.getOriginal().getArcsSet()) {
                            imgLi = data.LkernelLinst.getImage(graphObject);
                            imgG = data.instMatch.getImage(imgLi);
                            imgL = data.leftRequestEdge.getImage(imgLi);
                            try {
                                if (imgL == null || imgG == null) continue;
                                m.addMapping(imgL, imgG);
                            }
                            catch (BadMappingException ex) {
                                mapOK = false;
                                break;
                            }
                        }
                        if (!m.makeDiagram(data.leftRequestEdge, data.instMatch)) {
                            System.out.println("makeDiagram   FAILED!");
                            continue block5;
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        if (!mapOK || !m.isTotal()) {
            this.errorMsg = "Amalgamated match failed.\n" + m.getErrorMsg();
        } else if (this.ruleScheme.parallelKernelMatch()) {
            if (this.glueObjectsOfAmalgamatedRule(amalgamRule, m)) {
                return m;
            }
            this.errorMsg = "Amalgamated rule failed.\n" + this.errorMsg;
        } else {
            m.setCompletionStrategy(this.strategy);
            m.getCompletionStrategy().getProperties().set(0, this.ruleScheme.disjointMultiMatches());
            if (this.ruleScheme.disjointMultiMatches()) {
                if (!m.getCompletionStrategy().getProperties().get(1)) return m;
                if (m.isDanglingSatisfied()) {
                    return m;
                }
                this.errorMsg = "Amalgamated match failed.\n" + m.getErrorMsg();
            } else if (this.glueObjectsOfAmalgamatedRule(amalgamRule, m)) {
                if (!m.getCompletionStrategy().getProperties().get(1)) return m;
                if (m.isDanglingSatisfied()) {
                    return m;
                }
                this.errorMsg = "Amalgamated match failed.\n" + m.getErrorMsg();
            } else {
                this.errorMsg = "Amalgamated rule failed.\n" + this.errorMsg;
            }
        }
        amalgamRule.setMatch(null);
        m.dispose();
        return null;
    }

    private boolean glueObjectsOfAmalgamatedRule(Rule amalgamRule, Match m) {
        int tgCheckLevel = m.getTarget().getTypeSet().getLevelOfTypeGraphCheck();
        m.getTarget().getTypeSet().setLevelOfTypeGraph(10);
        Hashtable<GraphObject, GraphObject> l2r = new Hashtable<GraphObject, GraphObject>();
        Hashtable<GraphObject, List<GraphObject>> keep2glue = new Hashtable<GraphObject, List<GraphObject>>();
        Vector<GraphObject> toDelete = new Vector<GraphObject>();
        Enumeration<GraphObject> matchCodom = m.getCodomain();
        while (matchCodom.hasMoreElements()) {
            List<GraphObject> listL;
            GraphObject codomObj = matchCodom.nextElement();
            if (!(codomObj instanceof Arc) || (listL = m.getInverseImageList(codomObj)).size() <= 1) continue;
            Vector<GraphObject> listR = new Vector<GraphObject>();
            int i = 0;
            while (i < listL.size()) {
                GraphObject img = amalgamRule.getImage(listL.get(i));
                if (img != null) {
                    listR.add(img);
                }
                ++i;
            }
            boolean shouldDelete = listL.size() > listR.size();
            GraphObject objL = listL.get(0);
            GraphObject objR = listR.size() > 0 ? (GraphObject)listR.get(0) : null;
            keep2glue.put(objL, listL);
            if (objR == null) continue;
            keep2glue.put(objR, listR);
            l2r.put(objL, objR);
            if (!shouldDelete) continue;
            toDelete.add(objR);
        }
        boolean result = true;
        matchCodom = m.getCodomain();
        while (matchCodom.hasMoreElements()) {
            List<GraphObject> listL;
            GraphObject codomObj = matchCodom.nextElement();
            if (!(codomObj instanceof Node) || (listL = m.getInverseImageList(codomObj)).size() <= 1) continue;
            Vector<GraphObject> listR = new Vector<GraphObject>();
            int i = 0;
            while (i < listL.size()) {
                GraphObject obj = listL.get(i);
                GraphObject img = amalgamRule.getImage(obj);
                if (img != null) {
                    listR.add(img);
                }
                ++i;
            }
            boolean shouldDelete = listL.size() > listR.size();
            GraphObject objL = listL.get(0);
            GraphObject objR = listR.size() > 0 ? (GraphObject)listR.get(0) : null;
            try {
                if (this.glueObjects(objL, listL)) {
                    if (objR == null) continue;
                    try {
                        if (this.glueObjects(objR, listR)) {
                            l2r.put(objL, objR);
                            if (!shouldDelete) continue;
                            toDelete.add(objR);
                            continue;
                        }
                        this.errorMsg = "Gluing nodes failed.";
                        result = false;
                    }
                    catch (TypeException ex) {
                        this.errorMsg = "Gluing nodes failed. \n" + ex.getLocalizedMessage();
                        result = false;
                    }
                    continue;
                }
                this.errorMsg = "Gluing nodes failed.";
                result = false;
            }
            catch (TypeException ex) {
                this.errorMsg = "Gluing nodes failed. \n" + ex.getLocalizedMessage();
                result = false;
            }
        }
        Enumeration keep = keep2glue.keys();
        while (keep.hasMoreElements() && result) {
            GraphObject keepObj = (GraphObject)keep.nextElement();
            List glue = (List)keep2glue.get(keepObj);
            try {
                if (this.glueObjects(keepObj, glue)) continue;
                this.errorMsg = "Gluing edges failed.";
                result = false;
            }
            catch (TypeException ex) {
                this.errorMsg = "Gluing edges failed. \n" + ex.getLocalizedMessage();
                result = false;
            }
        }
        if (result) {
            GraphObject r;
            Enumeration lhs = l2r.keys();
            while (lhs.hasMoreElements()) {
                GraphObject l = (GraphObject)lhs.nextElement();
                if (!l.isNode()) continue;
                r = (GraphObject)l2r.get(l);
                if (amalgamRule.getImage(l) != null) continue;
                try {
                    amalgamRule.addMapping(l, r);
                }
                catch (BadMappingException ex) {
                    this.errorMsg = "Node mapping after gluing nodes failed.";
                    result = false;
                    break;
                }
            }
            while (lhs.hasMoreElements()) {
                GraphObject l = (GraphObject)lhs.nextElement();
                if (!l.isArc()) continue;
                r = (GraphObject)l2r.get(l);
                if (amalgamRule.getImage(l) != null) continue;
                try {
                    amalgamRule.addMapping(l, r);
                }
                catch (BadMappingException ex) {
                    this.errorMsg = "Edge mapping after gluing edges failed.";
                    result = false;
                    break;
                }
            }
        }
        if (result) {
            int i = 0;
            while (i < toDelete.size()) {
                GraphObject go = (GraphObject)toDelete.get(i);
                try {
                    if (go.getContext() != null) {
                        if (go instanceof Node) {
                            amalgamRule.getRight().destroyNode((Node)go, true, false);
                        } else {
                            amalgamRule.getRight().destroyArc((Arc)go, true, false);
                        }
                    }
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
                ++i;
            }
        }
        m.getTarget().getTypeSet().setLevelOfTypeGraph(tgCheckLevel);
        if (result) {
            if (amalgamRule.getTypeSet().checkType(amalgamRule.getLeft(), tgCheckLevel).isEmpty() && amalgamRule.getTypeSet().checkType(amalgamRule.getRight(), tgCheckLevel).isEmpty()) {
                result = true;
            } else {
                this.errorMsg = "Gluing of graph objects failed (type check). ";
                result = false;
            }
        }
        return result;
    }

    private boolean glueObjects(GraphObject keep, List<GraphObject> list) throws TypeException {
        int i = 0;
        while (i < list.size()) {
            GraphObject glue = list.get(i);
            if (keep != glue) {
                block5: {
                    if (keep.getContext().glue(keep, glue)) break block5;
                    return false;
                }
                list.remove(glue);
                --i;
            }
            ++i;
        }
        return true;
    }

    private void setAttrContext(OrdinaryMorphism from, OrdinaryMorphism to) {
        VarTuple varsTo = (VarTuple)to.getAttrContext().getVariables();
        VarTuple varsFrom = (VarTuple)from.getAttrContext().getVariables();
        int j = 0;
        while (j < varsFrom.getSize()) {
            VarMember vmFrom = varsFrom.getVarMemberAt(j);
            DeclMember dm = (DeclMember)vmFrom.getDeclaration();
            if (!varsTo.isDeclared(dm.getTypeName(), dm.getName())) {
                varsTo.declare(dm.getHandler(), dm.getTypeName(), dm.getName());
            }
            VarMember vmTo = varsTo.getVarMemberAt(dm.getName());
            vmTo.setInputParameter(vmFrom.isInputParameter());
            if (vmFrom.isSet()) {
                vmTo.setExprAsText(vmFrom.getExprAsText());
            }
            ++j;
        }
    }

    private void getKernelMatch() {
        this.kernelMatch = this.kernelRule.getMatch();
        if (this.kernelMatch == null) {
            this.kernelMatch = this.bf.createMatch(this.kernelRule, this.hostGraph);
            this.kernelRule.setMatch(this.kernelMatch);
        }
        if (this.strategy.getProperties().get(0)) {
            this.kernelMatch.setCompletionStrategy(new Completion_NAC(new Completion_InjCSP()));
        } else {
            this.kernelMatch.setCompletionStrategy(new Completion_NAC(new Completion_CSP()));
        }
        this.kernelMatch.getCompletionStrategy().getProperties().set(2, this.strategy.getProperties().get(2));
        this.kernelMatch.getCompletionStrategy().getProperties().set(3, this.strategy.getProperties().get(3));
        this.kernelMatch.getCompletionStrategy().getProperties().set(4, this.strategy.getProperties().get(4));
        this.kernelMatch.getCompletionStrategy().getProperties().set(5, this.strategy.getProperties().get(5));
        this.kernelMatch.getCompletionStrategy().getProperties().set(1, this.strategy.getProperties().get(1));
        this.kernelMatch.getCompletionStrategy().getProperties().set(1, false);
        this.kernelMatch.getCompletionStrategy().setRandomisedDomain(this.strategy.isRandomisedDomain());
        this.kernelMatch.getCompletionStrategy().initialize(this.kernelMatch);
    }

    private Match getPartialMultiMatch(MultiRule multiRule) {
        Match multiMatch = multiRule.getMatch();
        if (multiMatch == null) {
            multiMatch = multiRule.getMatch(this.kernelRule);
        }
        if (multiMatch != null) {
            if (this.strategy.getProperties().get(0)) {
                multiMatch.setCompletionStrategy(new Completion_NAC(new Completion_InjCSP()));
            } else {
                multiMatch.setCompletionStrategy(new Completion_NAC(new Completion_CSP()));
            }
            multiMatch.getCompletionStrategy().getProperties().set(2, this.strategy.getProperties().get(2));
            multiMatch.getCompletionStrategy().getProperties().set(3, this.strategy.getProperties().get(3));
            multiMatch.getCompletionStrategy().getProperties().set(4, this.strategy.getProperties().get(4));
            multiMatch.getCompletionStrategy().getProperties().set(5, this.strategy.getProperties().get(5));
            multiMatch.getCompletionStrategy().getProperties().set(1, false);
            multiMatch.getCompletionStrategy().setRandomisedDomain(this.strategy.isRandomisedDomain());
            multiMatch.getCompletionStrategy().initialize(multiMatch);
        }
        return multiMatch;
    }

    private OrdinaryMorphism makeInstanceMorphism(Graph src, Graph tar) {
        AttrContext context = AttrTupleManager.getDefaultManager().newContext(0);
        OrdinaryMorphism morph = new OrdinaryMorphism(src, tar, context);
        return morph;
    }

    private OrdinaryMorphism makeInstanceMatchOfRuleMatch(OrdinaryMorphism LruleLinst, Match ruleMatch) {
        OrdinaryMorphism instMatch = this.makeInstanceMorphism(LruleLinst.getTarget(), ruleMatch.getTarget());
        instMatch.setName(ruleMatch.getName());
        Enumeration<GraphObject> e = ruleMatch.getDomain();
        while (e.hasMoreElements()) {
            GraphObject o = e.nextElement();
            GraphObject oImg = LruleLinst.getImage(o);
            GraphObject img = ruleMatch.getImage(o);
            try {
                instMatch.addMapping(oImg, img);
            }
            catch (BadMappingException ex) {
                return null;
            }
        }
        instMatch.addToAttrContext((VarTuple)ruleMatch.getRule().getAttrContext().getVariables());
        instMatch.adaptAttrContextValues(ruleMatch.getAttrContext());
        return instMatch;
    }

    private void tryToSetAttrValuesOfMorph(OrdinaryMorphism morph) {
        Iterator<GraphObject> e1 = morph.getSource().getNodesSet().iterator();
        while (e1.hasNext()) {
            this.tryToSetValueFromVar(morph, e1.next());
        }
        e1 = morph.getSource().getArcsSet().iterator();
        while (e1.hasNext()) {
            this.tryToSetValueFromVar(morph, e1.next());
        }
        e1 = morph.getTarget().getNodesSet().iterator();
        while (e1.hasNext()) {
            this.tryToSetValueFromVarAndExpr(morph, e1.next());
        }
        e1 = morph.getTarget().getArcsSet().iterator();
        while (e1.hasNext()) {
            this.tryToSetValueFromVarAndExpr(morph, e1.next());
        }
    }

    private void tryToSetValueFromVar(OrdinaryMorphism morph, GraphObject go) {
        if (go.getAttribute() != null) {
            ValueTuple value = (ValueTuple)go.getAttribute();
            int j = 0;
            while (j < value.getNumberOfEntries()) {
                VarMember var;
                ValueMember mem = value.getValueMemberAt(j);
                if (mem.isSet() && mem.getExpr().isVariable() && (var = ((VarTuple)morph.getAttrContext().getVariables()).getVarMemberAt(mem.getExprAsText())) != null && var.isSet()) {
                    mem.setExpr(var.getExpr());
                }
                ++j;
            }
        }
    }

    private void tryToSetValueFromVarAndExpr(OrdinaryMorphism morph, GraphObject go) {
        if (go.getAttribute() != null) {
            ValueTuple value = (ValueTuple)go.getAttribute();
            int j = 0;
            while (j < value.getNumberOfEntries()) {
                ValueMember mem = value.getValueMemberAt(j);
                if (mem.isSet()) {
                    if (mem.getExpr().isVariable()) {
                        VarMember var = ((VarTuple)morph.getAttrContext().getVariables()).getVarMemberAt(mem.getExprAsText());
                        if (var != null && var.isSet()) {
                            mem.setExpr(var.getExpr());
                        }
                    } else if (mem.getExpr().isComplex()) {
                        try {
                            mem.getExpr().evaluate(morph.getAttrContext());
                        }
                        catch (AttrHandlerException ex) {
                            System.out.println("Covering.tryToComputeAttrExpresionOfMorph:: " + ex);
                        }
                    }
                }
                ++j;
            }
        }
    }

    private void adoptEntries(OrdinaryMorphism morph, GraphObject from, GraphObject to) {
        if (from.getAttribute() != null && to.getAttribute() != null) {
            ValueTuple valFrom = (ValueTuple)from.getAttribute();
            ValueTuple valTo = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < valFrom.getNumberOfEntries()) {
                ValueMember vmTo;
                ValueMember vmFrom = valFrom.getEntryAt(i);
                if (vmFrom.isSet() && (vmTo = valTo.getEntryAt(vmFrom.getName())) != null) {
                    vmTo.setExprAsText(vmFrom.getExprAsText());
                }
                ++i;
            }
        }
    }

    private void adoptEntriesWhereEmpty(OrdinaryMorphism morph, GraphObject from, GraphObject to, GraphObject origTo) {
        if (morph.getImage(from) != null && from.getAttribute() != null && to.getAttribute() != null) {
            ValueTuple valuefrom = (ValueTuple)from.getAttribute();
            ValueTuple value = (ValueTuple)to.getAttribute();
            int i = 0;
            while (i < value.getSize()) {
                ValueMember vm = value.getValueMemberAt(i);
                ValueMember vmfrom = valuefrom.getValueMemberAt(vm.getName());
                if (origTo == null) {
                    if (!vm.isSet() && vmfrom != null && vmfrom.isSet()) {
                        vm.setExprAsText(vmfrom.getExprAsText());
                    }
                } else {
                    ValueMember vm_origTo = ((ValueTuple)origTo.getAttribute()).getValueMemberAt(vm.getName());
                    if (vm_origTo.isSet() && !vm.isSet() && vmfrom != null && vmfrom.isSet()) {
                        vm.setExprAsText(vmfrom.getExprAsText());
                    }
                }
                ++i;
            }
        }
    }

    private void setAttributeVariable(String from, String to, AttrContext ac, Iterator<?> e) {
        VarTuple vars = (VarTuple)ac.getVariables();
        while (e.hasNext()) {
            GraphObject obj = (GraphObject)e.next();
            if (obj.getAttribute() == null) continue;
            ValueTuple fromObj = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < fromObj.getSize()) {
                ValueMember fromVM = fromObj.getValueMemberAt(i);
                if (fromVM.isSet()) {
                    if (fromVM.getExpr().isVariable() && fromVM.getExprAsText().equals(from)) {
                        fromVM.setExprAsText(to);
                        VarMember var = vars.getVarMemberAt(to);
                        if (var == null) {
                            vars.declare(fromVM.getDeclaration().getHandler(), fromVM.getDeclaration().getTypeName(), to);
                        }
                    } else if (fromVM.getExpr().isComplex()) {
                        JexExpr oldExpr = (JexExpr)fromVM.getExpr();
                        Vector<String> variables = new Vector<String>();
                        oldExpr.getAllVariables(variables);
                        this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, ac, vars);
                    }
                }
                ++i;
            }
        }
    }

    private void renameVariables(Rule basicr, OrdinaryMorphism LiRi, int index) {
        String mark = String.valueOf(index);
        VarTuple varsBasic = (VarTuple)basicr.getAttrContext().getVariables();
        VarTuple varsLiRi = (VarTuple)LiRi.getAttrContext().getVariables();
        int i = 0;
        while (i < varsLiRi.getSize()) {
            VarMember vm = varsLiRi.getVarMemberAt(i);
            VarMember vmKernel = varsBasic.getVarMemberAt(vm.getName());
            if (vmKernel == null) {
                String from = vm.getName();
                String to = String.valueOf(vm.getName()) + mark;
                vm.getDeclaration().setName(to);
                this.setAttributeVariable(from, to, LiRi.getAttrContext(), LiRi.getSource().getNodesSet().iterator());
                this.setAttributeVariable(from, to, LiRi.getAttrContext(), LiRi.getSource().getArcsSet().iterator());
                this.setAttributeVariable(from, to, LiRi.getAttrContext(), LiRi.getTarget().getNodesSet().iterator());
                this.setAttributeVariable(from, to, LiRi.getAttrContext(), LiRi.getTarget().getArcsSet().iterator());
                CondTuple conds = (CondTuple)LiRi.getAttrContext().getConditions();
                int j = 0;
                while (j < conds.getSize()) {
                    CondMember cm = conds.getCondMemberAt(j);
                    Vector<String> v1 = cm.getAllVariables();
                    if (v1.contains(from)) {
                        JexExpr oldExpr = (JexExpr)cm.getExpr();
                        Vector<String> variables = new Vector<String>();
                        oldExpr.getAllVariables(variables);
                        this.findPrimaryAndReplace((SimpleNode)oldExpr.getAST(), from, to, LiRi.getAttrContext(), null);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void findPrimaryAndReplace(SimpleNode node, String from, String to, AttrContext ac, VarTuple vars) {
        AttrContext symbs = ac;
        int j = 0;
        while (j < node.jjtGetNumChildren()) {
            SimpleNode n = (SimpleNode)node.jjtGetChild(j);
            if (n instanceof ASTPrimaryExpression || n instanceof ASTId) {
                if (n.getString().equals(from)) {
                    SimpleNode test;
                    HandlerExpr expression2;
                    HandlerType t;
                    VarMember vm;
                    boolean to_found = false;
                    ContextView context = (ContextView)symbs;
                    VarTuple vt = (VarTuple)context.getVariables();
                    int i = 0;
                    while (i < vt.getSize()) {
                        vm = vt.getVarMemberAt(i);
                        if (vm.getName().equals(to)) {
                            to_found = true;
                            t = vm.getDeclaration().getType();
                            try {
                                expression2 = vm.getHandler().newHandlerExpr(t, to);
                                test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                node.replaceChild(n, test);
                            }
                            catch (AttrHandlerException expression2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    if (!to_found) {
                        i = 0;
                        while (i < vars.getSize()) {
                            vm = vars.getVarMemberAt(i);
                            if (vm.getName().equals(to)) {
                                to_found = true;
                                t = vm.getDeclaration().getType();
                                try {
                                    expression2 = vm.getHandler().newHandlerExpr(t, to);
                                    test = (SimpleNode)expression2.getAST().jjtGetChild(0);
                                    node.replaceChild(n, test);
                                }
                                catch (AttrHandlerException attrHandlerException) {
                                    // empty catch block
                                }
                            }
                            ++i;
                        }
                    }
                } else if (n.getString().contains(from)) {
                    this.findPrimaryAndReplace(n, from, to, ac, vars);
                }
            } else {
                this.findPrimaryAndReplace(n, from, to, ac, vars);
            }
            ++j;
        }
    }
}

