/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.parser.ExcludePairContainer;
import agg.parser.InvalidAlgorithmException;
import agg.util.Pair;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Consistency
implements Runnable {
    ExcludePairContainer excludeContainer;
    Rule rule1;
    Rule rule2;

    public Consistency(ExcludePairContainer excludeContainer) {
        this.excludeContainer = excludeContainer;
        this.rule1 = null;
        this.rule2 = null;
    }

    public Consistency(ExcludePairContainer excludeContainer, Rule r1, Rule r2) {
        this(excludeContainer);
        this.rule1 = r1;
        this.rule2 = r2;
    }

    @Override
    public void run() {
        if (this.rule1 != null && this.rule2 != null) {
            this.checkRulePair();
        } else {
            this.check();
        }
    }

    public void check() {
        try {
            Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeCont = this.excludeContainer.getContainer(0);
            GraGra gra = this.excludeContainer.getGrammar();
            Enumeration<Rule> keys = excludeCont.keys();
            while (keys.hasMoreElements()) {
                Rule r1 = keys.nextElement();
                Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = excludeCont.get(r1);
                Enumeration<Rule> k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    Rule r2 = k2.nextElement();
                    Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> pair = secondPart.get(r2);
                    Boolean b = (Boolean)pair.first;
                    if (!b.booleanValue()) continue;
                    Vector v = (Vector)pair.second;
                    int size = v.size();
                    int i = 0;
                    while (i < size) {
                        Pair pi = (Pair)v.elementAt(i);
                        Pair p = (Pair)pi.first;
                        Graph g = ((OrdinaryMorphism)p.first).getImage();
                        if (!gra.checkGraphConsistency(g)) {
                            v.removeElement(p);
                            BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.first);
                            BaseFactory.theFactory().destroyMorphism((OrdinaryMorphism)p.second);
                            --i;
                            size = v.size();
                        }
                        ++i;
                    }
                    if (v.size() != 0) continue;
                    this.excludeContainer.moveEntryFromExcludeToConflictFreeContainer(r1, r2);
                }
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
    }

    public void checkRulePair() {
        try {
            Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> excludeCont = this.excludeContainer.getContainer(0);
            GraGra gra = this.excludeContainer.getGrammar();
            Enumeration<Rule> keys = excludeCont.keys();
            while (keys.hasMoreElements()) {
                Rule r1 = keys.nextElement();
                if (r1 != this.rule1) continue;
                Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> secondPart = excludeCont.get(r1);
                Enumeration<Rule> k2 = secondPart.keys();
                while (k2.hasMoreElements()) {
                    Rule r2 = k2.nextElement();
                    if (r2 != this.rule2) continue;
                    Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> pair = secondPart.get(r2);
                    Boolean b = (Boolean)pair.first;
                    if (!b.booleanValue()) continue;
                    Vector v = (Vector)pair.second;
                    int size = v.size();
                    int i = 0;
                    while (i < size) {
                        Pair pi = (Pair)v.elementAt(i);
                        Pair p = (Pair)pi.first;
                        Graph g = ((OrdinaryMorphism)p.first).getImage();
                        if (!g.isEmpty() && !gra.checkGraphConsistency(g)) {
                            v.removeElement(p);
                            ((OrdinaryMorphism)p.first).dispose();
                            ((OrdinaryMorphism)p.second).dispose();
                            --i;
                            size = v.size();
                        }
                        ++i;
                    }
                    if (v.size() != 0) continue;
                    this.excludeContainer.moveEntryFromExcludeToConflictFreeContainer(r1, r2);
                }
            }
        }
        catch (InvalidAlgorithmException invalidAlgorithmException) {
            // empty catch block
        }
    }
}

