/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.AttrContext;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.editor.impl.ArcReprData;
import agg.editor.impl.CenterOfPoints;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraphObject;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.editor.impl.EditUndoManager;
import agg.editor.impl.Loop;
import agg.editor.impl.NodeReprData;
import agg.editor.impl.TypeReprData;
import agg.layout.evolutionary.EvolutionaryGraphLayout;
import agg.util.Change;
import agg.util.Pair;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.TypeSet;
import agg.xt_basis.UndirectedGraph;
import agg.xt_basis.agt.KernelRule;
import agg.xt_basis.agt.MultiRule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class EdGraph
implements XMLObject,
Observer,
StateEditable {
    protected Graph bGraph;
    protected EdGraGra eGra;
    protected EdTypeSet typeSet;
    protected Vector<EdNode> nodes;
    protected Vector<EdArc> arcs;
    private Hashtable<Node, EdNode> basisNode2node;
    protected Vector<EdNode> visibleNodes;
    protected Vector<EdArc> visibleArcs;
    protected Vector<EdNode> selectedNodes;
    protected Vector<EdArc> selectedArcs;
    protected Vector<GraphObject> changedObjects;
    protected Vector<EdArc> inheritanceArcs;
    private Vector<EdGraphObject> newAfterTransformStep;
    private EvolutionaryGraphLayout itsLayouter;
    protected EdNode selectedNode;
    protected EdArc selectedArc;
    private EdType inheritanceType;
    protected EdGraphObject pickedObj;
    private EdGraph gCopy;
    protected boolean editable;
    protected boolean isTG;
    private boolean isCPA;
    protected int criticalStyle;
    protected int hidden;
    protected boolean visibilityChecked;
    protected boolean changed;
    private boolean isTransformChange;
    private boolean isGraphTransformed;
    protected String errMsg;
    protected boolean straightenArcs;
    protected boolean hasDefaultLayout;
    protected boolean externalLayouting;
    private Dimension gDim;
    private int ggen;
    private boolean staticNodeXY;
    private double itsScale;
    private boolean firstDraw = true;
    protected boolean nodeNumberChanged;
    private boolean nodeRemoved;
    protected EditUndoManager undoManager;
    protected StateEdit newEdit;
    protected Pair<String, Vector<?>> undoObj;

    public EdGraph() {
        this.init();
        this.typeSet = new EdTypeSet();
    }

    public EdGraph(EdTypeSet types) {
        this.init();
        this.typeSet = types != null ? types : new EdTypeSet();
    }

    public EdGraph(Graph graph) {
        this.init();
        if (graph == null) {
            this.typeSet = new EdTypeSet();
        } else {
            this.bGraph = graph;
            this.bGraph.addObserver(this);
            this.typeSet = new EdTypeSet(this.bGraph.getTypeSet());
            if (this.bGraph instanceof TypeGraph) {
                this.isTG = true;
            }
            this.makeGraphObjects();
        }
    }

    public EdGraph(Graph graph, EdTypeSet types) {
        this.init();
        if (graph == null) {
            this.typeSet = types != null ? types : new EdTypeSet();
        } else {
            this.bGraph = graph;
            this.bGraph.addObserver(this);
            this.typeSet = types;
            if (this.bGraph instanceof TypeGraph) {
                this.isTG = true;
            }
            this.makeGraphObjects();
        }
    }

    public EdGraph(Graph graph, EdTypeSet types, boolean attrsVisible) {
        this(graph, types);
    }

    private void init() {
        this.nodes = new Vector();
        this.arcs = new Vector();
        this.basisNode2node = new Hashtable();
        this.itsLayouter = new EvolutionaryGraphLayout(100, null);
        this.editable = true;
        this.criticalStyle = 0;
        this.visibilityChecked = true;
        this.itsScale = 1.0;
        this.firstDraw = true;
        this.errMsg = "";
    }

    public void trimToSize() {
        this.nodes.trimToSize();
        this.arcs.trimToSize();
        if (this.visibleArcs != null) {
            this.visibleArcs.trimToSize();
        }
        if (this.visibleNodes != null) {
            this.visibleNodes.trimToSize();
        }
        if (this.selectedArcs != null) {
            this.selectedArcs.trimToSize();
        }
        if (this.selectedNodes != null) {
            this.selectedNodes.trimToSize();
        }
        if (this.inheritanceArcs != null) {
            this.inheritanceArcs.trimToSize();
        }
        if (this.changedObjects != null) {
            this.changedObjects.trimToSize();
        }
    }

    public void dispose() {
        int i;
        if (this.bGraph != null) {
            this.bGraph.deleteObserver(this);
        }
        if (this.visibleArcs != null) {
            this.visibleArcs.clear();
        }
        if (this.visibleNodes != null) {
            this.visibleNodes.clear();
        }
        if (this.selectedNodes != null) {
            this.selectedNodes.clear();
        }
        if (this.selectedArcs != null) {
            this.selectedArcs.clear();
        }
        this.selectedNode = null;
        this.selectedArc = null;
        this.pickedObj = null;
        if (this.inheritanceArcs != null) {
            i = 0;
            while (i < this.inheritanceArcs.size()) {
                this.arcs.remove(this.inheritanceArcs.get(i));
                this.inheritanceArcs.get(i).dispose();
                ++i;
            }
            this.inheritanceArcs.clear();
        }
        this.inheritanceType = null;
        i = 0;
        while (i < this.arcs.size()) {
            this.arcs.get(i).dispose();
            ++i;
        }
        i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).dispose();
            ++i;
        }
        this.arcs.clear();
        this.nodes.clear();
        this.basisNode2node.clear();
        if (this.newAfterTransformStep != null) {
            this.newAfterTransformStep.clear();
        }
        if (this.changedObjects != null) {
            this.changedObjects.clear();
        }
        this.bGraph = null;
        this.itsLayouter = null;
        this.typeSet = null;
        this.gCopy = null;
        this.eGra = null;
        if (this.undoObj != null) {
            ((Vector)this.undoObj.second).clear();
        }
        if (this.newEdit != null) {
            this.newEdit.die();
        }
        this.undoManager = null;
    }

    public void finalize() {
    }

    private void addElement(EdGraphObject go, boolean addBasisGraphObject) {
        go.setContext(this);
        if (go.isNode()) {
            if (addBasisGraphObject) {
                this.bGraph.addNode(((EdNode)go).getBasisNode());
            }
            this.basisNode2node.put((Node)go.getBasisObject(), (EdNode)go);
            this.nodes.add((EdNode)go);
            go.markElementOfTypeGraph(this.isTG);
            this.typeSet.addTypeUser(go.getType(), go);
            if (this.visibleNodes != null && this.visibleNodes.size() > 0) {
                this.visibilityChecked = false;
            }
        } else {
            if (addBasisGraphObject) {
                this.bGraph.addArc(((EdArc)go).getBasisArc());
            }
            this.arcs.add((EdArc)go);
            go.markElementOfTypeGraph(this.isTG);
            this.typeSet.addTypeUser(go.getType(), go);
            if (this.visibleArcs != null && this.visibleArcs.size() > 0) {
                this.visibilityChecked = false;
            }
        }
    }

    private void removeElement(EdGraphObject go) {
        if (go.isNode()) {
            this.removeNodeElement((EdNode)go);
        } else {
            this.removeArcElement((EdArc)go);
        }
    }

    private void removeNodeElement(EdNode go) {
        if (go.isSelected()) {
            if (this.selectedNodes != null) {
                this.selectedNodes.remove(go);
            }
            if (this.selectedNode == go) {
                this.selectedNode = null;
            }
        }
        if (this.visibleNodes != null) {
            this.visibleNodes.remove(go);
        }
        this.nodes.remove(go);
        if (go.getType() != null) {
            this.typeSet.removeTypeUser(go.getType(), go);
        }
        if (go.getBasisObject() != null) {
            this.basisNode2node.remove(go.getBasisObject());
        }
        if (this.pickedObj == go) {
            this.pickedObj = null;
        }
        if (this.newAfterTransformStep != null) {
            this.newAfterTransformStep.remove(go);
        }
        go.dispose();
        if (this.bGraph.getKind() == "LHS") {
            this.updateArcKeys();
        }
    }

    private void removeArcElement(EdArc go) {
        if (go.isSelected()) {
            if (this.selectedArcs != null) {
                this.selectedArcs.remove(go);
            }
            if (this.selectedArc == go) {
                this.selectedArc = null;
            }
        }
        if (this.visibleArcs != null) {
            this.visibleArcs.remove(go);
        }
        this.arcs.remove(go);
        if (go.getType() != null) {
            this.typeSet.removeTypeUser(go.getType(), go);
        }
        if (this.pickedObj == go) {
            this.pickedObj = null;
        }
        if (this.newAfterTransformStep != null) {
            this.newAfterTransformStep.remove(go);
        }
        go.dispose();
        if (this.bGraph.getKind() == "LHS") {
            this.updateArcKeys();
        }
    }

    private void removeBadArc(EdArc go, EdType nType) {
        if (go.isSelected()) {
            if (this.selectedArcs != null) {
                this.selectedArcs.remove(go);
            }
            if (this.selectedArc == go) {
                this.selectedArc = null;
            }
        }
        if (this.visibleArcs != null) {
            this.visibleArcs.remove(go);
        }
        this.arcs.remove(go);
        this.typeSet.removeArcTypeUser(go.getType(), go, nType);
        if (this.pickedObj == go) {
            this.pickedObj = null;
        }
        if (this.newAfterTransformStep != null) {
            this.newAfterTransformStep.remove(go);
        }
        go.dispose();
        if (this.bGraph.getKind() == "LHS") {
            this.updateArcKeys();
        }
    }

    private void updateNodeKeys() {
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).setMorphismMark(i + 1);
            ++i;
        }
    }

    private void updateArcKeys() {
        int i = 0;
        while (i < this.arcs.size()) {
            this.arcs.get(i).setMorphismMark(this.nodes.size() + i + 1);
            ++i;
        }
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
    }

    public void undoManagerLastEditDie() {
        if (this.undoManager != null) {
            this.undoManager.lastEditDie();
        }
    }

    boolean undoManagerAddEdit(String presentationName) {
        String pName = presentationName;
        if (this.isTransformChange) {
            pName = String.valueOf(presentationName) + " (Transformation)";
        }
        this.newEdit = new StateEdit(this, pName);
        return this.undoManager.addEdit(this.newEdit);
    }

    public void undoManagerEndEdit() {
        if (!this.editable || this.undoManager == null || !this.undoManager.isEnabled() || this.undoObj == null) {
            return;
        }
        String addEditKind = (String)this.undoObj.first;
        String kind = "";
        Vector gos = (Vector)((Vector)this.undoObj.second).clone();
        if (addEditKind.equals("CREATE_DELETE")) {
            kind = "DELETE_CREATE";
        } else if (addEditKind.equals("DELETE_CREATE")) {
            kind = "CREATE_DELETE";
        } else if (addEditKind.equals("SELECT_DESELECT")) {
            kind = "DESELECT_SELECT";
        } else if (addEditKind.equals("DESELECT_SELECT")) {
            kind = "SELECT_DESELECT";
        } else if (addEditKind.equals("MOVE_GOBACK")) {
            kind = "MOVE_GOBACK";
        } else if (addEditKind.equals("CHANGE_ATTRIBUTE")) {
            kind = "CHANGE_ATTRIBUTE";
        } else if (addEditKind.equals("CHANGE_MULTIPLICITY")) {
            kind = "CHANGE_MULTIPLICITY";
        } else if (addEditKind.equals("CHANGE_PARENT")) {
            kind = "CHANGE_PARENT";
        } else if (addEditKind.equals("CHANGE_TYPE")) {
            kind = "CHANGE_TYPE";
        } else if (addEditKind.equals("CHANGE")) {
            kind = "CHANGE";
        } else if (addEditKind.equals("TARGET_UNSET_SET")) {
            kind = "TARGET_SET_UNSET";
        } else if (addEditKind.equals("TARGET_SET_UNSET")) {
            kind = "TARGET_UNSET_SET";
        } else if (addEditKind.equals("SOURCE_UNSET_SET")) {
            kind = "SOURCE_SET_UNSET";
        } else if (addEditKind.equals("SOURCE_SET_UNSET")) {
            kind = "SOURCE_UNSET_SET";
        }
        if (!kind.equals("") && !gos.isEmpty()) {
            this.endEdit(gos, kind);
        }
    }

    private void endEdit(Vector<?> gos, String kind) {
        this.undoObj = new Pair(kind, gos);
        this.undoManager.end(this.newEdit);
    }

    protected void addEdit(Vector<?> gos, String kind, String presentation) {
        if (kind.equals("") || gos.isEmpty()) {
            return;
        }
        this.undoObj = new Pair(kind, gos);
        this.undoManagerAddEdit(presentation);
    }

    public void addCreatedToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<EdGraphObject> gos = new Vector<EdGraphObject>(1);
        gos.add(go);
        this.addEdit(gos, "CREATE_DELETE", "Undo Creating");
    }

    public void addCreatedToUndo(Vector<EdGraphObject> gos) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        this.addEdit(gos, "CREATE_DELETE", "Undo Creating");
    }

    public void addDeletedToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<EdGraphObject> gos = new Vector<EdGraphObject>(1);
        gos.add(go);
        this.addEdit(gos, "DELETE_CREATE", "Undo Deleting");
    }

    public void addDeletedToUndo(Vector<EdGraphObject> gos) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        this.addEdit(gos, "DELETE_CREATE", "Undo Deleting");
    }

    public void addCommonDeletedToUndo(Vector<EdGraphObject> gos) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        this.addEdit(gos, "DELETE_CREATE", "Undo Deleting");
    }

    public void addDeleteSelectedToUndo() {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>();
        if (this.selectedNodes != null) {
            vec.addAll(this.selectedNodes);
            int i = 0;
            while (i < this.selectedNodes.size()) {
                EdNode n = this.selectedNodes.get(i);
                int j = 0;
                while (j < this.arcs.size()) {
                    EdArc a = this.arcs.elementAt(j);
                    if (a.getTarget().equals(n)) {
                        if (this.selectedArcs == null && !this.selectedArcs.contains(a)) {
                            vec.add(a);
                        }
                    } else if (a.getSource().equals(n) && this.selectedArcs == null && !this.selectedArcs.contains(a)) {
                        vec.add(a);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (this.selectedArcs != null) {
            vec.addAll(this.selectedArcs);
        }
        if (vec.size() > 0) {
            this.addEdit(vec, "DELETE_CREATE", "Undo Deleting");
        }
    }

    public void addChangedAttributeToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<EdGraphObject> gos = new Vector<EdGraphObject>();
        gos.add(go);
        this.addEdit(gos, "CHANGE_ATTRIBUTE", "Undo Changing Attribute");
    }

    public void addChangedAttributeToUndo(Vector<EdGraphObject> gos) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        this.addEdit(gos, "CHANGE_ATTRIBUTE", "Undo Changing Attribute");
    }

    public void addChangedTypeToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<String> gos = new Vector<String>();
        gos.add(String.valueOf(go.hashCode()));
        this.addEdit(gos, "CHANGE_TYPE", "Undo Changing");
    }

    public void addChangedMultiplicityToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<String> vec = new Vector<String>();
        vec.add(String.valueOf(go.hashCode()));
        this.addEdit(vec, "CHANGE_MULTIPLICITY", "Undo Changing Type Multiplicity");
    }

    public void addChangedParentToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<EdGraphObject> gos = new Vector<EdGraphObject>();
        gos.add(go);
        this.addEdit(gos, "CHANGE_PARENT", "Undo Changing Node Inheritance");
    }

    public void addUnsetTargetOfArcToUndo(EdGraphObject go) {
        if (!(this.undoManager != null && this.undoManager.isEnabled() && this.editable && go.isArc())) {
            return;
        }
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(1);
        vec.add(go);
        this.addEdit(vec, "TARGET_UNSET_SET", "Unset Target");
    }

    public void addSetTargetOfArcToUndo(EdGraphObject go) {
        if (!(this.undoManager != null && this.undoManager.isEnabled() && this.editable && go.isArc())) {
            return;
        }
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(1);
        vec.add(go);
        this.addEdit(vec, "TARGET_SET_UNSET", "Set Target");
    }

    public void addUnsetSourceOfArcToUndo(EdGraphObject go) {
        if (!(this.undoManager != null && this.undoManager.isEnabled() && this.editable && go.isArc())) {
            return;
        }
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(1);
        vec.add(go);
        this.addEdit(vec, "SOURCE_UNSET_SET", "Unset Source");
    }

    public void addSetSourceOfArcToUndo(EdGraphObject go) {
        if (!(this.undoManager != null && this.undoManager.isEnabled() && this.editable && go.isArc())) {
            return;
        }
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(1);
        vec.add(go);
        this.addEdit(vec, "SOURCE_SET_UNSET", "Set Source");
    }

    public void addMovedToUndo(EdGraphObject go) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        Vector<EdGraphObject> vec = new Vector<EdGraphObject>(1);
        vec.add(go);
        this.addEdit(vec, "MOVE_GOBACK", "Undo Moving");
    }

    public void addMovedToUndo(Vector<EdGraphObject> gos) {
        if (this.undoManager == null || !this.undoManager.isEnabled() || !this.editable) {
            return;
        }
        this.addEdit(gos, "MOVE_GOBACK", "Undo Moving");
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        if (this.undoObj == null || this.undoObj.first == null || this.undoObj.second == null) {
            return;
        }
        String op = (String)this.undoObj.first;
        if (op.equals("DELETE_CREATE")) {
            Vector vec = (Vector)this.undoObj.second;
            Vector<StateEditable> vecData = new Vector<StateEditable>(vec.size());
            int i = 0;
            while (i < vec.size()) {
                Object obj = vec.get(i);
                EdGraphObject go = null;
                if (obj instanceof EdGraphObject) {
                    go = (EdGraphObject)obj;
                } else if (obj instanceof String) {
                    String hashCode = (String)obj;
                    go = this.findGraphObject(hashCode);
                }
                if (go != null) {
                    StateEditable data;
                    if (go.isNode()) {
                        data = new NodeReprData((EdNode)go);
                        ((NodeReprData)data).storeState(state);
                        vecData.add(data);
                    } else {
                        data = new ArcReprData((EdArc)go);
                        ((ArcReprData)data).storeState(state);
                        vecData.add(data);
                    }
                }
                ++i;
            }
            ((Vector)this.undoObj.second).clear();
            this.undoObj.second = vecData;
        } else if (op.equals("CREATE_DELETE") || op.equals("CHANGE_ATTRIBUTE")) {
            Vector vec = (Vector)this.undoObj.second;
            Vector<String> vecData = new Vector<String>(vec.size());
            int i = 0;
            while (i < vec.size()) {
                Object obj = vec.get(i);
                EdGraphObject go = null;
                if (obj instanceof String) {
                    String hashCode = (String)obj;
                    go = this.findGraphObject(hashCode);
                } else if (obj instanceof EdGraphObject) {
                    go = (EdGraphObject)obj;
                } else if (obj instanceof NodeReprData) {
                    vecData.add(String.valueOf(((NodeReprData)obj).nodeHashCode));
                } else if (obj instanceof ArcReprData) {
                    vecData.add(String.valueOf(((ArcReprData)obj).arcHashCode));
                }
                if (go != null) {
                    if (go.isNode()) {
                        ((EdNode)go).storeState(state);
                    } else {
                        ((EdArc)go).storeState(state);
                    }
                    vecData.add(String.valueOf(go.hashCode()));
                }
                ++i;
            }
            ((Vector)this.undoObj.second).clear();
            this.undoObj.second = vecData;
        } else if (op.equals("TARGET_UNSET_SET") || op.equals("SOURCE_UNSET_SET")) {
            Vector vec = (Vector)this.undoObj.second;
            Vector<ArcReprData> vecData = new Vector<ArcReprData>(vec.size());
            int i = 0;
            while (i < vec.size()) {
                Object obj = vec.get(i);
                EdArc go = null;
                if (obj instanceof EdArc) {
                    go = (EdArc)obj;
                } else if (obj instanceof String) {
                    String hashCode = (String)obj;
                    go = (EdArc)this.findGraphObject(hashCode);
                }
                if (go != null) {
                    ArcReprData data = new ArcReprData(go);
                    data.storeState(state);
                    vecData.add(data);
                }
                ++i;
            }
            ((Vector)this.undoObj.second).clear();
            this.undoObj.second = vecData;
        } else if (op.equals("TARGET_SET_UNSET") || op.equals("SOURCE_SET_UNSET")) {
            Vector vec = (Vector)this.undoObj.second;
            Vector<String> vecData = new Vector<String>(vec.size());
            int i = 0;
            while (i < vec.size()) {
                Object obj = vec.get(i);
                EdArc go = null;
                if (obj instanceof String) {
                    String hashCode = (String)obj;
                    go = (EdArc)this.findGraphObject(hashCode);
                } else if (obj instanceof EdArc) {
                    go = (EdArc)obj;
                } else if (obj instanceof ArcReprData) {
                    vecData.add(String.valueOf(((ArcReprData)obj).arcHashCode));
                }
                if (go != null) {
                    go.storeState(state);
                    vecData.add(String.valueOf(go.hashCode()));
                }
                ++i;
            }
        } else {
            Vector vec = (Vector)this.undoObj.second;
            Vector<String> vecData = new Vector<String>(vec.size());
            int i = 0;
            while (i < vec.size()) {
                Object obj = vec.get(i);
                EdGraphObject go = null;
                if (obj instanceof String) {
                    go = this.findGraphObject((String)obj);
                } else if (obj instanceof EdGraphObject) {
                    go = (EdGraphObject)obj;
                }
                if (go != null) {
                    if (go.isNode()) {
                        ((EdNode)go).storeState(state);
                    } else {
                        ((EdArc)go).storeState(state);
                    }
                    vecData.add(String.valueOf(go.hashCode()));
                }
                ++i;
            }
            ((Vector)this.undoObj.second).clear();
            this.undoObj.second = vecData;
        }
        state.put(this, this.undoObj);
        if (this.undoManager.isUndoEndOfTransformStepAllowed()) {
            this.undoManager.setUndoEndOfTransformStep();
            this.undoManager.setUndoEndOfTransformStepAllowed(false);
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        if (state != null) {
            if (state.get(this) != null) {
                try {
                    this.restoreStateOfGraph(this, state);
                }
                catch (TypeException ex) {
                    this.undoObj = (Pair)state.get(this);
                    this.newEdit = new StateEdit(this, (String)this.undoObj.first);
                    this.undoManager.addEdit(this.newEdit);
                }
                return;
            }
            Enumeration<?> keys = state.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (key instanceof EdGraph) {
                    if ((EdGraph)key == this) break;
                    try {
                        this.restoreStateOfGraph(key, state);
                    }
                    catch (TypeException ex) {
                        this.undoObj = (Pair)state.get(this);
                        this.newEdit = new StateEdit(this, (String)this.undoObj.first);
                        this.undoManager.addEdit(this.newEdit);
                    }
                    break;
                }
                if (key instanceof EdNode) {
                    this.restoreStateOfNode(key, state);
                    continue;
                }
                if (!(key instanceof EdArc)) continue;
                this.restoreStateOfArc(key, state);
            }
        }
    }

    private void restoreStateOfGraph(Object key, Hashtable<?, ?> state) throws TypeException {
        Object obj = state.get(key);
        if (obj == null || !(obj instanceof Pair)) {
            return;
        }
        String op = (String)((Pair)obj).first;
        Vector vec = (Vector)((Pair)obj).second;
        if (!vec.isEmpty()) {
            if (op.equals("CREATE_DELETE")) {
                int i = 0;
                while (i < vec.size()) {
                    StateEditable data;
                    EdGraphObject o;
                    int tgCheckLevel = this.bGraph.getTypeSet().getLevelOfTypeGraphCheck();
                    if (tgCheckLevel == 30) {
                        this.bGraph.getTypeSet().setLevelOfTypeGraphCheck(20);
                    }
                    if (vec.get(i) instanceof String) {
                        String hashCode = (String)vec.get(i);
                        o = this.findRestoredObject(hashCode);
                        if (o != null) {
                            this.propagateRemoveGraphObjectToMultiRule(o);
                            this.deleteObj(o, true);
                        }
                    } else if (vec.get(i) instanceof EdGraphObject) {
                        EdGraphObject o2 = this.findRestoredObject((EdGraphObject)vec.get(i));
                        if (o2 != null) {
                            this.propagateRemoveGraphObjectToMultiRule(o2);
                            this.deleteObj(o2, true);
                        }
                    } else if (vec.get(i) instanceof NodeReprData) {
                        data = (NodeReprData)vec.get(i);
                        o = this.findRestoredObject(data.nodeHC);
                        if (o != null) {
                            this.deleteObj(o, true);
                            this.propagateRemoveGraphObjectToMultiRule(o);
                        }
                    } else if (vec.get(i) instanceof ArcReprData) {
                        data = (ArcReprData)vec.get(i);
                        o = this.findRestoredObject(((ArcReprData)data).arcHC);
                        if (o != null) {
                            this.deleteObj(o, true);
                            this.propagateRemoveGraphObjectToMultiRule(o);
                        }
                    }
                    this.bGraph.getTypeSet().setLevelOfTypeGraphCheck(tgCheckLevel);
                    ++i;
                }
            } else if (op.equals("DELETE_CREATE")) {
                Vector<EdNode> restoredNodes = new Vector<EdNode>();
                int i = 0;
                while (i < vec.size()) {
                    EdGraphObject go;
                    TypeReprData typedata;
                    Object data = vec.get(i);
                    if (data instanceof NodeReprData) {
                        ((NodeReprData)data).restoreState(state);
                        typedata = ((NodeReprData)data).getNodeTypeReprData();
                        if (this.typeSet.containsNodeType(typedata.getName(), typedata.getShape(), typedata.getColor(), typedata.hasFilledShape()) && (go = ((NodeReprData)data).createNodeFromNodeRepr(this)) != null) {
                            go.setContext(this);
                            if (this.bGraph.isTypeGraph()) {
                                this.refreshInheritanceArcs();
                            }
                            ((EdNode)go).refreshAttributeInstance();
                            restoredNodes.add((EdNode)go);
                            ((EdNode)go).getLNode().setFrozenByDefault(true);
                            this.propagateAddGraphObjectToMultiRule(go);
                        }
                    } else if (data instanceof ArcReprData) {
                        ((ArcReprData)data).restoreState(state);
                        typedata = ((ArcReprData)data).getArcTypeReprData();
                        if (this.typeSet.containsArcType(typedata.getName(), typedata.getShape(), typedata.getColor()) && (go = ((ArcReprData)data).createArcFromArcRepr(this, restoredNodes)) != null) {
                            go.setContext(this);
                            ((EdArc)go).refreshAttributeInstance();
                            ((EdArc)go).getLArc().setFrozenByDefault(true);
                            this.propagateAddGraphObjectToMultiRule(go);
                        }
                    }
                    ++i;
                }
                restoredNodes.clear();
            } else if (op.equals("TARGET_SET_UNSET") || op.equals("SOURCE_SET_UNSET")) {
                int i = 0;
                while (i < vec.size()) {
                    EdArc o;
                    int tgCheckLevel = this.bGraph.getTypeSet().getLevelOfTypeGraphCheck();
                    if (tgCheckLevel == 30) {
                        this.bGraph.getTypeSet().setLevelOfTypeGraphCheck(20);
                    }
                    if (vec.get(i) instanceof String) {
                        String hashCode = (String)vec.get(i);
                        o = (EdArc)this.findRestoredObject(hashCode);
                        if (o != null) {
                            this.delSelectedArc(o, false);
                        }
                    } else if (vec.get(i) instanceof EdGraphObject) {
                        EdArc o3 = (EdArc)this.findRestoredObject((EdArc)vec.get(i));
                        if (o3 != null) {
                            this.delSelectedArc(o3, false);
                        }
                    } else if (vec.get(i) instanceof ArcReprData) {
                        ArcReprData data = (ArcReprData)vec.get(i);
                        o = (EdArc)this.findRestoredObject(data.arcHC);
                        if (o != null) {
                            this.delSelectedArc(o, false);
                        }
                    }
                    this.bGraph.getTypeSet().setLevelOfTypeGraphCheck(tgCheckLevel);
                    ++i;
                }
            } else if (op.equals("TARGET_UNSET_SET") || op.equals("SOURCE_UNSET_SET")) {
                Vector<EdNode> restoredNodes = new Vector<EdNode>();
                int i = 0;
                while (i < vec.size()) {
                    Object data = vec.get(i);
                    if (data instanceof ArcReprData) {
                        EdArc go;
                        ((ArcReprData)data).restoreState(state);
                        TypeReprData typedata = ((ArcReprData)data).getArcTypeReprData();
                        if (this.typeSet.containsArcType(typedata.getName(), typedata.getShape(), typedata.getColor()) && (go = ((ArcReprData)data).createArcFromArcRepr(this, restoredNodes)) != null) {
                            go.setContext(this);
                            go.refreshAttributeInstance();
                            go.getLArc().setFrozenByDefault(true);
                        }
                    }
                    ++i;
                }
                restoredNodes.clear();
            } else if (op.equals("SELECT_DESELECT")) {
                int i = 0;
                while (i < vec.size()) {
                    String hashCode = (String)vec.get(i);
                    EdGraphObject o = this.findRestoredObject(hashCode);
                    if (o != null) {
                        if (o.isNode()) {
                            ((EdNode)o).restoreState(state, hashCode);
                            if (this.selectedNodes != null) {
                                if (o.isSelected()) {
                                    o.deselect();
                                    if (this.selectedNodes.contains(o)) {
                                        this.selectedNodes.remove(o);
                                    }
                                } else if (this.selectedNodes.contains(o)) {
                                    this.selectedNodes.remove(o);
                                }
                            }
                        } else {
                            ((EdArc)o).restoreState(state, hashCode);
                            if (this.selectedArcs != null) {
                                if (o.isSelected()) {
                                    o.deselect();
                                    if (this.selectedArcs.contains(o)) {
                                        this.selectedArcs.remove(o);
                                    }
                                } else if (this.selectedArcs.contains(o)) {
                                    this.selectedArcs.remove(o);
                                }
                            }
                        }
                    }
                    ++i;
                }
            } else if (op.equals("DESELECT_SELECT")) {
                int i = 0;
                while (i < vec.size()) {
                    String hashCode = (String)vec.get(i);
                    EdGraphObject o = this.findRestoredObject(hashCode);
                    if (o != null) {
                        if (o.isNode()) {
                            ((EdNode)o).restoreState(state, hashCode);
                            if (o.isSelected()) {
                                if (!this.selectedNodes.contains(o)) {
                                    this.selectedNodes.add((EdNode)o);
                                }
                            } else {
                                o.select();
                                if (!this.selectedNodes.contains(o)) {
                                    this.selectedNodes.add((EdNode)o);
                                }
                            }
                        } else {
                            ((EdArc)o).restoreState(state, hashCode);
                            if (o.isSelected()) {
                                if (!this.selectedArcs.contains(o)) {
                                    this.selectedArcs.add((EdArc)o);
                                }
                            } else {
                                o.select();
                                if (!this.selectedArcs.contains(o)) {
                                    this.selectedArcs.add((EdArc)o);
                                }
                            }
                        }
                    }
                    ++i;
                }
            } else if (op.equals("MOVE_GOBACK")) {
                int i = 0;
                while (i < vec.size()) {
                    String hashCode = (String)vec.get(i);
                    EdGraphObject o = this.findRestoredObject(hashCode);
                    if (o != null) {
                        if (o.isNode()) {
                            ((EdNode)o).restoreState(state, hashCode);
                        } else {
                            ((EdArc)o).restoreState(state, hashCode);
                        }
                    }
                    ++i;
                }
            } else if (op.equals("CHANGE_ATTRIBUTE")) {
                int i = 0;
                while (i < vec.size()) {
                    String hashCode = (String)vec.get(i);
                    EdGraphObject o = this.findRestoredObject(hashCode);
                    if (o != null) {
                        if (o.isNode()) {
                            ((EdNode)o).restoreState(state, hashCode);
                        } else {
                            ((EdArc)o).restoreState(state, hashCode);
                        }
                    }
                    ++i;
                }
            } else if (op.equals("CHANGE_MULTIPLICITY") || op.equals("CHANGE_TYPE")) {
                int i = 0;
                while (i < vec.size()) {
                    String hashCode = (String)vec.get(i);
                    EdGraphObject o = this.findRestoredObject(hashCode);
                    if (o != null) {
                        if (o.isNode()) {
                            ((EdNode)o).restoreState(state, hashCode);
                        } else {
                            ((EdArc)o).restoreState(state, hashCode);
                        }
                    }
                    ++i;
                }
            } else if (op.equals("CHANGE_PARENT")) {
                int i = 0;
                while (i < vec.size()) {
                    String hashCode = (String)vec.get(i);
                    EdGraphObject o = this.findRestoredObject(hashCode);
                    if (o != null && o.isNode()) {
                        ((EdNode)o).restoreState(state, hashCode);
                        if (this.isTG) {
                            this.refreshInheritanceArcs();
                        }
                    }
                    ++i;
                }
            }
        } else {
            this.undoManager.lastEditDie();
        }
    }

    private void propagateAddGraphObjectToMultiRule(EdGraphObject obj) {
        EdRuleScheme rs;
        if (this.eGra != null && this.isSourceGraphOfGraphEmbedding() && (rs = this.eGra.getRuleScheme(this.bGraph)) != null) {
            rs.propagateAddGraphObjectToMultiRule(obj);
        }
    }

    private void propagateRemoveGraphObjectToMultiRule(EdGraphObject obj) {
        EdRuleScheme rs;
        if (this.eGra != null && this.isSourceGraphOfGraphEmbedding() && (rs = this.eGra.getRuleScheme(this.bGraph)) != null) {
            rs.propagateRemoveGraphObjectToMultiRule(obj);
        }
    }

    private void restoreStateOfNode(Object key, Hashtable<?, ?> state) {
        if (key instanceof EdNode) {
            ((EdNode)key).restoreState(state);
            EdGraphObject o = this.findRestoredObject((EdNode)key);
            if (o != null) {
                if (o != (EdNode)key) {
                    ((EdNode)o).restoreState(new NodeReprData((EdNode)key));
                }
                if (this.selectedNodes != null) {
                    if (o.isSelected()) {
                        if (!this.selectedNodes.contains(o)) {
                            this.selectedNodes.add((EdNode)o);
                        }
                    } else if (this.selectedNodes.contains(o)) {
                        this.selectedNodes.remove(o);
                    }
                }
                if (this.isTG) {
                    this.refreshInheritanceArcs();
                }
            } else if (((EdNode)key).getContext() != null && ((EdNode)key).getContext() != this && (o = ((EdNode)key).getContext().findRestoredObject((EdNode)key)) != null) {
                if (o != (EdNode)key) {
                    ((EdNode)o).restoreState(new NodeReprData((EdNode)key));
                }
                if (o.getContext().isTG) {
                    o.getContext().refreshInheritanceArcs();
                }
            }
        }
    }

    private void restoreStateOfArc(Object key, Hashtable<?, ?> state) {
        if (key instanceof EdArc) {
            ((EdArc)key).restoreState(state);
            EdGraphObject o = this.findRestoredObject((EdArc)key);
            if (o != null) {
                if (o != (EdArc)key) {
                    ((EdArc)o).restoreState(new ArcReprData((EdArc)key));
                }
                if (this.selectedArcs != null) {
                    if (o.isSelected()) {
                        if (!this.selectedArcs.contains(o)) {
                            this.selectedArcs.add((EdArc)o);
                        }
                    } else if (this.selectedArcs.contains(o)) {
                        this.selectedArcs.remove(o);
                    }
                }
            } else if (((EdArc)key).getContext() != null && ((EdArc)key).getContext() != this && (o = ((EdArc)key).getContext().findRestoredObject((EdArc)key)) != null && o != (EdArc)key) {
                ((EdArc)o).restoreState(new ArcReprData((EdArc)key));
            }
        }
    }

    protected EdGraphObject findRestoredObject(EdGraphObject go) {
        block5: {
            block4: {
                if (!go.isNode()) break block4;
                int i = 0;
                while (i < this.nodes.size()) {
                    EdGraphObject o = this.nodes.get(i);
                    if (o == go || o.getContextUsage().contains(String.valueOf(go.hashCode()))) {
                        return o;
                    }
                    ++i;
                }
                break block5;
            }
            if (!go.isArc()) break block5;
            int i = 0;
            while (i < this.arcs.size()) {
                EdGraphObject o = this.arcs.get(i);
                if (o == go || o.getContextUsage().contains(String.valueOf(go.hashCode()))) {
                    return o;
                }
                ++i;
            }
        }
        return null;
    }

    protected EdGraphObject findRestoredObject(String hashCode) {
        return this.findGraphObject(hashCode);
    }

    protected EdGraphObject findGraphObject(String hashCode) {
        EdGraphObject o;
        int i = 0;
        while (i < this.nodes.size()) {
            o = this.nodes.get(i);
            if (o.getContextUsage().contains(hashCode)) {
                return o;
            }
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            o = this.arcs.get(i);
            if (o.getContextUsage().contains(hashCode)) {
                return o;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findNode(String hashCode) {
        int i = 0;
        while (i < this.nodes.size()) {
            EdGraphObject o = this.nodes.get(i);
            if (o.getContextUsage().contains(hashCode)) {
                return o;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findArc(String hashCode) {
        int i = 0;
        while (i < this.arcs.size()) {
            EdGraphObject o = this.arcs.get(i);
            if (o.getContextUsage().contains(hashCode)) {
                return o;
            }
            ++i;
        }
        return null;
    }

    protected EdGraphObject findRestoredNode(String hashCode) {
        return this.findNode(hashCode);
    }

    protected EdGraphObject findRestoredArc(String hashCode) {
        return this.findArc(hashCode);
    }

    private void makeGraphObjects() {
        if (this.bGraph == null || this.bGraph.isEmpty()) {
            return;
        }
        if (!this.nodes.isEmpty()) {
            this.disposeGraphObjects();
        }
        for (Node n : this.bGraph.getNodesSet()) {
            this.newNode(n);
        }
        for (Arc a : this.bGraph.getArcsSet()) {
            this.newArc(a, this.basisNode2node.get((Node)a.getSource()), this.basisNode2node.get((Node)a.getTarget()));
        }
        if (this.isTG) {
            this.makeInheritanceArcs();
        }
    }

    public void makeGraphObjectsOfNewBasisObjects(boolean selectnew) {
        if (this.bGraph == null || this.bGraph.isEmpty()) {
            return;
        }
        for (Node bn : this.bGraph.getNodesSet()) {
            if (this.findNode(bn) != null) continue;
            EdNode n = this.newNode(bn);
            if (!selectnew) continue;
            this.select(n);
        }
        for (Arc ba : this.bGraph.getArcsSet()) {
            if (this.findArc(ba) != null) continue;
            EdArc a = this.newArc(ba);
            if (!selectnew) continue;
            this.select(a);
        }
        if (this.isTG) {
            this.makeInheritanceArcs();
        }
    }

    public Graph getBasisGraph() {
        return this.bGraph;
    }

    public String getName() {
        if (this.bGraph != null) {
            return this.bGraph.getName();
        }
        return "unnamed";
    }

    public EdGraGra getGraGra() {
        return this.eGra;
    }

    public void setGraGra(EdGraGra egra) {
        if (egra == null) {
            return;
        }
        this.eGra = egra;
        if (this.eGra.getTypeSet() != null && this.eGra.getTypeSet() != this.typeSet) {
            this.setTypeSet(egra.getTypeSet());
        }
        if (this.isTG) {
            this.eGra.setChanged(true);
        }
    }

    public EdTypeSet getTypeSet() {
        return this.typeSet;
    }

    public void setTypeSet(EdTypeSet types) {
        if (this.typeSet != null && types != null) {
            EdType t;
            int i = 0;
            while (i < this.typeSet.getNodeTypes().size()) {
                t = this.typeSet.getNodeTypes().elementAt(i);
                if (types.isNewType(types.getNodeTypes(), t)) {
                    types.getNodeTypes().addElement(t);
                }
                ++i;
            }
            i = 0;
            while (i < this.typeSet.getArcTypes().size()) {
                t = this.typeSet.getArcTypes().elementAt(i);
                if (types.isNewType(types.getArcTypes(), t)) {
                    types.getArcTypes().addElement(t);
                }
                ++i;
            }
        }
        this.typeSet = types;
    }

    public Vector<EdGraphObject> getGraphObjects() {
        Vector<EdGraphObject> result = new Vector<EdGraphObject>(this.nodes.size() + this.arcs.size());
        result.addAll(this.nodes);
        result.addAll(this.arcs);
        return result;
    }

    public Vector<EdNode> getNodes() {
        return this.nodes;
    }

    public Vector<EdArc> getArcs() {
        return this.arcs;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setTransformChangeEnabled(boolean b) {
        this.isTransformChange = b;
        if (this.isTransformChange && this.newAfterTransformStep != null) {
            this.newAfterTransformStep.clear();
        }
    }

    public boolean isGraph(EdGraph eg) {
        if (eg == null) {
            return false;
        }
        int i = 0;
        while (i < eg.arcs.size()) {
            EdArc ea = eg.arcs.elementAt(i);
            if (!eg.nodes.contains(ea.getSource()) || !eg.nodes.contains(ea.getTarget())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isTypeGraph() {
        return this.isTG;
    }

    public boolean isInheritanceType(EdType t) {
        return this.inheritanceType == t;
    }

    public void markTypeGraph(boolean val) {
        this.isTG = val;
    }

    public boolean isCPAgraph() {
        return this.isCPA;
    }

    public void setCPAgraph(boolean b) {
        this.isCPA = b;
    }

    public void clear() {
        this.disposeGraphObjects();
        this.basisNode2node.clear();
    }

    public void clearSelected() {
        int i;
        if (this.selectedArcs != null && this.selectedArcs.size() > 0) {
            i = 0;
            while (i < this.selectedArcs.size()) {
                EdArc ea = this.selectedArcs.elementAt(i);
                ea.setSelected(false);
                ++i;
            }
            this.selectedArcs.removeAllElements();
        }
        this.selectedArc = null;
        if (this.selectedNodes != null && this.selectedNodes.size() > 0) {
            i = 0;
            while (i < this.selectedNodes.size()) {
                EdNode en = this.selectedNodes.elementAt(i);
                en.setSelected(false);
                ++i;
            }
            this.selectedNodes.removeAllElements();
        }
        this.selectedNode = null;
    }

    public EdNode addNode(int x, int y, boolean visible) throws TypeException {
        if (this.typeSet.getSelectedNodeType() == null) {
            this.errMsg = "Any node type isn't selected!";
            return null;
        }
        EdNode eNode = new EdNode(this.bGraph, this.typeSet.getSelectedNodeType());
        this.addElement(eNode, false);
        eNode.setReps(x, y, visible, false);
        if (eNode.getBasisNode().xyAttr && this.bGraph.isCompleteGraph()) {
            ((ValueTuple)eNode.getBasisNode().getAttribute()).getValueMemberAt("thisX").setExprAsObject(eNode.getX());
            ((ValueTuple)eNode.getBasisNode().getAttribute()).getValueMemberAt("thisY").setExprAsObject(eNode.getY());
        }
        eNode.setMorphismMark(this.nodes.size() + this.arcs.size());
        return eNode;
    }

    public EdNode addNode(int x, int y, EdType eType, boolean visible) throws TypeException {
        EdNode eNode = new EdNode(this.bGraph, eType);
        this.addElement(eNode, false);
        eNode.setReps(x, y, visible, false);
        if (eNode.getBasisNode().xyAttr && this.bGraph.isCompleteGraph()) {
            ((ValueTuple)eNode.getBasisNode().getAttribute()).getValueMemberAt("thisX").setExprAsObject(eNode.getX());
            ((ValueTuple)eNode.getBasisNode().getAttribute()).getValueMemberAt("thisY").setExprAsObject(eNode.getY());
        }
        eNode.setMorphismMark(this.nodes.size() + this.arcs.size());
        return eNode;
    }

    private EdNode newNode(Node bNode) {
        EdType et = null;
        int i = 0;
        while (i < this.typeSet.getNodeTypes().size()) {
            EdType t = this.typeSet.getNodeTypes().elementAt(i);
            if (t.getBasisType() == bNode.getType()) {
                et = t;
                break;
            }
            ++i;
        }
        if (et == null && (et = this.typeSet.getNodeType(bNode.getType())) == null) {
            et = this.typeSet.createNodeType(bNode.getType());
        }
        if (et != null) {
            EdNode eNode = new EdNode(bNode, et);
            this.addElement(eNode, false);
            eNode.setMorphismMark(this.nodes.size());
            return eNode;
        }
        this.errMsg = "Creating node failed!";
        return null;
    }

    public EdNode addNode(Node bNode, EdType et) {
        EdNode eNode = new EdNode(bNode, et);
        this.addElement(eNode, false);
        eNode.setMorphismMark(this.nodes.size() + this.arcs.size());
        return eNode;
    }

    public EdArc addArc(EdGraphObject from, EdGraphObject to, Point anchor, boolean directed) throws TypeException {
        if (this.typeSet.getSelectedArcType() == null) {
            this.errMsg = "Any edge type isn't selected!";
            throw new TypeException(this.errMsg);
        }
        EdArc eArc = new EdArc(this.bGraph, this.typeSet.getSelectedArcType(), from, to, anchor);
        this.addElement(eArc, false);
        eArc.setReps(directed, true, false);
        this.resizeArc(eArc, 15);
        eArc.setMorphismMark(this.nodes.size() + this.arcs.size());
        return eArc;
    }

    public EdArc addArc(EdType eType, EdGraphObject from, EdGraphObject to, Point anchor, boolean directed) throws TypeException {
        EdArc eArc = new EdArc(this.bGraph, eType, from, to, anchor);
        this.addElement(eArc, false);
        eArc.setReps(directed, true, false);
        eArc.setMorphismMark(this.nodes.size() + this.arcs.size());
        return eArc;
    }

    private EdArc newArc(Arc bArc) {
        EdArc eArc = null;
        EdType et = null;
        int i = 0;
        while (i < this.typeSet.getArcTypes().size()) {
            EdType t = this.typeSet.getArcTypes().elementAt(i);
            if (t.getBasisType() == bArc.getType()) {
                et = t;
                break;
            }
            ++i;
        }
        if (et == null && (et = this.typeSet.getType(bArc.getType())) == null) {
            et = this.typeSet.createArcType(bArc.getType());
        }
        if (et != null) {
            GraphObject bSrc = bArc.getSource();
            EdNode eSrc = this.findNode(bSrc);
            GraphObject bTar = bArc.getTarget();
            EdNode eTar = this.findNode(bTar);
            if (eSrc != null && eTar != null) {
                try {
                    eArc = new EdArc(bArc, et, (EdGraphObject)eSrc, (EdGraphObject)eTar);
                    this.addElement(eArc, false);
                    eArc.setMorphismMark(this.nodes.size() + this.arcs.size());
                    return eArc;
                }
                catch (TypeException ex) {
                    this.errMsg = "Creating edge failed! Source or target of this arc failed!";
                    return null;
                }
            }
            this.errMsg = "Creating edge failed! Source or target of this arc failed!";
        } else {
            this.errMsg = "Creating edge failed! Edge Type  <" + bArc.getType().getName() + ">  is not found!";
        }
        return null;
    }

    private EdArc newArc(Arc bArc, EdGraphObject eSrc, EdGraphObject eTar) {
        EdArc eArc = null;
        EdType et = null;
        int i = 0;
        while (i < this.typeSet.getArcTypes().size()) {
            EdType t = this.typeSet.getArcTypes().elementAt(i);
            if (t.getBasisType() == bArc.getType()) {
                et = t;
                break;
            }
            ++i;
        }
        if (et == null && (et = this.typeSet.getArcType(bArc.getType())) == null) {
            et = this.typeSet.createArcType(bArc.getType());
        }
        if (et != null) {
            try {
                eArc = new EdArc(bArc, et, eSrc, eTar);
                this.addElement(eArc, false);
                eArc.setMorphismMark(this.nodes.size() + this.arcs.size());
                return eArc;
            }
            catch (TypeException ex) {
                this.errMsg = "Creating edge failed! Source or target of this arc failed!";
                return null;
            }
        }
        this.errMsg = "Creating edge failed! Edge Type  <" + bArc.getType().getName() + ">  is not found!";
        return null;
    }

    public EdArc newInheritanceArc(Arc bArc, Vector<EdArc> eArcs) {
        if (!this.isTG) {
            this.errMsg = "This graph should be a type graph!";
            return null;
        }
        this.errMsg = "";
        if (this.inheritanceArcs == null) {
            this.inheritanceArcs = new Vector();
        }
        if (this.inheritanceType == null) {
            this.inheritanceType = new EdType(bArc.getType(), 61, new Color(0, 0, 0), "");
        }
        GraphObject bSrc = bArc.getSource();
        GraphObject bTar = bArc.getTarget();
        EdNode eSrc = this.findNode(bSrc);
        EdNode eTar = this.findNode(bTar);
        if (eSrc != null && eTar != null) {
            try {
                EdArc eArc = new EdArc(bArc, this.inheritanceType, (EdGraphObject)eSrc, (EdGraphObject)eTar);
                eArc.setContext(this);
                eArc.setReps(true, true, false);
                eArc.markElementOfTypeGraph(true);
                this.inheritanceArcs.addElement(eArc);
                eArcs.addElement(eArc);
                return eArc;
            }
            catch (TypeException ex) {
                return null;
            }
        }
        return null;
    }

    public boolean deleteInheritanceRelation(EdNode child, EdNode parent) {
        EdArc a;
        if (this.isTG && this.bGraph != null && this.inheritanceArcs != null && !this.inheritanceArcs.isEmpty() && this.bGraph.getTypeSet().removeInheritanceRelation(child.getBasisNode().getType(), parent.getBasisNode().getType()) && (a = this.findInheritanceArc(child, parent, false)) != null) {
            this.inheritanceArcs.removeElement(a);
            this.arcs.removeElement(a);
            a.dispose();
            return true;
        }
        return false;
    }

    public boolean deleteAllInheritanceRelations(EdNode child) {
        if (this.isTG && this.bGraph != null && this.inheritanceArcs != null && !this.inheritanceArcs.isEmpty()) {
            int i = 0;
            while (i < this.inheritanceArcs.size()) {
                EdArc a = this.inheritanceArcs.elementAt(i);
                if (a.getSource() == child && this.bGraph.getTypeSet().isInheritanceArc(a.getBasisArc()) && this.bGraph.getTypeSet().removeInheritanceRelation(child.getBasisNode().getType(), ((EdNode)a.getTarget()).getBasisNode().getType())) {
                    this.inheritanceArcs.removeElement(a);
                    this.arcs.removeElement(a);
                    a.dispose();
                }
                ++i;
            }
        }
        return false;
    }

    public EdArc addArc(Arc bArc, EdType et) throws TypeException {
        this.errMsg = "";
        EdArc eArc = null;
        GraphObject bSrc = bArc.getSource();
        GraphObject bTar = bArc.getTarget();
        EdNode eSrc = this.findNode(bSrc);
        EdNode eTar = this.findNode(bTar);
        if (eSrc != null && eTar != null) {
            try {
                eArc = new EdArc(bArc, et, (EdGraphObject)eSrc, (EdGraphObject)eTar);
                this.addElement(eArc, false);
                eArc.setReps(bArc.isDirected(), true, false);
                eArc.setMorphismMark(this.nodes.size() + this.arcs.size());
                return eArc;
            }
            catch (TypeException ex) {
                this.errMsg = "Bad arc!";
                throw new TypeException(this.errMsg);
            }
        }
        this.errMsg = "Bad arc!";
        throw new TypeException(this.errMsg);
    }

    public Node findBasisNode(EdNode eNode) {
        return eNode.getBasisNode();
    }

    public EdNode findNode(GraphObject bNode) {
        if (bNode == null) {
            return null;
        }
        return this.basisNode2node.get(bNode);
    }

    public Vector<EdNode> getNodes(EdType t) {
        Vector<EdNode> v = new Vector<EdNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode o = this.nodes.elementAt(i);
            if (o.getType().compareTo(t)) {
                v.add(o);
            }
            ++i;
        }
        return v;
    }

    public Vector<EdArc> getArcs(EdType t) {
        Vector<EdArc> v = new Vector<EdArc>();
        int i = 0;
        while (i < this.arcs.size()) {
            EdArc o = this.arcs.elementAt(i);
            if (o.getType().compareTo(t)) {
                v.add(o);
            }
            ++i;
        }
        return v;
    }

    private EdArc findInheritanceArc(EdNode src, EdNode tar, boolean inhRelExists) {
        if (this.isTG && this.bGraph != null && this.inheritanceArcs != null && !this.inheritanceArcs.isEmpty()) {
            int i = 0;
            while (i < this.inheritanceArcs.size()) {
                EdArc a = this.inheritanceArcs.elementAt(i);
                if (a.getSource() == src && a.getTarget() == tar && (!inhRelExists || this.bGraph.getTypeSet().isInheritanceArc(a.getBasisArc()))) {
                    return a;
                }
                ++i;
            }
        }
        return null;
    }

    public Arc findBasisArc(EdArc eArc) {
        return eArc.getBasisArc();
    }

    public EdArc findArc(GraphObject bArc) {
        if (bArc == null) {
            return null;
        }
        int i = 0;
        while (i < this.arcs.size()) {
            EdArc eArc = this.arcs.elementAt(i);
            if (eArc.getBasisArc() == bArc) {
                return eArc;
            }
            ++i;
        }
        return null;
    }

    public EdGraphObject findGraphObject(GraphObject obj) {
        if (obj != null) {
            if (obj.isNode()) {
                return this.findNode(obj);
            }
            return this.findArc(obj);
        }
        return null;
    }

    public EdGraphObject getPicked(int x, int y) {
        this.pickedObj = this.getPickedNode(x, y);
        if (this.pickedObj == null) {
            this.pickedObj = this.getPickedArc(x, y);
        }
        return this.pickedObj;
    }

    public EdGraphObject getPicked() {
        return this.pickedObj;
    }

    public EdNode getPickedNode(int x, int y) {
        this.pickedObj = null;
        int i = this.nodes.size() - 1;
        while (i >= 0) {
            EdNode en = this.nodes.elementAt(i);
            if (en.inside(x, y)) {
                this.pickedObj = en;
                return en;
            }
            --i;
        }
        return null;
    }

    public EdArc getPickedArc(int x, int y) {
        this.pickedObj = null;
        int i = this.arcs.size() - 1;
        while (i >= 0) {
            EdArc ea = this.arcs.elementAt(i);
            if (ea.inside(x, y)) {
                this.pickedObj = ea;
                return ea;
            }
            --i;
        }
        return null;
    }

    public void setNodeOfAnimatedTypeToFront() {
        EdNode eNode;
        Vector<EdNode> list = new Vector<EdNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            eNode = this.nodes.get(i);
            if (eNode.getType().isAnimated()) {
                list.add(eNode);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            eNode = (EdNode)list.get(i);
            this.nodes.remove(eNode);
            this.nodes.add(eNode);
            ++i;
        }
        list.clear();
    }

    public void nodeToFront(EdNode go) {
        if (go != null) {
            this.nodes.remove(go);
            this.nodes.add(go);
        }
    }

    public EdArc getPickedTextOfArc(int x, int y, FontMetrics fm) {
        int i = 0;
        while (i < this.arcs.size()) {
            EdArc ea = this.arcs.elementAt(i);
            if (ea.insideTextOfArc(x, y, fm)) {
                return ea;
            }
            ++i;
        }
        return null;
    }

    public void moveNode(EdNode pickedNode, int dx, int dy) {
        if (pickedNode != null) {
            EdArc ea;
            Vector<EdArc> in = this.getIncomingArcs(pickedNode);
            Vector<EdArc> out = this.getOutgoingArcs(pickedNode);
            pickedNode.x += dx;
            pickedNode.y += dy;
            int i = 0;
            while (i < in.size()) {
                ea = in.elementAt(i);
                if (ea.isLine() && ea.hasAnchor()) {
                    ea.setAnchor(new Point(ea.getAnchor().x + dx / 2, ea.getAnchor().y + dy / 2));
                }
                ++i;
            }
            i = 0;
            while (i < out.size()) {
                ea = out.elementAt(i);
                if (ea.isLine() && ea.hasAnchor()) {
                    ea.setAnchor(new Point(ea.getAnchor().x + dx / 2, ea.getAnchor().y + dy / 2));
                } else if (!ea.isLine()) {
                    Loop loop = ea.toLoop();
                    loop.move(((EdNode)ea.getSource()).toRectangle(), 0, dx, dy);
                    ea.setAnchor(1, new Point(loop.x, loop.y));
                    ea.setWidth(loop.w);
                    ea.setHeight(loop.h);
                }
                ++i;
            }
        }
    }

    public void moveNodeAndNotSelectedInOutArcs(EdNode pickedNode, int dx, int dy) {
        if (pickedNode != null) {
            EdArc ea;
            Vector<EdArc> in = this.getIncomingArcs(pickedNode);
            Vector<EdArc> out = this.getOutgoingArcs(pickedNode);
            pickedNode.x += dx;
            pickedNode.y += dy;
            int i = 0;
            while (i < in.size()) {
                ea = in.elementAt(i);
                if (!ea.isSelected() && ea.isLine() && ea.hasAnchor()) {
                    if (!ea.getSource().isSelected()) {
                        ea.setAnchor(new Point(ea.getAnchor().x + dx / 2, ea.getAnchor().y + dy / 2));
                    } else if (!ea.moved) {
                        ea.setAnchor(new Point(ea.getAnchor().x + dx, ea.getAnchor().y + dy));
                        ea.moved = true;
                    } else {
                        ea.moved = false;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < out.size()) {
                ea = out.elementAt(i);
                if (!ea.isSelected()) {
                    if (ea.isLine() && ea.hasAnchor()) {
                        if (!ea.getTarget().isSelected()) {
                            ea.setAnchor(new Point(ea.getAnchor().x + dx / 2, ea.getAnchor().y + dy / 2));
                        } else if (!ea.moved) {
                            ea.setAnchor(new Point(ea.getAnchor().x + dx, ea.getAnchor().y + dy));
                            ea.moved = true;
                        } else {
                            ea.moved = false;
                        }
                    } else if (!ea.isLine()) {
                        Loop loop = ea.toLoop();
                        loop.move(((EdNode)ea.getSource()).toRectangle(), 0, dx, dy);
                        ea.setAnchor(1, new Point(loop.x, loop.y));
                        ea.setWidth(loop.w);
                        ea.setHeight(loop.h);
                    }
                }
                ++i;
            }
        }
    }

    private void moveNodeOnly(EdNode pickedNode, int dx, int dy) {
        if (pickedNode != null) {
            Vector<EdArc> in = this.getIncomingArcs(pickedNode);
            pickedNode.x += dx;
            pickedNode.y += dy;
            int i = 0;
            while (i < in.size()) {
                EdArc ea = in.elementAt(i);
                if (!ea.isLine()) {
                    Loop loop = ea.toLoop();
                    loop.move(((EdNode)ea.getSource()).toRectangle(), 0, dx, dy);
                    ea.setAnchor(1, new Point(loop.x, loop.y));
                    ea.setWidth(loop.w);
                    ea.setHeight(loop.h);
                }
                ++i;
            }
        }
    }

    public void moveArc(EdArc pickedArc, int dx, int dy) {
        if (pickedArc != null) {
            if (pickedArc.isLine()) {
                pickedArc.setAnchor(new Point(pickedArc.getAnchor().x + dx, pickedArc.getAnchor().y + dy));
            } else {
                Loop loop = pickedArc.toLoop();
                loop.move(((EdNode)pickedArc.getSource()).toRectangle(), pickedArc.getAnchorID(), dx, dy);
                pickedArc.setAnchor(1, new Point(loop.x, loop.y));
                pickedArc.setWidth(loop.w);
                pickedArc.setHeight(loop.h);
            }
        }
    }

    public void moveTextOfArc(EdArc pickedTextOfArc, int dx, int dy) {
        pickedTextOfArc.translateTextOffset(dx, dy);
    }

    public void moveObject(EdGraphObject go, int dx, int dy) {
        if (go instanceof EdNode) {
            this.moveNode((EdNode)go, dx, dy);
        } else if (go instanceof EdArc) {
            this.moveArc((EdArc)go, dx, dy);
        }
    }

    public void moveObjects(Vector<EdGraphObject> objects, int dx, int dy) {
        if (objects == null) {
            return;
        }
        Enumeration<EdGraphObject> objs = objects.elements();
        while (objs.hasMoreElements()) {
            EdGraphObject go = objs.nextElement();
            if (go instanceof EdNode) {
                this.moveNode((EdNode)go, dx, dy);
                continue;
            }
            if (!(go instanceof EdArc)) continue;
            EdArc ea = (EdArc)go;
            this.moveArc(ea, dx, dy);
        }
    }

    public EdNode getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(EdNode en) {
        if (this.nodes.contains(en)) {
            if (this.selectedNodes == null) {
                this.selectedNodes = new Vector();
            }
            if (!this.selectedNodes.contains(en)) {
                en.setSelected(true);
                this.selectedNodes.addElement(en);
            }
            this.selectedNode = en;
        }
    }

    public Vector<EdNode> getSelectedNodes() {
        return this.selectedNodes != null ? this.selectedNodes : new Vector(0);
    }

    public EdGraphObject selectNode(int x, int y) {
        EdNode selEdNode = null;
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode eNode = this.nodes.elementAt(i);
            if (eNode.inside(x, y)) {
                selEdNode = eNode;
                selEdNode.setSelected(true);
                if (this.selectedNodes == null) {
                    this.selectedNodes = new Vector();
                }
                if (selEdNode.isSelected()) {
                    this.selectedNodes.addElement(selEdNode);
                    this.selectedNode = selEdNode;
                    break;
                }
                this.selectedNodes.removeElement(selEdNode);
                if (this.selectedNode != selEdNode) break;
                this.selectedNode = null;
                break;
            }
            ++i;
        }
        return selEdNode;
    }

    public EdArc getSelectedArc() {
        return this.selectedArc;
    }

    public void setSelectedArc(EdArc ea) {
        if (this.arcs.contains(ea)) {
            if (this.selectedArcs == null) {
                this.selectedArcs = new Vector();
            }
            if (!this.selectedArcs.contains(ea)) {
                ea.setSelected(true);
                this.selectedArcs.addElement(ea);
            }
            this.selectedArc = ea;
        }
    }

    public Vector<EdArc> getSelectedArcs() {
        return this.selectedArcs != null ? this.selectedArcs : new Vector(0);
    }

    public EdGraphObject selectArc(int x, int y) {
        EdArc selEdArc = null;
        int i = 0;
        while (i < this.arcs.size()) {
            EdArc eArc = this.arcs.elementAt(i);
            if (eArc.inside(x, y) || eArc.insideTextOfArc(x, y, null)) {
                selEdArc = eArc;
                selEdArc.setSelected(true);
                if (this.selectedArcs == null) {
                    this.selectedArcs = new Vector();
                }
                if (selEdArc.isSelected()) {
                    this.selectedArcs.addElement(selEdArc);
                    this.selectedArc = selEdArc;
                    break;
                }
                this.selectedArcs.removeElement(selEdArc);
                if (this.selectedArc != selEdArc) break;
                this.selectedArc = null;
                break;
            }
            ++i;
        }
        return selEdArc;
    }

    public EdGraphObject select(int x, int y) {
        EdGraphObject eObj = null;
        eObj = this.selectNode(x, y);
        if (eObj == null) {
            eObj = this.selectArc(x, y);
        }
        return eObj;
    }

    public void select(EdGraphObject obj) {
        if (obj != null) {
            obj.setSelected(true);
            if (obj.isNode()) {
                if (this.selectedNodes == null) {
                    this.selectedNodes = new Vector();
                }
                this.selectedNodes.addElement((EdNode)obj);
            } else {
                if (this.selectedArcs == null) {
                    this.selectedArcs = new Vector();
                }
                this.selectedArcs.addElement((EdArc)obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.selectedNodes == null) {
                this.selectedNodes = new Vector();
            }
            if (this.selectedArcs == null) {
                this.selectedArcs = new Vector();
            }
            this.deselectAll();
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode eNode = this.nodes.elementAt(i);
                if (!eNode.isSelected()) {
                    eNode.setSelected(true);
                    this.selectedNodes.addElement(eNode);
                }
                ++i;
            }
            int j = 0;
            while (j < this.arcs.size()) {
                EdArc eArc = this.arcs.elementAt(j);
                if (!eArc.isSelected()) {
                    eArc.setSelected(true);
                    this.selectedArcs.addElement(eArc);
                }
                ++j;
            }
        }
    }

    public void selectObjectsOfSelectedNodeType() {
        EdType t = this.typeSet.getSelectedNodeType();
        this.selectObjectsOfType(t);
    }

    public void selectObjectsOfSelectedArcType() {
        EdType t = this.typeSet.getSelectedArcType();
        this.selectObjectsOfType(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectObjectsOfType(EdType t) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            this.clearSelected();
            if (this.selectedNodes == null) {
                this.selectedNodes = new Vector();
            }
            if (this.selectedArcs == null) {
                this.selectedArcs = new Vector();
            }
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode eNode = this.nodes.elementAt(i);
                if (eNode.getType().equals(t) && !this.selectedNodes.contains(eNode)) {
                    eNode.setSelected(true);
                    this.selectedNodes.addElement(eNode);
                }
                ++i;
            }
            int j = 0;
            while (j < this.arcs.size()) {
                EdArc eArc = this.arcs.elementAt(j);
                if (eArc.getType().equals(t) && !this.selectedArcs.contains(eArc)) {
                    eArc.setSelected(true);
                    this.selectedArcs.addElement(eArc);
                }
                ++j;
            }
        }
    }

    public void deselect(EdGraphObject ego) {
        if (ego != null) {
            ego.setSelected(false);
            if (ego.isNode() && this.selectedNodes != null) {
                this.selectedNodes.removeElement(ego);
            } else if (ego.isArc() && this.selectedArcs != null) {
                this.selectedArcs.removeElement(ego);
            }
        }
    }

    public void deselectAll() {
        this.clearSelected();
    }

    public Vector<EdGraphObject> getSelectedObjs() {
        int i;
        Vector<EdGraphObject> sel = new Vector<EdGraphObject>();
        if (this.selectedNodes != null) {
            i = 0;
            while (i < this.selectedNodes.size()) {
                EdNode en = this.selectedNodes.elementAt(i);
                sel.addElement(en);
                ++i;
            }
        }
        if (this.selectedArcs != null) {
            i = 0;
            while (i < this.selectedArcs.size()) {
                EdArc ea = this.selectedArcs.elementAt(i);
                sel.addElement(ea);
                ++i;
            }
        }
        return sel;
    }

    public EdGraph getSelectedAsGraph() {
        if (this.selectedNodes != null && !this.selectedNodes.isEmpty() && this.selectedArcsOK()) {
            int i;
            TypeSet ts = new TypeSet(this.typeSet.isArcDirected(), this.typeSet.isArcParallel());
            Graph bResult = BaseFactory.theFactory().createGraph(ts);
            HashMap<EdGraphObject, EdNode> hmap = new HashMap<EdGraphObject, EdNode>();
            EdGraph result = new EdGraph(bResult, new EdTypeSet(bResult.getTypeSet()));
            Vector<EdNode> singleNodes = new Vector<EdNode>(this.selectedNodes.size());
            singleNodes.addAll(this.selectedNodes);
            if (this.selectedArcs != null) {
                i = 0;
                while (i < this.selectedArcs.size()) {
                    EdArc copy;
                    EdArc ea = this.selectedArcs.elementAt(i);
                    EdNode src = (EdNode)hmap.get(ea.getSource());
                    if (src == null && (src = result.copyNode((EdNode)ea.getSource(), ea.getSource().getX(), ea.getSource().getY())) != null) {
                        hmap.put(ea.getSource(), src);
                    }
                    EdNode trg = src;
                    if (!ea.getSource().equals(ea.getTarget()) && (trg = (EdNode)hmap.get(ea.getTarget())) == null && (trg = result.copyNode((EdNode)ea.getTarget(), ea.getTarget().getX(), ea.getTarget().getY())) != null) {
                        hmap.put(ea.getTarget(), trg);
                    }
                    if (src != null && trg != null && (copy = result.copyArc(ea, src, trg)) != null) {
                        if (ea.getBasisArc().isInheritance()) {
                            copy.setContextUsage("INHERITANCE");
                        }
                        copy.setSelected(true);
                        if (!src.isSelected()) {
                            src.setSelected(true);
                        }
                        if (!trg.isSelected()) {
                            trg.setSelected(true);
                        }
                        singleNodes.removeElement(ea.getSource());
                        singleNodes.removeElement(ea.getTarget());
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < singleNodes.size()) {
                EdNode en = (EdNode)singleNodes.elementAt(i);
                EdNode copy = result.copyNode(en, en.getX(), en.getY());
                if (copy != null) {
                    copy.setSelected(true);
                }
                ++i;
            }
            hmap.clear();
            return result;
        }
        return null;
    }

    public void deselectAllWeakselected() {
        for (EdNode en : this.nodes) {
            if (!en.isWeakselected()) continue;
            en.setWeakselected(false);
            return;
        }
        for (EdArc ea : this.arcs) {
            if (!ea.isWeakselected()) continue;
            ea.setWeakselected(false);
            return;
        }
    }

    public void setVisibilityOfGraphObjectsOfType(EdGraphObject type, boolean vis) {
        if (this.isTG) {
            int i;
            int oldhidden = this.hidden;
            if (type.isNode()) {
                Vector<EdNode> list = new Vector<EdNode>();
                i = 0;
                while (i < this.nodes.size()) {
                    EdNode n = this.nodes.get(i);
                    if (type.getType().getBasisType().isParentOf(n.getType().getBasisType())) {
                        n.getType().getBasisType().setVisibilityOfObjectsOfTypeGraphNode(vis);
                        this.hidden = vis ? this.hidden - 1 : this.hidden + 1;
                        list.add(n);
                    }
                    ++i;
                }
                int j = 0;
                while (j < this.arcs.size()) {
                    EdArc a = this.arcs.get(j);
                    if (list.contains(a.getSource()) || list.contains(a.getTarget())) {
                        a.getType().getBasisType().setVisibityOfObjectsOfTypeGraphArc(a.getSource().getType().getBasisType(), a.getTarget().getType().getBasisType(), vis);
                        this.hidden = vis ? this.hidden - 1 : this.hidden + 1;
                    }
                    ++j;
                }
            } else {
                ((EdArc)type).getType().getBasisType().setVisibityOfObjectsOfTypeGraphArc(((EdArc)type).getSource().getType().getBasisType(), ((EdArc)type).getTarget().getType().getBasisType(), vis);
                this.hidden = vis ? this.hidden - 1 : this.hidden + 1;
            }
            Vector<EdGraph> graphs = this.eGra.getGraphs();
            i = 0;
            while (i < graphs.size()) {
                ((EdGraph)graphs.get((int)i)).visibilityChecked = oldhidden == this.hidden;
                ++i;
            }
        }
    }

    public void setDrawingStyleOfCriticalObjects(int criticalStyle) {
        this.criticalStyle = criticalStyle;
    }

    public void setGraphToCopy(EdGraph g) {
        this.gCopy = g;
    }

    private void addToGraphEmbedding(EdGraphObject sourceObject) {
        EdRuleScheme rs;
        EdRule kernelRule;
        if (this.isSourceGraphOfGraphEmbedding() && (kernelRule = this.eGra.getRule(this.bGraph)) != null && (rs = this.eGra.getRuleScheme(kernelRule.getBasisRule())) != null) {
            rs.propagateAddGraphObjectToMultiRule(sourceObject);
        }
    }

    private void addGraph(EdGraph eg, int x, int y) {
        if (this.isGraph(eg) && eg.getNodes().size() > 0) {
            int newY;
            int newX;
            if (this.selectedNodes == null) {
                this.selectedNodes = new Vector();
            }
            if (this.selectedArcs == null) {
                this.selectedArcs = new Vector();
            }
            HashMap<EdGraphObject, EdNode> hmap = new HashMap<EdGraphObject, EdNode>();
            Vector<EdNode> singleNodes = new Vector<EdNode>();
            singleNodes.addAll(eg.getNodes());
            int i = 0;
            while (i < eg.getArcs().size()) {
                EdArc ea = eg.getArcs().elementAt(i);
                EdNode src = null;
                EdNode trg = null;
                src = (EdNode)hmap.get(ea.getSource());
                if (src == null) {
                    src = this.copyNode((EdNode)ea.getSource(), ea.getSource().getX(), ea.getSource().getY());
                    if (src != null) {
                        if (!src.isSelected()) {
                            src.setSelected(true);
                            this.selectedNodes.addElement(src);
                        }
                    } else if (this.isTG) {
                        src = this.getFirstNodeByTypeName(ea.getSource().getTypeName());
                    }
                    if (src != null) {
                        hmap.put(ea.getSource(), src);
                    }
                }
                if ((trg = (EdNode)hmap.get(ea.getTarget())) == null) {
                    trg = this.copyNode((EdNode)ea.getTarget(), ea.getTarget().getX(), ea.getTarget().getY());
                    if (trg != null) {
                        if (!trg.equals(src) && !trg.isSelected()) {
                            trg.setSelected(true);
                            this.selectedNodes.addElement(trg);
                        }
                    } else if (this.isTG) {
                        trg = this.getFirstNodeByTypeName(ea.getTarget().getTypeName());
                    }
                    if (trg != null) {
                        hmap.put(ea.getTarget(), trg);
                    }
                }
                if (src != null && trg != null) {
                    if (ea.getContextUsage().equals("INHERITANCE")) {
                        this.getBasisGraph().getTypeSet().addInheritanceRelation(src.getBasisNode().getType(), trg.getBasisNode().getType());
                    } else {
                        EdArc copy = this.copyArc(ea, src, trg);
                        if (copy != null) {
                            if (!(this.selectedNodes.contains(src) && this.selectedNodes.contains(trg) || !copy.isLine())) {
                                copy.setAnchor(null);
                            }
                            copy.setSelected(true);
                            this.selectedArcs.addElement(copy);
                        } else if (this.isTG) {
                            copy = this.getFirstArcByTypeName(ea.getTypeName(), src, trg);
                        }
                    }
                }
                singleNodes.removeElement(ea.getSource());
                singleNodes.removeElement(ea.getTarget());
                ++i;
            }
            i = 0;
            while (i < singleNodes.size()) {
                EdNode en = (EdNode)singleNodes.elementAt(i);
                EdNode copy = this.copyNode(en, en.getX(), en.getY());
                if (copy != null) {
                    copy.setSelected(true);
                    this.selectedNodes.addElement(copy);
                } else if (this.isTG) {
                    copy = this.getFirstNodeByTypeName(en.getTypeName());
                }
                ++i;
            }
            Point p = this.findCenter(this.selectedNodes);
            int dx = 0;
            int dy = 0;
            int i2 = 0;
            while (i2 < this.selectedNodes.size()) {
                EdNode en = this.selectedNodes.get(i2);
                dx = en.getX() - p.x;
                dy = en.getY() - p.y;
                newX = x + dx;
                newY = y + dy;
                en.setX(newX);
                en.setY(newY);
                this.addToGraphEmbedding(en);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.selectedArcs.size()) {
                EdArc ea = this.selectedArcs.get(i2);
                if (ea.isLine() && ea.hasAnchor()) {
                    dx = ea.getAnchor().x - p.x;
                    dy = ea.getAnchor().y - p.y;
                    newX = x + dx;
                    newY = y + dy;
                    ea.setAnchor(new Point(newX, newY));
                }
                this.addToGraphEmbedding(ea);
                ++i2;
            }
            this.refreshInheritanceArcs();
            this.typeSet.fireTypeChangedEvent();
        }
    }

    private EdNode getFirstNodeByTypeName(String tname) {
        Vector<EdNode> tnodes;
        EdType t = this.getTypeSet().getNodeTypeForName(tname);
        if (t != null && !(tnodes = this.getNodes(t)).isEmpty()) {
            return (EdNode)tnodes.get(0);
        }
        return null;
    }

    private EdArc getFirstArcByTypeName(String tname, EdNode src, EdNode tgt) {
        Arc baseArc;
        EdType t = this.getTypeSet().getArcTypeForName(tname);
        if (t != null && (baseArc = this.getTypeSet().getBasisTypeSet().getTypeGraphArc(t.getBasisType(), src.getBasisNode().getType(), tgt.getBasisNode().getType())) != null) {
            return this.findArc(baseArc);
        }
        return null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean adjustTypeObjectsMap() {
        if (this.typeSet.hasTypeKeyChanged()) {
            this.bGraph.updateTypeObjectsMap();
            this.typeSet.unsetTypeKeyChanged();
            return true;
        }
        return false;
    }

    public boolean isNodeNumberChanged() {
        return this.nodeNumberChanged;
    }

    public boolean isNodeRemoved() {
        return this.nodeRemoved;
    }

    public void unsetNodeNumberChanged() {
        this.nodeNumberChanged = false;
        this.nodeRemoved = false;
    }

    public boolean hasOneSelection() {
        int s = 0;
        if (this.selectedNodes != null) {
            s = this.selectedNodes.size();
        }
        if (s == 0 && this.selectedArcs != null) {
            s = this.selectedArcs.size();
        }
        return s == 1;
    }

    private boolean nothingSelected() {
        if (this.selectedNodes != null && this.selectedNodes.size() > 0) {
            return false;
        }
        return this.selectedArcs == null || this.selectedArcs.size() <= 0;
    }

    public boolean hasSelection() {
        return !this.nothingSelected();
    }

    public boolean hasAllSelected() {
        return this.selectedNodes != null && this.selectedNodes.size() == this.nodes.size() && this.selectedArcs != null && this.selectedArcs.size() == this.arcs.size();
    }

    private boolean selectedArcsOK() {
        if (this.selectedArcs != null) {
            int i = 0;
            while (i < this.selectedArcs.size()) {
                EdArc selObj = this.selectedArcs.elementAt(i);
                if (this.selectedNodes == null || !this.selectedNodes.contains(selObj.getSource()) || !this.selectedNodes.contains(selObj.getTarget())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean unsetCriticalGraphObjects() {
        boolean res = false;
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i).getBasisNode().isCritical()) {
                this.nodes.get(i).getBasisNode().setCritical(false);
                res = true;
            }
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            if (this.arcs.get(i).getBasisArc().isCritical()) {
                this.arcs.get(i).getBasisArc().setCritical(false);
                res = true;
            }
            ++i;
        }
        return res;
    }

    public void setContextUsageOfGraphObjToBasisHashCode() {
        EdGraphObject go;
        int i = 0;
        while (i < this.nodes.size()) {
            go = this.nodes.get(i);
            ((EdNode)go).getBasisNode().setContextUsage(((EdNode)go).getBasisNode().hashCode());
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            go = this.arcs.get(i);
            ((EdArc)go).getBasisArc().setContextUsage(((EdArc)go).getBasisArc().hashCode());
            ++i;
        }
    }

    public void unsetContextUsageOfGraphObj() {
        EdGraphObject go;
        int i = 0;
        while (i < this.nodes.size()) {
            go = this.nodes.get(i);
            ((EdNode)go).getBasisNode().setContextUsage(-1);
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            go = this.arcs.get(i);
            ((EdArc)go).getBasisArc().setContextUsage(-1);
            ++i;
        }
    }

    public EdGraph copy() {
        this.setContextUsageOfGraphObjToBasisHashCode();
        int tglevel = this.bGraph.getTypeSet().getLevelOfTypeGraphCheck();
        if (tglevel == 30) {
            this.bGraph.getTypeSet().setLevelOfTypeGraphCheck(20);
        }
        EdGraph clone = new EdGraph(BaseFactory.theFactory().createGraph(this.bGraph.getTypeSet(), this.bGraph.isCompleteGraph()), this.typeSet);
        clone.getBasisGraph().setName(this.bGraph.getName());
        if (this.bGraph.getAttrContext() != null && ((ContextView)this.bGraph.getAttrContext()).getAllowedMapping() == 2) {
            AttrContext aGraphContext = AttrTupleManager.getDefaultManager().newContext(2);
            clone.getBasisGraph().setAttrContext(AttrTupleManager.getDefaultManager().newRightContext(aGraphContext));
        }
        Hashtable<EdNode, EdNode> table = new Hashtable<EdNode, EdNode>();
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode node = this.nodes.elementAt(i);
            try {
                Node n = clone.getBasisGraph().copyNode(node.getBasisNode());
                if (n != null) {
                    EdNode cnode = clone.addNode(n, node.getType());
                    cnode.setXY(node.getX(), node.getY());
                    cnode.getLNode().setFrozenByDefault(node.getLNode().isFrozen());
                    table.put(node, cnode);
                }
            }
            catch (TypeException e) {
                System.out.println("EdGraph.copy::  " + e.getLocalizedMessage());
            }
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            EdArc arc = this.arcs.elementAt(i);
            EdNode src = (EdNode)arc.getSource();
            EdNode trg = (EdNode)arc.getTarget();
            EdNode csrc = (EdNode)table.get(src);
            EdNode ctrg = (EdNode)table.get(trg);
            if (csrc != null && ctrg != null) {
                try {
                    EdArc carc;
                    Arc a = clone.getBasisGraph().copyArc(arc.getBasisArc(), csrc.getBasisNode(), ctrg.getBasisNode());
                    if (a != null && (carc = clone.addArc(a, arc.getType())) != null) {
                        if (arc.isLine()) {
                            if (arc.hasAnchor()) {
                                carc.setAnchor(new Point(arc.getAnchor()));
                            }
                        } else if (arc.hasAnchor()) {
                            carc.setAnchor(1, new Point(arc.getAnchor()));
                            carc.setWidth(arc.getWidthOfLoop());
                            carc.setHeight(arc.getHeightOfLoop());
                        }
                        carc.setTextOffset(arc.getTextOffset().x, arc.getTextOffset().y);
                        carc.getLArc().setFrozenByDefault(arc.getLArc().isFrozenByDefault());
                    }
                }
                catch (TypeException e) {
                    System.out.println("EdGraph.copy::  " + e.getLocalizedMessage());
                }
            }
            ++i;
        }
        if (tglevel == 30) {
            this.getBasisGraph().getTypeSet().setLevelOfTypeGraphCheck(30);
        }
        table.clear();
        table = null;
        return clone;
    }

    private void disposeGraphObjects() {
        if (this.selectedNodes != null) {
            this.selectedNodes.clear();
        }
        if (this.selectedArcs != null) {
            this.selectedArcs.clear();
        }
        this.selectedNode = null;
        this.selectedArc = null;
        this.pickedObj = null;
        if (this.visibleArcs != null) {
            this.visibleArcs.clear();
        }
        if (this.visibleNodes != null) {
            this.visibleNodes.clear();
        }
        if (this.inheritanceArcs != null) {
            this.inheritanceArcs.clear();
        }
        if (this.changedObjects != null) {
            this.changedObjects.clear();
        }
        int i = 0;
        while (i < this.arcs.size()) {
            this.arcs.get(i).dispose();
            ++i;
        }
        i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).dispose();
            ++i;
        }
        this.arcs.clear();
        this.nodes.clear();
        this.basisNode2node.clear();
        this.gCopy = null;
    }

    public boolean isSourceGraphOfGraphEmbedding() {
        EdRule rule;
        return this.eGra != null && (rule = this.eGra.getRule(this.bGraph)) != null && rule.getBasisRule() instanceof KernelRule;
    }

    public boolean isSourceGraphOfGraphEmbeddingLeft() {
        EdRule rule;
        return this.eGra != null && (rule = this.eGra.getRule(this.bGraph)) != null && rule.getBasisRule() instanceof KernelRule && rule.getLeft() == this;
    }

    public boolean isSourceGraphOfGraphEmbeddingRight() {
        EdRule rule;
        return this.eGra != null && (rule = this.eGra.getRule(this.bGraph)) != null && rule.getBasisRule() instanceof KernelRule && rule.getRight() == this;
    }

    public boolean isTargetObjOfGraphEmbedding(EdGraphObject go) {
        EdRule rule;
        return this.eGra != null && (rule = this.eGra.getRule(this.bGraph)) != null && rule.getBasisRule() instanceof MultiRule && (((MultiRule)rule.getBasisRule()).isTargetOfEmbeddingLeft(go.getBasisObject()) || ((MultiRule)rule.getBasisRule()).isTargetOfEmbeddingRight(go.getBasisObject()));
    }

    public EdGraphObject getSourceObjOfGraphEmbedding(EdGraphObject tarObj) {
        EdRule rule = this.eGra.getRule(this.bGraph);
        if (rule != null && rule.getBasisRule() instanceof MultiRule) {
            if (((MultiRule)rule.getBasisRule()).isTargetOfEmbeddingLeft(tarObj.getBasisObject())) {
                GraphObject kern = ((MultiRule)rule.getBasisRule()).getEmbeddingLeft().getInverseImage(tarObj.getBasisObject()).nextElement();
                EdRuleScheme rs = this.eGra.getRuleScheme(this.bGraph);
                if (rs != null) {
                    return rs.getKernelRule().getLeft().findGraphObject(kern);
                }
            } else if (((MultiRule)rule.getBasisRule()).isTargetOfEmbeddingRight(tarObj.getBasisObject())) {
                GraphObject kern = ((MultiRule)rule.getBasisRule()).getEmbeddingRight().getInverseImage(tarObj.getBasisObject()).nextElement();
                EdRuleScheme rs = this.eGra.getRuleScheme(this.bGraph);
                if (rs != null) {
                    return rs.getKernelRule().getRight().findGraphObject(kern);
                }
            }
        }
        return null;
    }

    protected boolean deleteArc(EdArc go, boolean addToUndo) {
        boolean done;
        block4: {
            done = true;
            try {
                if (addToUndo) {
                    this.addDeletedToUndo(go);
                    this.deleteObj(go, false);
                    this.undoManagerEndEdit();
                } else {
                    this.deleteObj(go, false);
                }
            }
            catch (TypeException e) {
                done = false;
                if (!addToUndo) break block4;
                this.undoManagerLastEditDie();
            }
        }
        return done;
    }

    protected boolean deleteNode(EdNode go, boolean addToUndo) {
        boolean done;
        block10: {
            done = true;
            if (go.getBasisNode().getNumberOfArcs() != 0) {
                EdArc arc;
                Iterator<Arc> edges = go.getBasisNode().getOutgoingArcsSet().iterator();
                while (edges.hasNext() && done) {
                    arc = this.findArc(edges.next());
                    if (arc == null) continue;
                    if (this.typeSet.getBasisTypeSet().checkIfRemovable(arc.getBasisArc(), true, false) == null && this.deleteArc(arc, addToUndo)) {
                        edges = go.getBasisNode().getOutgoingArcsSet().iterator();
                        continue;
                    }
                    done = false;
                }
                edges = go.getBasisNode().getIncomingArcsSet().iterator();
                while (edges.hasNext() && done) {
                    arc = this.findArc(edges.next());
                    if (arc == null) continue;
                    if (this.typeSet.getBasisTypeSet().checkIfRemovable(arc.getBasisArc(), false, true) == null && this.deleteArc(arc, addToUndo)) {
                        edges = go.getBasisNode().getIncomingArcsSet().iterator();
                        continue;
                    }
                    done = false;
                }
            }
            if (done) {
                try {
                    if (addToUndo) {
                        this.addDeletedToUndo(go);
                        this.deleteObj(go, false);
                        this.undoManagerEndEdit();
                    } else {
                        this.deleteObj(go, false);
                    }
                }
                catch (TypeException e) {
                    done = false;
                    if (!addToUndo) break block10;
                    this.undoManagerLastEditDie();
                }
            }
        }
        return done;
    }

    protected List<EdGraphObject> getGraphObjectsOfType(EdGraphObject tgo) {
        Vector<EdGraphObject> list = new Vector<EdGraphObject>();
        if (tgo.isArc()) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc go = this.arcs.get(i);
                if (tgo.getType() == go.getType() && ((EdArc)tgo).getSource().getType().isParentOf(go.getSource().getType()) && ((EdArc)tgo).getTarget().getType().isParentOf(go.getTarget().getType())) {
                    list.add(go);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode go = this.nodes.get(i);
                if (tgo.getType() == go.getType()) {
                    list.add(go);
                }
                ++i;
            }
        }
        return list;
    }

    protected List<EdGraphObject> getGraphObjectsOfType(EdType t) {
        Vector<EdGraphObject> list = new Vector<EdGraphObject>();
        if (t.isArcType()) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc go = this.arcs.get(i);
                if (t == go.getType()) {
                    list.add(go);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode go = this.nodes.get(i);
                if (t == go.getType()) {
                    list.add(go);
                }
                ++i;
            }
        }
        return list;
    }

    public boolean deleteGraphObjectsOfTypeFromGraph(EdGraphObject tgo, boolean addToUndo) {
        boolean alldone = true;
        if (tgo.isArc()) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc go = this.arcs.get(i);
                if (tgo.getType() == go.getType() && ((EdArc)tgo).getSource().getType().isParentOf(go.getSource().getType()) && ((EdArc)tgo).getTarget().getType().isParentOf(go.getTarget().getType())) {
                    if (this.deleteArc(go, addToUndo)) {
                        --i;
                    } else {
                        alldone = false;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode go = this.nodes.get(i);
                if (tgo.getType() == go.getType()) {
                    if (this.deleteNode(go, addToUndo)) {
                        --i;
                    } else {
                        alldone = false;
                    }
                }
                ++i;
            }
        }
        return alldone;
    }

    public boolean deleteGraphObjectsOfTypeFromGraph(EdType t, boolean addToUndo) {
        boolean alldone = true;
        if (t.isArcType()) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc go = this.arcs.get(i);
                if (t == go.getType()) {
                    if (this.deleteArc(go, addToUndo)) {
                        --i;
                    } else {
                        alldone = false;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode go = this.nodes.get(i);
                if (t == go.getType()) {
                    if (this.deleteNode(go, addToUndo)) {
                        --i;
                    } else {
                        alldone = false;
                    }
                }
                ++i;
            }
        }
        return alldone;
    }

    public void delArc(Arc bArc) throws TypeException {
        EdArc eArc = this.findArc(bArc);
        if (eArc != null) {
            this.delSelectedArc(eArc);
        }
    }

    public void delNode(Node bNode) throws TypeException {
        Vector<EdArc> inArcs = new Vector<EdArc>();
        Vector<EdArc> outArcs = new Vector<EdArc>();
        EdArc eArc = null;
        EdNode eNode = this.findNode(bNode);
        if (eNode != null) {
            int j = 0;
            while (j < this.arcs.size()) {
                eArc = this.arcs.elementAt(j);
                if (eNode.equals(eArc.getSource())) {
                    outArcs.addElement(eArc);
                } else if (eNode.equals(eArc.getTarget()) && eArc.isLine()) {
                    inArcs.addElement(eArc);
                }
                ++j;
            }
            if (!inArcs.isEmpty()) {
                j = 0;
                while (j < inArcs.size()) {
                    eArc = (EdArc)inArcs.elementAt(j);
                    this.removeElement(eArc);
                    ++j;
                }
                inArcs.removeAllElements();
            }
            if (!outArcs.isEmpty()) {
                j = 0;
                while (j < outArcs.size()) {
                    eArc = (EdArc)outArcs.elementAt(j);
                    this.removeElement(eArc);
                    ++j;
                }
                outArcs.removeAllElements();
            }
            this.delSelectedNode(eNode);
        }
    }

    public void delSelectedNode(EdNode eNode) throws TypeException {
        this.delSelectedNode(eNode, false);
    }

    public void delSelectedNode(EdNode eNode, boolean forceDelete) throws TypeException {
        boolean canDelete = true;
        EdType nType = eNode.getType();
        if (this.bGraph != null) {
            canDelete = false;
            try {
                eNode.removeFromAttributeViewObserver();
                this.bGraph.destroyNode(eNode.getBasisNode(), true, forceDelete);
                canDelete = true;
            }
            catch (TypeException e) {
                throw new TypeException(e.getTypeError());
            }
        }
        if (canDelete) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc a = this.arcs.get(i);
                if (!a.getBasisArc().isInheritance() && a.getBasisArc().getContext() == null) {
                    a.removeFromAttributeViewObserver();
                    this.removeBadArc(a, nType);
                    --i;
                }
                ++i;
            }
            this.removeElement(eNode);
        }
    }

    public void delSelectedArc(EdArc eArc) throws TypeException {
        this.delSelectedArc(eArc, false);
    }

    public void delSelectedArc(EdArc eArc, boolean forceDelete) throws TypeException {
        boolean canDelete = true;
        if (this.bGraph != null) {
            canDelete = false;
            try {
                eArc.removeFromAttributeViewObserver();
                this.bGraph.destroyArc(eArc.getBasisArc(), true, forceDelete);
                canDelete = true;
            }
            catch (TypeException e) {
                throw new TypeException(e.getTypeError());
            }
        }
        if (canDelete) {
            this.removeElement(eArc);
        }
    }

    public void deleteSelectedNodes() throws TypeException {
        if (this.selectedNodes != null) {
            while (!this.selectedNodes.isEmpty()) {
                EdNode eNode = this.selectedNodes.get(0);
                this.delSelectedNode(eNode, false);
            }
        }
    }

    public void deleteSelectedArcs() throws TypeException {
        if (this.selectedArcs != null) {
            while (!this.selectedArcs.isEmpty()) {
                EdArc eArc = this.selectedArcs.get(0);
                this.delSelectedArc(eArc, false);
            }
        }
    }

    public void deleteSelected() throws TypeException {
        int currentTypeGraphLevel = this.typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck();
        if (this.selectedNodes != null && this.selectedNodes.size() == this.nodes.size() && currentTypeGraphLevel > 10) {
            this.typeSet.getBasisTypeSet().setLevelOfTypeGraphCheck(10);
        }
        this.deleteSelectedArcs();
        this.deleteSelectedNodes();
        if (currentTypeGraphLevel > 10) {
            this.typeSet.getBasisTypeSet().setLevelOfTypeGraphCheck(currentTypeGraphLevel);
        }
    }

    public void deleteAll() throws TypeException {
        this.selectAll();
        int currentTypeGraphLevel = this.typeSet.getBasisTypeSet().getLevelOfTypeGraphCheck();
        if (currentTypeGraphLevel > 10) {
            this.typeSet.getBasisTypeSet().setLevelOfTypeGraphCheck(10);
        }
        this.deleteSelected();
        if (currentTypeGraphLevel > 10) {
            this.typeSet.getBasisTypeSet().setLevelOfTypeGraphCheck(currentTypeGraphLevel);
        }
    }

    public boolean deleteObj(int x, int y) throws TypeException {
        EdGraphObject obj = this.getPicked(x, y);
        if (obj != null) {
            if (obj.isNode()) {
                EdNode en = obj.getNode();
                this.delSelectedNode(en);
            } else {
                EdArc ea = obj.getArc();
                this.delSelectedArc(ea);
            }
            return true;
        }
        return false;
    }

    public void deleteObj(EdGraphObject ego, boolean forceDelete) throws TypeException {
        if (ego == null) {
            return;
        }
        if (ego.isNode()) {
            this.delSelectedNode((EdNode)ego, forceDelete);
        } else {
            EdArc ea = ego.getArc();
            this.delSelectedArc(ea, forceDelete);
        }
    }

    public void forceDeleteObj(EdGraphObject ego) throws TypeException {
        if (ego == null) {
            return;
        }
        if (ego.isNode()) {
            this.delSelectedNode((EdNode)ego, true);
        } else {
            this.delSelectedArc((EdArc)ego, true);
        }
    }

    public void deleteObjects(EdGraphObject typeGraphObject) throws TypeException {
        if (typeGraphObject == null) {
            return;
        }
        if (typeGraphObject.isNode()) {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode en = this.nodes.elementAt(i);
                if (en.getType().equals(typeGraphObject.getType())) {
                    this.delSelectedNode(en);
                    --i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc ea = this.arcs.elementAt(i);
                if (ea.getType().equals(((EdArc)typeGraphObject).getType()) && ea.getSource().getType().equals(((EdArc)typeGraphObject).getSource().getType()) && ea.getTarget().getType().equals(((EdArc)typeGraphObject).getTarget().getType())) {
                    this.delSelectedArc(ea);
                    --i;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjects(EdType t) throws TypeException {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (t == null) {
                return;
            }
            boolean nodeType = false;
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode en = this.nodes.elementAt(i);
                if (!t.isParentOf(en.getType())) break;
                nodeType = true;
                this.delSelectedNode(en);
                --i;
                ++i;
            }
            if (!nodeType) {
                i = 0;
                while (i < this.arcs.size()) {
                    EdArc ea = this.arcs.elementAt(i);
                    if (!t.isParentOf(ea.getType())) break;
                    this.delSelectedArc(ea);
                    --i;
                    ++i;
                }
            }
        }
    }

    public boolean isStraightenArcsEnabled() {
        return this.straightenArcs;
    }

    public void setStraightenArcs(boolean b) {
        if (!this.straightenArcs && b) {
            this.straightAllArcs();
        }
        this.straightenArcs = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void straightAllArcs() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc ea = this.arcs.elementAt(i);
                if (ea.isLine()) {
                    ea.setAnchor(null);
                }
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean straightSelectedArcs() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            boolean moved = false;
            if (this.selectedArcs != null) {
                int i = 0;
                while (i < this.selectedArcs.size()) {
                    EdArc ea = this.selectedArcs.elementAt(i);
                    if (ea.isLine() && ea.hasAnchor()) {
                        ea.setAnchor(null);
                        moved = true;
                    }
                    ++i;
                }
                if (moved) {
                    this.straightenArcs = false;
                }
            }
            return moved;
        }
    }

    public boolean straightArc(EdGraphObject ego) {
        EdArc ea;
        if (ego == null) {
            return false;
        }
        if (ego.isArc() && (ea = ego.getArc()).isLine() && ea.hasAnchor()) {
            ea.setAnchor(null);
            return true;
        }
        return false;
    }

    public Vector<EdGraphObject> copySelected(int x, int y) {
        int i;
        if (this.nothingSelected()) {
            if (this.gCopy != null) {
                this.addGraph(this.gCopy, x, y);
                this.deselectAll();
            } else {
                this.errMsg = "bad selection";
            }
            this.gCopy = null;
            return null;
        }
        if (!this.selectedArcsOK()) {
            this.errMsg = "bad selection";
            return null;
        }
        Vector<EdGraphObject> sel = new Vector<EdGraphObject>();
        Vector<EdGraphObject> selCopy = new Vector<EdGraphObject>();
        if (this.selectedNodes != null) {
            i = 0;
            while (i < this.selectedNodes.size()) {
                EdNode en = this.selectedNodes.elementAt(i);
                sel.addElement(en);
                ++i;
            }
        }
        if (this.selectedArcs != null) {
            i = 0;
            while (i < this.selectedArcs.size()) {
                EdArc ea = this.selectedArcs.elementAt(i);
                sel.addElement(ea);
                ++i;
            }
        }
        if (sel.isEmpty()) {
            this.errMsg = "bad selection";
            return null;
        }
        Point p = this.findCenter(this.selectedNodes);
        int dx = x - p.x;
        int dy = y - p.y;
        i = 0;
        while (i < sel.size()) {
            EdGraphObject goCopy;
            EdGraphObject go = (EdGraphObject)sel.elementAt(i);
            int cx = go.getX() + dx;
            int cy = go.getY() + dy;
            if (cx < 0) {
                cx = 20;
            }
            if (cy < 0) {
                cy = 20;
            }
            if ((goCopy = this.copyGraphObject(go, cx, cy)) != null) {
                this.addToGraphEmbedding(goCopy);
                selCopy.addElement(goCopy);
            }
            ++i;
        }
        i = 0;
        while (i < this.selectedNodes.size()) {
            this.selectedNodes.elementAt(i).setSelected(false);
            this.selectedNodes.elementAt(i).setCopy(null);
            ++i;
        }
        this.selectedNodes.removeAllElements();
        if (this.selectedArcs != null) {
            i = 0;
            while (i < this.selectedArcs.size()) {
                this.selectedArcs.elementAt(i).setSelected(false);
                this.selectedArcs.elementAt(i).setCopy(null);
                ++i;
            }
            this.selectedArcs.removeAllElements();
        }
        return selCopy;
    }

    private EdGraphObject copyGraphObject(EdGraphObject srcObj, int x, int y) {
        EdGraphObject goCopy = null;
        EdGraphObject src = null;
        EdGraphObject tar = null;
        if (srcObj.isNode() && srcObj.getCopy() == null) {
            goCopy = this.copyNode(srcObj.getNode(), x, y);
            srcObj.setCopy(goCopy);
        } else if (srcObj.isArc() && srcObj.getCopy() == null) {
            src = srcObj.getArc().getSource().getCopy() == null ? this.copyNode((EdNode)srcObj.getArc().getSource(), x, y) : srcObj.getArc().getSource().getCopy();
            tar = srcObj.getArc().getTarget().getCopy() == null ? this.copyNode((EdNode)srcObj.getArc().getTarget(), x, y) : srcObj.getArc().getTarget().getCopy();
            if (src != null && tar != null) {
                int dx = tar.getX() - srcObj.getArc().getTarget().getX();
                int dy = tar.getY() - srcObj.getArc().getTarget().getY();
                goCopy = this.copyArc(srcObj.getArc(), src, tar, dx, dy);
                srcObj.setCopy(goCopy);
            }
        }
        return goCopy;
    }

    public EdNode copyNode(EdNode en, int x, int y) {
        EdNode cn = null;
        EdType t = this.typeSet.getNodeType(en.getType().getBasisType(), en.getType().getName(), en.getType().getShape(), en.getType().getColor(), en.getType().hasFilledShape());
        if (t != null) {
            this.typeSet.setSelectedNodeType(t);
            try {
                cn = this.addNode(x, y, t, true);
                cn.getBasisNode().copyAttributes(en.getBasisNode());
                cn.getLNode().setFrozenByDefault(true);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return cn;
    }

    public EdArc copyArc(EdArc ea, EdGraphObject src, EdGraphObject tar) {
        EdArc ca = null;
        EdType t = this.typeSet.getArcType(ea.getType().getBasisType(), ea.getType().getName(), ea.getType().getShape(), ea.getType().getColor(), ea.getType().hasFilledShape());
        if (t != null) {
            this.typeSet.setSelectedArcType(t);
            try {
                boolean directed = !(this.bGraph instanceof UndirectedGraph);
                ca = this.addArc(t, src, tar, null, directed);
                if (ca != null) {
                    ca.getBasisArc().copyAttributes(ea.getBasisArc());
                    if (ea.isLine()) {
                        if (ea.hasAnchor()) {
                            ca.setAnchor(new Point(ea.getX(), ea.getY()));
                        }
                    } else if (ea.hasAnchor()) {
                        ca.setAnchor(1, new Point(ea.getX(), ea.getY()));
                        ca.setWidth(ea.getWidthOfLoop());
                        ca.setHeight(ea.getHeightOfLoop());
                    }
                    ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
                    ca.setReps(ea.isDirected(), true, false);
                    ca.getLArc().setFrozenByDefault(true);
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return ca;
    }

    private EdArc copyArc(EdArc ea, EdGraphObject src, EdGraphObject tar, int dx, int dy) {
        EdArc ca = null;
        if (this.bGraph != null) {
            Arc ba = null;
            try {
                ba = this.bGraph.copyArc(ea.getBasisArc(), (Node)src.getBasisObject(), (Node)tar.getBasisObject());
                ca = new EdArc(ba, ea.getType(), src, tar);
                this.addElement(ca, false);
                ca.setMorphismMark(this.nodes.size() + this.arcs.size());
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        if (ca != null) {
            if (ea.isLine()) {
                if (ea.hasAnchor()) {
                    ca.setAnchor(new Point(ea.getX() + dx, ea.getY() + dy));
                }
            } else if (ea.hasAnchor()) {
                ca.setAnchor(1, new Point(ea.getX() + dx, ea.getY() + dy));
                ca.setWidth(ea.getWidth());
                ca.setHeight(ea.getHeight());
            }
            ca.setTextOffset(ea.getTextOffset().x, ea.getTextOffset().y);
            ca.setReps(ea.isDirected(), true, false);
            ca.getLArc().setFrozenByDefault(true);
        }
        return ca;
    }

    private Point findCenter(Vector<EdNode> v) {
        if (v == null) {
            return new Point(0, 0);
        }
        if (v.size() == 0) {
            return new Point(0, 0);
        }
        Vector<Point> points = new Vector<Point>();
        int i = 0;
        while (i < v.size()) {
            EdGraphObject o = v.elementAt(i);
            if (o != null) {
                points.addElement(new Point(o.getX(), o.getY()));
            }
            ++i;
        }
        CenterOfPoints centerOfPoints = new CenterOfPoints(points);
        return centerOfPoints.getCenter();
    }

    public void setMorphismMarks(HashMap<?, ?> marks, boolean all) {
        String m;
        GraphObject go;
        if (all) {
            this.clearMarks();
        }
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode n = this.nodes.elementAt(i);
            go = n.getBasisNode();
            m = (String)marks.get(go);
            if (m != null && m.length() > 0 && (all || !all && n.getMorphismMark().equals(""))) {
                n.addMorphismMark(m);
                marks.remove(go);
            }
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            EdArc a = this.arcs.elementAt(i);
            go = a.getBasisArc();
            m = (String)marks.get(go);
            if (m != null && m.length() > 0 && (all || !all && a.getMorphismMark().equals(""))) {
                a.addMorphismMark(m);
                marks.remove(go);
            }
            ++i;
        }
    }

    public void setCurrentLayoutToDefault(boolean b) {
        this.hasDefaultLayout = b;
        this.freezeLayout(b);
    }

    private void handleChangeEvent(int changeEvent, GraphObject obj1, GraphObject obj2) {
        if (changeEvent == 10) {
            if (this.newAfterTransformStep == null) {
                this.newAfterTransformStep = new Vector();
            }
            if (obj1.isNode()) {
                EdNode newObj = this.newNode((Node)obj1);
                this.addCreatedToUndo(newObj);
                this.undoManagerEndEdit();
                this.newAfterTransformStep.add(newObj);
                this.isGraphTransformed = true;
                this.nodeNumberChanged = true;
            } else {
                EdArc newObj = this.newArc((Arc)obj1);
                this.addCreatedToUndo(newObj);
                this.undoManagerEndEdit();
                this.newAfterTransformStep.add(newObj);
                this.isGraphTransformed = true;
            }
        } else if (changeEvent == 120) {
            EdGraphObject go = this.findGraphObject(obj1);
            if (go != null) {
                this.addDeletedToUndo(go);
                this.typeSet.removeTypeUser(go.getType(), go);
            }
        } else if (changeEvent == 12) {
            EdGraphObject go = this.findGraphObject(obj1);
            if (go != null) {
                if (go.isNode()) {
                    this.nodeNumberChanged = true;
                    this.nodeRemoved = true;
                }
                go.removeFromAttributeViewObserver();
                this.removeElement(go);
                this.undoManagerEndEdit();
                this.isGraphTransformed = true;
            }
        } else if (changeEvent == 26) {
            EdGraphObject go = this.findGraphObject(obj1);
            if (go != null) {
                this.addUnsetTargetOfArcToUndo(go);
                go.removeFromAttributeViewObserver();
                this.removeArcElement((EdArc)go);
                this.undoManagerEndEdit();
                this.isGraphTransformed = true;
            }
        } else if (changeEvent == 25) {
            EdGraphObject go = this.findGraphObject(obj1);
            if (go == null) {
                EdArc newObj = this.newArc((Arc)obj1);
                this.addSetTargetOfArcToUndo(newObj);
                this.undoManagerEndEdit();
            }
        } else if (changeEvent == 24) {
            EdGraphObject go = this.findGraphObject(obj1);
            if (go != null) {
                this.addUnsetSourceOfArcToUndo(go);
                go.removeFromAttributeViewObserver();
                this.removeArcElement((EdArc)go);
                this.undoManagerEndEdit();
                this.isGraphTransformed = true;
            }
        } else if (changeEvent == 23) {
            EdGraphObject go = this.findGraphObject(obj1);
            if (go == null) {
                EdArc newObj = this.newArc((Arc)obj1);
                this.addSetSourceOfArcToUndo(newObj);
                this.undoManagerEndEdit();
            }
        } else if (changeEvent == 110) {
            EdGraphObject go = this.findGraphObject(obj1);
            this.addChangedAttributeToUndo(go);
        } else if (changeEvent == 11) {
            this.undoManagerEndEdit();
        }
    }

    protected boolean resetSourceTargetOfEdge(EdArc go, Arc arc) {
        EdNode tar;
        EdNode src;
        boolean result = false;
        if (go.getSource().getBasisObject() != arc.getSource() && (src = this.findNode(arc.getSource())) != null) {
            go.setSource(src);
            result = true;
        }
        if (go.getTarget().getBasisObject() != arc.getTarget() && (tar = this.findNode(arc.getTarget())) != null) {
            go.setTarget(tar);
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.isTransformChange && this.bGraph != null && arg != null) {
                GraphObject go = null;
                Change ch = (Change)arg;
                if (ch.getEvent() == 10 || ch.getEvent() == 120 || ch.getEvent() == 12 || ch.getEvent() == 110 || ch.getEvent() == 24 || ch.getEvent() == 26 || ch.getEvent() == 23 || ch.getEvent() == 25) {
                    if (ch.getItem() instanceof Node) {
                        go = (GraphObject)ch.getItem();
                        this.handleChangeEvent(ch.getEvent(), go, null);
                    } else if (ch.getItem() instanceof Arc) {
                        go = (GraphObject)ch.getItem();
                        this.handleChangeEvent(ch.getEvent(), go, null);
                    } else if (ch.getItem() instanceof Pair) {
                        Pair p = (Pair)ch.getItem();
                        Object obj1 = p.first;
                        Object obj2 = p.second;
                        if (obj1 instanceof GraphObject && obj2 instanceof GraphObject) {
                            go = (GraphObject)obj1;
                            this.handleChangeEvent(ch.getEvent(), (GraphObject)obj1, (GraphObject)obj2);
                        }
                    }
                } else if (ch.getEvent() == 11 && ch.getItem() instanceof Pair) {
                    Pair p = (Pair)ch.getItem();
                    Object obj = p.first;
                    if (obj instanceof Node && this.bGraph.isElement((Node)obj)) {
                        go = (GraphObject)obj;
                    } else if (obj instanceof Arc && this.bGraph.isElement((Arc)obj)) {
                        go = (GraphObject)obj;
                    }
                    if (go != null) {
                        this.handleChangeEvent(ch.getEvent(), (GraphObject)obj, null);
                    }
                }
                if (go != null) {
                    if (this.changedObjects == null) {
                        this.changedObjects = new Vector();
                    }
                    this.changed = true;
                    if (!this.changedObjects.contains(go)) {
                        this.changedObjects.addElement(go);
                    }
                    if (this.eGra != null) {
                        this.eGra.setChanged(true);
                    }
                }
            }
        }
    }

    public Vector<EdGraphObject> getChangedGraphObjects() {
        if (this.changed && this.changedObjects != null) {
            Vector<EdGraphObject> v = new Vector<EdGraphObject>();
            int i = 0;
            while (i < this.changedObjects.size()) {
                EdGraphObject go = this.findGraphObject(this.changedObjects.elementAt(i));
                if (go != null) {
                    v.addElement(go);
                }
                ++i;
            }
            this.changed = false;
            this.changedObjects.removeAllElements();
            return v;
        }
        return null;
    }

    public boolean hasDefaultLayout() {
        return this.hasDefaultLayout;
    }

    public void enableDefaultGraphLayout(boolean b) {
        this.externalLayouting = !b;
    }

    public void update() {
        this.updateGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraph(boolean attrsVisible) {
        if (this.bGraph == null) {
            return;
        }
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (!this.hasDefaultLayout) {
                this.doDefaultEvolutionaryGraphLayout(20);
            } else {
                this.doUpdateGraph(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraph(boolean attrsVisible, boolean selectNewObjects) {
        if (this.bGraph == null) {
            return;
        }
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (!this.hasDefaultLayout) {
                this.doDefaultEvolutionaryGraphLayout(20);
                if (selectNewObjects && this.newAfterTransformStep != null) {
                    int i = 0;
                    while (i < this.newAfterTransformStep.size()) {
                        this.select(this.newAfterTransformStep.get(i));
                        ++i;
                    }
                }
            } else {
                this.doUpdateGraph(selectNewObjects);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraph() {
        if (this.bGraph == null) {
            return;
        }
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (!this.hasDefaultLayout) {
                this.doDefaultEvolutionaryGraphLayout(20);
            } else {
                this.doUpdateGraph(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateGraph(boolean selectNewObjects) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.isTransformChange && this.isGraphTransformed) {
                if (!this.externalLayouting) {
                    this.doDefaultEvolutionaryGraphLayout(20);
                }
                if (selectNewObjects && this.newAfterTransformStep != null) {
                    int i = 0;
                    while (i < this.newAfterTransformStep.size()) {
                        this.select(this.newAfterTransformStep.get(i));
                        ++i;
                    }
                }
                this.isGraphTransformed = false;
            } else if (!this.isTransformChange && !this.hasDefaultLayout) {
                this.doDefaultEvolutionaryGraphLayout(20);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshInheritanceArcs() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.isTG && this.inheritanceArcs != null) {
                int i = 0;
                while (i < this.inheritanceArcs.size()) {
                    this.arcs.remove(this.inheritanceArcs.get(i));
                    ++i;
                }
                Vector<EdArc> oldInhArcs = new Vector<EdArc>(this.inheritanceArcs);
                this.inheritanceArcs.clear();
                Enumeration<Arc> bInhArcs = this.typeSet.getBasisTypeSet().getInheritanceArcs().elements();
                while (bInhArcs.hasMoreElements()) {
                    Arc bArc = bInhArcs.nextElement();
                    boolean found = false;
                    int k = 0;
                    while (k < oldInhArcs.size()) {
                        EdArc currentArc = oldInhArcs.get(k);
                        if (currentArc.getBasisArc() == bArc) {
                            if (!this.inheritanceArcs.contains(currentArc)) {
                                this.inheritanceArcs.add(currentArc);
                                this.arcs.add(currentArc);
                            }
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (found) continue;
                    this.newInheritanceArc(bArc, this.arcs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeInheritanceArcs() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.isTG) {
                Enumeration<Arc> bInhArcs = this.typeSet.getBasisTypeSet().getInheritanceArcs().elements();
                while (bInhArcs.hasMoreElements()) {
                    Arc bArc = bInhArcs.nextElement();
                    if (this.findArc(bArc) != null) continue;
                    this.newInheritanceArc(bArc, this.arcs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeWithBasis(boolean selectnew) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            EdArc arc;
            EdNode node;
            Vector<EdNode> list = new Vector<EdNode>(this.nodes.size());
            list.addAll(this.nodes);
            for (Node bn : this.bGraph.getNodesSet()) {
                node = this.findNode(bn);
                if (node != null) {
                    if (bn.getContext() == null) {
                        this.removeElement(node);
                    }
                    list.remove(node);
                    continue;
                }
                EdNode n = this.newNode(bn);
                if (!selectnew) continue;
                this.select(n);
            }
            int i = 0;
            while (i < list.size()) {
                node = (EdNode)list.get(i);
                if (node.getBasisNode().getContext() == null) {
                    this.removeElement(node);
                }
                ++i;
            }
            list.clear();
            Vector<EdArc> list1 = new Vector<EdArc>(this.arcs.size());
            list1.addAll(this.arcs);
            for (Arc ba : this.bGraph.getArcsSet()) {
                arc = this.findArc(ba);
                if (arc != null) {
                    if (ba.getContext() == null) {
                        this.removeElement(arc);
                    }
                    list1.remove(arc);
                    continue;
                }
                EdArc a = this.newArc(ba);
                if (!selectnew) continue;
                this.select(a);
            }
            int i2 = 0;
            while (i2 < list1.size()) {
                arc = (EdArc)list1.get(i2);
                if (arc.getBasisArc().getContext() == null) {
                    this.removeElement(arc);
                }
                ++i2;
            }
            list1.clear();
            if (this.isTG) {
                this.makeInheritanceArcs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGraph(OrdinaryMorphism m1, OrdinaryMorphism m2) {
        if (m1 == null || m2 == null) {
            return;
        }
        EdGraph edGraph = this;
        synchronized (edGraph) {
            GraphObject bImage;
            GraphObject bOrig;
            EdGraph eImageGraph = this;
            eImageGraph.clearMarks();
            EdNode enI = null;
            EdArc eaI = null;
            EdGraph eOrigGraph = new EdGraph(m1.getOriginal());
            EdNode enO = null;
            EdArc eaO = null;
            eOrigGraph.clearMarks();
            Enumeration<GraphObject> domain = m1.getDomain();
            while (domain.hasMoreElements()) {
                bOrig = domain.nextElement();
                bImage = m1.getImage(bOrig);
                enI = eImageGraph.findNode(bImage);
                if (enI != null) {
                    if (enI.isMorphismMarkEmpty()) {
                        enI.addMorphismMark(enI.getMyKey());
                    }
                    if ((enO = eOrigGraph.findNode(bOrig)) == null) continue;
                    enO.addMorphismMark(enI.getMorphismMark());
                    continue;
                }
                eaI = eImageGraph.findArc(bImage);
                if (eaI == null) continue;
                if (eaI.isMorphismMarkEmpty()) {
                    eaI.addMorphismMark(eaI.getMyKey());
                }
                if ((eaO = eOrigGraph.findArc(bOrig)) == null) continue;
                eaO.addMorphismMark(eaI.getMorphismMark());
            }
            domain = m2.getDomain();
            while (domain.hasMoreElements()) {
                bOrig = domain.nextElement();
                bImage = m2.getImage(bOrig);
                enI = eImageGraph.findNode(bImage);
                if (enI != null) {
                    if (enI.isMorphismMarkEmpty()) {
                        enI.addMorphismMark(enI.getMyKey());
                    }
                    if ((enO = eOrigGraph.findNode(bOrig)) == null) continue;
                    enO.addMorphismMark(enI.getMorphismMark());
                    continue;
                }
                eaI = eImageGraph.findArc(bImage);
                if (eaI == null) continue;
                if (eaI.isMorphismMarkEmpty()) {
                    eaI.addMorphismMark(eaI.getMyKey());
                }
                if ((eaO = eOrigGraph.findArc(bOrig)) == null) continue;
                eaO.addMorphismMark(eaI.getMorphismMark());
            }
        }
    }

    public void setLayoutByBasisObject(EdGraph layout) {
        this.setLayoutFrom(layout, true, true);
    }

    private void setLayoutFrom(EdGraph layout, boolean ofNodes, boolean ofArcs) {
        if (this.bGraph == layout.getBasisGraph()) {
            int i;
            if (this.nodes.size() == 0) {
                this.makeGraphObjects();
            }
            if (ofNodes) {
                i = 0;
                while (i < this.nodes.size()) {
                    EdNode n = this.nodes.get(i);
                    EdNode ln = layout.findNode(n.getBasisNode());
                    if (ln != null) {
                        n.setX(ln.getX());
                        n.setY(ln.getY());
                        n.getLNode().setFrozenByDefault(true);
                    }
                    ++i;
                }
            }
            if (ofArcs) {
                i = 0;
                while (i < this.arcs.size()) {
                    EdArc a = this.arcs.get(i);
                    EdArc la = layout.findArc(a.getBasisArc());
                    if (la != null) {
                        if (la.isLine()) {
                            if (la.hasAnchor()) {
                                a.setAnchor(la.getAnchor());
                            } else {
                                a.setAnchor(null);
                            }
                        } else if (la.hasAnchor()) {
                            a.setAnchor(1, new Point(la.getAnchor()));
                            a.setWidth(la.getWidthOfLoop());
                            a.setHeight(la.getHeightOfLoop());
                        }
                        a.getLArc().setFrozenByDefault(true);
                        a.setTextOffset(la.getTextOffset().x, la.getTextOffset().y);
                    }
                    ++i;
                }
            }
            this.hasDefaultLayout = true;
        } else {
            this.doDefaultEvolutionaryGraphLayout(20);
        }
    }

    public void setLayoutByType(EdGraph layout) {
        Vector<EdGraphObject> other;
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode n = this.nodes.get(i);
            other = layout.getNodes(n.getType());
            if (!other.isEmpty()) {
                EdNode nl = other.firstElement();
                n.setX(nl.getX());
                n.setY(nl.getY());
                n.getLNode().setFrozenByDefault(true);
            }
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            EdArc a = this.arcs.get(i);
            other = layout.getArcs(a.getType());
            int j = 0;
            while (j < other.size()) {
                EdArc al = (EdArc)other.get(j);
                if (a.getSource().getType().compareTo(al.getSource().getType()) && a.getTarget().getType().compareTo(al.getTarget().getType())) {
                    if (al.isLine()) {
                        if (al.hasAnchor()) {
                            a.setAnchor(new Point(al.getAnchor().x, al.getAnchor().y));
                        } else {
                            a.setAnchor(null);
                        }
                    } else if (al.hasAnchor()) {
                        a.setAnchor(1, new Point(al.getAnchor()));
                        a.setWidth(al.getWidthOfLoop());
                        a.setHeight(al.getHeightOfLoop());
                    }
                    a.getLArc().setFrozenByDefault(true);
                    a.setTextOffset(al.getTextOffset().x, al.getTextOffset().y);
                }
                ++j;
            }
            ++i;
        }
        this.hasDefaultLayout = true;
    }

    protected EdNode findNodeByBasisContextUsage(String basisHashCode) {
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode n = this.nodes.get(i);
            if (n.getBasisNode().getContextUsage() == Integer.valueOf(basisHashCode).intValue()) {
                return n;
            }
            ++i;
        }
        return null;
    }

    protected EdArc findArcByBasisContextUsage(String basisHashCode) {
        int i = 0;
        while (i < this.arcs.size()) {
            EdArc a = this.arcs.get(i);
            if (a.getBasisArc().getContextUsage() == Integer.valueOf(basisHashCode).intValue()) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public void setLayoutByContextUsage(EdGraph layout, boolean ofNodesOnly) {
        int i = 0;
        while (i < layout.getNodes().size()) {
            EdNode ln = layout.getNodes().get(i);
            EdNode n = this.findNodeByBasisContextUsage(String.valueOf(ln.getBasisNode().hashCode()));
            if (n != null) {
                n.setX(ln.getX());
                n.setY(ln.getY());
                n.getLNode().setFrozenByDefault(true);
            }
            ++i;
        }
        this.hasDefaultLayout = true;
        if (ofNodesOnly) {
            return;
        }
        i = 0;
        while (i < layout.getArcs().size()) {
            EdArc la = layout.getArcs().get(i);
            EdArc a = this.findArcByBasisContextUsage(String.valueOf(la.getBasisArc().hashCode()));
            if (la.isLine()) {
                if (la.hasAnchor()) {
                    a.setAnchor(new Point(la.getAnchor().x, la.getAnchor().y));
                } else {
                    a.setAnchor(null);
                }
            } else {
                a.setAnchor(1, new Point(la.getAnchor()));
                a.setWidth(la.getWidthOfLoop());
                a.setHeight(la.getHeightOfLoop());
            }
            a.getLArc().setFrozenByDefault(true);
            a.setTextOffset(la.getTextOffset().x, la.getTextOffset().y);
            ++i;
        }
    }

    public void setLayoutByIndex(EdGraph layout, boolean ofNodesOnly) {
        if (this.nodes.size() == 0) {
            this.makeGraphObjects();
        }
        int i = 0;
        while (i < this.nodes.size()) {
            if (i < layout.getNodes().size()) {
                EdNode n = this.nodes.get(i);
                n.setX(layout.getNodes().get(i).getX());
                n.setY(layout.getNodes().get(i).getY());
                n.getLNode().setFrozenByDefault(true);
            }
            ++i;
        }
        this.hasDefaultLayout = true;
        if (ofNodesOnly) {
            return;
        }
        i = 0;
        while (i < this.arcs.size()) {
            if (i < layout.getArcs().size()) {
                EdArc a = this.arcs.get(i);
                EdArc other = layout.getArcs().get(i);
                if (other.isLine()) {
                    if (other.hasAnchor()) {
                        a.setAnchor(new Point(other.getAnchor().x, other.getAnchor().y));
                    } else {
                        a.setAnchor(null);
                    }
                } else if (other.hasAnchor()) {
                    a.setAnchor(1, new Point(other.getAnchor()));
                    a.setWidth(other.getWidthOfLoop());
                    a.setHeight(other.getHeightOfLoop());
                }
                a.getLArc().setFrozenByDefault(true);
                a.setTextOffset(other.getTextOffset().x, other.getTextOffset().y);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLayoutByIsoMorphism(OrdinaryMorphism isoCopyOfBaseGraph, EdGraph layout) {
        if (layout.getBasisGraph() != isoCopyOfBaseGraph.getSource() || this.bGraph != isoCopyOfBaseGraph.getTarget()) {
            return false;
        }
        EdGraph edGraph = this;
        synchronized (edGraph) {
            GraphObject img;
            GraphObject orig;
            int i = 0;
            while (i < layout.getNodes().size()) {
                EdNode ln = layout.getNodes().elementAt(i);
                orig = ln.getBasisNode();
                img = isoCopyOfBaseGraph.getImage(orig);
                EdNode en = this.findNode(img);
                if (en != null) {
                    en.setX(ln.getX());
                    en.setY(ln.getY());
                }
                ++i;
            }
            i = 0;
            while (i < layout.getArcs().size()) {
                EdArc la = layout.getArcs().elementAt(i);
                orig = la.getBasisArc();
                img = isoCopyOfBaseGraph.getImage(orig);
                EdArc ea = this.findArc(img);
                if (ea != null) {
                    if (la.isLine()) {
                        if (la.hasAnchor()) {
                            ea.setAnchor(new Point(la.getX(), la.getY()));
                        }
                    } else if (la.hasAnchor()) {
                        ea.setAnchor(1, new Point(la.getX(), la.getY()));
                        ea.setWidth(la.getWidth());
                        ea.setHeight(la.getHeight());
                    }
                    ea.setTextOffset(la.getTextOffset().x, la.getTextOffset().y);
                    ea.getLArc().setFrozenByDefault(true);
                }
                ++i;
            }
            this.setCurrentLayoutToDefault(true);
            return true;
        }
    }

    public void filterLayout() {
        int i = this.arcs.size() - 1;
        while (i >= 0) {
            EdArc ea = this.arcs.elementAt(i);
            Arc a = this.findBasisArc(ea);
            if (a == null || !a.isInheritance() && !this.bGraph.isElement(a)) {
                this.arcs.remove(ea);
                ea.dispose();
            }
            --i;
        }
        i = this.nodes.size() - 1;
        while (i >= 0) {
            EdNode en = this.nodes.elementAt(i);
            Node n = this.findBasisNode(en);
            if (n == null || !this.bGraph.isElement(n)) {
                this.nodes.remove(en);
                this.basisNode2node.remove(en.getBasisObject());
                en.dispose();
            }
            --i;
        }
    }

    public void setXYofNewNode(EdRule rule, OrdinaryMorphism validmatch, OrdinaryMorphism comatch) {
        if (rule == null || validmatch == null || comatch == null || !this.nodeNumberChanged) {
            return;
        }
        List<GraphObject> newobjs = rule.getBasisRule().getElementsToCreate();
        if (newobjs.size() > 0) {
            Node ruleimg = null;
            Node graphimg = null;
            EdNode enruleimg = null;
            EdNode engraphimg = null;
            int i = 0;
            while (i < newobjs.size()) {
                if (newobjs.get(i).isNode()) {
                    GraphObject go;
                    Node nodetocreate = (Node)newobjs.get(i);
                    if (ruleimg == null && !nodetocreate.getIncomingArcsSet().isEmpty()) {
                        for (Arc arc : nodetocreate.getIncomingArcsSet()) {
                            if (!rule.getBasisRule().getInverseImage(arc.getSource()).hasMoreElements()) continue;
                            ruleimg = (Node)arc.getSource();
                            go = rule.getBasisRule().getInverseImage(arc.getSource()).nextElement();
                            graphimg = (Node)validmatch.getImage(go);
                            break;
                        }
                    }
                    if (ruleimg == null && !nodetocreate.getOutgoingArcsSet().isEmpty()) {
                        for (Arc arc : nodetocreate.getOutgoingArcsSet()) {
                            if (!rule.getBasisRule().getInverseImage(arc.getTarget()).hasMoreElements()) continue;
                            ruleimg = (Node)arc.getTarget();
                            go = rule.getBasisRule().getInverseImage(arc.getTarget()).nextElement();
                            graphimg = (Node)validmatch.getImage(go);
                            break;
                        }
                    }
                    if (ruleimg != null) break;
                    Enumeration<GraphObject> ruledom = rule.getBasisRule().getDomain();
                    while (ruledom.hasMoreElements()) {
                        GraphObject go2 = ruledom.nextElement();
                        if (!go2.isNode() || this.getTypeSet().getType((Type)go2.getType()).animated) continue;
                        ruleimg = (Node)rule.getBasisRule().getImage(go2);
                        graphimg = (Node)validmatch.getImage(go2);
                        break;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < newobjs.size()) {
                if (newobjs.get(i).isNode()) {
                    Node nodeTocreate = (Node)newobjs.get(i);
                    EdNode enodeTocreate = rule.getRight().findNode(nodeTocreate);
                    Node createdNode = (Node)comatch.getImage(nodeTocreate);
                    EdNode createdEnode = this.findNode(createdNode);
                    int posX = 0;
                    int posY = 0;
                    if (createdEnode != null && enodeTocreate != null) {
                        if (ruleimg != null) {
                            enruleimg = rule.getRight().findNode(ruleimg);
                            if (enruleimg != null) {
                                posX = enruleimg.getX() - enodeTocreate.getX();
                                posY = enruleimg.getY() - enodeTocreate.getY();
                            }
                            if ((engraphimg = this.findNode(graphimg)) != null) {
                                posX = engraphimg.getX() - posX >= 0 ? engraphimg.getX() - posX : Math.abs(engraphimg.getX() - posX);
                                posY = engraphimg.getY() - posY >= 0 ? engraphimg.getY() - posY : Math.abs(engraphimg.getY() - posY);
                            }
                        } else {
                            posX = enodeTocreate.getX();
                            posY = enodeTocreate.getY();
                        }
                        createdEnode.setX(posX);
                        createdEnode.setY(posY);
                        createdEnode.getLNode().setFrozenByDefault(this.staticNodeXY);
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlongMorph(Morphism coMorph, Rule r) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (coMorph != null) {
                this.deselectAll();
                Enumeration<GraphObject> e = coMorph.getDomain();
                while (e.hasMoreElements()) {
                    GraphObject o = e.nextElement();
                    GraphObject img = coMorph.getImage(o);
                    if (r != null) {
                        EdGraphObject go;
                        Enumeration<GraphObject> inverse = r.getInverseImage(o);
                        if (inverse.hasMoreElements() || (go = this.findGraphObject(img)) == null) continue;
                        this.select(go);
                        continue;
                    }
                    EdGraphObject go = this.findGraphObject(img);
                    if (go == null) continue;
                    this.select(go);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlongMorph(Morphism m) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            this.deselectAll();
            if (m != null) {
                Enumeration<GraphObject> e = m.getDomain();
                while (e.hasMoreElements()) {
                    GraphObject o = e.nextElement();
                    GraphObject img = m.getImage(o);
                    EdGraphObject go = this.findGraphObject(img);
                    if (go == null) continue;
                    this.select(go);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.selectedNodes == null) {
                this.selectedNodes = new Vector();
            } else {
                this.selectedNodes.removeAllElements();
            }
            if (this.selectedArcs == null) {
                this.selectedArcs = new Vector();
            } else {
                this.selectedArcs.removeAllElements();
            }
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode en = this.nodes.elementAt(i);
                if (en.isSelected()) {
                    this.selectedNodes.addElement(en);
                }
                ++i;
            }
            i = 0;
            while (i < this.arcs.size()) {
                EdArc ea = this.arcs.elementAt(i);
                if (ea.isSelected()) {
                    this.selectedArcs.addElement(ea);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMarks() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode en = this.nodes.elementAt(i);
                en.clearMorphismMark();
                en.setMorphismMark(i + 1);
                ++i;
            }
            i = 0;
            while (i < this.arcs.size()) {
                EdArc ea = this.arcs.elementAt(i);
                ea.clearMorphismMark();
                ea.setMorphismMark(this.nodes.size() + i + 1);
                ++i;
            }
        }
    }

    public String getMsg() {
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        return this.errMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getGraphDimension() {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            EdGraphObject elem;
            int maxX = 0;
            int maxY = 0;
            int offsetX = 0;
            int offsetY = 0;
            int i = 0;
            while (i < this.nodes.size()) {
                elem = this.nodes.elementAt(i);
                offsetX = elem.getWidth() / 2 + 10;
                offsetY = elem.getHeight() / 2 + 10;
                if (elem.getX() + offsetX > maxX) {
                    maxX = elem.getX() + offsetX;
                }
                if (elem.getY() + offsetY > maxY) {
                    maxY = elem.getY() + offsetY;
                }
                ++i;
            }
            i = 0;
            while (i < this.arcs.size()) {
                elem = this.arcs.elementAt(i);
                offsetX = elem.getWidth() / 2 + 10;
                offsetY = elem.getHeight() / 2 + 10;
                if (elem.getX() + offsetX > maxX) {
                    maxX = elem.getX() + offsetX;
                }
                if (elem.getY() + offsetY > maxY) {
                    maxY = elem.getY() + offsetY;
                }
                ++i;
            }
            return new Dimension(maxX, maxY);
        }
    }

    public Dimension getGraphDimension(double scale) {
        Dimension dim = this.getGraphDimension();
        return new Dimension((int)(scale * (double)dim.width), (int)(scale * (double)dim.height));
    }

    public double getScale() {
        return this.itsScale;
    }

    public void applyScale(double scale) {
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).applyScale(scale);
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            this.arcs.get(i).applyScale(scale);
            ++i;
        }
        this.itsScale = scale;
    }

    public void makeInitialUpdateOfNodes() {
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode n = this.nodes.elementAt(i);
            if (this.isCPA) {
                n.updateNameAttrOnly(null);
            } else {
                n.myUpdate(null);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGraphics(Graphics g, boolean all, boolean attribueVisible) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int i = 0;
            while (i < this.arcs.size()) {
                EdArc a = this.arcs.elementAt(i);
                a.setAttributeVisible(attribueVisible);
                if (this.isCPA) {
                    a.drawNameAttrOnly(g);
                } else if (all || a.isSelected()) {
                    a.drawGraphic(g);
                }
                ++i;
            }
            i = 0;
            while (i < this.nodes.size()) {
                EdNode n = this.nodes.elementAt(i);
                n.setAttributeVisible(attribueVisible);
                if (this.isCPA) {
                    n.drawNameAttrOnly(g);
                } else if (all || n.isSelected()) {
                    n.drawGraphic(g);
                }
                ++i;
            }
        }
    }

    public List<EdNode> getVisibleNodes() {
        if (this.isTG || this.visibleNodes == null || this.visibleNodes.isEmpty()) {
            return this.nodes;
        }
        return this.visibleNodes;
    }

    public List<EdArc> getVisibleArcs() {
        if (this.isTG || this.visibleArcs == null || this.visibleArcs.isEmpty()) {
            return this.arcs;
        }
        return this.visibleArcs;
    }

    public void updateVisibility() {
        this.doUpdateVisibility(false);
    }

    private void doUpdateVisibility(boolean forceCheck) {
        if (this.isTG) {
            this.visibilityChecked = true;
        } else {
            if (!this.visibilityChecked || forceCheck) {
                if (this.visibleNodes == null) {
                    this.visibleNodes = new Vector();
                } else {
                    this.visibleNodes.clear();
                }
                if (this.visibleArcs == null) {
                    this.visibleArcs = new Vector();
                } else {
                    this.visibleArcs.clear();
                }
                int i = 0;
                while (i < this.nodes.size()) {
                    EdNode n = this.nodes.elementAt(i);
                    if (n.isVisible()) {
                        this.visibleNodes.add(n);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.arcs.size()) {
                    EdArc a = this.arcs.elementAt(i);
                    if (a.isVisible()) {
                        this.visibleArcs.add(a);
                    }
                    ++i;
                }
            }
            this.visibilityChecked = true;
        }
    }

    public void forceVisibilityUpdate() {
        this.doUpdateVisibility(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawGraphics(Graphics graphics, List<EdNode> nodeList, List<EdArc> arcList, boolean all, boolean attributeVisible) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.firstDraw) {
                this.firstDraw = false;
                Graphics testGraphics = graphics.create();
                int i = 0;
                while (i < nodeList.size()) {
                    EdNode n = nodeList.get(i);
                    n.setAttributeVisible(attributeVisible);
                    if (this.isCPA) {
                        n.drawNameAttrOnly(testGraphics);
                    } else if (all || n.isSelected()) {
                        n.drawGraphic(testGraphics);
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < arcList.size()) {
                EdArc a = arcList.get(i);
                a.setAttributeVisible(attributeVisible);
                if (this.isCPA) {
                    a.drawNameAttrOnly(graphics);
                } else if (all || a.isSelected()) {
                    a.drawGraphic(graphics);
                }
                ++i;
            }
            i = 0;
            while (i < nodeList.size()) {
                EdNode n = nodeList.get(i);
                n.setAttributeVisible(attributeVisible);
                if (this.isCPA) {
                    n.drawNameAttrOnly(graphics);
                } else if (all || n.isSelected()) {
                    n.drawGraphic(graphics);
                }
                ++i;
            }
        }
    }

    public void drawNode(Graphics g, EdNode n) {
        n.drawGraphic(g);
    }

    public void drawArc(Graphics g, EdArc a) {
        a.drawGraphic(g);
        ((EdNode)a.getSource()).drawGraphic(g);
        ((EdNode)a.getTarget()).drawGraphic(g);
    }

    public void drawObj(Graphics g, EdGraphObject o) {
        if (o.isNode()) {
            ((EdNode)o).drawGraphic(g);
        } else {
            ((EdArc)o).drawGraphic(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawNodes(Graphics g, Vector<EdNode> v) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (v != null) {
                int j = 0;
                while (j < v.size()) {
                    EdNode n = v.elementAt(j);
                    this.drawNode(g, n);
                    ++j;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArcs(Graphics g, Vector<EdArc> v) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int j = 0;
            while (j < v.size()) {
                EdArc a = v.elementAt(j);
                this.drawArc(g, a);
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSelected(Graphics g) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            if (this.selectedArcs != null) {
                int j = 0;
                while (j < this.selectedArcs.size()) {
                    EdArc a = this.selectedArcs.elementAt(j);
                    a.drawGraphic(g);
                    EdNode src = (EdNode)a.getSource();
                    EdNode trg = (EdNode)a.getTarget();
                    if (this.selectedNodes == null || !this.selectedNodes.contains(src)) {
                        src.drawGraphic(g);
                    }
                    if (this.selectedNodes == null || !this.selectedNodes.contains(trg)) {
                        trg.drawGraphic(g);
                    }
                    ++j;
                }
            }
            this.drawNodes(g, this.selectedNodes);
        }
    }

    public void eraseNode(Graphics g, EdNode n) {
        this.eraseArcs(g, this.getIncomingArcs(n));
        this.eraseArcs(g, this.getOutgoingArcs(n));
        n.eraseGraphic(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseNodes(Graphics g, Vector<EdNode> v) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int j = 0;
            while (j < v.size()) {
                EdNode n = v.elementAt(j);
                this.eraseNode(g, n);
                ++j;
            }
        }
    }

    public void eraseArc(Graphics g, EdArc a) {
        a.eraseGraphic(g);
        ((EdNode)a.getSource()).drawGraphic(g);
        ((EdNode)a.getTarget()).drawGraphic(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseArcs(Graphics g, Vector<EdArc> v) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int j = 0;
            while (j < v.size()) {
                EdArc a = v.elementAt(j);
                this.eraseArc(g, a);
                ++j;
            }
        }
    }

    public void eraseObj(Graphics g, EdGraphObject o) {
        if (o.isNode()) {
            this.eraseNode(g, (EdNode)o);
        } else {
            this.eraseArc(g, (EdArc)o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseSelected(Graphics g, boolean redraw) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            int j;
            if (this.selectedArcs != null) {
                j = 0;
                while (j < this.selectedArcs.size()) {
                    EdArc a = this.selectedArcs.elementAt(j);
                    if (redraw) {
                        a.setSelected(false);
                        this.drawArc(g, a);
                    } else {
                        a.eraseGraphic(g);
                    }
                    EdNode src = (EdNode)a.getSource();
                    EdNode trg = (EdNode)a.getTarget();
                    if (this.selectedNodes == null || !this.selectedNodes.contains(src)) {
                        this.drawNode(g, src);
                    }
                    if (this.selectedNodes == null || !this.selectedNodes.contains(trg)) {
                        this.drawNode(g, trg);
                    }
                    ++j;
                }
            }
            if (this.selectedNodes != null) {
                j = 0;
                while (j < this.selectedNodes.size()) {
                    EdNode n = this.selectedNodes.elementAt(j);
                    if (redraw) {
                        n.setSelected(false);
                        this.drawNode(g, n);
                    } else {
                        n.eraseGraphic(g);
                    }
                    ++j;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<EdArc> getIncomingArcs(EdNode en) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            Vector<EdArc> in = new Vector<EdArc>();
            int i = 0;
            while (i < this.arcs.size()) {
                if (this.arcs.elementAt(i).getTarget() == en) {
                    in.addElement(this.arcs.elementAt(i));
                }
                ++i;
            }
            return in;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<EdArc> getOutgoingArcs(EdNode en) {
        EdGraph edGraph = this;
        synchronized (edGraph) {
            Vector<EdArc> out = new Vector<EdArc>();
            int i = 0;
            while (i < this.arcs.size()) {
                if (this.arcs.elementAt(i).getSource() == en) {
                    out.addElement(this.arcs.elementAt(i));
                }
                ++i;
            }
            return out;
        }
    }

    public boolean containsIncomingOutgoingArcsAt(EdNode n) {
        if (!this.getIncomingArcs(n).isEmpty()) {
            return true;
        }
        return !this.getOutgoingArcs(n).isEmpty();
    }

    public boolean isUsingVariable(VarMember v) {
        return this.bGraph.isUsingVariable(v);
    }

    public void unsetAttributeValueWhereVariable() {
        this.bGraph.unsetAttributeValueWhereVariable();
    }

    public Vector<EdNode> getParentsOf(EdNode n) {
        Vector<EdNode> v = new Vector<EdNode>();
        if (this.inheritanceArcs != null) {
            int i = 0;
            while (i < this.inheritanceArcs.size()) {
                EdArc a = this.inheritanceArcs.get(i);
                if (a.getSource() == n) {
                    v.add((EdNode)a.getTarget());
                }
                ++i;
            }
        }
        return v;
    }

    public Vector<EdNode> getChildrenOf(EdNode n) {
        Vector<EdNode> v = new Vector<EdNode>();
        if (this.inheritanceArcs != null) {
            int i = 0;
            while (i < this.inheritanceArcs.size()) {
                EdArc a = this.inheritanceArcs.get(i);
                if (a.getTarget() == n) {
                    v.add((EdNode)a.getSource());
                }
                ++i;
            }
        }
        return v;
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        if (h.openObject(this.bGraph, this)) {
            if (this.bGraph.isCompleteGraph()) {
                if (this.ggen > 0) {
                    h.addAttr("age", this.ggen);
                }
                if (this.straightenArcs) {
                    h.addAttr("straightenArcs", "true");
                }
                if (this.staticNodeXY) {
                    h.addAttr("staticNodePosition", "true");
                }
                if (this.undoManager != null && !this.undoManager.isEnabled()) {
                    h.addAttr("undoEnabled", "false");
                }
            }
            int j = 0;
            while (j < this.nodes.size()) {
                EdNode n = this.nodes.elementAt(j);
                n.getLNode().setFrozenByDefault(true);
                h.addObject("", n, true);
                ++j;
            }
            j = 0;
            while (j < this.arcs.size()) {
                EdArc a = this.arcs.elementAt(j);
                a.getLArc().setFrozenByDefault(true);
                h.addObject("", a, true);
                ++j;
            }
        }
    }

    @Override
    public void XreadObject(XMLHelper h) {
        boolean hasLoadedLayout = false;
        h.peekObject(this.bGraph, this);
        if (this.bGraph.isCompleteGraph()) {
            String undoEnabledStr;
            String staticNodePositionStr;
            String straightenArcsStr;
            String age = h.readAttr("age");
            if (age != null && !age.equals("")) {
                try {
                    this.ggen = Integer.valueOf(age);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(straightenArcsStr = h.readAttr("straightenArcs")).equals("")) {
                this.straightenArcs = Boolean.valueOf(straightenArcsStr);
            }
            if (!(staticNodePositionStr = h.readAttr("staticNodePosition")).equals("")) {
                this.staticNodeXY = Boolean.valueOf(staticNodePositionStr);
            }
            if (!(undoEnabledStr = h.readAttr("undoEnabled")).equals("")) {
                this.eGra.enableUndoManager(Boolean.valueOf(undoEnabledStr));
            }
        }
        int j = 0;
        while (j < this.nodes.size()) {
            EdNode n = this.nodes.elementAt(j);
            h.enrichObject(n);
            if (n.hasDefaultLayout) {
                hasLoadedLayout = true;
                n.getLNode().setFrozenByDefault(true);
            }
            ++j;
        }
        j = 0;
        while (j < this.arcs.size()) {
            EdArc a = this.arcs.elementAt(j);
            h.enrichObject(a);
            a.getLArc().setFrozenByDefault(true);
            ++j;
        }
        if (hasLoadedLayout) {
            this.hasDefaultLayout = true;
        } else if (this.nodes.size() > 1) {
            if (this.isTG || this.bGraph.isCompleteGraph()) {
                if (this.nodes.size() <= 100) {
                    this.layoutBasisGraph(new Dimension(800, 600));
                } else {
                    this.layoutBasisGraph(new Dimension(1000, 800));
                }
            } else if (!this.isCPA) {
                if (this.nodes.size() <= 50) {
                    this.layoutBasisGraph(new Dimension(400, 300));
                } else if (this.nodes.size() <= 100) {
                    this.layoutBasisGraph(new Dimension(600, 400));
                } else {
                    this.layoutBasisGraph(new Dimension(800, 600));
                }
            }
            if (!this.bGraph.isCompleteGraph()) {
                this.staticNodeXY = true;
            }
        }
    }

    public void layoutBasisGraph(Dimension maxdim) {
        if (this.hasDefaultLayout) {
            return;
        }
        this.nodeNumberChanged = true;
        this.setCurrentLayoutToDefault(false);
        this.getDefaultGraphLayouter().setEnabled(true);
        this.doDefaultEvolutionaryGraphLayout(this.itsLayouter, 100, 10, maxdim);
        this.nodeNumberChanged = false;
    }

    public EvolutionaryGraphLayout getDefaultGraphLayouter() {
        return this.itsLayouter;
    }

    public boolean isStaticNodePositionEnabled() {
        return this.staticNodeXY;
    }

    public void setStaticNodePosition(boolean enable) {
        if (enable && !this.staticNodeXY) {
            int i = 0;
            while (i < this.nodes.size()) {
                this.nodes.get(i).getLNode().setFrozen(true);
                ++i;
            }
        } else if (!enable && this.staticNodeXY) {
            int i = 0;
            while (i < this.nodes.size()) {
                this.nodes.get(i).getLNode().setFrozen(false);
                ++i;
            }
        }
        this.staticNodeXY = enable;
    }

    public void enableStaticNodePosition() {
        if (!this.staticNodeXY) {
            int i = 0;
            while (i < this.nodes.size()) {
                this.nodes.get(i).getLNode().setFrozen(true);
                ++i;
            }
            this.staticNodeXY = true;
        }
    }

    public void disableStaticNodePosition() {
        if (this.staticNodeXY) {
            int i = 0;
            while (i < this.nodes.size()) {
                this.nodes.get(i).getLNode().setFrozen(false);
                ++i;
            }
            this.staticNodeXY = false;
        }
    }

    public void doDefaultEvolutionaryGraphLayout(int spaceBetweenParallelEdges) {
        if (this.nodes.isEmpty()) {
            this.makeGraphObjects();
            this.nodeNumberChanged = this.nodes.size() > 0;
        }
        this.doDefaultEvolutionaryGraphLayout(this.itsLayouter, 50, spaceBetweenParallelEdges);
    }

    public void forceDefaultEvolutionaryGraphLayout(int spaceBetweenParallelEdges) {
        if (this.nodes.isEmpty()) {
            this.makeGraphObjects();
        }
        this.nodeNumberChanged = true;
        this.doDefaultEvolutionaryGraphLayout(this.itsLayouter, 50, spaceBetweenParallelEdges);
    }

    public void doDefaultEvolutionaryGraphLayout(EvolutionaryGraphLayout layouter, int iters, int spaceBetweenParallelEdges) {
        this.doDefaultEvolutionaryGraphLayout(layouter, iters, spaceBetweenParallelEdges, null);
    }

    public void doDefaultEvolutionaryGraphLayout(EvolutionaryGraphLayout layouter, int iters, int spaceBetweenParallelEdges, Dimension dim) {
        EdNode n;
        if (this.bGraph.isCompleteGraph() && !this.nodeNumberChanged) {
            return;
        }
        this.updateVisibility();
        List<EdNode> visiblenodes = this.getVisibleNodes();
        Vector<EdArc> visiblearcs = new Vector<EdArc>();
        if (visiblenodes.size() <= 1) {
            return;
        }
        this.updateNodePosEtoL(visiblenodes);
        if (dim == null) {
            layouter.setPanelSize(layouter.getNeededPanelSize(visiblenodes));
        } else {
            layouter.setPanelSize(dim);
        }
        int intersect = layouter.getNodeIntersect(visiblenodes, true);
        if (intersect > 0) {
            if (!layouter.isEnabled()) {
                layouter.setFrozenByDefault(true);
            } else {
                layouter.setFrozenByDefault(false);
            }
            layouter.makeRandomLayoutOfNodes(this, visiblenodes);
        } else {
            if (!layouter.isEnabled()) {
                return;
            }
            layouter.setFrozenByDefault(false);
            layouter.setUsePattern(false);
        }
        this.straightAllArcs();
        int i = 0;
        while (i < visiblenodes.size()) {
            n = visiblenodes.get(i);
            if (n.getNodeID() == -1) {
                n.setNodeID(n.hashCode());
            }
            ++i;
        }
        i = 0;
        while (i < visiblenodes.size()) {
            n = visiblenodes.get(i);
            n.calculateCluster(100, visiblenodes);
            ++i;
        }
        if (!layouter.isEnabled()) {
            layouter.layoutGraph(this, visiblenodes, visiblearcs, iters, 1, 1);
        } else {
            layouter.layoutGraph(this, visiblenodes, visiblearcs, iters, 1, 50);
        }
        if (layouter.isCentre()) {
            layouter.centreLayout(this, visiblenodes);
        }
        if (spaceBetweenParallelEdges > 0) {
            this.resolveArcOverlappings(spaceBetweenParallelEdges);
        }
        this.refreshInheritanceArcs();
        this.hasDefaultLayout = true;
    }

    private void freezeLayout(boolean b) {
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode n = this.nodes.get(i);
            n.getLNode().setFrozenByDefault(b);
            n.getLNode().unsetOverlap();
            ++i;
        }
        i = 0;
        while (i < this.arcs.size()) {
            EdArc a = this.arcs.get(i);
            a.getLArc().setFrozenByDefault(b);
            ++i;
        }
    }

    public void resolveArcOverlappings(int space) {
        if (this.arcs.size() < 2 || this.straightenArcs) {
            return;
        }
        int j = 0;
        while (j < this.arcs.size()) {
            EdArc a = this.arcs.elementAt(j);
            if (!a.hasAnchor()) {
                this.resizeArc(a, space);
            }
            ++j;
        }
    }

    private void resizeArc(EdArc ea, int space) {
        if (ea.getBasisArc().isInheritance() || ea.hasAnchor() || this.straightenArcs) {
            return;
        }
        int step = space;
        if (step < 10) {
            step = 10;
        }
        int nb1 = 0;
        int nb2 = 0;
        int i = 0;
        while (i < this.arcs.size()) {
            EdArc elem = this.arcs.elementAt(i);
            if (!elem.equals(ea)) {
                if (elem.isLine() && ea.isLine()) {
                    if (elem.getSource() == ea.getSource() && elem.getTarget() == ea.getTarget() || elem.getSource() == ea.getTarget() && elem.getTarget() == ea.getSource()) {
                        Point p1 = new Point(elem.getSource().getX(), elem.getSource().getY());
                        Point p2 = new Point(elem.getTarget().getX(), elem.getTarget().getY());
                        Point p = new Point(p1.x + (p2.x - p1.x) / 2, p1.y + (p2.y - p1.y) / 2);
                        int aa = (p.x - p1.x) * (p.x - p1.x) + (p.y - p1.y) * (p.y - p1.y);
                        int k0 = 2;
                        try {
                            int a = (int)Math.sqrt(aa);
                            k0 = a / step;
                        }
                        catch (ArithmeticException aex) {
                            System.out.println("EdGraph.resizeArc::  " + aex.getLocalizedMessage());
                        }
                        if (k0 == 0) {
                            k0 = 2;
                        }
                        if (!elem.hasAnchor() && !ea.hasAnchor()) {
                            Point p3 = new Point(p.x + (p.y - p1.y) / k0, p.y - (p.x - p1.x) / k0);
                            if (p3.x <= 0) {
                                p3.x = 5;
                            }
                            if (p3.y <= 0) {
                                p3.y = 5;
                            }
                            ea.setAnchor(p3);
                            if (elem.getSource() == ea.getSource() && elem.getTarget() == ea.getTarget()) {
                                ++nb1;
                            } else if (elem.getSource() == ea.getTarget() && elem.getTarget() == ea.getSource()) {
                                ++nb2;
                            }
                        } else if (!(elem.hasAnchor() && !ea.hasAnchor() || !elem.hasAnchor() && ea.hasAnchor() || elem.getAnchor().x != ea.getAnchor().x || elem.getAnchor().y != ea.getAnchor().y)) {
                            if (elem.getSource() == ea.getSource() && elem.getTarget() == ea.getTarget()) {
                                Point p3 = new Point(p.x + ++nb1 * (p.y - p1.y) / k0, p.y - nb1 * (p.x - p1.x) / k0);
                                if (p3.x <= 0) {
                                    p3.x = 5;
                                }
                                if (p3.y <= 0) {
                                    p3.y = 5;
                                }
                                ea.setAnchor(p3);
                            } else if (elem.getSource() == ea.getTarget() && elem.getTarget() == ea.getSource()) {
                                Point p3 = new Point(p.x + ++nb2 * (p.y - p1.y) / k0, p.y - nb2 * (p.x - p1.x) / k0);
                                if (p3.x <= 0) {
                                    p3.x = 5;
                                }
                                if (p3.y <= 0) {
                                    p3.y = 5;
                                }
                                ea.setAnchor(p3);
                            }
                        }
                    }
                } else if (!elem.isLine() && !ea.isLine() && elem.getSource().equals(ea.getSource())) {
                    Loop loop = null;
                    if (ea.getWidth() == ea.getHeight() && ea.getHeight() == 0) {
                        if (ea.getSource().isNode()) {
                            int w1;
                            int h1 = w1 = ea.getWidthOfLoop();
                            int x1 = ea.getSource().getX() - ea.getSource().getNode().getWidth() / 2 - w1 / 2 - w1 / 4;
                            int y1 = ea.getSource().getY() - ea.getSource().getNode().getHeight() / 2 - h1 / 2 - h1 / 4;
                            loop = new Loop(x1, y1, w1, h1);
                        }
                    } else {
                        loop = ea.toLoop();
                    }
                    if (loop != null && (elem.getAnchor((int)1).x == loop.getAnchor((int)1).x && elem.getAnchor((int)1).y == loop.getAnchor((int)1).y || elem.getWidth() == loop.w && elem.getHeight() == loop.h)) {
                        ea.setAnchor(1, new Point(elem.getAnchor((int)1).x - step, elem.getAnchor((int)1).y - step));
                        ea.setWidth(elem.getWidthOfLoop() + step);
                        ea.setHeight(elem.getHeightOfLoop() + step);
                    }
                }
            }
            ++i;
        }
    }

    public void updateNodePosLtoE(List<EdNode> nodelist) {
        int i = 0;
        while (i < nodelist.size()) {
            EdNode e = nodelist.get(i);
            e.setXY(e.getLNode().getAkt().x, e.getLNode().getAkt().y);
            ++i;
        }
    }

    public void updateNodePosEtoL(List<EdNode> nodelist) {
        int i = 0;
        while (i < nodelist.size()) {
            EdNode e = nodelist.get(i);
            e.getLNode().setAkt(new Point(e.getX(), e.getY()));
            ++i;
        }
    }

    public void updateLengthOfLayoutEdge(List<EdArc> arclist, int l) {
        int i = 0;
        while (i < arclist.size()) {
            EdArc e = arclist.get(i);
            e.getLArc().setAktLength(l);
            e.getLArc().setPrefLength(l);
            ++i;
        }
    }

    public Dimension getMaxNodeDim() {
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < this.nodes.size()) {
            EdNode e = this.nodes.get(i);
            w = Math.max(w, e.getWidth());
            h = Math.max(h, e.getHeight());
            ++i;
        }
        Dimension d = new Dimension(w, h);
        return d;
    }

    public Dimension getAverageNodeDim() {
        float aw = 0.0f;
        float ah = 0.0f;
        if (!this.nodes.isEmpty()) {
            int i = 0;
            while (i < this.nodes.size()) {
                EdNode e = this.nodes.get(i);
                aw += (float)e.getWidth();
                ah += (float)e.getHeight();
                ++i;
            }
            aw /= (float)this.nodes.size();
            ah /= (float)this.nodes.size();
        }
        Dimension d = new Dimension((int)(aw + 1.0f), (int)(ah + 1.0f));
        return d;
    }

    public Dimension getAverageNodeDim(List<EdNode> visiblenodes) {
        float aw = 0.0f;
        float ah = 0.0f;
        if (!visiblenodes.isEmpty()) {
            int i = 0;
            while (i < visiblenodes.size()) {
                EdNode e = visiblenodes.get(i);
                aw += (float)e.getWidth();
                ah += (float)e.getHeight();
                ++i;
            }
            aw /= (float)visiblenodes.size();
            ah /= (float)visiblenodes.size();
        }
        return new Dimension((int)aw, (int)ah);
    }

    public Dimension getGraphDim() {
        return this.gDim;
    }

    public void setGraphDim(Dimension d) {
        this.gDim = new Dimension(d);
    }

    public int getGraphGen() {
        return this.ggen;
    }

    public void incGraphGen() {
        ++this.ggen;
        int i = 0;
        while (i < this.nodes.size()) {
            this.nodes.get(i).getLNode().incAge();
            ++i;
        }
    }
}

