/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.actions;

import configuration.Configuration;
import java.util.ArrayList;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.VariabilityModelHelper;
import org.eclipse.emf.henshin.variability.configuration.ui.providers.ConfigurationProvider;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityTransactionHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

public class MoveElementToConfigurationAction
implements IActionDelegate {
    public static final String ID = "org.eclipse.emf.henshin.variability.ui.MoveElementToConfigurationActionID";
    private ArrayList<GraphElement> selectedGraphElementList = new ArrayList();

    public void run(IAction action) {
        if (this.selectedGraphElementList != null && !this.selectedGraphElementList.isEmpty()) {
            for (GraphElement graphElement : this.selectedGraphElementList) {
                if (!(graphElement instanceof ModelElement)) continue;
                Rule rule = graphElement.getGraph().getRule();
                Configuration configuration = ConfigurationProvider.getInstance().getConfiguration(rule);
                String presenceCondition = VariabilityModelHelper.getPresenceCondition(configuration);
                VariabilityTransactionHelper.setAnnotationValue((ModelElement)((ModelElement)graphElement), (String)"presenceCondition", (String)presenceCondition);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedGraphElementList.clear();
        if (selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                View view;
                AbstractGraphicalEditPart editPart;
                if (!(o instanceof AbstractGraphicalEditPart) || !((editPart = (AbstractGraphicalEditPart)o).getModel() instanceof View) || !((view = (View)editPart.getModel()).getElement() instanceof GraphElement)) continue;
                this.selectedGraphElementList.add((GraphElement)view.getElement());
            }
        }
    }
}

