/*
 * Decompiled with CFR 0.152.
 */
package laxcondition.impl;

import laxcondition.Condition;
import laxcondition.Formula;
import laxcondition.LaxconditionFactory;
import laxcondition.LaxconditionPackage;
import laxcondition.Operator;
import laxcondition.QuantifiedLaxCondition;
import laxcondition.Quantifier;
import laxcondition.True;
import laxcondition.Variable;
import laxcondition.impl.ConditionImpl;
import laxcondition.impl.FormulaImpl;
import laxcondition.impl.QuantifiedLaxConditionImpl;
import laxcondition.impl.TrueImpl;
import laxcondition.impl.VariableImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class LaxconditionFactoryImpl
extends EFactoryImpl
implements LaxconditionFactory {
    public static LaxconditionFactory init() {
        try {
            LaxconditionFactory theLaxconditionFactory = (LaxconditionFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.example.org/laxcondition");
            if (theLaxconditionFactory != null) {
                return theLaxconditionFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new LaxconditionFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createCondition();
            }
            case 2: {
                return this.createQuantifiedLaxCondition();
            }
            case 3: {
                return this.createTrue();
            }
            case 4: {
                return this.createFormula();
            }
            case 5: {
                return this.createVariable();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createQuantifierFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createOperatorFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertQuantifierToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertOperatorToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Condition createCondition() {
        ConditionImpl condition = new ConditionImpl();
        return condition;
    }

    @Override
    public QuantifiedLaxCondition createQuantifiedLaxCondition() {
        QuantifiedLaxConditionImpl quantifiedLaxCondition = new QuantifiedLaxConditionImpl();
        return quantifiedLaxCondition;
    }

    @Override
    public True createTrue() {
        TrueImpl true_ = new TrueImpl();
        return true_;
    }

    @Override
    public Formula createFormula() {
        FormulaImpl formula = new FormulaImpl();
        return formula;
    }

    @Override
    public Variable createVariable() {
        VariableImpl variable = new VariableImpl();
        return variable;
    }

    public Quantifier createQuantifierFromString(EDataType eDataType, String initialValue) {
        Quantifier result = Quantifier.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertQuantifierToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Operator createOperatorFromString(EDataType eDataType, String initialValue) {
        Operator result = Operator.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOperatorToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public LaxconditionPackage getLaxconditionPackage() {
        return (LaxconditionPackage)this.getEPackage();
    }

    @Deprecated
    public static LaxconditionPackage getPackage() {
        return LaxconditionPackage.eINSTANCE;
    }
}

