/*
 * Decompiled with CFR 0.152.
 */
package laxcondition;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Quantifier implements Enumerator
{
    EXISTS(0, "EXISTS", "EXISTS"),
    FORALL(1, "FORALL", "FORALL");

    public static final int EXISTS_VALUE = 0;
    public static final int FORALL_VALUE = 1;
    private static final Quantifier[] VALUES_ARRAY;
    public static final List<Quantifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Quantifier[]{EXISTS, FORALL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Quantifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Quantifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Quantifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Quantifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Quantifier get(int value) {
        switch (value) {
            case 0: {
                return EXISTS;
            }
            case 1: {
                return FORALL;
            }
        }
        return null;
    }

    private Quantifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

