/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.runner.pullback;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.impl.HenshinFactoryImpl;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.multicda.cda.ConflictAnalysis;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.runner.pullback.EssentialCpaLoggerPB;
import org.eclipse.emf.henshin.multicda.cda.runner.pullback.LoggerPB;
import org.eclipse.emf.henshin.multicda.cda.runner.pullback.MinimalConflReasonLoggerPB;
import org.eclipse.emf.henshin.multicda.cda.runner.pullback.NormalCpaLoggerPB;
import org.eclipse.emf.henshin.multicda.cda.tasks.AtomicResultContainer;
import org.eclipse.emf.henshin.multicda.cda.tasks.CalculateAtomicCpaTask;
import org.eclipse.emf.henshin.multicda.cda.tasks.CalculateCpaTask;
import org.eclipse.emf.henshin.multicda.cda.tasks.SingleCpaTaskResultContainer;
import org.eclipse.emf.henshin.multicda.cpa.CDAOptions;
import org.eclipse.emf.henshin.multicda.cpa.CpaByAGG;
import org.eclipse.emf.henshin.multicda.cpa.ICriticalPairAnalysis;
import org.eclipse.emf.henshin.multicda.cpa.result.CPAResult;
import org.eclipse.emf.henshin.multicda.cpa.result.Conflict;
import org.eclipse.emf.henshin.multicda.cpa.result.ConflictKind;
import org.eclipse.emf.henshin.multicda.cpa.result.CriticalPair;

public class Runner_WithPullback {
    boolean runNormalCPA = true;
    boolean runEssentialCPA = true;
    boolean runAtomicAnalysis = true;
    private boolean noApplicationConditions = false;
    private boolean removeAllMultirules = false;
    private Set<String> limitedSetOfRulesByRuleNames;
    ICriticalPairAnalysis normalCpa = new CpaByAGG();
    CDAOptions normalOptions = new CDAOptions();
    ICriticalPairAnalysis essentialCpa = new CpaByAGG();
    CDAOptions essentialOptions = new CDAOptions();
    int numberOfAllEssentialConflicts = 0;
    int numberOfFilteredEssentialConflicts = 0;
    long totalNormalRuntime = 0L;
    long totalEssentialRuntime = 0L;
    long totalAtomicRuntime = 0L;
    int totalNumberOfNormalCPs = 0;
    int totalNumberOfEssentialCPs = 0;
    int totalNumberOfAtomicCPs = 0;
    int totalNumberOfConflictAtomCandidates = 0;
    int totalNumberOfMinimalConflictReasons = 0;
    List<LoggerPB> loggers = new LinkedList<LoggerPB>();
    LoggerPB normalCpaLogger = new NormalCpaLoggerPB();
    LoggerPB minimalReasonLogger = new MinimalConflReasonLoggerPB();
    LoggerPB essentialCpaLogger = new EssentialCpaLoggerPB();
    int currentRow = 0;
    int firstRowToAnalyse = 0;
    int lastRowToAnalyse = 70;
    private boolean ruleMetricAdded;

    public void runWithActivatedRules(String fullSubDirectoryPath, List<String> activatedRules) {
        this.essentialOptions.essentialCP = true;
        this.loggers.add(this.normalCpaLogger);
        this.loggers.add(this.essentialCpaLogger);
        this.loggers.add(this.minimalReasonLogger);
        File dir = new File(fullSubDirectoryPath);
        List<String> pathsToHenshinFiles = this.inspectDirectoryForHenshinFiles(dir);
        List<Rule> allLoadedRules = this.loadAllActivatedRulesFromFileSystemPaths(pathsToHenshinFiles, activatedRules);
        for (Rule rule : allLoadedRules) {
            rule.setCheckDangling(true);
        }
        if (this.noApplicationConditions) {
            for (Rule rule : allLoadedRules) {
                LinkedList allPACs = new LinkedList(rule.getLhs().getPACs());
                for (NestedCondition pac : allPACs) {
                    rule.getLhs().removeNestedCondition(pac);
                }
                LinkedList allNACs = new LinkedList(rule.getLhs().getNACs());
                Iterator iterator = allNACs.iterator();
                while (iterator.hasNext()) {
                    NestedCondition nac = (NestedCondition)iterator.next();
                    rule.getLhs().removeNestedCondition(nac);
                }
            }
        }
        if (this.removeAllMultirules) {
            for (Rule rule : allLoadedRules) {
                rule.getMultiRules().clear();
            }
        }
        List<Rule> copiesOfRulesWithoutDeletion = this.buildCopiesOfRulesWithoutDeletion(allLoadedRules);
        int numberOfAddedRules = allLoadedRules.size();
        for (LoggerPB loggerPB : this.loggers) {
            loggerPB.init(numberOfAddedRules);
            loggerPB.setAddDetailsOnRuleName(true);
        }
        LinkedList<String> recalculateEssentialCpaRules = new LinkedList<String>();
        recalculateEssentialCpaRules.add("Generalization_2-2");
        recalculateEssentialCpaRules.add("Generalization_2-5");
        recalculateEssentialCpaRules.add("Refactoring_1-9");
        LinkedList<Rule> skippedRules = new LinkedList<Rule>();
        CalculateCpaTask.AnalysisKind analysisKind = CalculateCpaTask.AnalysisKind.CONFLICT;
        for (Rule firstRule : allLoadedRules) {
            if (skippedRules.contains(firstRule)) {
                System.err.println("skipping row for rule: " + firstRule.getName());
            }
            if (!skippedRules.contains(firstRule) && this.ruleIsntLimited(firstRule) && this.currentRow >= this.firstRowToAnalyse && this.currentRow <= this.lastRowToAnalyse) {
                Graph lhsOfFirstRule = firstRule.getLhs();
                int elementsInLhsOfFirstRule = lhsOfFirstRule.getNodes().size() + lhsOfFirstRule.getEdges().size();
                for (LoggerPB loggerPB : this.loggers) {
                    loggerPB.addData(firstRule, null, Integer.toString(elementsInLhsOfFirstRule), Integer.toString(elementsInLhsOfFirstRule));
                }
                this.ruleMetricAdded = false;
                for (Rule secondRule : copiesOfRulesWithoutDeletion) {
                    Rule originalRuleOfRule2 = allLoadedRules.get(copiesOfRulesWithoutDeletion.indexOf(secondRule));
                    Graph lhsOfOriginalRuleOfRule2 = originalRuleOfRule2.getLhs();
                    int elementsInLhsOfSecondRule = lhsOfOriginalRuleOfRule2.getNodes().size() + lhsOfOriginalRuleOfRule2.getEdges().size();
                    if (skippedRules.contains(secondRule) || skippedRules.contains(originalRuleOfRule2)) {
                        System.err.println("skipping column for rule: " + secondRule.getName());
                    }
                    if (skippedRules.contains(secondRule) || skippedRules.contains(originalRuleOfRule2) || !this.ruleIsntLimited(secondRule)) continue;
                    boolean canceled = false;
                    if (this.runNormalCPA) {
                        canceled = this.runNormalCPA(firstRule, secondRule, originalRuleOfRule2, skippedRules, analysisKind, elementsInLhsOfSecondRule);
                    }
                    if (this.runEssentialCPA && !canceled) {
                        canceled = this.runEssentialCPA(firstRule, secondRule, originalRuleOfRule2, skippedRules, analysisKind, elementsInLhsOfSecondRule);
                    }
                    if (!this.runAtomicAnalysis) continue;
                    canceled = this.runAtomicAnalysis(firstRule, secondRule, originalRuleOfRule2, skippedRules, analysisKind, elementsInLhsOfSecondRule);
                }
                this.ruleMetricAdded = true;
                System.gc();
            }
            ++this.currentRow;
        }
        System.err.println("numberOfAllEssentialConflicts: " + this.numberOfAllEssentialConflicts);
        System.err.println("numberOfFilteredEssentialConflicts: " + this.numberOfFilteredEssentialConflicts);
        System.out.println("HALT");
        for (LoggerPB loggerPB : this.loggers) {
            loggerPB.exportStoredRuntimeToCSV(String.valueOf(fullSubDirectoryPath) + File.separator);
            loggerPB.exportStoredConflictsToCSV(String.valueOf(fullSubDirectoryPath) + File.separator);
        }
    }

    private boolean ruleIsntLimited(Rule ruleToCheck) {
        if (this.limitedSetOfRulesByRuleNames == null) {
            return true;
        }
        System.out.println(ruleToCheck.getName());
        return this.limitedSetOfRulesByRuleNames.contains(ruleToCheck.getName());
    }

    private List<Rule> buildCopiesOfRulesWithoutDeletion(List<Rule> allLoadedRules) {
        HenshinFactoryImpl henshinFactory = new HenshinFactoryImpl();
        LinkedList<Rule> copiesOfRulesWithoutDeletion = new LinkedList<Rule>();
        for (Rule ruleToCopy : allLoadedRules) {
            EcoreUtil.Copier copierForRule = new EcoreUtil.Copier();
            Rule copyOfRule = (Rule)copierForRule.copy((EObject)ruleToCopy);
            copyOfRule.setName(copyOfRule.getName().concat("_"));
            copierForRule.copyReferences();
            MappingList mappings = copyOfRule.getMappings();
            mappings.clear();
            for (Node nodeInLhs : copyOfRule.getLhs().getNodes()) {
                nodeInLhs.getAttributes().clear();
            }
            EcoreUtil.Copier copierForLhsGraph = new EcoreUtil.Copier();
            Graph copiedLhs = (Graph)copierForLhsGraph.copy((EObject)copyOfRule.getLhs());
            copierForLhsGraph.copyReferences();
            copiedLhs.setName("Rhs");
            copyOfRule.setRhs(copiedLhs);
            for (Node nodeInLhsOfCopiedRule : copyOfRule.getLhs().getNodes()) {
                Node nodeInNewRhs = (Node)copierForLhsGraph.get((Object)nodeInLhsOfCopiedRule);
                Mapping createdMapping = henshinFactory.createMapping(nodeInLhsOfCopiedRule, nodeInNewRhs);
                mappings.add((Object)createdMapping);
            }
            copiesOfRulesWithoutDeletion.add(copyOfRule);
        }
        return copiesOfRulesWithoutDeletion;
    }

    public void setAnalysisKinds(boolean runNormalCPA, boolean runEssentialCPA, boolean runAtomicAnalysis) {
        this.runNormalCPA = runNormalCPA;
        this.runEssentialCPA = runEssentialCPA;
        this.runAtomicAnalysis = runAtomicAnalysis;
    }

    private List<Rule> loadAllActivatedRulesFromFileSystemPaths(List<String> pathsToHenshinFiles, List<String> namesOfActivatedRules) {
        LinkedList<Rule> allEditRulesWithoutAmalgamation = new LinkedList<Rule>();
        for (String pathToHenshinFiles : pathsToHenshinFiles) {
            HenshinResourceSet henshinResourceSet = new HenshinResourceSet();
            Module module = henshinResourceSet.getModule(pathToHenshinFiles);
            for (Unit unit : module.getUnits()) {
                if (!(unit instanceof Rule)) continue;
                boolean activatedRule = false;
                if (namesOfActivatedRules.contains(unit.getName())) {
                    allEditRulesWithoutAmalgamation.add((Rule)unit);
                }
                if (!activatedRule) continue;
                allEditRulesWithoutAmalgamation.add((Rule)unit);
            }
        }
        return allEditRulesWithoutAmalgamation;
    }

    private List<CriticalPair> filterDeleteUseConflicts(CPAResult essentialResult) {
        if (essentialResult != null) {
            List criticalPairs = essentialResult.getCriticalPairs();
            LinkedList<CriticalPair> filteredDeleteUseConflicts = new LinkedList<CriticalPair>();
            for (CriticalPair cp : criticalPairs) {
                if (!(cp instanceof Conflict) || !((Conflict)cp).getConflictKind().equals((Object)ConflictKind.DELETE_USE_CONFLICT)) continue;
                filteredDeleteUseConflicts.add(cp);
            }
            return filteredDeleteUseConflicts;
        }
        return new LinkedList<CriticalPair>();
    }

    private List<String> inspectDirectoryForHenshinFiles(File dir) {
        LinkedList<String> pathsToHenshinFiles = new LinkedList<String>();
        File[] directoryListing = dir.listFiles();
        if (directoryListing != null) {
            File[] fileArray = directoryListing;
            int n = directoryListing.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                System.out.println("recursive call of exploration method");
                String fileName = child.getName();
                if (fileName.endsWith(".henshin")) {
                    pathsToHenshinFiles.add(child.getAbsolutePath());
                } else if (!child.getName().contains(".")) {
                    File subDir = child;
                    pathsToHenshinFiles.addAll(this.inspectDirectoryForHenshinFiles(subDir));
                }
                ++n2;
            }
        }
        return pathsToHenshinFiles;
    }

    public void setNoApplicationConditions(boolean removeAllApplicationConditions) {
        this.noApplicationConditions = removeAllApplicationConditions;
    }

    public void setNoMultirules(boolean removeAllMultirules) {
        this.removeAllMultirules = removeAllMultirules;
    }

    public void limitSetOfRulesByRuleNames(Set<String> limitedSetOfRulesByRuleNames) {
        this.limitedSetOfRulesByRuleNames = limitedSetOfRulesByRuleNames;
    }

    private int computePullback(Rule r1, Match m1, Match m2, Rule r2) {
        LinkedList<EObject> temporary = new LinkedList<EObject>();
        LinkedList<EObject> r2MatchTarget = new LinkedList<EObject>();
        LinkedList<Node> result = new LinkedList<Node>();
        for (Node node : r1.getLhs().getNodes()) {
            temporary.add(m1.getNodeTarget(node));
        }
        for (Node node : r2.getLhs().getNodes()) {
            r2MatchTarget.add(m2.getNodeTarget(node));
            if (!temporary.contains(m2.getNodeTarget(node))) continue;
            result.add(node);
        }
        return result.size();
    }

    private boolean runAtomicAnalysis(Rule firstRule, Rule secondRule, Rule originalRuleOfRule2, List<Rule> skippedRules, CalculateCpaTask.AnalysisKind analysisKind, int elementsInLhsOfSecondRule) {
        boolean canceled = false;
        StringBuffer runTimesOfRuleCombination = new StringBuffer();
        new StringBuffer();
        String cfr_ignored_0 = String.valueOf(firstRule.getName()) + " -> " + secondRule.getName();
        long atomicStartTime = System.currentTimeMillis();
        AtomicResultContainer resultKeeper = new AtomicResultContainer(firstRule, secondRule);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(new CalculateAtomicCpaTask(resultKeeper)).get(15L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | NullPointerException | ExecutionException exception) {
            System.err.println("Timeout!");
            executor.shutdown();
        }
        catch (TimeoutException e) {
            System.err.println("TIME OUT!!!");
            e.printStackTrace();
        }
        ConflictAnalysis atomicCoreCPA = new ConflictAnalysis(firstRule, secondRule);
        atomicCoreCPA.computeAtoms();
        resultKeeper.getConflictAtoms();
        resultKeeper.getCandidates();
        Set<ConflictReason> atomicCoreMinimalConflictReasons = resultKeeper.getMinimalConflictReasons();
        long atomicEndTime = System.currentTimeMillis();
        long atomiRunTime = atomicEndTime - atomicStartTime;
        this.totalAtomicRuntime += atomiRunTime;
        runTimesOfRuleCombination.append(String.valueOf(atomiRunTime));
        if (!this.ruleMetricAdded) {
            this.minimalReasonLogger.addData(firstRule, originalRuleOfRule2, Integer.toString(elementsInLhsOfSecondRule), Integer.toString(elementsInLhsOfSecondRule));
        }
        if (!canceled) {
            this.minimalReasonLogger.addData(firstRule, originalRuleOfRule2, runTimesOfRuleCombination.toString(), String.valueOf(atomicCoreMinimalConflictReasons.size()));
        }
        return canceled;
    }

    private boolean runEssentialCPA(Rule firstRule, Rule secondRule, Rule originalRuleOfRule2, List<Rule> skippedRules, CalculateCpaTask.AnalysisKind analysisKind, int elementsInLhsOfSecondRule) {
        boolean canceled = false;
        StringBuffer runTimesOfRuleCombination = new StringBuffer();
        StringBuffer amountOfDeleteUseConflictsOfRulecombination = new StringBuffer();
        long essentialStartTime = System.currentTimeMillis();
        LinkedList<Rule> firstRuleList = new LinkedList<Rule>();
        firstRuleList.add(firstRule);
        LinkedList<Rule> secondRuleList = new LinkedList<Rule>();
        secondRuleList.add(secondRule);
        CPAResult essentialResult = null;
        SingleCpaTaskResultContainer singleCpaTaskResultContainer = new SingleCpaTaskResultContainer(firstRuleList, secondRuleList, this.essentialOptions);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(new CalculateCpaTask(singleCpaTaskResultContainer, analysisKind)).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | NullPointerException | ExecutionException exception) {
            System.err.println("Timeout!");
            executor.shutdown();
        }
        catch (TimeoutException e) {
            canceled = true;
            skippedRules.add(firstRule);
            skippedRules.add(originalRuleOfRule2);
            skippedRules.add(secondRule);
            System.err.println("TIME OUT!!!");
            e.printStackTrace();
        }
        long essentialEndTime = System.currentTimeMillis();
        executor.shutdown();
        essentialResult = singleCpaTaskResultContainer.getResult();
        long essentialRunTime = essentialEndTime - essentialStartTime;
        this.totalEssentialRuntime += essentialRunTime;
        if (essentialResult != null) {
            runTimesOfRuleCombination.append(String.valueOf(essentialRunTime));
            this.numberOfAllEssentialConflicts += essentialResult.getCriticalPairs().size();
            List<CriticalPair> filteredDeleteUseConflicts = this.filterDeleteUseConflicts(essentialResult);
            this.numberOfFilteredEssentialConflicts += filteredDeleteUseConflicts.size();
            System.err.println("delete-use-conflicts: " + filteredDeleteUseConflicts.size());
            this.totalNumberOfEssentialCPs += filteredDeleteUseConflicts.size();
            int sumOfElementsInPullback = 0;
            for (CriticalPair critPair : filteredDeleteUseConflicts) {
                Conflict confl = (Conflict)critPair;
                Rule r1 = confl.getFirstRule();
                Rule r2 = confl.getFirstRule();
                Match match1 = confl.getMatch1();
                Match match2 = confl.getMatch2();
                int elementsOfPullBack = this.computePullback(r1, match1, match2, r2);
                sumOfElementsInPullback += elementsOfPullBack;
            }
            amountOfDeleteUseConflictsOfRulecombination.append(sumOfElementsInPullback);
        } else {
            runTimesOfRuleCombination.append("TO");
            amountOfDeleteUseConflictsOfRulecombination.append("TO");
        }
        if (!this.ruleMetricAdded) {
            this.essentialCpaLogger.addData(firstRule, originalRuleOfRule2, Integer.toString(elementsInLhsOfSecondRule), Integer.toString(elementsInLhsOfSecondRule));
        }
        if (!canceled) {
            this.essentialCpaLogger.addData(firstRule, originalRuleOfRule2, runTimesOfRuleCombination.toString(), amountOfDeleteUseConflictsOfRulecombination.toString());
        }
        return canceled;
    }

    private boolean runNormalCPA(Rule firstRule, Rule secondRule, Rule originalRuleOfRule2, List<Rule> skippedRules, CalculateCpaTask.AnalysisKind analysisKind, int elementsInLhsOfSecondRule) {
        boolean canceled = false;
        StringBuffer runTimesOfRuleCombination = new StringBuffer();
        StringBuffer amountOfDeleteUseConflictsOfRulecombination = new StringBuffer();
        System.currentTimeMillis();
        LinkedList<Rule> firstRuleList = new LinkedList<Rule>();
        firstRuleList.add(firstRule);
        LinkedList<Rule> secondRuleList = new LinkedList<Rule>();
        secondRuleList.add(secondRule);
        CPAResult normalResult = null;
        SingleCpaTaskResultContainer singleCpaTaskResultContainer = new SingleCpaTaskResultContainer(firstRuleList, secondRuleList, this.normalOptions);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            executor.submit(new CalculateCpaTask(singleCpaTaskResultContainer, analysisKind)).get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | NullPointerException | ExecutionException exception) {
            System.err.println("Timeout!");
            executor.shutdown();
        }
        catch (TimeoutException e) {
            canceled = true;
            skippedRules.add(firstRule);
            skippedRules.add(originalRuleOfRule2);
            skippedRules.add(secondRule);
            System.err.println("TIME OUT!!!");
            e.printStackTrace();
        }
        executor.shutdown();
        normalResult = singleCpaTaskResultContainer.getResult();
        long normalRunTime = singleCpaTaskResultContainer.getAnalysisDuration();
        this.totalNormalRuntime += normalRunTime;
        if (normalResult != null) {
            runTimesOfRuleCombination.append(String.valueOf(normalRunTime));
            List<CriticalPair> filteredDeleteUseConflicts = this.filterDeleteUseConflicts(normalResult);
            this.totalNumberOfNormalCPs += filteredDeleteUseConflicts.size();
            int sumOfElementsInPullback = 0;
            for (CriticalPair critPair : filteredDeleteUseConflicts) {
                Conflict confl = (Conflict)critPair;
                Rule r1 = confl.getFirstRule();
                Rule r2 = confl.getFirstRule();
                Match match1 = confl.getMatch1();
                Match match2 = confl.getMatch2();
                int elementsOfPullBack = this.computePullback(r1, match1, match2, r2);
                sumOfElementsInPullback += elementsOfPullBack;
            }
            amountOfDeleteUseConflictsOfRulecombination.append(sumOfElementsInPullback);
        } else {
            System.err.println("normal CPA failed!");
            runTimesOfRuleCombination.append("TO");
            amountOfDeleteUseConflictsOfRulecombination.append("TO");
        }
        if (!this.ruleMetricAdded) {
            this.normalCpaLogger.addData(firstRule, originalRuleOfRule2, Integer.toString(elementsInLhsOfSecondRule), Integer.toString(elementsInLhsOfSecondRule));
        }
        if (!canceled) {
            this.normalCpaLogger.addData(firstRule, originalRuleOfRule2, runTimesOfRuleCombination.toString(), amountOfDeleteUseConflictsOfRulecombination.toString());
        }
        return canceled;
    }
}

