/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.framework;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Pair;
import org.eclipse.emf.henshin.multicda.cda.Utils;

public class RuleConfigurator {
    private Set<RuleType> types = new HashSet<RuleType>();
    private int hash = 0;
    private Rule rule;
    private String TAG;

    public RuleConfigurator(Rule rule) {
        this.rule = rule;
        Action p = new Action(Action.Type.PRESERVE);
        Action d = new Action(Action.Type.DELETE);
        Action c = new Action(Action.Type.CREATE);
        Action f = new Action(Action.Type.FORBID);
        Action r = new Action(Action.Type.REQUIRE);
        if (!rule.getActionNodes(p).isEmpty() || !rule.getActionEdges(p).isEmpty()) {
            this.add(RuleType.Preserve);
        }
        if (!rule.getActionNodes(d).isEmpty() || !rule.getActionEdges(d).isEmpty()) {
            this.add(RuleType.Delete);
        }
        if (!rule.getActionNodes(c).isEmpty() || !rule.getActionEdges(c).isEmpty()) {
            this.add(RuleType.Create);
        }
        if (!rule.getActionNodes(f).isEmpty() || !rule.getActionEdges(f).isEmpty()) {
            this.add(RuleType.Forbid);
        }
        if (!rule.getActionNodes(r).isEmpty() || !rule.getActionEdges(r).isEmpty()) {
            this.add(RuleType.Require);
        }
        this.checkAttributes(rule, new boolean[0]);
        for (Rule nacRule : Utils.createNACRules(rule)) {
            this.checkAttributes(nacRule, false);
        }
        for (Rule pacRule : Utils.createPACRules(rule)) {
            this.checkAttributes(pacRule, true);
        }
    }

    private void checkAttributes(Rule rule, boolean ... nacsPacs) {
        Map<Node, Set<Pair<Attribute, Attribute>>> changeNodes = Utils.getAttributeChanges(rule);
        EList parameters = rule.getParameters();
        for (Node n : changeNodes.keySet()) {
            Set<Pair<Attribute, Attribute>> attributes = changeNodes.get(n);
            for (Pair<Attribute, Attribute> attribute : attributes) {
                if (attribute.first == null) {
                    if (this.parameterContains((EList<Parameter>)parameters, (Attribute)attribute.second)) {
                        this.add(RuleType.CreateAVar);
                        continue;
                    }
                    this.add(RuleType.CreateA);
                    continue;
                }
                if (attribute.second == null) {
                    if (this.parameterContains((EList<Parameter>)parameters, (Attribute)attribute.first)) {
                        if (nacsPacs.length != 0 && !nacsPacs[0]) {
                            this.add(RuleType.ForbidAVar);
                            continue;
                        }
                        if (nacsPacs.length != 0) {
                            this.add(RuleType.PreserveAVar);
                            continue;
                        }
                        this.add(RuleType.DeleteAVar);
                        continue;
                    }
                    if (nacsPacs.length != 0 && !nacsPacs[0]) {
                        this.add(RuleType.ForbidA);
                        continue;
                    }
                    if (nacsPacs.length != 0) {
                        this.add(RuleType.PreserveA);
                        continue;
                    }
                    this.add(RuleType.DeleteA);
                    continue;
                }
                if (this.parameterContains((EList<Parameter>)parameters, (Attribute)attribute.first, (Attribute)attribute.second)) {
                    this.add(RuleType.ChangeAVar);
                    continue;
                }
                this.add(RuleType.ChangeA);
            }
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    private void setTAG() {
        this.TAG = "";
        for (RuleType type : this.types) {
            this.TAG = String.valueOf(this.TAG) + type.TAG;
        }
    }

    private boolean parameterContains(EList<Parameter> ps, Attribute ... as) {
        for (Parameter p : ps) {
            Attribute[] attributeArray = as;
            int n = as.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute a = attributeArray[n2];
                if (p.getName().equals(a.getValue())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void add(RuleType rt) {
        this.types.add(rt);
        this.hash |= rt.id;
    }

    public boolean is(RuleType rt) {
        return (this.hash & rt.id) == rt.id;
    }

    public Set<RuleType> getTypes() {
        return new HashSet<RuleType>(this.types);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuleConfigurator) {
            return this.hash == obj.hashCode();
        }
        return false;
    }

    public String toString() {
        String result = "";
        if (this.is(RuleType.All)) {
            result = ", ALL";
        } else {
            for (RuleType rt : this.types) {
                result = String.valueOf(result) + ", " + rt.name();
            }
        }
        return String.valueOf(this.rule.getName()) + "\t" + (result.isEmpty() ? "" : result.substring(2)) + "\n";
    }

    public String getTAG() {
        this.setTAG();
        return this.TAG;
    }

    public static enum RuleType {
        None(0, "N", "Contains no nodes"),
        Preserve(1, "P", "Preserve nodes"),
        Delete(2, "D", "Delete nodes"),
        Create(4, "C", "Create nodes"),
        Forbid(8, "F", "Forbid nodes"),
        Require(16, "R", "Require nodes"),
        PreserveA(32, "pA", "Nodes with preserve attributes"),
        DeleteA(64, "dA", "Nodes with delete attributes"),
        CreateA(128, "cA", "Nodes with create attributes"),
        ForbidA(256, "fA", "Nodes with forbid attributes"),
        RequireA(512, "rA", "Nodes with require attributes"),
        ChangeA(1024, "chA", "Nodes with changing attributes"),
        PreserveAVar(2048, "paV", "Nodes with attributes that preserve a value of a variable"),
        DeleteAVar(4096, "daV", "Nodes with attributes that delete a value of a variable"),
        CreateAVar(8192, "caV", "Nodes with attributes that create a value of a variable"),
        ForbidAVar(16384, "faV", "Nodes with attributes that forbid a value of a variable"),
        RequireAVar(32768, "raV", "Nodes with attributes that require a value of a variable"),
        ChangeAVar(65536, "chaV", "Nodes with attributes that changing a value of a variable"),
        All(131071, "All", "Contains all kinds of rule type");

        private final int id;
        public final String TAG;
        public final String description;

        private RuleType(int id, String TAG, String description) {
            this.id = id;
            this.description = description;
            this.TAG = TAG;
        }
    }
}

