/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.MultiGranularAnalysis;
import org.eclipse.emf.henshin.multicda.cda.Pair;
import org.eclipse.emf.henshin.multicda.cda.ReasonFactory;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.computation.AtomCandidateComputation;
import org.eclipse.emf.henshin.multicda.cda.computation.ConflictReasonComputation;
import org.eclipse.emf.henshin.multicda.cda.computation.DeleteUseConflictReasonComputation;
import org.eclipse.emf.henshin.multicda.cda.computation.MinimalReasonComputation;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.units.Atom;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public class ConflictAnalysis
implements MultiGranularAnalysis {
    private Rule rule1;
    private Rule rule1INV;
    private Rule rule2;
    private Rule originalR2;
    private Set<Rule> rule2NACs;
    public static int unnamedNodeID = 0;
    private Set<Atom.ConflictAtom> atoms = new HashSet<Atom.ConflictAtom>();
    private Set<ConflictReason> mcrs = new HashSet<ConflictReason>();
    private Set<ConflictReason> crs = new HashSet<ConflictReason>();

    public ConflictAnalysis(Rule rule1, Rule rule2) {
        Utils.checkNull(rule1);
        Utils.checkNull(rule2);
        unnamedNodeID = 0;
        this.rule1 = ConflictAnalysis.prepare(rule1);
        this.originalR2 = ConflictAnalysis.prepare(rule2);
        this.rule2 = this.mergeRequire(this.originalR2);
        this.rule1INV = Utils.invertRuleForForbid(this.rule1);
        this.rule2NACs = Utils.createNACRules(this.rule2);
    }

    public Set<Atom.ConflictAtom> computeAtoms() {
        return this.computeConflictAtoms(new boolean[0]);
    }

    @Override
    public Atom.ConflictAtom computeResultsBinary() {
        Atom.ConflictAtom result = this.hasConflicts();
        if (result == null) {
            return null;
        }
        return result;
    }

    public Set<ConflictReason> computeResultsCoarse() {
        if (this.mcrs.isEmpty()) {
            if (this.allowed()) {
                this.mcrs.addAll(this.computeMinimalDeleteUseConflictReasons(this.rule1, this.rule2));
                this.setRequires(this.mcrs);
            }
            if (this.mcrs.isEmpty()) {
                this.mcrs.addAll(this.computeCreateForbidConflictReasons(true));
            }
        }
        return this.mcrs;
    }

    public Set<ConflictReason> computeResultsFine() {
        if (this.crs.isEmpty()) {
            if (this.allowed()) {
                this.crs.addAll(this.computeDeleteUseConflictReasons(this.rule1, this.rule2));
                this.setRequires(this.crs);
            }
            if (this.crs.isEmpty()) {
                this.crs.addAll(this.computeCreateForbidConflictReasons(false));
            }
        }
        return this.crs;
    }

    private Set<ConflictReason> computeCreateForbidConflictReasons(boolean minimal) {
        HashSet<ConflictReason> result = new HashSet<ConflictReason>();
        for (NestedCondition nc : this.originalR2.getLhs().getNACs()) {
            if (nc.getConclusion().getFormula() == null) continue;
            return result;
        }
        for (Rule r2 : this.rule2NACs) {
            Set<ConflictReason> reasons = minimal ? this.computeMinimalDeleteUseConflictReasons(this.rule1INV, r2) : this.computeDeleteUseConflictReasons(this.rule1INV, r2);
            for (Reason reason : reasons) {
                ConflictReason reason2 = ReasonFactory.eINSTANCE.createForbidReason(reason, this.rule1, this.originalR2);
                if (reason2 == null) continue;
                result.add(reason2);
            }
        }
        return result;
    }

    private Atom.ConflictAtom hasConflicts() {
        Set<Atom.ConflictAtom> cas = this.computeConflictAtoms(true);
        if (cas.isEmpty()) {
            return null;
        }
        return new ArrayList<Atom.ConflictAtom>(cas).get(0);
    }

    private Set<Atom.ConflictAtom> computeConflictAtoms(boolean ... earlyExit) {
        if (this.atoms.isEmpty()) {
            Set<Object> candidates = new HashSet();
            if (this.allowed()) {
                candidates = new AtomCandidateComputation(this.rule1, this.rule2).computeAtomCandidates();
                Set<Atom> set = new AtomCandidateComputation(this.rule2, this.rule1).computeAtomCandidates();
                for (Atom candidate : set) {
                    if (!Utils.attributesCheck(candidate)) continue;
                    HashSet minimalConflictReasons = new HashSet();
                    new MinimalReasonComputation(this.rule2, this.rule1).computeMinimalConflictReasons(candidate, minimalConflictReasons);
                    Set<ConflictReason> crs = Utils.computeCreateEdgeDeleteNode(minimalConflictReasons);
                    if (crs.isEmpty()) continue;
                    this.atoms.add(new Atom.CreateEdgeDeleteNodeConflictAtom(candidate, crs));
                }
                this.setRequires(candidates);
            }
            for (Rule rule : this.rule2NACs) {
                for (Atom a : new AtomCandidateComputation(this.rule1INV, rule).computeAtomCandidates()) {
                    Atom atom = ReasonFactory.eINSTANCE.createForbidAtom(a, this.rule1, this.originalR2);
                    if (atom == null) continue;
                    candidates.add(atom);
                }
            }
            for (Atom atom : candidates) {
                if (!Utils.attributesCheck(atom)) continue;
                HashSet<ConflictReason> minimalConflictReasons = new HashSet<ConflictReason>();
                if (atom.isForbid()) {
                    for (Rule rNac : this.rule2NACs) {
                        if (rNac != atom.getRule2()) continue;
                        new MinimalReasonComputation(this.rule1INV, rNac).computeMinimalConflictReasons(atom, minimalConflictReasons);
                    }
                } else {
                    new MinimalReasonComputation(this.rule1, this.rule2).computeMinimalConflictReasons(atom, minimalConflictReasons);
                }
                Atom.ConflictAtom a = null;
                if (!minimalConflictReasons.isEmpty()) {
                    if (atom instanceof Atom.DeleteConflictAtom) {
                        a = (Atom.ConflictAtom)((Span)new Atom.DeleteConflictAtom(atom, minimalConflictReasons).setForbid(atom.isForbid())).setRequire(atom.isRequire());
                    } else if (atom instanceof Atom.CreateConflictAtom) {
                        a = (Atom.ConflictAtom)((Span)new Atom.CreateConflictAtom(atom, minimalConflictReasons).setForbid(atom.isForbid())).setRequire(atom.isRequire());
                    } else if (atom instanceof Atom.ChangeConflictAtom) {
                        a = (Atom.ConflictAtom)((Span)new Atom.ChangeConflictAtom(atom, minimalConflictReasons).setForbid(atom.isForbid())).setRequire(atom.isRequire());
                    } else {
                        try {
                            throw new Exception("\nUndentified Atom\n\n" + atom + "\n");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.atoms.add(a);
                }
                if (this.atoms.isEmpty() || earlyExit.length <= 0 || !earlyExit[0]) continue;
                Set<Atom.ConflictAtom> temp = this.atoms;
                this.atoms = new HashSet<Atom.ConflictAtom>();
                return temp;
            }
        }
        return this.atoms;
    }

    private Set<ConflictReason> computeMinimalDeleteUseConflictReasons(Rule r1, Rule r2) {
        Set<Object> normalCR = new HashSet();
        Set<Object> DUCR = normalCR = new MinimalReasonComputation(r1, r2).computeMinimalConflictReasons();
        if (r1 != r2) {
            DUCR = new MinimalReasonComputation(r2, r1).computeMinimalConflictReasons();
        }
        return new DeleteUseConflictReasonComputation(r1, r2, normalCR, DUCR).computeDeleteUseConflictReason();
    }

    private Set<ConflictReason> computeDeleteUseConflictReasons(Rule r1, Rule r2) {
        Set<Object> normalCR = new HashSet();
        Set<Object> DUCR = normalCR = new ConflictReasonComputation(r1, r2).computeConflictReasons();
        if (r1 != r2) {
            DUCR = new ConflictReasonComputation(r2, r1).computeConflictReasons();
        }
        return new DeleteUseConflictReasonComputation(r1, r2, normalCR, DUCR).computeDeleteUseConflictReason();
    }

    public static Rule prepare(Rule r) {
        EcoreUtil.Copier ruleC = new EcoreUtil.Copier();
        Rule rule = (Rule)ruleC.copy((EObject)r);
        ruleC.copyReferences();
        rule.getAttributeConditions().clear();
        return ConflictAnalysis.prepareWithACons(rule);
    }

    public static Rule prepareWithACons(Rule r) {
        for (Node n : r.getRhs().getNodes()) {
            if (n.getName() != null && !n.getName().isEmpty()) continue;
            n.setName("|" + unnamedNodeID++ + "|");
            Node origin = r.getMappings().getOrigin(n);
            if (origin == null) continue;
            origin.setName(n.getName());
        }
        for (Node n : r.getLhs().getNodes()) {
            if (n.getName() != null && !n.getName().isEmpty()) continue;
            n.setName("|" + unnamedNodeID++ + "|");
        }
        return r;
    }

    private Pair<Boolean, Node> containsExactNode(Graph g, Node n) {
        Node gN = g.getNode(n.getName());
        if (gN == null) {
            return new Pair<Boolean, Object>(false, null);
        }
        if (gN.getAttributes().size() != n.getAttributes().size()) {
            return new Pair<Boolean, Node>(false, gN);
        }
        for (Attribute a : n.getAttributes()) {
            if (gN.getAttribute(a.getType()) != null) continue;
            return new Pair<Boolean, Node>(false, gN);
        }
        return new Pair<Boolean, Node>(true, gN);
    }

    private Rule mergeRequire(Rule rule) {
        Rule newRule = rule = ConflictAnalysis.prepare(rule);
        Set<Rule> rNCs = Utils.createPACRules(rule);
        for (Rule rNC : rNCs) {
            Node target;
            Node source;
            Pair<Boolean, Node> contains;
            if (newRule == rule) {
                newRule = rNC;
                continue;
            }
            HashSet nodes = new HashSet(rNC.getLhs().getNodes());
            for (Node n : nodes) {
                contains = this.containsExactNode(newRule.getLhs(), n);
                if (!((Boolean)contains.first).booleanValue() && contains.second == null) {
                    n.setGraph(newRule.getLhs());
                    continue;
                }
                if (contains.second == null) continue;
                for (Attribute a : n.getAttributes()) {
                    if (((Node)contains.second).getAttribute(a.getType()) != null) continue;
                    HenshinFactory.eINSTANCE.createAttribute((Node)contains.second, a.getType(), a.getValue());
                }
            }
            nodes = new HashSet(rNC.getRhs().getNodes());
            for (Node n : nodes) {
                contains = this.containsExactNode(newRule.getRhs(), n);
                if (!((Boolean)contains.first).booleanValue() && contains.second == null) {
                    n.setGraph(newRule.getRhs());
                    continue;
                }
                if (contains.second == null) continue;
                for (Attribute a : n.getAttributes()) {
                    if (((Node)contains.second).getAttribute(a.getType()) != null) continue;
                    HenshinFactory.eINSTANCE.createAttribute((Node)contains.second, a.getType(), a.getValue());
                }
            }
            for (Edge e : rNC.getLhs().getEdges()) {
                source = e.getSource();
                if (!newRule.getLhs().getNodes().contains((Object)source)) {
                    source = newRule.getLhs().getNode(source.getName());
                }
                target = e.getTarget();
                if (!newRule.getLhs().getNodes().contains((Object)target)) {
                    target = newRule.getLhs().getNode(target.getName());
                }
                if (source.getOutgoing(e.getType(), target) != null) continue;
                newRule.getLhs().getEdges().add((Object)HenshinFactory.eINSTANCE.createEdge(source, target, e.getType()));
            }
            for (Edge e : rNC.getRhs().getEdges()) {
                source = e.getSource();
                if (!newRule.getRhs().getNodes().contains((Object)source)) {
                    source = newRule.getRhs().getNode(source.getName());
                }
                target = e.getTarget();
                if (!newRule.getRhs().getNodes().contains((Object)target)) {
                    target = newRule.getRhs().getNode(target.getName());
                }
                if (source.getOutgoing(e.getType(), target) != null) continue;
                newRule.getRhs().getEdges().add((Object)HenshinFactory.eINSTANCE.createEdge(source, target, e.getType()));
            }
            for (Mapping map : rNC.getMappings()) {
                if (newRule.getLhs().getNodes().contains((Object)map.getImage())) {
                    newRule.getMappings().add((Object)HenshinFactory.eINSTANCE.createMapping(newRule.getMappings().getOrigin(map.getImage()), map.getImage()));
                    continue;
                }
                Node origin = map.getOrigin();
                if (!newRule.getLhs().getNodes().contains((Object)origin)) {
                    origin = newRule.getLhs().getNode(origin.getName());
                }
                Node image = map.getImage();
                if (!newRule.getRhs().getNodes().contains((Object)image)) {
                    image = newRule.getRhs().getNode(image.getName());
                }
                if (newRule.getMappings().getOrigin(image) == origin) continue;
                newRule.getMappings().add((Object)HenshinFactory.eINSTANCE.createMapping(origin, image));
            }
        }
        return newRule;
    }

    public boolean allowed() {
        HashMap<Object, Object> result;
        Node mappedNode;
        HashSet<Node> l1 = new HashSet<Node>((Collection<Node>)this.rule1.getLhs().getNodes());
        HashSet<Node> l2 = new HashSet<Node>((Collection<Node>)this.originalR2.getLhs().getNodes());
        HashSet<Node> f = new HashSet<Node>();
        HashSet<Node> l1InNac = new HashSet<Node>();
        HashSet<Node> l2InNac = new HashSet<Node>();
        boolean allowed1 = true;
        boolean allowed2 = true;
        boolean nac2Allowed = false;
        boolean nac1Allowed = false;
        for (NestedCondition nc : this.originalR2.getLhs().getNACs()) {
            for (Node fn : nc.getConclusion().getNodes()) {
                mappedNode = nc.getMappings().getOrigin(fn);
                if (mappedNode == null) {
                    f.add(fn);
                    continue;
                }
                if (fn.getAttributes().size() != mappedNode.getAttributes().size()) {
                    l2.remove(mappedNode);
                    f.add(fn);
                    continue;
                }
                l2InNac.add(fn);
            }
            if (!f.isEmpty()) {
                boolean allNodesMapped;
                result = new HashMap<Node, Node>();
                f.addAll(l2InNac);
                Utils.mapNodes(l1, f, result, true);
                boolean bl = allNodesMapped = result.size() == f.size();
                nac2Allowed = allNodesMapped ? this.checkValidityOfMapping(result) : true;
            } else {
                nac2Allowed = true;
            }
            f.clear();
            l2InNac.clear();
            boolean bl = allowed1 = allowed1 && nac2Allowed;
        }
        l2 = new HashSet(this.originalR2.getLhs().getNodes());
        l1 = new HashSet(this.rule1.getLhs().getNodes());
        for (NestedCondition nc : this.rule1.getLhs().getNACs()) {
            for (Node fn : nc.getConclusion().getNodes()) {
                mappedNode = nc.getMappings().getOrigin(fn);
                if (mappedNode == null) {
                    f.add(fn);
                    continue;
                }
                if (fn.getAttributes().size() != mappedNode.getAttributes().size()) {
                    l1.remove(mappedNode);
                    f.add(fn);
                    continue;
                }
                l1InNac.add(fn);
            }
            if (!f.isEmpty()) {
                boolean allNodesMapped;
                result = new HashMap();
                f.addAll(l1InNac);
                Utils.mapNodes(l2, f, result, true);
                boolean bl = allNodesMapped = result.size() == f.size();
                nac1Allowed = allNodesMapped ? this.checkValidityOfMapping(result) : true;
            } else {
                nac1Allowed = true;
            }
            f.clear();
            l1InNac.clear();
            boolean bl = allowed2 = allowed2 && nac1Allowed;
        }
        return allowed1 && allowed2;
    }

    private boolean checkValidityOfMapping(Map<Node, Node> result) {
        Set<Node> mappedNodes = result.keySet();
        for (Node n : mappedNodes) {
            if (n.getOutgoing().size() != result.get(n).getOutgoing().size() || n.getIncoming().size() != result.get(n).getIncoming().size()) {
                return true;
            }
            if (n.getOutgoing().size() != result.get(n).getOutgoing().size()) continue;
            for (Edge e : n.getOutgoing()) {
                if (result.containsKey(e.getTarget())) continue;
                return true;
            }
            if (n.getIncoming().size() != result.get(n).getIncoming().size()) continue;
            for (Edge e : n.getIncoming()) {
                if (result.containsKey(e.getSource())) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends Span> Set<T> setRequires(Set<T> spans) {
        for (Span s : spans) {
            boolean found = false;
            for (Node nn : s.getGraph().getNodes()) {
                Node n2 = s.getMappingIntoRule2(nn).getImage();
                found = Utils.isRealNcNode(n2, false);
                if (found) break;
            }
            if (!found) {
                for (Edge e : s.getGraph().getEdges()) {
                    Node n2Source = s.getMappingIntoRule2(e.getSource()).getImage();
                    Node n2Target = s.getMappingIntoRule2(e.getTarget()).getImage();
                    n2Source = s.getRule2().getMappings().getOrigin(n2Source);
                    n2Target = s.getRule2().getMappings().getOrigin(n2Target);
                    if (n2Source != null && n2Target != null && (found = n2Source.getOutgoing(e.getType(), n2Target) == null)) break;
                }
            }
            if (!found) continue;
            ReasonFactory.eINSTANCE.createRequireReason(s);
        }
        return spans;
    }
}

