/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.debug;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.compare.internal.CompareAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.interpreter.Change;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.debug.HenshinDebugTarget;
import org.eclipse.emf.henshin.interpreter.impl.DebugEngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.MatchImpl;
import org.eclipse.emf.henshin.interpreter.matching.conditions.DebugApplicationCondition;
import org.eclipse.emf.henshin.interpreter.matching.constraints.Solution;
import org.eclipse.emf.henshin.interpreter.ui.debug.ParamUtil;
import org.eclipse.emf.henshin.interpreter.ui.util.ParameterConfig;
import org.eclipse.emf.henshin.interpreter.ui.util.TransformOperation;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterKind;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class LaunchRuleDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String modulePath = configuration.getAttribute("MODULE_PATH", "");
        String unitName = configuration.getAttribute("UNIT_NAME", "");
        String inputURIString = configuration.getAttribute("INPUT_URI", "");
        String outputURIString = configuration.getAttribute("OUTPUT_URI", "");
        Map paramTypes = configuration.getAttribute("PARAMETER_TYPES", new HashMap());
        Map paramValues = configuration.getAttribute("PARAMETER_VALUES", new HashMap());
        List unsetParamNames = configuration.getAttribute("UNSET_PARAMETERS", new ArrayList());
        boolean openCompare = configuration.getAttribute("OPEN_COMPARE", true);
        URI moduleUri = URI.createURI((String)modulePath);
        HenshinResourceSet resourceSet = new HenshinResourceSet();
        Module module = resourceSet.getModule(moduleUri, false);
        Resource oldModuleResource = module.eResource();
        Resource newModuleResource = resourceSet.createResource(oldModuleResource.getURI());
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection copies = copier.copyAll((Collection)oldModuleResource.getContents());
        copier.copyReferences();
        newModuleResource.getContents().addAll(copies);
        module = (Module)copier.get((Object)module);
        for (EPackage ePackage : module.getImports()) {
            resourceSet.getPackageRegistry().put((Object)ePackage.getNsURI(), (Object)ePackage);
        }
        final Unit unit = module.getUnit(unitName);
        List<ParameterConfig> paramConfigs = ParamUtil.getParameterPreferences(unit);
        ParamUtil.fillParamConfigs(paramConfigs, paramTypes, paramValues, unsetParamNames);
        URI inputUri = URI.createURI((String)inputURIString);
        URI outputUri = URI.createURI((String)outputURIString);
        TransformOperation transformOperation = new TransformOperation();
        transformOperation.setUnit(unit, paramConfigs);
        transformOperation.setInputURI(inputUri);
        transformOperation.setOutputURI(outputUri);
        Iterator<ParameterConfig> iterator = transformOperation.getParameterConfigurations().iterator();
        while (iterator.hasNext()) {
            ParameterConfig paramConfig = iterator.next();
            if (paramConfig.getKind() != ParameterKind.VAR && paramConfig.getKind() != ParameterKind.OUT) continue;
            iterator.remove();
        }
        if (mode.equals("debug")) {
            final DebugEngineImpl engine = new DebugEngineImpl();
            HenshinDebugTarget target = new HenshinDebugTarget(launch, unitName);
            engine.setDebugTarget(target);
            Resource input = resourceSet.getResource(inputUri, true);
            EGraphImpl graph = new EGraphImpl(input);
            Rule rule = null;
            try {
                rule = (Rule)unit;
            }
            catch (ClassCastException classCastException) {
                final String configName = configuration.getName();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        MessageDialog.openError((Shell)shell, (String)configName, (String)"The selected unit is not a rule");
                    }
                });
            }
            MatchImpl partialMatch = new MatchImpl(rule);
            for (Parameter param : rule.getParameters()) {
                if (param.getKind() == ParameterKind.VAR || param.getKind() == ParameterKind.OUT) continue;
                partialMatch.setParameterValue(param, transformOperation.getParameterValue(param.getName()));
            }
            DebugApplicationCondition applicationCondition = engine.getDebugApplicationCondition(rule, (EGraph)graph, (Match)partialMatch, new Observer((EGraph)graph, inputUri, outputUri, input, resourceSet, monitor, configuration, openCompare){
                private final /* synthetic */ EGraph val$graph;
                private final /* synthetic */ URI val$inputUri;
                private final /* synthetic */ URI val$outputUri;
                private final /* synthetic */ Resource val$input;
                private final /* synthetic */ HenshinResourceSet val$resourceSet;
                private final /* synthetic */ IProgressMonitor val$monitor;
                private final /* synthetic */ ILaunchConfiguration val$configuration;
                private final /* synthetic */ boolean val$openCompare;
                {
                    this.val$graph = eGraph;
                    this.val$inputUri = uRI;
                    this.val$outputUri = uRI2;
                    this.val$input = resource;
                    this.val$resourceSet = henshinResourceSet;
                    this.val$monitor = iProgressMonitor;
                    this.val$configuration = iLaunchConfiguration;
                    this.val$openCompare = bl;
                }

                @Override
                public void update(Observable o, Object arg) {
                    Resource output;
                    if (!(arg instanceof Solution)) {
                        throw new IllegalStateException("update arg has to be of type Solution, but is of type " + arg.getClass().getSimpleName());
                    }
                    Solution solution = (Solution)arg;
                    Match completeMatch = engine.getMatchFinder().basicMatchFromSolution(solution);
                    MatchImpl resultMatch = new MatchImpl((Rule)unit, true);
                    Change change = engine.createChange((Rule)unit, this.val$graph, completeMatch, (Match)resultMatch);
                    change.applyAndReverse();
                    if (this.val$inputUri.equals(this.val$outputUri)) {
                        output = this.val$input;
                    } else {
                        output = this.val$resourceSet.createResource(this.val$outputUri);
                        output.getContents().addAll((Collection)this.val$input.getContents());
                    }
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    options.put("SCHEMA_LOCATION", Boolean.TRUE);
                    try {
                        output.save(options);
                        if (this.val$outputUri.isPlatformResource()) {
                            Path path = new Path(this.val$outputUri.toPlatformString(false));
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                            if (file != null) {
                                file.getParent().refreshLocal(2, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)this.val$monitor, (int)2));
                            }
                        }
                    }
                    catch (IOException | CoreException e) {
                        e.printStackTrace();
                        LaunchRuleDelegate.this.displayMessage(this.val$configuration, "Error saving transformation result.");
                    }
                    if (this.val$openCompare) {
                        LaunchRuleDelegate.this.openCompareView(this.val$inputUri, this.val$outputUri);
                    }
                }
            });
            IFile moduleResource = moduleUri.isPlatform() ? ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(moduleUri.toPlatformString(true))) : this.findResourceForModulePath(modulePath);
            engine.getDebugTarget().initTarget(applicationCondition, (IResource)moduleResource);
            launch.addDebugTarget((IDebugTarget)engine.getDebugTarget());
            applicationCondition.initNextVariable();
        } else if (mode.equals("run")) {
            try {
                transformOperation.run(monitor);
                if (openCompare) {
                    this.openCompareView(inputUri, outputUri);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    this.displayMessage(configuration, e.getCause().getMessage());
                } else {
                    this.displayMessage(configuration, "Error applying transformation");
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void displayMessage(ILaunchConfiguration configuration, final String message) {
        final String configName = configuration.getName();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)configName, (String)message);
            }
        });
    }

    private IFile findResourceForModulePath(String modulePath) throws CoreException {
        try {
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(FileLocator.resolve((URL)java.net.URI.create(modulePath).toURL()).toURI());
            if (files.length > 0) {
                return files[0];
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.emf.henshin.interpreter.ui", "Didn't find resource for modulePath '" + modulePath + "'."));
    }

    private void openCompareView(URI inputUri, URI outputUri) {
        IFile left = ParamUtil.getIFile(outputUri);
        IFile right = ParamUtil.getIFile(inputUri);
        if (left != null && right != null) {
            try {
                StructuredSelection selection = new StructuredSelection(new Object[]{left, right});
                Display.getDefault().asyncExec(new Runnable((ISelection)selection){
                    private final /* synthetic */ ISelection val$selection;
                    {
                        this.val$selection = iSelection;
                    }

                    @Override
                    public void run() {
                        MyCompareAction c = new MyCompareAction();
                        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                        c.setActivePart(null, part);
                        c.run(this.val$selection);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class MyCompareAction
    extends CompareAction {
        private MyCompareAction() {
        }

        public void run(ISelection selection) {
            if (super.isEnabled(selection)) {
                super.run(selection);
            }
        }
    }
}

