/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.ui.giraph;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.henshin.giraph.GiraphGenerator;
import org.eclipse.emf.henshin.giraph.GiraphValidator;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class GenerateGiraphCodeWizard
extends Wizard {
    private final GiraphGenerator generator;

    public GenerateGiraphCodeWizard(Unit unit) {
        this.setWindowTitle("Henshin Giraph Code Generator");
        this.setNeedsProgressMonitor(true);
        this.generator = new GiraphGenerator();
        this.generator.setMainUnit(unit);
    }

    public void addPages() {
        this.addPage((IWizardPage)new GiraphPage());
    }

    public boolean performFinish() {
        final ArrayList javaFile = new ArrayList();
        final ArrayList exception = new ArrayList();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        javaFile.add(GenerateGiraphCodeWizard.this.generator.generate(monitor));
                    }
                    catch (CoreException e) {
                        exception.add(e);
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (!exception.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)((CoreException)((Object)exception.get(0))).getMessage());
            ((CoreException)((Object)exception.get(0))).printStackTrace();
        } else {
            IWorkbench wb = PlatformUI.getWorkbench();
            IEditorDescriptor desc = wb.getEditorRegistry().getDefaultEditor(((IFile)javaFile.get(0)).getName());
            try {
                wb.getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput((IFile)javaFile.get(0)), desc.getId());
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            }
        }
        return true;
    }

    private class GiraphPage
    extends WizardPage {
        Text projectNameText;
        Text packageNameText;
        Text classNameText;
        Button masterLoggingCheckBox;
        Button vertexLoggingCheckBox;
        Button uuidsCheckBox;
        Button testEnvCheckBox;

        public GiraphPage() {
            super("Giraph");
            this.setTitle("Henshin Giraph Code Generator");
            this.setDescription("Enter the details for the Giraph code generation");
        }

        private void validate() {
            IStatus status = GenerateGiraphCodeWizard.this.generator.validateAll();
            this.setMessage(status.getSeverity() == 2 ? status.getMessage() : null, 2);
            this.setErrorMessage(status.getSeverity() == 4 ? status.getMessage() : null);
            this.setPageComplete(status.getSeverity() != 4);
        }

        public void createControl(Composite parent) {
            Composite comp = new Composite(parent, 4);
            comp.setLayout((Layout)new GridLayout(1, true));
            Group group = new Group(comp, 0);
            group.setText("Paths");
            GridData data = new GridData(4, 1, true, false);
            data.horizontalSpan = 2;
            group.setLayoutData((Object)data);
            group.setLayout((Layout)new GridLayout(2, false));
            Label label = new Label((Composite)group, 0);
            label.setText("Project Name:");
            label.setLayoutData((Object)new GridData(128));
            this.projectNameText = new Text((Composite)group, 2048);
            this.projectNameText.setLayoutData((Object)new GridData(768));
            this.projectNameText.setText(String.valueOf(GenerateGiraphCodeWizard.this.generator.getProjectName()));
            this.projectNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setProjectName(GiraphPage.this.projectNameText.getText());
                    GiraphPage.this.validate();
                }
            });
            label = new Label((Composite)group, 0);
            label.setText("Package Name:");
            label.setLayoutData((Object)new GridData(128));
            this.packageNameText = new Text((Composite)group, 2048);
            this.packageNameText.setLayoutData((Object)new GridData(768));
            this.packageNameText.setText(String.valueOf(GenerateGiraphCodeWizard.this.generator.getPackageName()));
            this.packageNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setPackageName(GiraphPage.this.packageNameText.getText());
                    GiraphPage.this.validate();
                }
            });
            label = new Label((Composite)group, 0);
            label.setText("Compute Class Name:");
            label.setLayoutData((Object)new GridData(128));
            this.classNameText = new Text((Composite)group, 2048);
            this.classNameText.setLayoutData((Object)new GridData(768));
            this.classNameText.setText(String.valueOf(GenerateGiraphCodeWizard.this.generator.getClassName()));
            this.classNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setClassName(GiraphPage.this.classNameText.getText());
                    GiraphPage.this.validate();
                }
            });
            group = new Group(comp, 0);
            group.setText("Options");
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setLayout((Layout)new GridLayout(4, false));
            label = new Label((Composite)group, 0);
            label.setText("Use Java UUIDs as Vertex IDs:");
            label.setLayoutData((Object)new GridData(128));
            this.uuidsCheckBox = new Button((Composite)group, 32);
            this.uuidsCheckBox.setSelection(GenerateGiraphCodeWizard.this.generator.isUseUUIDs());
            this.uuidsCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setUseUUIDs(GiraphPage.this.uuidsCheckBox.getSelection());
                    GiraphPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            label = new Label((Composite)group, 0);
            label.setText("     Enable Master Logging:");
            label.setLayoutData((Object)new GridData(128));
            this.masterLoggingCheckBox = new Button((Composite)group, 32);
            this.masterLoggingCheckBox.setSelection(GenerateGiraphCodeWizard.this.generator.isMasterLogging());
            this.masterLoggingCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setMasterLogging(GiraphPage.this.masterLoggingCheckBox.getSelection());
                    GiraphPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            label = new Label((Composite)group, 0);
            label.setText("Install Test Environment (Hadoop 0.20.203.0, Linux only):");
            label.setLayoutData((Object)new GridData(128));
            this.testEnvCheckBox = new Button((Composite)group, 32);
            this.testEnvCheckBox.setEnabled(GiraphValidator.validatePlatformForTesting().getSeverity() != 4);
            this.testEnvCheckBox.setSelection(false);
            GenerateGiraphCodeWizard.this.generator.setTestEnvironment(false);
            this.testEnvCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setTestEnvironment(GiraphPage.this.testEnvCheckBox.getSelection());
                    GiraphPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.testEnvCheckBox.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent arg0) {
                }

                public void focusGained(FocusEvent arg0) {
                    GiraphPage.this.validate();
                }
            });
            label = new Label((Composite)group, 0);
            label.setText("     Enable Vertex Logging:");
            label.setLayoutData((Object)new GridData(128));
            this.vertexLoggingCheckBox = new Button((Composite)group, 32);
            this.vertexLoggingCheckBox.setSelection(GenerateGiraphCodeWizard.this.generator.isVertexLogging());
            this.vertexLoggingCheckBox.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ((GiraphPage)GiraphPage.this).GenerateGiraphCodeWizard.this.generator.setVertexLogging(GiraphPage.this.vertexLoggingCheckBox.getSelection());
                    GiraphPage.this.validate();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.validate();
            this.setControl((Control)comp);
        }
    }
}

