/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.AttrContext;
import agg.attribute.AttrInstance;
import agg.attribute.AttrType;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.util.Pair;
import agg.util.Triple;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Match;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public final class ExcludePairHelper {
    static int count1;
    static int count2;

    public static boolean isMatchValid(Rule r, Match m, OrdinaryMorphism nac_NotToCheck, boolean firstRule, Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping) {
        boolean withNACs = true;
        m.getTarget().setCompleteGraph(false);
        if (!m.isTotal()) {
            return false;
        }
        if (!m.isValid(true)) {
            return false;
        }
        if (withNACs) {
            boolean nacOK = true;
            List<OrdinaryMorphism> nacs = r.getNACsList();
            int l = 0;
            while (l < nacs.size() && nacOK) {
                OrdinaryMorphism nacStar;
                OrdinaryMorphism nac = nacs.get(l);
                if (nac.isEnabled() && (nac_NotToCheck == null || nac_NotToCheck != nac) && (nacStar = (OrdinaryMorphism)m.checkNAC(nac, true)) != null) {
                    if (firstRule) {
                        nacStar.dispose();
                        nacStar = null;
                        return false;
                    }
                    if (!(ExcludePairHelper.hasVariableInContext(nac, r.getAttrContext()) || ExcludePairHelper.hasConstantToVariableMappingInContext(nacStar) || ExcludePairHelper.hasConstantInAttrOfNewObj(nac))) {
                        nacStar.dispose();
                        nacStar = null;
                        return false;
                    }
                    nacStar.dispose();
                    nacStar = null;
                }
                ++l;
            }
        }
        return true;
    }

    protected static boolean hasVariableInContext(OrdinaryMorphism morph, AttrContext relatedAttrContext) {
        CondTuple conds;
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        return ExcludePairHelper.hasVarInContext(vars, conds = (CondTuple)morph.getAttrContext().getConditions(), morph, relatedAttrContext, morph.getTarget().getNodesSet().iterator()) || ExcludePairHelper.hasVarInContext(vars, conds, morph, relatedAttrContext, morph.getTarget().getArcsSet().iterator());
    }

    protected static boolean hasVarInContext(VarTuple vars, CondTuple conds, OrdinaryMorphism morph, AttrContext relatedAttrContext, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null) continue;
            if (!morph.getInverseImage(o).hasMoreElements()) {
                ValueTuple vt = (ValueTuple)o.getAttribute();
                int k = 0;
                while (k < vt.getSize()) {
                    ValueMember vm = vt.getValueMemberAt(k);
                    if (vm.isSet() && vm.getExpr().isVariable()) {
                        VarMember varm = null;
                        varm = relatedAttrContext == null ? vars.getVarMemberAt(vm.getExprAsText()) : ((VarTuple)relatedAttrContext.getVariables()).getVarMemberAt(vm.getExprAsText());
                        if (varm != null && varm.isInputParameter()) {
                            return true;
                        }
                        int i = 0;
                        while (i < conds.getSize()) {
                            CondMember cm = (CondMember)conds.getValueMemberAt(i);
                            if (cm.getAllVariableNamesOfExpression().contains(vm.getExprAsText())) {
                                return true;
                            }
                            ++i;
                        }
                    }
                    ++k;
                }
                continue;
            }
            GraphObject src = morph.getInverseImage(o).nextElement();
            ValueTuple srcvt = (ValueTuple)src.getAttribute();
            ValueTuple vt = (ValueTuple)o.getAttribute();
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                ValueMember srcvm = srcvt.getValueMemberAt(k);
                if (srcvm != null && vm.isSet() && vm.getExpr().isVariable() && !srcvm.isSet()) {
                    VarMember varm = null;
                    varm = relatedAttrContext == null ? vars.getVarMemberAt(vm.getExprAsText()) : ((VarTuple)relatedAttrContext.getVariables()).getVarMemberAt(vm.getExprAsText());
                    if (varm != null) {
                        if (varm.isInputParameter()) {
                            return true;
                        }
                        int i = 0;
                        while (i < conds.getSize()) {
                            CondMember cm = (CondMember)conds.getValueMemberAt(i);
                            if (cm.getAllVariableNamesOfExpression().contains(vm.getExprAsText())) {
                                return true;
                            }
                            ++i;
                        }
                    }
                }
                ++k;
            }
        }
        return false;
    }

    protected static boolean hasConstantToVariableMappingInContext(OrdinaryMorphism morph) {
        Enumeration<GraphObject> e = morph.getDomain();
        while (e.hasMoreElements()) {
            GraphObject o = e.nextElement();
            GraphObject img = morph.getImage(o);
            if (o.getAttribute() == null || img.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)o.getAttribute();
            ValueTuple vtimg = (ValueTuple)img.getAttribute();
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                ValueMember vmimg = vtimg.getValueMemberAt(vm.getName());
                if (vmimg != null && vm.getExpr() != null && vm.getExpr().isConstant() && vmimg.getExpr() != null && vmimg.getExpr().isVariable()) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    protected static boolean hasConstantInAttrOfNewObj(OrdinaryMorphism morph) {
        return ExcludePairHelper.hasConstInAttrOfNewObj(morph, morph.getTarget().getNodesSet().iterator()) || ExcludePairHelper.hasConstInAttrOfNewObj(morph, morph.getTarget().getArcsSet().iterator());
    }

    protected static boolean hasConstInAttrOfNewObj(OrdinaryMorphism morph, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null || morph.getInverseImage(o).hasMoreElements()) continue;
            ValueTuple vt = (ValueTuple)o.getAttribute();
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.getExpr() != null && vm.getExpr().isConstant()) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    protected static boolean hasVariableInAttrOfNewObj(OrdinaryMorphism morph) {
        return ExcludePairHelper.hasVarInAttrOfNewObj(morph, morph.getTarget().getNodesSet().iterator()) || ExcludePairHelper.hasVarInAttrOfNewObj(morph, morph.getTarget().getArcsSet().iterator());
    }

    protected static boolean hasVarInAttrOfNewObj(OrdinaryMorphism morph, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null || morph.getInverseImage(o).hasMoreElements()) continue;
            ValueTuple vt = (ValueTuple)o.getAttribute();
            int k = 0;
            while (k < vt.getSize()) {
                ValueMember vm = vt.getValueMemberAt(k);
                if (vm.getExpr() != null && vm.getExpr().isVariable()) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    protected static boolean graphSatisfiesTypeMaxMultiplicity(OrdinaryMorphism morph) {
        TypeError error = morph.getTarget().getTypeSet().checkTypeMaxMultiplicity(morph.getTarget(), 20);
        return error == null;
    }

    protected static boolean isAttrMemberChangedFromLeftToRight(Rule rule1, Rule rule2, ValueMember changedLeftMemberOfRule1, GraphObject lhsRule1Object, GraphObject lhsRule2Object, OrdinaryMorphism nacInsideOverlapGraph, GraphObject overlapObject) {
        ValueMember vm;
        boolean result = false;
        ValueMember rightMember = (ValueMember)lhsRule2Object.getAttribute().getMemberAt(changedLeftMemberOfRule1.getName());
        if (rightMember == null) {
            return result;
        }
        GraphObject r1Object = rule1.getImage(lhsRule1Object);
        ValueMember l1Member = (ValueMember)lhsRule1Object.getAttribute().getMemberAt(changedLeftMemberOfRule1.getName());
        ValueMember r1Member = (ValueMember)r1Object.getAttribute().getMemberAt(changedLeftMemberOfRule1.getName());
        if (rightMember.isSet()) {
            if (rightMember.getExpr().isConstant()) {
                if (r1Member.isSet()) {
                    if (r1Member.getExpr().isConstant()) {
                        ValueMember vm2;
                        if (!r1Member.getExprAsText().equals(rightMember.getExprAsText())) {
                            if (nacInsideOverlapGraph != null) {
                                ValueMember vm3;
                                if (overlapObject.getContextUsage() == nacInsideOverlapGraph.hashCode() && (vm3 = (ValueMember)overlapObject.getAttribute().getMemberAt(r1Member.getName())).getExpr().isConstant()) {
                                    result = true;
                                }
                            } else {
                                result = true;
                            }
                        } else if (nacInsideOverlapGraph != null && overlapObject.getContextUsage() == nacInsideOverlapGraph.hashCode() && (vm2 = (ValueMember)overlapObject.getAttribute().getMemberAt(r1Member.getName())).getExpr().isConstant() && !vm2.getExprAsText().equals(r1Member.getExprAsText())) {
                            result = true;
                        }
                    } else if (r1Member.getExpr().isVariable()) {
                        if (!l1Member.isSet()) {
                            result = true;
                        } else if (!l1Member.getExprAsText().equals(r1Member.getExprAsText())) {
                            result = true;
                        }
                    } else {
                        result = true;
                    }
                }
            } else if (rightMember.getExpr().isVariable()) {
                ValueMember vm4;
                int k;
                Vector<ValueMember> variableMember;
                GraphObject grob;
                if (!rightMember.isTransient()) {
                    result = true;
                }
                String variableName = rightMember.getExprAsText();
                Iterator<GraphObject> en = rule2.getLeft().getNodesSet().iterator();
                while (!result && en.hasNext()) {
                    grob = en.next();
                    variableMember = ExcludePairHelper.findMemberWhichUsesVariable(variableName, grob);
                    if (variableMember == null) continue;
                    k = 0;
                    while (k < variableMember.size() && !result) {
                        vm4 = variableMember.elementAt(k);
                        if (vm4.hashCode() != rightMember.hashCode()) {
                            result = true;
                        }
                        ++k;
                    }
                    variableMember = null;
                }
                en = rule2.getLeft().getArcsSet().iterator();
                while (!result && en.hasNext()) {
                    grob = en.next();
                    variableMember = ExcludePairHelper.findMemberWhichUsesVariable(variableName, grob);
                    if (variableMember != null) {
                        k = 0;
                        while (k < variableMember.size() && !result) {
                            vm4 = variableMember.elementAt(k);
                            if (vm4.hashCode() != rightMember.hashCode()) {
                                result = true;
                            }
                            ++k;
                        }
                    }
                    variableMember = null;
                }
            }
        } else if (nacInsideOverlapGraph != null && overlapObject.getContextUsage() == nacInsideOverlapGraph.hashCode() && (vm = (ValueMember)overlapObject.getAttribute().getMemberAt(r1Member.getName())).getExpr().isConstant()) {
            result = true;
        }
        return result;
    }

    protected static boolean isAttrMemberChangedFromPACRule2ToRight(Rule rule1, Rule rule2, GraphObject l1Object, GraphObject overlapObject, Pair<OrdinaryMorphism, OrdinaryMorphism> helpPair) {
        boolean result = false;
        Enumeration<GraphObject> l2Objects = ((OrdinaryMorphism)helpPair.second).getInverseImage(overlapObject);
        if (l2Objects.hasMoreElements()) {
            GraphObject l2Object = l2Objects.nextElement();
            Vector<ValueMember> changedMembersR1 = ExcludePairHelper.getChangedAttributeMember(rule1, l1Object);
            if (changedMembersR1 != null) {
                int j = 0;
                while (j < changedMembersR1.size() && !result) {
                    ValueMember leftMember = changedMembersR1.elementAt(j);
                    ValueMember rightMember = (ValueMember)l2Object.getAttribute().getMemberAt(leftMember.getName());
                    if (rightMember.isSet()) {
                        GraphObject r1Object = rule1.getImage(l1Object);
                        ValueMember l1Member = (ValueMember)l1Object.getAttribute().getMemberAt(leftMember.getName());
                        ValueMember r1Member = (ValueMember)r1Object.getAttribute().getMemberAt(leftMember.getName());
                        if (rightMember.getExpr().isConstant()) {
                            if (r1Member.isSet() && (!r1Member.getExpr().isConstant() || !r1Member.getExpr().equals(l1Member.getExpr()) && !r1Member.getExpr().equals(rightMember.getExpr()))) {
                                result = true;
                            }
                        } else if (rightMember.getExpr().isVariable() && !rightMember.isTransient()) {
                            result = true;
                        }
                    }
                    ++j;
                }
                changedMembersR1 = null;
            }
        }
        return result;
    }

    protected static boolean isAttrMemberChangedFromNACRule2ToRight(Rule rule1, Rule rule2, Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping, OrdinaryMorphism nacInsideOverlapGraph, List<GraphObject> changedAttributesR1, List<Type> forbiddenTypesR2, Hashtable<ValueMember, Pair<String, String>> attrMember2Constant) {
        boolean result = false;
        Match match2 = (Match)overlapping.second;
        List<OrdinaryMorphism> nacs = rule2.getNACsList();
        int l = 0;
        while (l < nacs.size() && !result) {
            OrdinaryMorphism nac = nacs.get(l);
            if (nac.isEnabled()) {
                OrdinaryMorphism nacStar = (OrdinaryMorphism)match2.checkNAC(nac, true);
                if (nacInsideOverlapGraph == null) {
                    if (nacStar != null) {
                        if (!ExcludePairHelper.hasVariableInContext(nac)) {
                            return false;
                        }
                    } else if (ExcludePairHelper.hasConstantInAttrOfNewObj(nac)) {
                        Hashtable<Object, Object> var2const = new Hashtable();
                        var2const = ExcludePairHelper.replaceConstantByNull(rule2, nac);
                        if (!var2const.isEmpty()) {
                            nacStar = (OrdinaryMorphism)match2.checkNAC(nac, true);
                            ExcludePairHelper.replaceNullByConstant(rule2, nac, var2const);
                            var2const.clear();
                        }
                        var2const = null;
                    }
                }
                if (nacStar != null) {
                    Iterator<GraphObject> l1Objs = ((OrdinaryMorphism)overlapping.first).getSource().getNodesSet().iterator();
                    boolean nodechanged = ExcludePairHelper.checkNACStarAttributes(rule1, rule2, nac, nacStar, match2, l1Objs, overlapping, changedAttributesR1, forbiddenTypesR2, attrMember2Constant);
                    if (!nacStar.isEnabled()) {
                        return false;
                    }
                    l1Objs = ((OrdinaryMorphism)overlapping.first).getSource().getArcsSet().iterator();
                    boolean arcchanged = ExcludePairHelper.checkNACStarAttributes(rule1, rule2, nac, nacStar, match2, l1Objs, overlapping, changedAttributesR1, forbiddenTypesR2, attrMember2Constant);
                    if (!nacStar.isEnabled()) {
                        return false;
                    }
                    if (!nodechanged && !arcchanged) {
                        result = false;
                    } else {
                        ((OrdinaryMorphism)overlapping.first).getTarget().setHelpInfo(nac.getName());
                        result = true;
                    }
                }
            }
            ++l;
        }
        return result;
    }

    public static void renameContextVariableOfOverlappingPair(Rule r1, Rule r2, Pair<OrdinaryMorphism, OrdinaryMorphism> pair, String prefix1, String prefix2) {
        Vector<String> variableEqualitiesList = new Vector<String>();
        Vector<GraphObject> checked = new Vector<GraphObject>();
        Vector<GraphObject> tocheck = new Vector<GraphObject>();
        count1 = 1;
        count2 = 1;
        OrdinaryMorphism morph1 = (OrdinaryMorphism)pair.first;
        OrdinaryMorphism morph2 = (OrdinaryMorphism)pair.second;
        Graph graph = morph1.getImage();
        for (GraphObject graphObject : graph.getNodesSet()) {
            if (morph1.getInverseImage(graphObject).hasMoreElements() && morph2.getInverseImage(graphObject).hasMoreElements()) {
                checked.add(graphObject);
                if (graphObject.getAttribute() == null) continue;
                ExcludePairHelper.renameVariableOfOverlapObj(graphObject, morph1, morph2, prefix1, prefix2, variableEqualitiesList);
                continue;
            }
            tocheck.add(graphObject);
        }
        for (GraphObject graphObject : graph.getArcsSet()) {
            if (morph1.getInverseImage(graphObject).hasMoreElements() && morph2.getInverseImage(graphObject).hasMoreElements()) {
                checked.add(graphObject);
                if (graphObject.getAttribute() == null) continue;
                ExcludePairHelper.renameVariableOfOverlapObj(graphObject, morph1, morph2, prefix1, prefix2, variableEqualitiesList);
                continue;
            }
            tocheck.add(graphObject);
        }
        ExcludePairHelper.renameSimilarVariables(r1, r2, morph1, morph2, checked, tocheck, prefix1, prefix2, variableEqualitiesList);
        if (!variableEqualitiesList.isEmpty()) {
            graph.setHelpInfo(String.valueOf(graph.getHelpInfo()) + ":VariableEquality:" + ((Object)variableEqualitiesList).toString());
        }
        variableEqualitiesList = null;
        checked = null;
        tocheck = null;
    }

    public static void renameContextVariableOfOverlapping(Rule r1, Rule r2, Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> pair, String prefix1, String prefix2) {
        ExcludePairHelper.renameContextVariableOfOverlappingPair(r1, r2, (Pair)pair.first, prefix1, prefix2);
    }

    private static void renameVariableOfOverlapObj(GraphObject o, OrdinaryMorphism morph1, OrdinaryMorphism morph2, String prefix1, String prefix2, List<String> variableEqualitiesList) {
        GraphObject o1 = morph1.getInverseImage(o).nextElement();
        GraphObject o2 = morph2.getInverseImage(o).nextElement();
        ValueTuple vt = (ValueTuple)o.getAttribute();
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            ValueMember vm = vt.getValueMemberAt(i);
            ValueMember vm1 = ((ValueTuple)o1.getAttribute()).getValueMemberAt(vm.getName());
            if (vm.isSet() && vm.getExpr().isVariable()) {
                String part1 = "";
                if (vm1 != null && vm1.isSet()) {
                    if (vm1.getExpr().isVariable()) {
                        if (!vm1.isTransient()) {
                            part1 = vm1.getExprAsText();
                            part1 = String.valueOf(prefix1) + part1;
                        }
                    } else if (vm1.getExpr().isComplex()) {
                        part1 = "expr" + count1;
                        ++count1;
                        part1 = String.valueOf(prefix1) + part1;
                        String variableEquality = String.valueOf(part1) + "=" + vm1.getExprAsText();
                        ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                    }
                }
                ValueMember vm2 = ((ValueTuple)o2.getAttribute()).getValueMemberAt(vm.getName());
                String part2 = "";
                if (vm2 != null && vm2.isSet()) {
                    if (vm2.getExpr().isVariable()) {
                        if (!vm2.isTransient()) {
                            part2 = vm2.getExprAsText();
                            part2 = String.valueOf(prefix2) + part2;
                        }
                    } else if (vm2.getExpr().isComplex()) {
                        part2 = "expr" + count2;
                        ++count2;
                        part2 = String.valueOf(prefix2) + part2;
                        String variableEquality = String.valueOf(part2) + "=" + vm2.getExprAsText();
                        ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                    }
                }
                String varname = "";
                if (!part1.equals("") && !part2.equals("")) {
                    varname = String.valueOf(part1) + "_" + part2;
                    String variableEquality = String.valueOf(part1) + "=" + part2;
                    ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                } else if (!part2.equals("")) {
                    varname = part2;
                } else if (!part1.equals("")) {
                    varname = part1;
                }
                if (!varname.equals("") && vm.isSet() && vm.getExpr().isVariable()) {
                    VarMember var2;
                    VarMember var1 = ((VarTuple)morph1.getAttrContext().getVariables()).getVarMemberAt(vm.getExprAsText());
                    if (var1 != null) {
                        var1.getDeclaration().setName(varname);
                    }
                    if ((var2 = ((VarTuple)morph2.getAttrContext().getVariables()).getVarMemberAt(vm.getExprAsText())) != null) {
                        var2.getDeclaration().setName(varname);
                    }
                    vm.setExprAsText(varname);
                }
                vm.setTransient(false);
            }
            ++i;
        }
    }

    private static void saveVariableEquality(List<String> variableEqualitiesList, String variableEquality) {
        boolean found = false;
        int i = 0;
        while (i < variableEqualitiesList.size() && !found) {
            String s = variableEqualitiesList.get(i);
            found = s.equals(variableEquality);
            ++i;
        }
        if (!found) {
            variableEqualitiesList.add(variableEquality);
        }
    }

    private static void renameSimilarVariables(Rule r1, Rule r2, OrdinaryMorphism morph1, OrdinaryMorphism morph2, List<GraphObject> checked, List<GraphObject> tocheck, String prefix1, String prefix2, List<String> variableEqualitiesList) {
        Vector<GraphObject> checked2 = new Vector<GraphObject>();
        int j = 0;
        while (j < tocheck.size()) {
            GraphObject o = tocheck.get(j);
            if (o.getAttribute() != null) {
                OrdinaryMorphism morph = null;
                GraphObject src1 = null;
                GraphObject src2 = null;
                ValueMember srcvm = null;
                if (morph1.getInverseImage(o).hasMoreElements()) {
                    morph = morph1;
                    src1 = morph1.getInverseImage(o).nextElement();
                } else if (morph2.getInverseImage(o).hasMoreElements()) {
                    morph = morph2;
                    src2 = morph2.getInverseImage(o).nextElement();
                }
                ValueTuple value = (ValueTuple)o.getAttribute();
                int i = 0;
                while (i < value.getNumberOfEntries()) {
                    ValueMember valuem = value.getValueMemberAt(i);
                    String memberName = valuem.getName();
                    if (valuem.isSet() && valuem.getExpr().isVariable() && !valuem.isTransient()) {
                        Vector<GraphObject> list = new Vector<GraphObject>();
                        String varName = valuem.getExprAsText();
                        if (src1 != null) {
                            srcvm = ((ValueTuple)src1.getAttribute()).getValueMemberAt(memberName);
                            list.addAll(ExcludePairHelper.getObjsWithVariable(varName, src1, morph1.getSource(), r1));
                        } else if (src2 != null) {
                            srcvm = ((ValueTuple)src2.getAttribute()).getValueMemberAt(memberName);
                            list.addAll(ExcludePairHelper.getObjsWithVariable(varName, src2, morph2.getSource(), r2));
                        }
                        if (list.size() > 1) {
                            GraphObject src_l = null;
                            GraphObject tar_l = null;
                            int l = 1;
                            while (l < list.size()) {
                                src_l = (GraphObject)list.get(l);
                                if (morph != null) {
                                    tar_l = morph.getImage(src_l);
                                }
                                if (checked.contains(tar_l) || checked2.contains(tar_l)) break;
                                tar_l = null;
                                ++l;
                            }
                            if (src_l != null && tar_l != null) {
                                ValueTuple src_l_value = (ValueTuple)src_l.getAttribute();
                                ValueTuple tar_l_value = (ValueTuple)tar_l.getAttribute();
                                ValueMember src_l_vm = src_l_value.getValueMemberAt(memberName);
                                ValueMember tar_l_vm = tar_l_value.getValueMemberAt(memberName);
                                if (src_l_vm != null && tar_l_vm != null) {
                                    String variableEquality;
                                    String part1 = "";
                                    String part2 = "";
                                    if (morph == morph1) {
                                        if (src_l_vm.isSet()) {
                                            if (src_l_vm.getExpr().isVariable()) {
                                                part1 = !src_l_vm.isTransient() ? src_l_vm.getExprAsText() : valuem.getExprAsText();
                                            } else if (src_l_vm.getExpr().isComplex()) {
                                                part1 = "expr" + count1;
                                                variableEquality = String.valueOf(prefix1) + part1 + "=" + src_l_vm.getExprAsText();
                                                ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                                            }
                                            if (!part1.equals("")) {
                                                part1 = String.valueOf(prefix1) + part1;
                                            }
                                        }
                                        if (morph2.getInverseImage(tar_l).hasMoreElements()) {
                                            ValueMember src2vm;
                                            src2 = morph2.getInverseImage(tar_l).nextElement();
                                            if (src2 != null && (src2vm = ((ValueTuple)src2.getAttribute()).getValueMemberAt(memberName)) != null && src2vm.isSet()) {
                                                if (src2vm.getExpr().isVariable()) {
                                                    if (!src2vm.isTransient() && src2vm.getExprAsText().equals(varName)) {
                                                        part2 = src2vm.getExprAsText();
                                                    } else if (src_l_vm.isTransient()) {
                                                        part2 = valuem.getExprAsText();
                                                        part1 = "";
                                                    }
                                                }
                                                if (!part2.equals("")) {
                                                    part2 = String.valueOf(prefix2) + part2;
                                                }
                                            }
                                            if (!part2.equals("")) {
                                                valuem.setExprAsText(part2);
                                            } else if (!part1.equals("")) {
                                                valuem.setExprAsText(part1);
                                            }
                                            valuem.setTransient(false);
                                        }
                                    } else if (morph == morph2) {
                                        if (src_l_vm.isSet()) {
                                            if (src_l_vm.getExpr().isVariable()) {
                                                part2 = !src_l_vm.isTransient() ? src_l_vm.getExprAsText() : valuem.getExprAsText();
                                            } else if (src_l_vm.getExpr().isComplex()) {
                                                part2 = "expr" + count2;
                                                variableEquality = String.valueOf(prefix2) + part2 + "=" + src_l_vm.getExprAsText();
                                                ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                                            }
                                            if (!part2.equals("")) {
                                                part2 = String.valueOf(prefix2) + part2;
                                            }
                                        }
                                        if (morph1.getInverseImage(tar_l).hasMoreElements()) {
                                            ValueMember src1vm;
                                            src1 = morph1.getInverseImage(tar_l).nextElement();
                                            if (src1 != null && (src1vm = ((ValueTuple)src1.getAttribute()).getValueMemberAt(memberName)) != null && src1vm.isSet()) {
                                                if (src1vm.getExpr().isVariable()) {
                                                    if (!src1vm.isTransient() && src1vm.getExprAsText().equals(varName)) {
                                                        part1 = src1vm.getExprAsText();
                                                    } else if (src_l_vm.isTransient()) {
                                                        part1 = valuem.getExprAsText();
                                                        part2 = "";
                                                    }
                                                }
                                                if (!part1.equals("")) {
                                                    part1 = String.valueOf(prefix1) + part1;
                                                }
                                            }
                                            if (!part2.equals("")) {
                                                valuem.setExprAsText(part2);
                                            } else if (!part1.equals("")) {
                                                valuem.setExprAsText(part1);
                                            }
                                            valuem.setTransient(false);
                                        }
                                    }
                                    if (!part1.equals("") && !part2.equals("")) {
                                        variableEquality = String.valueOf(part1) + "=" + part2;
                                        ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                                    }
                                }
                                checked2.add(o);
                            }
                        } else if (srcvm != null && srcvm.isSet()) {
                            String part = "";
                            if (srcvm.getExpr().isVariable() && !srcvm.isTransient()) {
                                part = !srcvm.isTransient() ? srcvm.getExprAsText() : valuem.getExprAsText();
                            } else if (srcvm.getExpr().isComplex()) {
                                String variableEquality;
                                if (morph == morph1) {
                                    part = "expr" + count1;
                                    ++count1;
                                    variableEquality = String.valueOf(prefix1) + part + "=" + srcvm.getExprAsText();
                                    ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                                } else if (morph == morph2) {
                                    part = "expr" + count2;
                                    ++count2;
                                    variableEquality = String.valueOf(prefix2) + part + "=" + srcvm.getExprAsText();
                                    ExcludePairHelper.saveVariableEquality(variableEqualitiesList, variableEquality);
                                }
                            }
                            if (part.equals("")) {
                                part = valuem.getExprAsText();
                            }
                            if (!part.equals("")) {
                                if (morph == morph2) {
                                    part = String.valueOf(prefix2) + part;
                                    valuem.setExprAsText(part);
                                } else if (morph == morph1) {
                                    part = String.valueOf(prefix1) + part;
                                    valuem.setExprAsText(part);
                                }
                            }
                            valuem.setTransient(false);
                        }
                        list = null;
                    }
                    ++i;
                }
            }
            ++j;
        }
        checked2 = null;
    }

    private static List<GraphObject> getObjsWithVariable(String varName, GraphObject startObj, Graph graph, Rule r) {
        Vector<GraphObject> list = new Vector<GraphObject>();
        list.add(startObj);
        ExcludePairHelper.objsWithVariable(varName, startObj, graph.getNodesSet().iterator(), list);
        ExcludePairHelper.objsWithVariable(varName, startObj, graph.getArcsSet().iterator(), list);
        list.trimToSize();
        return list;
    }

    private static List<GraphObject> objsWithVariable(String varName, GraphObject startObj, Iterator<?> objs, List<GraphObject> result) {
        while (objs.hasNext()) {
            ValueTuple value;
            ValueMember member;
            GraphObject o = (GraphObject)objs.next();
            if (o.getAttribute() == null || o == startObj || (member = (value = (ValueTuple)o.getAttribute()).getEntryWithValueAsText(varName)) == null) continue;
            result.add(o);
        }
        return result;
    }

    protected static Vector<ValueMember> findMemberWhichUsesVariable(String variablenName, GraphObject obj) {
        Vector<ValueMember> resultVector = null;
        if (obj.getAttribute() != null) {
            int i = 0;
            while (i < obj.getAttribute().getNumberOfEntries()) {
                ValueMember vm = (ValueMember)obj.getAttribute().getMemberAt(i);
                String value = vm.getExprAsText();
                if (value != null && value.equals(variablenName)) {
                    if (resultVector == null) {
                        resultVector = new Vector<ValueMember>(5);
                    }
                    resultVector.addElement(vm);
                }
                ++i;
            }
            if (resultVector != null) {
                resultVector.trimToSize();
            }
        }
        return resultVector;
    }

    protected static Vector<Type> getForbiddenTypesRule2(Rule rule2, Hashtable<ValueMember, Pair<String, String>> attrMember2Constant) {
        Vector<Type> forbiddenTypesR2 = new Vector<Type>(2);
        Enumeration<OrdinaryMorphism> nacsR2 = rule2.getNACs();
        while (nacsR2.hasMoreElements()) {
            OrdinaryMorphism nac = nacsR2.nextElement();
            if (!nac.isEnabled()) continue;
            for (GraphObject graphObject : nac.getTarget().getNodesSet()) {
                Type type = ExcludePairHelper.getTypeWhenDifferentAttrValue(nac, graphObject, attrMember2Constant);
                if (type == null || forbiddenTypesR2.contains(type)) continue;
                forbiddenTypesR2.add(graphObject.getType());
            }
            for (GraphObject graphObject : nac.getTarget().getArcsSet()) {
                Type t = ExcludePairHelper.getTypeWhenDifferentAttrValue(nac, graphObject, attrMember2Constant);
                if (t == null || forbiddenTypesR2.contains(t)) continue;
                forbiddenTypesR2.add(graphObject.getType());
            }
        }
        forbiddenTypesR2.trimToSize();
        return forbiddenTypesR2;
    }

    protected static Type getTypeWhenDifferentAttrValue(OrdinaryMorphism morph, GraphObject imageObj, Hashtable<ValueMember, Pair<String, String>> attrMember2Constant) {
        if (imageObj.getAttribute() == null) {
            return null;
        }
        if (!morph.getInverseImage(imageObj).hasMoreElements()) {
            return imageObj.getType();
        }
        ValueTuple vt = (ValueTuple)imageObj.getAttribute();
        int i = 0;
        while (i < vt.getNumberOfEntries()) {
            ValueTuple vt_o;
            ValueMember vm_o;
            GraphObject o;
            ValueMember vm = (ValueMember)vt.getMemberAt(i);
            if (attrMember2Constant.get(vm) != null) {
                return imageObj.getType();
            }
            if (!(!vm.isSet() || (o = morph.getInverseImage(imageObj).nextElement()).getAttribute() == null || (vm_o = (ValueMember)(vt_o = (ValueTuple)o.getAttribute()).getMemberAt(vm.getName())).isSet() && vm.getExprAsText().equals(vm_o.getExprAsText()))) {
                return imageObj.getType();
            }
            ++i;
        }
        return null;
    }

    public static Vector<ValueMember> getChangedAttributeMember(Rule r, GraphObject leftObj) {
        Vector<ValueMember> resultVector = null;
        if (leftObj.getAttribute() != null) {
            GraphObject goRight = r.getImage(leftObj);
            AttrInstance leftAttr = leftObj.getAttribute();
            AttrInstance rightAttr = goRight.getAttribute();
            int i = 0;
            while (i < leftAttr.getNumberOfEntries()) {
                ValueMember leftMember = (ValueMember)leftAttr.getMemberAt(i);
                ValueMember rightMember = (ValueMember)rightAttr.getMemberAt(i);
                if (rightMember.isSet()) {
                    if (!leftMember.isSet()) {
                        if (resultVector == null) {
                            resultVector = new Vector<ValueMember>(5);
                        }
                        resultVector.addElement(leftMember);
                    } else if (rightMember.getExpr().isVariable()) {
                        if (leftMember.getExpr().isVariable() && !leftMember.getExprAsText().equals(rightMember.getExprAsText()) || leftMember.getExpr().isConstant()) {
                            if (resultVector == null) {
                                resultVector = new Vector(5);
                            }
                            resultVector.add(leftMember);
                        }
                    } else if (rightMember.getExpr().isConstant()) {
                        if (leftMember.getExpr().isConstant() && !leftMember.getExprAsText().equals(rightMember.getExprAsText()) || leftMember.getExpr().isVariable()) {
                            if (resultVector == null) {
                                resultVector = new Vector(5);
                            }
                            resultVector.addElement(leftMember);
                        }
                    } else if (rightMember.getExpr().isComplex()) {
                        if (resultVector == null) {
                            resultVector = new Vector(5);
                        }
                        resultVector.addElement(leftMember);
                    }
                }
                ++i;
            }
            if (resultVector != null) {
                resultVector.trimToSize();
            }
        }
        return resultVector;
    }

    protected static boolean doesRuleChangeAttr(Rule r, GraphObject leftObj) {
        if (leftObj.getAttribute() != null) {
            GraphObject goRight = r.getImage(leftObj);
            AttrInstance leftAttr = leftObj.getAttribute();
            AttrInstance rightAttr = goRight.getAttribute();
            int i = 0;
            while (i < leftAttr.getNumberOfEntries()) {
                ValueMember leftMember = (ValueMember)leftAttr.getMemberAt(i);
                ValueMember rightMember = (ValueMember)rightAttr.getMemberAt(i);
                if (rightMember.isSet()) {
                    if (!leftMember.isSet()) {
                        return true;
                    }
                    if (rightMember.getExpr().isVariable() ? leftMember.getExpr().isVariable() && !leftMember.getExprAsText().equals(rightMember.getExprAsText()) || leftMember.getExpr().isConstant() : (rightMember.getExpr().isConstant() ? leftMember.getExpr().isConstant() && !leftMember.getExprAsText().equals(rightMember.getExprAsText()) || leftMember.getExpr().isVariable() : rightMember.getExpr().isComplex())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    protected static boolean isAttributeRestricted(Rule r, GraphObject obj, GraphObject refobj) {
        if (obj.getAttribute() == null) {
            return false;
        }
        int i = 0;
        while (i < obj.getAttribute().getNumberOfEntries()) {
            ValueMember vm = (ValueMember)obj.getAttribute().getMemberAt(i);
            if (vm.isSet()) {
                ValueMember refvm;
                ValueMember valueMember = refvm = refobj != null ? (ValueMember)refobj.getAttribute().getMemberAt(vm.getName()) : null;
                if (refvm == null || !refvm.isSet() || !vm.getExprAsText().equals(refvm.getExprAsText())) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected static boolean isAttrRestrictedByConstant(Rule r, GraphObject obj) {
        if (obj.getAttribute() == null) {
            return false;
        }
        int i = 0;
        while (i < obj.getAttribute().getNumberOfEntries()) {
            ValueMember vm = (ValueMember)obj.getAttribute().getMemberAt(i);
            if (vm.isSet() && vm.getExpr().isConstant()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isAttrRestrictedByVariable(Rule r, GraphObject obj, boolean onlyInputParam) {
        if (obj.getAttribute() == null) {
            return false;
        }
        int i = 0;
        while (i < obj.getAttribute().getNumberOfEntries()) {
            VarMember var;
            ValueMember vm = (ValueMember)obj.getAttribute().getMemberAt(i);
            if (vm.isSet() && vm.getExpr().isVariable() && (var = ((VarTuple)r.getAttrContext().getVariables()).getVarMemberAt(vm.getExprAsText())) != null) {
                if (!onlyInputParam) {
                    return true;
                }
                if (var.isInputParameter()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected static boolean hasVariableInContext(OrdinaryMorphism morph) {
        CondMember cm;
        int i;
        VarMember test_vm;
        ValueMember vm;
        int k;
        ValueTuple vt;
        VarTuple vars = (VarTuple)morph.getAttrContext().getVariables();
        CondTuple conds = (CondTuple)morph.getAttrContext().getConditions();
        for (GraphObject graphObject : morph.getTarget().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.getExpr() != null && vm.getExpr().isVariable()) {
                    test_vm = (VarMember)vars.getValueMemberAt(vm.getExprAsText());
                    if (test_vm != null && test_vm.isInputParameter()) {
                        return true;
                    }
                    i = 0;
                    while (i < conds.getSize()) {
                        cm = (CondMember)conds.getValueMemberAt(i);
                        if (cm.getAllVariableNamesOfExpression().contains(vm.getExprAsText())) {
                            return true;
                        }
                        ++i;
                    }
                }
                ++k;
            }
        }
        for (GraphObject graphObject : morph.getTarget().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.getExpr() != null && vm.getExpr().isVariable()) {
                    test_vm = (VarMember)vars.getValueMemberAt(vm.getExprAsText());
                    if (test_vm != null && test_vm.isInputParameter()) {
                        return true;
                    }
                    i = 0;
                    while (i < conds.getSize()) {
                        cm = (CondMember)conds.getValueMemberAt(i);
                        if (cm.getAllVariableNamesOfExpression().contains(vm.getExprAsText())) {
                            return true;
                        }
                        ++i;
                    }
                }
                ++k;
            }
        }
        return false;
    }

    private static void replaceNullByConstant(Rule r, OrdinaryMorphism nac, Hashtable<ValueMember, String> var2const) {
        ValueMember vm;
        int i;
        ValueTuple vt;
        for (GraphObject graphObject : nac.getTarget().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                vm = vt.getValueMemberAt(i);
                if (var2const.containsKey(vm)) {
                    vm.setExprAsText(var2const.get(vm));
                }
                ++i;
            }
        }
        for (GraphObject graphObject : nac.getTarget().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                vm = vt.getValueMemberAt(i);
                if (var2const.containsKey(vm)) {
                    vm.setExprAsText(var2const.get(vm));
                }
                ++i;
            }
        }
    }

    private static Hashtable<ValueMember, String> replaceConstantByNull(Rule r, OrdinaryMorphism nac) {
        ValueMember vm;
        int i;
        ValueTuple vt;
        Hashtable<ValueMember, String> var2const = new Hashtable<ValueMember, String>();
        for (GraphObject graphObject : nac.getTarget().getNodesSet()) {
            if (graphObject.getAttribute() == null || nac.getInverseImage(graphObject).hasMoreElements()) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isConstant()) {
                    var2const.put(vm, vm.getExprAsText());
                    vm.setExpr(null);
                }
                ++i;
            }
        }
        for (GraphObject graphObject : nac.getTarget().getArcsSet()) {
            if (graphObject.getAttribute() == null || nac.getInverseImage(graphObject).hasMoreElements()) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            i = 0;
            while (i < vt.getNumberOfEntries()) {
                vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isConstant()) {
                    var2const.put(vm, vm.getExprAsText());
                    vm.setExpr(null);
                }
                ++i;
            }
        }
        return var2const;
    }

    private static boolean checkNACStarAttributes(Rule r1, Rule r2, OrdinaryMorphism nac, OrdinaryMorphism nacStar, Match match2, Iterator<?> l1Objs, Pair<OrdinaryMorphism, OrdinaryMorphism> overlapping, List<GraphObject> changedAttributesR1, List<Type> forbiddenObjTypesR2, Hashtable<ValueMember, Pair<String, String>> attrMember2Constant) {
        boolean result = false;
        boolean nacStarFailed = false;
        block0: while (l1Objs.hasNext()) {
            GraphObject l1Obj = (GraphObject)l1Objs.next();
            GraphObject overlapObj = ((OrdinaryMorphism)overlapping.first).getImage(l1Obj);
            if (changedAttributesR1.contains(l1Obj)) {
                if (forbiddenObjTypesR2.contains(overlapObj.getType())) {
                    Enumeration<GraphObject> e = nacStar.getInverseImage(overlapObj);
                    if (!e.hasMoreElements()) continue;
                    GraphObject nacObj = e.nextElement();
                    ValueTuple vtNac = (ValueTuple)nacObj.getAttribute();
                    if (!nac.getInverseImage(nacObj).hasMoreElements()) {
                        Vector<ValueMember> changedMembers = ExcludePairHelper.getChangedAttributeMember(r1, l1Obj);
                        if (changedMembers == null) continue;
                        int j = 0;
                        while (j < vtNac.getNumberOfEntries()) {
                            ValueMember vmNacObj = vtNac.getValueMemberAt(j);
                            ValueMember vmL1 = ((ValueTuple)l1Obj.getAttribute()).getValueMemberAt(vmNacObj.getName());
                            if (vmL1 != null) {
                                ValueMember vmr1Obj;
                                if (!changedMembers.contains(vmL1)) {
                                    if (vmNacObj.isSet() && vmNacObj.getExpr().isConstant() && vmL1.isSet() && vmL1.getExpr().isConstant() && !vmNacObj.getExprAsText().equals(vmL1.getExprAsText())) {
                                        nacStar.setEnabled(false);
                                        return false;
                                    }
                                } else if (vmNacObj.isSet() && (vmr1Obj = ((ValueTuple)r1.getImage(l1Obj).getAttribute()).getValueMemberAt(vmL1.getName())) != null && vmr1Obj.isSet()) {
                                    if (vmNacObj.getExpr().isVariable()) {
                                        if (attrMember2Constant.get(vmNacObj) != null) {
                                            Pair<String, String> p = attrMember2Constant.get(vmNacObj);
                                            if (vmNacObj.getExprAsText().equals(p.first) && vmr1Obj.getExpr().isConstant() && ((String)p.second).equals(vmr1Obj.getExprAsText())) {
                                                result = true;
                                                overlapObj.setCritical(true);
                                            }
                                        } else {
                                            result = true;
                                            overlapObj.setCritical(true);
                                        }
                                    } else if (vmNacObj.getExpr().isConstant()) {
                                        if (!vmNacObj.getExprAsText().equals(vmL1.getExprAsText())) {
                                            if (vmr1Obj.getExpr().isConstant() && vmNacObj.getExprAsText().equals(vmr1Obj.getExprAsText())) {
                                                result = true;
                                                overlapObj.setCritical(true);
                                            } else {
                                                nacStarFailed = true;
                                            }
                                        } else {
                                            nacStarFailed = true;
                                        }
                                    }
                                }
                            }
                            ++j;
                        }
                        changedMembers = null;
                        continue;
                    }
                    ValueTuple nacObjVT = (ValueTuple)nacObj.getAttribute();
                    int i = 0;
                    while (i < nacObjVT.getNumberOfEntries()) {
                        ValueMember rhs1ObjVM;
                        ValueTuple overlapObjVT;
                        ValueMember overlapObjVM;
                        ValueMember nacObjVM = nacObjVT.getValueMemberAt(i);
                        if (attrMember2Constant.get(nacObjVM) != null && (overlapObjVM = (overlapObjVT = (ValueTuple)overlapObj.getAttribute()).getValueMemberAt(nacObjVM.getName())) != null && (rhs1ObjVM = ((ValueTuple)r1.getImage(l1Obj).getAttribute()).getValueMemberAt(nacObjVM.getName())) != null && rhs1ObjVM.isSet() && (rhs1ObjVM.getExprAsText().equals(attrMember2Constant.get((Object)nacObjVM).second) || rhs1ObjVM.getExpr().isVariable())) {
                            result = true;
                            overlapObj.setCritical(true);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!((OrdinaryMorphism)overlapping.second).getInverseImage(overlapObj).hasMoreElements()) continue;
                GraphObject l2Obj = ((OrdinaryMorphism)overlapping.second).getInverseImage(overlapObj).nextElement();
                ValueTuple vtL1Obj = (ValueTuple)l1Obj.getAttribute();
                int i = 0;
                while (i < vtL1Obj.getNumberOfEntries()) {
                    ValueMember vmL1 = vtL1Obj.getValueMemberAt(i);
                    ValueMember vmL2 = ((ValueTuple)l2Obj.getAttribute()).getValueMemberAt(i);
                    if (vmL2 != null && vmL1.isSet() && vmL1.getExpr().isVariable() && vmL2.isSet() && !vmL2.isTransient()) {
                        result = true;
                        overlapObj.setCritical(true);
                    }
                    ++i;
                }
                continue;
            }
            if (!((OrdinaryMorphism)overlapping.second).getInverseImage(overlapObj).hasMoreElements()) {
                if (overlapObj.getAttribute() == null) continue;
                ValueTuple vt = (ValueTuple)overlapObj.getAttribute();
                int i = 0;
                while (i < vt.getNumberOfEntries()) {
                    ValueMember m = vt.getValueMemberAt(i);
                    if (m.isSet() && m.getExpr().isConstant() && nac.getInverseImage(l1Obj).hasMoreElements()) {
                        VarMember var;
                        GraphObject nacObj = nac.getInverseImage(l1Obj).nextElement();
                        if (nacObj.getAttribute() == null) continue block0;
                        ValueMember mnacObj = vt.getValueMemberAt(m.getName());
                        if (mnacObj != null && mnacObj.isSet() && (!mnacObj.getExpr().isConstant() || !mnacObj.getExprAsText().equals(m.getExprAsText())) && mnacObj.getExpr().isVariable() && (var = (VarMember)match2.getAttrContext().getVariables().getMemberAt(mnacObj.getExprAsText())).isInputParameter()) {
                            result = true;
                        }
                    }
                    ++i;
                }
                continue;
            }
            GraphObject nacObj = nac.getImage(l1Obj);
            if (nacObj == null || !forbiddenObjTypesR2.contains(overlapObj.getType())) continue;
            ValueTuple nacObjVT = (ValueTuple)nacObj.getAttribute();
            int i = 0;
            while (i < nacObjVT.getNumberOfEntries()) {
                ValueMember rhs1ObjVM;
                ValueTuple overlapObjVT;
                ValueMember overlapObjVM;
                ValueMember nacObjVM = nacObjVT.getValueMemberAt(i);
                if (attrMember2Constant.get(nacObjVM) != null && (overlapObjVM = (overlapObjVT = (ValueTuple)overlapObj.getAttribute()).getValueMemberAt(nacObjVM.getName())) != null && (rhs1ObjVM = ((ValueTuple)r1.getImage(l1Obj).getAttribute()).getValueMemberAt(nacObjVM.getName())) != null && rhs1ObjVM.getExpr() != null && rhs1ObjVM.getExprAsText().equals(attrMember2Constant.get((Object)nacObjVM).second)) {
                    result = true;
                    overlapObj.setCritical(true);
                }
                ++i;
            }
        }
        return result || nacStarFailed;
    }

    private static void doReplaceConstantByInputParam(Rule r, OrdinaryMorphism nac, Hashtable<ValueMember, String> var2const) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        ExcludePairHelper.doReplaceConstantByInputParam(vars, nac.getTarget().getNodesSet().iterator(), nac, var2const);
        ExcludePairHelper.doReplaceConstantByInputParam(vars, nac.getTarget().getArcsSet().iterator(), nac, var2const);
    }

    protected static Hashtable<ValueMember, String> replaceConstantByInputParam(Rule r, Hashtable<ValueMember, String> var2const) {
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int l = 0;
        while (l < nacs.size()) {
            OrdinaryMorphism nac = nacs.get(l);
            ExcludePairHelper.doReplaceConstantByInputParam(r, nac, var2const);
            ++l;
        }
        return var2const;
    }

    protected static void doReplaceConstantByInputParam(VarTuple vars, Iterator<?> en, OrdinaryMorphism nac, Hashtable<ValueMember, String> var2const) {
        while (en.hasNext()) {
            GraphObject o = (GraphObject)en.next();
            if (o.getAttribute() == null || nac.getInverseImage(o).hasMoreElements()) continue;
            ValueTuple vt = (ValueTuple)o.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (vm.isSet() && vm.getExpr().isConstant()) {
                    var2const.put(vm, vm.getExprAsText());
                    String varname = String.valueOf(vm.getName()) + i;
                    vm.setExprAsText(varname);
                    vm.setTransient(true);
                    VarMember var = vars.getVarMemberAt(varname);
                    if (var != null) {
                        var.setInputParameter(true);
                    }
                }
                ++i;
            }
        }
    }

    protected static void replaceInputParamByConstant(Rule r, Hashtable<ValueMember, String> var2const) {
        List<OrdinaryMorphism> nacs = r.getNACsList();
        int l = 0;
        while (l < nacs.size()) {
            OrdinaryMorphism nac = nacs.get(l);
            ExcludePairHelper.doReplaceInputParamByConstant(r, nac, var2const);
            ++l;
        }
    }

    private static void doReplaceInputParamByConstant(Rule r, OrdinaryMorphism nac, Hashtable<ValueMember, String> var2const) {
        VarTuple vars = (VarTuple)r.getAttrContext().getVariables();
        ExcludePairHelper.doReplaceInputParamByConstant(vars, nac.getTarget().getNodesSet().iterator(), var2const);
        ExcludePairHelper.doReplaceInputParamByConstant(vars, nac.getTarget().getArcsSet().iterator(), var2const);
    }

    private static void doReplaceInputParamByConstant(VarTuple vars, Iterator<?> en, Hashtable<ValueMember, String> var2const) {
        while (en.hasNext()) {
            GraphObject o = (GraphObject)en.next();
            if (o.getAttribute() == null) continue;
            ValueTuple vt = (ValueTuple)o.getAttribute();
            int i = 0;
            while (i < vt.getNumberOfEntries()) {
                ValueMember vm = vt.getValueMemberAt(i);
                if (var2const.containsKey(vm)) {
                    String varname = vm.getExprAsText();
                    vm.setExprAsText(var2const.get(vm));
                    vm.setTransient(false);
                    if (vars.getVarMemberAt(varname) != null) {
                        vars.getTupleType().deleteMemberAt(varname);
                    }
                }
                ++i;
            }
        }
    }

    protected static Vector<Vector<GraphObject>> combineGraphLikeInclusionsOf(int maxSize, Vector<GraphObject> nodeSet, Vector<GraphObject> arcs) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        Vector<GraphObject> combi = null;
        result.add(nodeSet);
        if (nodeSet.size() < maxSize) {
            int j = 0;
            while (j < arcs.size()) {
                GraphObject o = arcs.get(j);
                if (nodeSet.contains(((Arc)o).getSource()) && nodeSet.contains(((Arc)o).getTarget())) {
                    combi = new Vector<GraphObject>(nodeSet);
                    combi.add(o);
                    result.add(combi);
                    if (j < arcs.size() - 1) {
                        combi = new Vector(result.get(result.size() - 1));
                    }
                    if (combi != null && !combi.isEmpty()) {
                        int k = j + 1;
                        while (k < arcs.size()) {
                            GraphObject o1 = arcs.get(k);
                            if (nodeSet.contains(((Arc)o1).getSource()) && nodeSet.contains(((Arc)o1).getTarget())) {
                                if (combi.size() >= maxSize) break;
                                combi.add(o1);
                                result.add(combi);
                                if (k < arcs.size() - 1) {
                                    combi = new Vector(result.get(result.size() - 1));
                                }
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
        }
        return result;
    }

    protected static Vector<Vector<GraphObject>> combineGraphLikeInclusions(int maxSize, Vector<Vector<GraphObject>> nodeSets, Vector<Vector<GraphObject>> arcSets) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        Vector<GraphObject> combi = null;
        int i = 0;
        while (i < nodeSets.size()) {
            Vector<GraphObject> nodeSet = nodeSets.get(i);
            if (nodeSet.size() <= maxSize) {
                result.add(nodeSet);
            }
            if (nodeSet.size() < maxSize) {
                int j = 0;
                while (j < arcSets.size()) {
                    Vector<GraphObject> arcSet = arcSets.get(j);
                    boolean ok = true;
                    int k = 0;
                    while (k < arcSet.size()) {
                        GraphObject o = arcSet.get(k);
                        if (!nodeSet.contains(((Arc)o).getSource()) || !nodeSet.contains(((Arc)o).getTarget())) {
                            ok = false;
                            break;
                        }
                        ++k;
                    }
                    if (ok && nodeSet.size() + arcSet.size() <= maxSize) {
                        combi = new Vector<GraphObject>(nodeSet);
                        combi.addAll(arcSet);
                        combi.trimToSize();
                        result.add(combi);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    protected static Vector<Vector<GraphObject>> combinePlainInclusions(int maxSize, Vector<Vector<GraphObject>> nodeSets, Vector<Vector<GraphObject>> arcSets) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        Vector<GraphObject> combi = null;
        int i = 0;
        while (i < nodeSets.size()) {
            Vector<GraphObject> nodeSet = nodeSets.get(i);
            if (nodeSet.size() <= maxSize) {
                result.add(nodeSet);
            }
            if (nodeSet.size() < maxSize) {
                int j = 0;
                while (j < arcSets.size()) {
                    Vector<GraphObject> arcSet = arcSets.get(j);
                    if (arcSet.size() <= maxSize) {
                        result.add(arcSet);
                    }
                    if (nodeSet.size() + arcSet.size() <= maxSize) {
                        combi = new Vector<GraphObject>(nodeSet);
                        combi.addAll(arcSet);
                        combi.trimToSize();
                        result.add(combi);
                    }
                    ++j;
                }
            }
            ++i;
        }
        result.trimToSize();
        return result;
    }

    protected static Vector<Vector<GraphObject>> combineInclusionsOf(int maxSize, Vector<Vector<GraphObject>> set1, Vector<GraphObject> set2, Vector<?> set3) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        if (set1 == null || set1.isEmpty() || set2 == null || set2.isEmpty()) {
            return result;
        }
        int i = 0;
        while (i < set1.size()) {
            Vector<GraphObject> v1i = set1.get(i);
            Vector<GraphObject> combi = new Vector<GraphObject>();
            combi.addAll(v1i);
            int jj = 0;
            while (jj < set2.size()) {
                GraphObject o = set2.get(jj);
                if (o.isNode() && !combi.contains(o)) {
                    combi.add(o);
                }
                ++jj;
            }
            boolean arcOK = true;
            int jj2 = 0;
            while (jj2 < set2.size() && arcOK) {
                GraphObject o = set2.get(jj2);
                if (o.isArc() && !combi.contains(o)) {
                    if (combi.contains(((Arc)o).getSource()) && combi.contains(((Arc)o).getTarget())) {
                        combi.add(o);
                    } else {
                        arcOK = false;
                    }
                }
                ++jj2;
            }
            if (arcOK) {
                result.add(combi);
            }
            ++i;
        }
        return result;
    }

    protected static Vector<Vector<GraphObject>> combineFirstWithSecondAboveThird(int maxSize, Vector<GraphObject> set1, Vector<Vector<GraphObject>> set2, Vector<?> set3) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        if (set1 != null && !set1.isEmpty()) {
            result.add(set1);
        }
        if (set1.size() < maxSize && set2 != null && !set2.isEmpty()) {
            int j = 0;
            while (j < set2.size()) {
                GraphObject o;
                Vector<GraphObject> v2j = set2.get(j);
                Vector<GraphObject> combi = new Vector<GraphObject>(set1);
                int jj = 0;
                while (jj < v2j.size()) {
                    o = v2j.get(jj);
                    if (o.isArc() && !combi.contains(o)) {
                        if (!combi.contains(((Arc)o).getSource())) {
                            combi.add(((Arc)o).getSource());
                        }
                        if (!combi.contains(((Arc)o).getTarget())) {
                            combi.add(((Arc)o).getTarget());
                        }
                        combi.add(o);
                    }
                    ++jj;
                }
                jj = 0;
                while (jj < v2j.size()) {
                    o = v2j.get(jj);
                    if (o.isNode() && !combi.contains(o)) {
                        combi.add(o);
                    }
                    ++jj;
                }
                ExcludePairHelper.addIfNotContained(result, combi);
                ++j;
            }
        }
        return result;
    }

    private static void addIfNotContained(Vector<Vector<GraphObject>> list, Vector<GraphObject> vec) {
        boolean found = false;
        int i = 0;
        while (i < list.size()) {
            Vector<GraphObject> l = list.get(i);
            if (l.size() == vec.size() && l.containsAll(vec)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            list.add(vec);
        }
    }

    protected static Vector<Vector<GraphObject>> combineFirstWithSecondAboveThirdOLD(int maxSize, Vector<GraphObject> set1, Vector<Vector<GraphObject>> set2, Vector<?> set3) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        if (set1 != null && !set1.isEmpty()) {
            result.add(set1);
        }
        if (set2 != null && !set2.isEmpty()) {
            Vector<GraphObject> combi = new Vector<GraphObject>();
            int j = 0;
            while (j < set2.size()) {
                Vector<GraphObject> v2j = set2.get(j);
                if (!combi.isEmpty()) {
                    combi = new Vector();
                }
                combi.addAll(set1);
                int jj = 0;
                while (jj < v2j.size()) {
                    GraphObject o = v2j.get(jj);
                    if (o.isNode() && !combi.contains(o)) {
                        combi.add(o);
                    }
                    ++jj;
                }
                boolean arcOK = true;
                int jj2 = 0;
                while (jj2 < v2j.size()) {
                    GraphObject o = v2j.get(jj2);
                    if (o.isArc() && !combi.contains(o) && combi.contains(((Arc)o).getSource()) && combi.contains(((Arc)o).getTarget())) {
                        combi.add(o);
                    }
                    ++jj2;
                }
                if (!arcOK) {
                    combi.clear();
                } else {
                    result.add(combi);
                }
                ++j;
            }
        }
        return result;
    }

    protected static Vector<Vector<GraphObject>> combineInclusions(int maxSize, Vector<Vector<GraphObject>> set1, Vector<Vector<GraphObject>> set2, Vector<?> set3) {
        Vector<Vector<GraphObject>> result = new Vector<Vector<GraphObject>>();
        if (set1 != null && !set1.isEmpty()) {
            if (set2 == null || set2.isEmpty()) {
                result.addAll(set1);
            } else {
                int i = 0;
                while (i < set1.size()) {
                    Vector<GraphObject> v1i = set1.get(i);
                    Vector<Vector<GraphObject>> res_i = ExcludePairHelper.combineFirstWithSecondAboveThird(maxSize, v1i, set2, set3);
                    result.addAll(res_i);
                    ++i;
                }
            }
        }
        return result;
    }

    protected static Vector<Vector<GraphObject>> getInclusions(Graph g, int size, Vector<GraphObject> set, boolean graphLikeIncl) {
        Vector<Vector<GraphObject>> combis = new Vector<Vector<GraphObject>>();
        Vector<GraphObject> nodeSubset = new Vector<GraphObject>(5);
        Vector<GraphObject> arcSubset = new Vector<GraphObject>(5);
        ExcludePairHelper.split(set, nodeSubset, arcSubset);
        Vector<Vector<GraphObject>> arcIncls = ExcludePairHelper.getArcInclusions(size, arcSubset);
        int tmpSize = nodeSubset.size();
        if (tmpSize > size) {
            tmpSize = size;
        }
        int i = 1;
        while (i <= tmpSize) {
            Vector<Vector<GraphObject>> incls = new Vector<Vector<GraphObject>>(5);
            ExcludePairHelper.generateAllSubsetsWithInclusionsOfSize(g, i, nodeSubset, incls, false);
            if (!incls.isEmpty()) {
                if (graphLikeIncl) {
                    combis.addAll(ExcludePairHelper.combineGraphLikeInclusions(size, incls, arcIncls));
                } else {
                    combis.addAll(ExcludePairHelper.combinePlainInclusions(size, incls, arcIncls));
                }
            }
            ++i;
        }
        combis.trimToSize();
        return combis;
    }

    protected static Vector<Vector<GraphObject>> getNodeInclusions(Graph g, int size, Vector<GraphObject> nodes) {
        int tmpSize = nodes.size();
        if (tmpSize > size) {
            tmpSize = size;
        }
        Vector<Vector<GraphObject>> nodeSubsets = new Vector<Vector<GraphObject>>();
        int i = 1;
        while (i <= tmpSize) {
            Vector<Vector<GraphObject>> incls = new Vector<Vector<GraphObject>>();
            ExcludePairHelper.generateAllSubsetsWithInclusionsOfSize(g, i, nodes, incls, false);
            if (!incls.isEmpty()) {
                nodeSubsets.addAll(incls);
            }
            ++i;
        }
        nodeSubsets.trimToSize();
        return nodeSubsets;
    }

    protected static Vector<Vector<GraphObject>> getArcInclusions(int size, Vector<GraphObject> arcs) {
        Vector<Vector<GraphObject>> arcSubsets = new Vector<Vector<GraphObject>>();
        int tmpSize = arcs.size();
        if (tmpSize > size) {
            tmpSize = size;
        }
        int i = 1;
        while (i <= tmpSize) {
            Vector<Vector<GraphObject>> incls = new Vector<Vector<GraphObject>>(5);
            ExcludePairHelper.generateAllSubsetsWithInclusionsOfSize(i, arcs, incls, false);
            if (!incls.isEmpty()) {
                arcSubsets.addAll(incls);
            }
            ++i;
        }
        arcSubsets.trimToSize();
        return arcSubsets;
    }

    private static void delEqualIncls(Vector<Vector<GraphObject>> incls) {
        Vector<Integer> del = new Vector<Integer>();
        int i = 0;
        while (i < incls.size()) {
            if (!del.contains(i)) {
                Vector<GraphObject> incl1 = incls.get(i);
                int j = 0;
                while (j < incls.size()) {
                    if (j != i && !del.contains(j)) {
                        Vector<GraphObject> incl2 = incls.get(j);
                        if (incl1.size() == incl2.size()) {
                            boolean ok = true;
                            int k = 0;
                            while (k < incl1.size()) {
                                if (!incl2.contains(incl1.get(k))) {
                                    ok = false;
                                    break;
                                }
                                ++k;
                            }
                            if (ok) {
                                del.add(j);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < del.size()) {
            incls.remove((Integer)del.get(i));
            ++i;
        }
    }

    protected static Vector<Vector<GraphObject>> getPlainCombinedInclusions(Vector<GraphObject> setToCombine, int size, Graph g) {
        Vector<GraphObject> nodes = new Vector<GraphObject>();
        Vector<GraphObject> arcs = new Vector<GraphObject>();
        ExcludePairHelper.split(setToCombine, nodes, arcs);
        Vector<Vector<GraphObject>> nodeSets = ExcludePairHelper.getNodeInclusions(g, size, nodes);
        Vector<Vector<GraphObject>> arcIncls = ExcludePairHelper.getArcInclusions(size, arcs);
        if (nodeSets.size() > 0) {
            return ExcludePairHelper.combinePlainInclusions(size, nodeSets, arcIncls);
        }
        return arcIncls;
    }

    protected static void split(Vector<GraphObject> set, Vector<GraphObject> outNodeSubset, Vector<GraphObject> outArcSubset) {
        if (!set.isEmpty()) {
            int i = 0;
            while (i < set.size()) {
                GraphObject go = set.get(i);
                if (go.isNode()) {
                    outNodeSubset.add(go);
                } else {
                    outArcSubset.add(go);
                }
                ++i;
            }
            outNodeSubset.trimToSize();
            outArcSubset.trimToSize();
        }
    }

    protected static Vector<Vector<GraphObject>> generateAllSubsetsWithInclusionsOfSize(Graph g, int i, Vector<GraphObject> itsGOSet, Vector<Vector<GraphObject>> inclusions, boolean graphLike) {
        if (i > 0 && i <= itsGOSet.size()) {
            Vector<Integer> select = new Vector<Integer>(i);
            int j = 0;
            while (j < i) {
                select.addElement(new Integer(j));
                ++j;
            }
            ExcludePairHelper.computeSelection(1, itsGOSet, select, inclusions, graphLike);
            inclusions.trimToSize();
        }
        return inclusions;
    }

    protected static Vector<Vector<GraphObject>> generateAllSubsetsWithInclusionsOfSize(int i, Vector<GraphObject> itsGOSet, Vector<Vector<GraphObject>> inclusions, boolean graphLike) {
        if (i > 0 && i <= itsGOSet.size()) {
            Vector<Integer> select = new Vector<Integer>(i);
            int j = 0;
            while (j < i) {
                select.addElement(new Integer(j));
                ++j;
            }
            ExcludePairHelper.computeSelection(1, itsGOSet, select, inclusions, graphLike);
            inclusions.trimToSize();
        }
        return inclusions;
    }

    private static Vector<Vector<GraphObject>> computeSelection(int s, Vector<GraphObject> itsGOSet, Vector<Integer> select, Vector<Vector<GraphObject>> inclusions, boolean graphLike) {
        int max = itsGOSet.size();
        int selSize = select.size();
        if (s <= selSize && s >= 1) {
            try {
                int v = select.elementAt(s - 1);
                while (v < max - selSize + s) {
                    inclusions = ExcludePairHelper.computeSelection(s + 1, itsGOSet, select, inclusions, graphLike);
                    if (s == selSize) {
                        Vector<GraphObject> goSet = ExcludePairHelper.makeGraphObjectSet(select, itsGOSet);
                        inclusions = ExcludePairHelper.putGraphInclusionSet(goSet, inclusions, graphLike);
                    }
                    select.setElementAt(new Integer(v + 1), s - 1);
                    v = select.elementAt(s - 1);
                }
                if (s > 1 && (v = select.elementAt(s - 2).intValue()) < max - selSize + s + 1) {
                    select.setElementAt(new Integer(v + 1), s - 2);
                    int j = 1;
                    while (j <= selSize - s + 1) {
                        select.setElementAt(new Integer(v + 1 + j), s + j - 2);
                        ++j;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return inclusions;
    }

    private static Vector<GraphObject> makeGraphObjectSet(Vector<Integer> select, Vector<GraphObject> itsGOSet) {
        Vector<GraphObject> tmp = new Vector<GraphObject>();
        int i = 0;
        while (i < select.size()) {
            int v = select.elementAt(i);
            tmp.addElement(itsGOSet.elementAt(v));
            ++i;
        }
        return tmp;
    }

    private static Vector<Vector<GraphObject>> putGraphInclusionSet(Vector<GraphObject> goSet, Vector<Vector<GraphObject>> inclusions, boolean graphLike) {
        if (graphLike) {
            int i = 0;
            while (i < goSet.size()) {
                GraphObject go = goSet.elementAt(i);
                if (!(!go.isArc() || goSet.contains(((Arc)go).getSource()) && goSet.contains(((Arc)go).getTarget()))) {
                    goSet.remove(i);
                    --i;
                }
                ++i;
            }
        }
        goSet.trimToSize();
        inclusions.addElement(goSet);
        return inclusions;
    }

    public static List<Pair<OrdinaryMorphism, OrdinaryMorphism>> shiftCondOverMorphism(Rule rule, OrdinaryMorphism cond, OrdinaryMorphism morph) {
        Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>> list = new Vector<Pair<OrdinaryMorphism, OrdinaryMorphism>>();
        OrdinaryMorphism condSrcIsom = cond.getSource().isomorphicCopy();
        if (condSrcIsom == null) {
            list.trimToSize();
            return list;
        }
        Graph dCondGraph = condSrcIsom.getTarget();
        Vector<GraphObject> condDom = condSrcIsom.getDomainObjects();
        Vector<Object> requiredObjs = new Vector<Object>(condDom.size());
        Hashtable<Object, Object> objmap = new Hashtable<Object, Object>(condDom.size());
        int j = 0;
        while (j < condDom.size()) {
            GraphObject go = condDom.get(j);
            GraphObject go1 = condSrcIsom.getImage(go);
            GraphObject go2 = morph.getImage(go);
            if (go1 != null && go2 != null) {
                requiredObjs.add(go1);
                objmap.put(go1, go2);
            }
            ++j;
        }
        Enumeration<Pair<OrdinaryMorphism, OrdinaryMorphism>> overlaps = BaseFactory.theFactory().getOverlappingByPartialPredefinedIntersection(dCondGraph, morph.getTarget(), requiredObjs, objmap, true);
        while (overlaps.hasMoreElements()) {
            Pair<OrdinaryMorphism, OrdinaryMorphism> p = overlaps.nextElement();
            OrdinaryMorphism condSh = (OrdinaryMorphism)p.second;
            condSh.setEnabled(cond.isEnabled());
            condSh.setName(cond.getName().concat("_").concat(String.valueOf(list.size())));
            list.add(p);
        }
        return list;
    }

    public static OrdinaryMorphism makeLeftACFromGraph(Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>> p, Rule r, boolean isFirstRule, boolean nested) {
        Graph criticalGraph = ((OrdinaryMorphism)((Pair)p.first).first).getTarget();
        OrdinaryMorphism iso = criticalGraph.isoCopy();
        if (iso == null) {
            return null;
        }
        iso.getTarget().setName(iso.getTarget().getName().replace("_copy", ""));
        OrdinaryMorphism ac = nested ? BaseFactory.theFactory().createGeneralMorphism(r.getLeft(), iso.getTarget()) : BaseFactory.theFactory().createMorphism(r.getLeft(), iso.getTarget());
        Pair cp1 = (Pair)p.first;
        Pair cp2 = (Pair)p.second;
        OrdinaryMorphism o1 = (OrdinaryMorphism)cp1.first;
        OrdinaryMorphism o2 = (OrdinaryMorphism)cp1.second;
        boolean mapOK = true;
        if (isFirstRule) {
            Enumeration<GraphObject> dom = o1.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                try {
                    if (go.getContext() == r.getLeft()) {
                        ac.addMapping(go, iso.getImage(o1.getImage(go)));
                        continue;
                    }
                    if (go.getContext() != r.getRight()) continue;
                    Enumeration<GraphObject> inverse = r.getInverseImage(go);
                    if (inverse.hasMoreElements()) {
                        GraphObject goL = inverse.nextElement();
                        ac.addMapping(goL, iso.getImage(o1.getImage(go)));
                        continue;
                    }
                    mapOK = false;
                    break;
                }
                catch (BadMappingException ex) {
                    mapOK = false;
                }
            }
            mapOK = mapOK && !ac.isEmpty();
        } else {
            Enumeration<GraphObject> dom = o2.getDomain();
            while (dom.hasMoreElements()) {
                GraphObject go = dom.nextElement();
                try {
                    Enumeration<GraphObject> inverse;
                    if (go.getContext() == r.getLeft()) {
                        ac.addMapping(go, iso.getImage(o2.getImage(go)));
                        continue;
                    }
                    if (go.getContext() != ((OrdinaryMorphism)cp2.first).getTarget() || !(inverse = ((OrdinaryMorphism)cp2.first).getInverseImage(go)).hasMoreElements()) continue;
                    GraphObject goL = inverse.nextElement();
                    ac.addMapping(goL, iso.getImage(o2.getImage(go)));
                }
                catch (BadMappingException ex) {
                    mapOK = false;
                }
            }
            mapOK = mapOK && !ac.isEmpty();
        }
        iso.dispose();
        if (!mapOK) {
            ac.dispose(false, true);
            return null;
        }
        return ac;
    }

    protected static boolean isCriticalPAC(OrdinaryMorphism pac, List<GraphObject> criticalContext) {
        boolean pacCritical = false;
        int j = 0;
        while (j < criticalContext.size() && !pacCritical) {
            GraphObject o = criticalContext.get(j);
            Vector<GraphObject> v = pac.getTarget().getElementsOfTypeAsVector(o.getType());
            if (!v.isEmpty()) {
                int i = 0;
                while (i < v.size()) {
                    GraphObject go = v.get(i);
                    if (!pac.getInverseImage(go).hasMoreElements()) {
                        pacCritical = true;
                        break;
                    }
                    ++i;
                }
            }
            ++j;
        }
        return pacCritical;
    }

    protected static List<GraphObject> getObjsWithAttrValue(OrdinaryMorphism om, boolean isConst, boolean isVar) {
        Vector<GraphObject> list = new Vector<GraphObject>(1);
        Enumeration<GraphObject> objs = om.getTarget().getElements();
        while (objs.hasMoreElements()) {
            GraphObject o = objs.nextElement();
            if (o.getAttribute() == null) continue;
            boolean added = false;
            AttrInstance attr = o.getAttribute();
            int i = 0;
            while (i < attr.getNumberOfEntries()) {
                ValueMember vm = (ValueMember)attr.getMemberAt(i);
                if (vm.isSet() && (isConst && vm.getExpr().isConstant() || isVar && vm.getExpr().isVariable()) && !added) {
                    list.add(o);
                    added = true;
                }
                ++i;
            }
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    protected static List<GraphObject> getImgOfObj(OrdinaryMorphism om, List<GraphObject> objs) {
        if (objs == null || objs.isEmpty()) {
            return null;
        }
        Vector<GraphObject> list = new Vector<GraphObject>(1);
        for (GraphObject o : objs) {
            GraphObject i = om.getImage(o);
            if (i == null) continue;
            list.add(i);
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected static List<Triple<GraphObject, ValueMember, String>> getObjsWithConstOrVarDuetoImg(AttrContext attrCtxt, List<GraphObject> objs, List<GraphObject> srcObjs, OrdinaryMorphism om, OrdinaryMorphism om1, OrdinaryMorphism om2, boolean isConst, boolean isVar) {
        if (srcObjs == null || srcObjs.isEmpty() || objs == null || objs.isEmpty()) {
            return null;
        }
        list = new Vector<Triple<GraphObject, ValueMember, String>>(1);
        for (GraphObject s : srcObjs) {
            s_attr = s.getAttribute();
            for (GraphObject obj : objs) {
                if (s.getType() != obj.getType() && !obj.getType().isParentOf(s.getType()) && !s.getType().isParentOf(obj.getType()) || (t = om.getImage(s)) == null || !(en2 = om2.getInverseImage(obj)).hasMoreElements()) continue;
                n2_obj = en2.nextElement();
                tmp = new Vector<Pair<GraphObject, ValueMember>>(1);
                t_attr = t.getAttribute();
                obj_attr = obj.getAttribute();
                n2_obj_attr = n2_obj.getAttribute();
                i = 0;
                while (i < s_attr.getNumberOfEntries()) {
                    block11: {
                        s_vm = (ValueMember)s_attr.getMemberAt(i);
                        t_vm = (ValueMember)t_attr.getMemberAt(s_vm.getName());
                        obj_vm = (ValueMember)obj_attr.getMemberAt(s_vm.getName());
                        n2_obj_vm = (ValueMember)n2_obj_attr.getMemberAt(s_vm.getName());
                        if (obj_vm == null || n2_obj_vm == null || !n2_obj_vm.isSet() || !t_vm.isSet() || s_vm.isSet() && s_vm.getExprAsText().equals(t_vm.getExprAsText())) break block11;
                        if (!isConst || !n2_obj_vm.getExpr().isConstant()) ** GOTO lbl34
                        if (!t_vm.getExpr().isConstant()) ** GOTO lbl28
                        if (t_vm.getExprAsText().equals(n2_obj_vm.getExprAsText())) {
                            tmp.add(new Pair<GraphObject, ValueMember>(obj, obj_vm));
                        } else {
                            tmp.clear();
                            break;
lbl28:
                            // 1 sources

                            if (!t_vm.getExprAsText().equals(s_vm.getExprAsText())) {
                                tmp.add(new Pair<GraphObject, ValueMember>(obj, obj_vm));
                            } else {
                                tmp.clear();
                                break;
lbl34:
                                // 1 sources

                                if (isVar && n2_obj_vm.getExpr().isVariable()) {
                                    tmp.add(new Pair<GraphObject, ValueMember>(obj, obj_vm));
                                }
                            }
                        }
                    }
                    ++i;
                }
                if (tmp.isEmpty()) continue;
                for (Pair p : tmp) {
                    obj_vm = (ValueMember)p.second;
                    list.add(new Triple<GraphObject, ValueMember, String>(obj, obj_vm, obj_vm.getExprAsText()));
                }
            }
        }
        if (list.isEmpty()) {
            list = null;
        }
        return list;
    }

    protected static boolean markObjDuetoNAC(List<Triple<GraphObject, ValueMember, String>> objs, OrdinaryMorphism om1, OrdinaryMorphism om2) {
        boolean critical = false;
        if (objs != null) {
            int i = 0;
            while (i < objs.size()) {
                Triple<GraphObject, ValueMember, String> trio = objs.get(i);
                GraphObject img2 = om2.getImage((GraphObject)trio.first);
                if (img2 != null) {
                    img2.setCritical(true);
                    critical = true;
                }
                ++i;
            }
        }
        return critical;
    }

    public static boolean bothOrigAndImgCriticalOrNot(OrdinaryMorphism om) {
        Enumeration<GraphObject> dom = om.getDomain();
        while (dom.hasMoreElements()) {
            GraphObject o1 = dom.nextElement();
            GraphObject o2 = om.getImage(o1);
            if (o2 == null || o1.isCritical() && o2.isCritical() || !o1.isCritical() && !o2.isCritical()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfMorphSimilar(Graph overlap1, Graph overlap2, OrdinaryMorphism first1, OrdinaryMorphism first2, OrdinaryMorphism second1, OrdinaryMorphism second2) {
        OrdinaryMorphism morph1 = BaseFactory.theFactory().createMorphism(overlap1, overlap2);
        OrdinaryMorphism morph2 = BaseFactory.theFactory().createMorphism(overlap1, overlap2);
        if (morph1.makeDiagram(first1, first2) && morph1.getSize() > 0) {
            if (!ExcludePairHelper.bothOrigAndImgCriticalOrNot(morph1)) {
                return false;
            }
            if (morph2.makeDiagram(second1, second2) && morph2.getSize() > 0) {
                if (!ExcludePairHelper.bothOrigAndImgCriticalOrNot(morph2)) {
                    return false;
                }
                if (morph1.isPartialIsomorphicTo(morph2)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean node2ToNode1_ChildToParentMap(Rule rule1, OrdinaryMorphism overlap1, OrdinaryMorphism overlap2) {
        for (Node go1 : overlap1.getSource().getNodesSet()) {
            Node go2;
            Node img;
            Enumeration<GraphObject> en;
            if (rule1.getImage(go1) != null || !(en = overlap2.getInverseImage(img = (Node)overlap1.getImage(go1))).hasMoreElements() || !(go2 = (Node)en.nextElement()).getType().isChildOf(go1.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean newNode_TypeToTypeMap(Rule rule1, OrdinaryMorphism overlap1) {
        for (Node go1 : overlap1.getSource().getNodesSet()) {
            Node img = (Node)overlap1.getImage(go1);
            Enumeration<GraphObject> en = rule1.getInverseImage(go1);
            if (en.hasMoreElements() || go1.getType().compareTo(img.getType())) continue;
            return false;
        }
        return true;
    }

    public static Vector<Pair<ValueMember, ValueMember>> getAttrMemberByParentType(Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> attrs, AttrType attrtype) {
        Enumeration<AttrType> keys = attrs.keys();
        while (keys.hasMoreElements()) {
            AttrType t = keys.nextElement();
            if (!((DeclTuple)attrtype).hasChild((DeclTuple)t)) continue;
            return attrs.get(t);
        }
        return null;
    }

    public static Vector<Pair<ValueMember, ValueMember>> getAttrMemberByChildType(Hashtable<AttrType, Vector<Pair<ValueMember, ValueMember>>> attrs, AttrType attrtype) {
        Enumeration<AttrType> keys = attrs.keys();
        while (keys.hasMoreElements()) {
            AttrType t = keys.nextElement();
            if (!((DeclTuple)attrtype).hasParent((DeclTuple)t)) continue;
            return attrs.get(t);
        }
        return null;
    }
}

