/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.typeeditor;

import agg.editor.impl.EdType;
import agg.editor.impl.EditUndoManager;
import agg.editor.impl.TypeReprData;
import agg.gui.event.TypeEvent;
import agg.gui.icons.ColorDashLineIcon;
import agg.gui.icons.ColorDotLineIcon;
import agg.gui.icons.ColorSolidLineIcon;
import agg.gui.typeeditor.ColorChooserDialog;
import agg.gui.typeeditor.TypeEditor;
import agg.gui.typeeditor.TypePalette;
import agg.util.Pair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.StateEdit;
import javax.swing.undo.StateEditable;
import javax.swing.undo.UndoManager;

public class ArcTypePropertyEditor
extends JPanel
implements ChangeListener,
StateEditable {
    private EditUndoManager undoManager;
    private StateEdit newEdit;
    private Pair<String, Vector<?>> undoObj;
    private final JFrame applFrame;
    private final TypePalette palette;
    private final TypeEditor typeEditor;
    private String typeName = "";
    private String typeComment = "";
    private Color typeColor = Color.black;
    private int typeShape = 61;
    protected boolean boldStyle;
    protected Point location;
    protected final ColorChooserDialog colorChooser;
    private final ButtonGroup colorGroup;
    private final ButtonGroup shapeGroup;
    protected final JTextField nameEditor;
    private final JEditorPane commentEditor;
    protected final JButton addButton;
    protected final JButton modifyButton;
    protected final JButton deleteButton;
    protected final JButton closeButton;
    protected final JButton cancelButton;
    private final JCheckBox moreColor;
    private final JCheckBox boldCB;
    protected final JDialog dialog;
    boolean changed = false;

    public ArcTypePropertyEditor(JFrame aggappl, TypeEditor typeEditor, TypePalette palette) {
        super(new BorderLayout());
        this.setBorder(new TitledBorder(" Edge Type Properties "));
        this.applFrame = aggappl;
        this.typeEditor = typeEditor;
        this.palette = palette;
        this.colorChooser = new ColorChooserDialog();
        this.colorChooser.addChangeListener(this);
        this.dialog = new JDialog((Frame)this.applFrame, " Edge Type Editor ");
        this.nameEditor = new JTextField(this.typeName);
        this.colorGroup = new ButtonGroup();
        this.moreColor = new JCheckBox("Other", null);
        this.shapeGroup = new ButtonGroup();
        this.boldCB = new JCheckBox("bold", null);
        this.commentEditor = new JEditorPane();
        this.addButton = new JButton();
        this.modifyButton = new JButton();
        this.deleteButton = new JButton();
        this.closeButton = new JButton();
        this.cancelButton = new JButton();
        this.initComponents();
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(EditUndoManager anUndoManager) {
        this.undoManager = anUndoManager;
    }

    public boolean undoManagerAddEdit(String presentationName) {
        if (this.undoManager == null || !this.undoManager.isEnabled()) {
            return false;
        }
        EdType type = this.typeEditor.getSelectedArcType();
        type.setContextUsage(String.valueOf(type.hashCode()));
        TypeReprData data = new TypeReprData(type);
        Vector<TypeReprData> vec = new Vector<TypeReprData>(1);
        vec.add(data);
        this.undoObj = new Pair(presentationName, vec);
        this.newEdit = new StateEdit(this, presentationName);
        return this.undoManager.addEdit(this.newEdit);
    }

    public void undoManagerEndEdit(EdType type) {
        if (this.undoObj == null || this.undoManager == null || !this.undoManager.isEnabled() || this.newEdit == null || type == null) {
            return;
        }
        String first = (String)this.undoObj.first;
        String kind = "";
        Vector<TypeReprData> gos = new Vector<TypeReprData>(1);
        gos.add(new TypeReprData(type));
        if (first.equals("CREATE_DELETE")) {
            kind = "DELETE_CREATE";
        } else if (first.equals("DELETE_CREATE")) {
            kind = "CREATE_DELETE";
        } else if (first.equals("COMMON_DELETE_CREATE")) {
            kind = "CREATE_DELETE";
        } else if (first.equals("CHANGE")) {
            kind = "CHANGE";
        }
        this.undoObj = new Pair(kind, gos);
        this.undoManager.end(this.newEdit);
    }

    @Override
    public void storeState(Hashtable<Object, Object> state) {
        if (this.undoObj.first != null && this.undoObj.second != null) {
            state.put(String.valueOf(this.hashCode()), this.undoObj);
            if (((String)this.undoObj.first).equals("COMMON_DELETE_CREATE")) {
                this.typeEditor.storeState(state);
            }
        }
    }

    @Override
    public void restoreState(Hashtable<?, ?> state) {
        if (state == null) {
            return;
        }
        EdType type = null;
        Pair obj = (Pair)state.get(String.valueOf(this.hashCode()));
        if (obj == null) {
            return;
        }
        if (obj.first == null || obj.second == null) {
            return;
        }
        String op = (String)obj.first;
        Vector vec = (Vector)obj.second;
        TypeReprData data = (TypeReprData)vec.firstElement();
        if (op.equals("CHANGE")) {
            int hc = data.getTypeHashCode();
            int index = -1;
            int i = 0;
            while (i < this.typeEditor.getArcTypes().size()) {
                type = this.typeEditor.getArcTypes().get(i);
                if (type.hashCode() == hc) {
                    index = i;
                    break;
                }
                if (type.getContextUsage().indexOf(":" + String.valueOf(hc) + ":") != -1) {
                    index = i;
                    break;
                }
                type = null;
                ++i;
            }
            if (type != null) {
                data.restoreTypeFromTypeRepr(type);
                this.refreshTypeProperty(type, index);
            }
        } else if (op.equals("CREATE_DELETE")) {
            int hc = data.getTypeHashCode();
            int i = 0;
            while (i < this.typeEditor.getArcTypes().size()) {
                type = this.typeEditor.getArcTypes().get(i);
                if (type.hashCode() == hc || type.getContextUsage().indexOf(":" + String.valueOf(hc) + ":") != -1) break;
                type = null;
                ++i;
            }
            if (type != null && type.isArcType() && !this.typeEditor.deleteArcType(type, false)) {
                this.undoManagerAddEdit("CREATE_DELETE");
            }
        } else if (op.equals("DELETE_CREATE")) {
            type = data.createTypeFromTypeRepr(this.typeEditor.getGraGra().getBasisGraGra().createArcType(false));
            this.typeEditor.addArcType(type);
            this.palette.enableArcTypeDeleteButton(true);
            this.palette.enableArcTypeModifyButton(true);
        } else if (op.equals("COMMON_DELETE_CREATE")) {
            type = data.createTypeFromTypeRepr(this.typeEditor.getGraGra().getBasisGraGra().createArcType(false));
            this.typeEditor.addArcType(type);
            this.palette.enableArcTypeDeleteButton(true);
            this.palette.enableArcTypeModifyButton(true);
            if (state.get(this.typeEditor) != null) {
                this.typeEditor.restoreState(state);
            }
        }
    }

    public TypeEditor getTypeEditor() {
        return this.typeEditor;
    }

    protected JDialog getDialog() {
        return this.dialog;
    }

    @Override
    public boolean isVisible() {
        return this.dialog.isVisible();
    }

    private void showPropertyDialog() {
        if (!this.dialog.isVisible()) {
            if (this.location.y + this.dialog.getHeight() + 10 > Toolkit.getDefaultToolkit().getScreenSize().height) {
                this.location.y = Toolkit.getDefaultToolkit().getScreenSize().height - (this.dialog.getHeight() + 10);
            }
            this.dialog.setLocation(this.location.x, this.location.y);
            this.dialog.setVisible(true);
        }
        this.changed = false;
    }

    private void initComponents() {
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel namePanel = this.initName();
        p1.add((Component)namePanel, "Center");
        JPanel p2 = new JPanel(new GridLayout(1, 0, 5, 5));
        JPanel colorPanel = this.initColors();
        JPanel shapePanel = this.initShapes();
        p2.add(colorPanel);
        p2.add(shapePanel);
        JPanel commentPanel = this.initComment();
        JPanel closePanel = this.initButtons();
        JPanel p3 = new JPanel(new BorderLayout());
        p3.add((Component)commentPanel, "Center");
        p3.add((Component)closePanel, "South");
        this.add((Component)p1, "North");
        this.add((Component)p2, "Center");
        this.add((Component)p3, "South");
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ArcTypePropertyEditor.this.dialog.setVisible(false);
            }
        });
        this.dialog.setContentPane(this);
        this.dialog.validate();
        this.dialog.pack();
        this.dialog.setAlwaysOnTop(true);
    }

    private JPanel initName() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(" Name "));
        this.nameEditor.setForeground(this.typeColor);
        this.nameEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ArcTypePropertyEditor.this.addType(true)) {
                    ArcTypePropertyEditor.this.modifyButton.setEnabled(true);
                    ArcTypePropertyEditor.this.deleteButton.setEnabled(true);
                }
            }
        });
        this.nameEditor.setForeground(this.typeColor);
        JScrollPane scrolltf = new JScrollPane(this.nameEditor);
        scrolltf.setPreferredSize(new Dimension(50, 40));
        panel.add((Component)scrolltf, "Center");
        return panel;
    }

    private JPanel initColors() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(new TitledBorder(" Color "));
        JCheckBox black = new JCheckBox("Black", null, true);
        this.colorGroup.add(black);
        black.setForeground(Color.black);
        if (this.typeColor == Color.black) {
            black.setSelected(true);
        } else {
            black.setSelected(false);
        }
        black.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ArcTypePropertyEditor.this.nameEditor.setForeground(Color.black);
                }
            }
        });
        panel.add(black);
        JCheckBox red = new JCheckBox("Red", null);
        this.colorGroup.add(red);
        red.setForeground(Color.red);
        if (this.typeColor == Color.red) {
            red.setSelected(true);
        } else {
            red.setSelected(false);
        }
        red.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ArcTypePropertyEditor.this.nameEditor.setForeground(Color.red);
                }
            }
        });
        panel.add(red);
        JCheckBox orange = new JCheckBox("Orange", null);
        this.colorGroup.add(orange);
        orange.setForeground(Color.orange);
        if (this.typeColor == Color.orange) {
            orange.setSelected(true);
        } else {
            orange.setSelected(false);
        }
        orange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ArcTypePropertyEditor.this.nameEditor.setForeground(Color.orange);
                }
            }
        });
        panel.add(orange);
        JCheckBox blue = new JCheckBox("Blue", null);
        this.colorGroup.add(blue);
        blue.setForeground(Color.blue);
        if (this.typeColor == Color.blue) {
            blue.setSelected(true);
        } else {
            blue.setSelected(false);
        }
        blue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ArcTypePropertyEditor.this.nameEditor.setForeground(Color.blue);
                }
            }
        });
        panel.add(blue);
        JCheckBox pink = new JCheckBox("Pink", null);
        this.colorGroup.add(pink);
        pink.setForeground(Color.pink);
        if (this.typeColor == Color.pink) {
            pink.setSelected(true);
        } else {
            pink.setSelected(false);
        }
        pink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ArcTypePropertyEditor.this.nameEditor.setForeground(Color.pink);
                }
            }
        });
        panel.add(pink);
        this.colorGroup.add(this.moreColor);
        if (!this.colorGroup.isSelected(this.colorGroup.getSelection())) {
            this.moreColor.setSelected(true);
        } else {
            this.moreColor.setSelected(false);
        }
        this.moreColor.setForeground(Color.black);
        this.moreColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArcTypePropertyEditor.this.colorChooser.showColorDialog(ArcTypePropertyEditor.this.dialog, ArcTypePropertyEditor.this.location);
            }
        });
        panel.add(this.moreColor);
        return panel;
    }

    private JPanel initShapes() {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.setBorder(new TitledBorder(" Style "));
        JCheckBox solid = new JCheckBox("Solid", null, true);
        this.shapeGroup.add(solid);
        if (this.typeShape == 61) {
            solid.setSelected(true);
        } else {
            solid.setSelected(false);
        }
        panel.add(solid);
        JCheckBox dot = new JCheckBox("Dot", null);
        this.shapeGroup.add(dot);
        if (this.typeShape == 63) {
            dot.setSelected(true);
        } else {
            dot.setSelected(false);
        }
        panel.add(dot);
        JCheckBox dash = new JCheckBox("Dash", null);
        this.shapeGroup.add(dash);
        if (this.typeShape == 62) {
            dash.setSelected(true);
        } else {
            dash.setSelected(false);
        }
        panel.add(dash);
        panel.add(new JLabel("      "));
        panel.add(this.boldCB);
        return panel;
    }

    private JPanel initComment() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(" Comment "));
        this.commentEditor.setText(this.typeComment);
        JScrollPane scrollpane = new JScrollPane(this.commentEditor);
        scrollpane.setPreferredSize(new Dimension(200, 100));
        panel.add(scrollpane);
        return panel;
    }

    private JPanel initButtons() {
        JPanel p = new JPanel(new GridLayout(2, 0, 10, 10));
        JPanel p1 = new JPanel(new GridLayout(0, 3, 10, 10));
        JPanel p2 = new JPanel(new GridLayout(0, 2, 10, 10));
        this.addButton.setActionCommand("add");
        this.addButton.setText("Add");
        this.addButton.setToolTipText("Add new type.");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArcTypePropertyEditor.this.addType(false);
                ArcTypePropertyEditor.this.modifyButton.setEnabled(true);
                ArcTypePropertyEditor.this.deleteButton.setEnabled(true);
            }
        });
        this.modifyButton.setActionCommand("change");
        this.modifyButton.setText("Modify");
        this.modifyButton.setToolTipText("Modify type properties.");
        this.modifyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArcTypePropertyEditor.this.changeType();
            }
        });
        this.deleteButton.setActionCommand("delete");
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete type.");
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArcTypePropertyEditor.this.deleteType();
            }
        });
        p1.add(this.addButton);
        p1.add(this.modifyButton);
        p1.add(this.deleteButton);
        this.closeButton.setActionCommand("close");
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Accept type properties and close dialog.");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArcTypePropertyEditor.this.close();
            }
        });
        this.cancelButton.setActionCommand("cancel");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel changes and close dialog.");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArcTypePropertyEditor.this.cancel();
            }
        });
        p2.add(this.closeButton);
        p2.add(this.cancelButton);
        p.add(p1);
        p.add(p2);
        return p;
    }

    public void enableChangeButton(boolean b) {
        this.modifyButton.setEnabled(b);
    }

    public void enableDeleteButton(boolean b) {
        this.deleteButton.setEnabled(b);
    }

    private void accept() {
        JCheckBox cb;
        this.changed = false;
        if (!this.typeName.equals(this.nameEditor.getText())) {
            this.changed = true;
            this.typeName = this.nameEditor.getText().replaceAll(" ", "");
        }
        Enumeration<AbstractButton> en = this.colorGroup.getElements();
        while (en.hasMoreElements()) {
            Color c;
            cb = (JCheckBox)en.nextElement();
            if (cb.isSelected()) {
                c = this.getTypeColor(cb.getText());
                if (this.typeColor.toString().equals(c.toString())) continue;
                this.changed = true;
                this.typeColor = c;
                this.nameEditor.setForeground(this.typeColor);
                break;
            }
            if (!this.moreColor.isSelected() || this.typeColor.equals(c = this.moreColor.getForeground())) continue;
            this.changed = true;
            this.typeColor = c;
            this.nameEditor.setForeground(this.typeColor);
            break;
        }
        en = this.shapeGroup.getElements();
        while (en.hasMoreElements()) {
            int sh;
            cb = (JCheckBox)en.nextElement();
            if (!cb.isSelected() || this.typeShape == (sh = this.getTypeShape(cb.getText()))) continue;
            this.changed = true;
            this.typeShape = sh;
            break;
        }
        if (this.boldStyle != this.boldCB.isSelected()) {
            this.changed = true;
            this.boldStyle = this.boldCB.isSelected();
        }
        if (!this.typeComment.equals(this.commentEditor.getText())) {
            this.typeComment = this.commentEditor.getText();
        }
    }

    protected boolean addType(boolean suppressWarning) {
        boolean result = false;
        this.accept();
        EdType t = this.typeEditor.addArcType(this.typeName, this.typeColor, this.typeShape, this.boldStyle, this.typeComment);
        if (t == null) {
            JOptionPane.showMessageDialog(this.dialog, "Type already exists.");
        } else {
            result = true;
        }
        this.changed = false;
        return result;
    }

    void changeType() {
        this.accept();
        if (this.changed) {
            if (!this.typeEditor.changeSelectedArcType(this.typeName, this.typeColor, this.typeShape, this.boldStyle, this.typeComment)) {
                JOptionPane.showMessageDialog(this.dialog, "Type already exists.");
            } else {
                this.changed = false;
            }
        }
    }

    void deleteType() {
        this.typeEditor.deleteSelectedArcType(true);
    }

    void close() {
        this.accept();
        if (this.changed) {
            JOptionPane.showMessageDialog(this.dialog, "You have changed the type properties.\nPlease save or cancel the entries.");
            return;
        }
        this.hideDialog();
    }

    void cancel() {
        this.hideDialog();
    }

    void hideDialog() {
        if (!this.palette.isArcTypesEmpty()) {
            this.palette.enableArcTypeModifyButton(true);
            this.palette.enableArcTypeDeleteButton(true);
        } else {
            this.palette.enableArcTypeModifyButton(false);
            this.palette.enableArcTypeDeleteButton(false);
        }
        this.dialog.setVisible(false);
    }

    public void setSelectedTypeProperty(EdType t) {
        this.typeName = t.getName();
        this.typeColor = t.getColor();
        this.typeShape = t.getShape();
        this.boldStyle = t.hasFilledShape();
        this.typeComment = t.getBasisType().getTextualComment();
        this.setTypeProperty();
        this.changed = false;
    }

    public void setSelectedTypeProperty(String tname, Color tcolor, int tshape, boolean tboldstyle, String tcomment) {
        this.typeName = tname;
        this.typeColor = tcolor;
        this.typeShape = tshape;
        this.boldStyle = tboldstyle;
        this.typeComment = tcomment;
        this.setTypeProperty();
        this.changed = false;
    }

    public void setNewTypeDefaultProperty() {
        this.typeName = "";
        this.typeColor = Color.black;
        this.typeShape = 61;
        this.typeComment = "";
        this.setTypeProperty();
        this.changed = false;
    }

    private void refreshTypeProperty(EdType t, int index) {
        this.typeName = t.getName();
        this.typeColor = t.getColor();
        this.typeShape = t.getShape();
        this.typeComment = t.getBasisType().getTextualComment();
        this.setTypeProperty();
        this.accept();
        JLabel l = this.typeEditor.makeArcTypeLabel(t);
        this.palette.changeArcType(l, index);
        this.typeEditor.fireTypeEvent(new TypeEvent(this, t, index, 12));
        this.changed = false;
    }

    private void setTypeProperty() {
        this.nameEditor.setText(this.typeName);
        this.nameEditor.setForeground(this.typeColor);
        String colorStr = this.getTypeColorStr(this.typeColor);
        Enumeration<AbstractButton> en = this.colorGroup.getElements();
        while (en.hasMoreElements()) {
            JCheckBox cb = (JCheckBox)en.nextElement();
            if (!cb.getText().equals(colorStr)) continue;
            if (cb.getText().equals("Other")) {
                this.moreColor.setForeground(this.typeColor);
            }
            cb.setSelected(true);
            break;
        }
        String shapeStr = this.getTypeShapeStr(this.typeShape);
        en = this.shapeGroup.getElements();
        while (en.hasMoreElements()) {
            JCheckBox cb = (JCheckBox)en.nextElement();
            if (!cb.getText().equals(shapeStr)) continue;
            cb.setSelected(true);
        }
        this.boldCB.setSelected(this.boldStyle);
        this.commentEditor.setText(this.typeComment);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Color newColor = this.colorChooser.getColor();
        this.moreColor.setForeground(newColor);
        this.nameEditor.setForeground(newColor);
    }

    @Override
    public String getName() {
        return this.typeName;
    }

    public Color getSelectedColor() {
        return this.typeColor;
    }

    public int getSelectedShape() {
        return this.typeShape;
    }

    private String getTypeShapeStr(int sh) {
        String s = "";
        switch (sh) {
            case 61: {
                s = "Solid";
                break;
            }
            case 63: {
                s = "Dot";
                break;
            }
            case 62: {
                s = "Dash";
                break;
            }
        }
        return s;
    }

    public void invoke() {
        this.location = new Point(100, 100);
        this.showPropertyDialog();
    }

    public void invoke(int x, int y) {
        this.location = new Point(x, y);
        this.showPropertyDialog();
    }

    private Color getTypeColor(String col) {
        if (col.equals("Black")) {
            return Color.black;
        }
        if (col.equals("Red")) {
            return Color.red;
        }
        if (col.equals("Blue")) {
            return Color.blue;
        }
        if (col.equals("White")) {
            return Color.white;
        }
        if (col.equals("Yellow")) {
            return Color.yellow;
        }
        if (col.equals("Orange")) {
            return Color.orange;
        }
        if (col.equals("Pink")) {
            return Color.pink;
        }
        if (col.equals("Other")) {
            return this.moreColor.getForeground();
        }
        return Color.black;
    }

    private String getTypeColorStr(Color col) {
        if (col.equals(Color.black)) {
            return "Black";
        }
        if (col.equals(Color.red)) {
            return "Red";
        }
        if (col.equals(Color.blue)) {
            return "Blue";
        }
        if (col.equals(Color.white)) {
            return "White";
        }
        if (col.equals(Color.yellow)) {
            return "Yellow";
        }
        if (col.equals(Color.orange)) {
            return "Orange";
        }
        if (col.equals(Color.pink)) {
            return "Pink";
        }
        return "Other";
    }

    int getTypeShape(String shape) {
        if (shape.equals("Solid")) {
            return 61;
        }
        if (shape.equals("Dash")) {
            return 62;
        }
        return 63;
    }

    public Icon getArcTypeIcon(int shape, Color color, boolean bold) {
        Icon icon = null;
        switch (shape) {
            case 61: {
                icon = new ColorSolidLineIcon(color, bold);
                break;
            }
            case 62: {
                icon = new ColorDashLineIcon(color, bold);
                break;
            }
            case 63: {
                icon = new ColorDotLineIcon(color, bold);
                break;
            }
        }
        return icon;
    }
}

