/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview;

import agg.attribute.impl.CondMember;
import agg.editor.impl.EdRule;
import agg.gui.IconResource;
import agg.gui.icons.NestedACIcon;
import agg.gui.icons.NewConclusionIcon;
import agg.gui.icons.TextIcon;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.xt_basis.agt.MultiRule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class GraGraTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean notApplicable;
    protected boolean isTriggerRule = false;
    protected boolean isKernelRule = false;
    protected boolean isFormula = false;
    protected boolean isDisabled = false;
    protected static final Color SelectedColor = new Color(153, 153, 255);
    protected static final Color NotApplicableColor = Color.LIGHT_GRAY;
    protected static final Color TriggerRuleColor = Color.RED;
    protected static final Color RuleFormulaColor = Color.BLUE;
    protected static final Color DisabledColor = Color.LIGHT_GRAY;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.setText(stringValue);
        this.setIconTextGap(5);
        GraGraTreeNodeData userObject = (GraGraTreeNodeData)((DefaultMutableTreeNode)value).getUserObject();
        this.notApplicable = false;
        this.isTriggerRule = false;
        this.isKernelRule = false;
        this.isFormula = false;
        this.isDisabled = false;
        if (userObject.isGraGra()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLGraGra()));
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isTypeGraph()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLTypeGraph()));
            this.setToolTipText(userObject.getToolTipText());
            this.isDisabled = userObject.getGraph().getBasisGraph().getTypeSet().getLevelOfTypeGraphCheck() == 0;
        } else if (userObject.isGraph()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLGraph()));
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isRuleScheme()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLRuleScheme()));
            this.notApplicable = !userObject.getRuleScheme().getKernelRule().isApplicable();
            this.isDisabled = !userObject.getRuleScheme().getBasisRuleScheme().isEnabled();
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isKernelRule()) {
            this.isKernelRule = true;
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLRule()));
            this.notApplicable = !userObject.getKernelRule().isApplicable();
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isMultiRule()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLRule()));
            this.notApplicable = !((MultiRule)userObject.getMultiRule().getBasisRule()).getRuleScheme().isApplicable();
            this.isDisabled = !((MultiRule)userObject.getMultiRule().getBasisRule()).isEnabled();
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isAmalgamatedRule()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLRule()));
            this.setToolTipText(userObject.getToolTipText());
            this.isDisabled = !userObject.getAmalgamatedRule().getBasisRule().isEnabled();
        } else if (userObject.isRule()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLRule()));
            this.notApplicable = !userObject.getRule().isApplicable();
            this.isTriggerRule = userObject.getRule().getBasisRule().isTriggerOfLayer();
            this.isDisabled = !userObject.getRule().getBasisRule().isEnabled();
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isNestedAC()) {
            NestedACIcon icon = new NestedACIcon(Color.blue);
            this.setIcon(icon);
            this.setToolTipText(userObject.getToolTipText());
            this.notApplicable = !userObject.getNestedAC().getRule().isApplicable();
            this.isDisabled = !userObject.getNestedAC().getMorphism().isEnabled();
        } else if (userObject.isNAC()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLNAC()));
            this.setToolTipText(userObject.getToolTipText());
            this.notApplicable = !userObject.getNAC().getRule().isApplicable();
            this.isDisabled = !userObject.getNAC().getMorphism().isEnabled();
        } else if (userObject.isPAC()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLPAC()));
            this.setToolTipText(userObject.getToolTipText());
            this.notApplicable = !userObject.getPAC().getRule().isApplicable();
            this.isDisabled = !userObject.getPAC().getMorphism().isEnabled();
        } else if (userObject.isAttrCondition()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLAttrCondition()));
            this.setToolTipText(userObject.getToolTipText());
            this.notApplicable = !((EdRule)userObject.getAttrCondition().second).isApplicable();
            this.isDisabled = !((CondMember)userObject.getAttrCondition().first).isEnabled();
        } else if (userObject.isAtomic()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLAtomic()));
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isConclusion()) {
            NewConclusionIcon icon = new NewConclusionIcon(Color.blue);
            icon.setEnabled(true);
            this.setIcon(icon);
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isConstraint()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLConstraint()));
            this.setToolTipText(userObject.getToolTipText());
            this.isDisabled = !userObject.getConstraint().getBasisConstraint().isEnabled();
        } else if (userObject.isRuleConstraint()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLPost()));
            this.setToolTipText(userObject.getToolTipText());
            this.notApplicable = !userObject.getRuleConstraint().getRule().isApplicable();
        } else if (userObject.isAtomApplCond()) {
            this.setIcon(IconResource.getIconFromURL(IconResource.getURLAtomConstr()));
            this.setToolTipText(userObject.getToolTipText());
            this.notApplicable = !userObject.getAtomApplCond().getRule().isApplicable();
        } else if (userObject.isRuleSequence()) {
            this.setIcon(null);
            this.setToolTipText(userObject.getToolTipText());
        } else if (userObject.isApplFormula()) {
            TextIcon icon = new TextIcon("F", true);
            icon.setColor(Color.red);
            this.setIcon(icon);
            this.setToolTipText(userObject.getToolTipText());
            this.isFormula = true;
        } else {
            this.setIcon(null);
            this.setToolTipText("");
        }
        this.selected = sel;
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        Color bColor = Color.WHITE;
        Color fColor = Color.BLACK;
        if (this.notApplicable) {
            fColor = NotApplicableColor;
        } else if (this.isTriggerRule || this.isKernelRule) {
            fColor = TriggerRuleColor;
        } else if (this.isFormula) {
            fColor = RuleFormulaColor;
        }
        bColor = this.isDisabled ? DisabledColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
        if (this.selected) {
            bColor = SelectedColor;
        }
        g.setColor(bColor);
        this.setForeground(fColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g);
    }
}

