/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.parser;

import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.gui.IconResource;
import agg.gui.editor.GraphCanvas;
import agg.gui.editor.GraphEditor;
import agg.gui.editor.GraphPanel;
import agg.gui.options.ParserGUIOption;
import agg.gui.parser.AGGParser;
import agg.gui.parser.event.StatusMessageEvent;
import agg.gui.parser.event.StatusMessageListener;
import agg.parser.Parser;
import agg.parser.ParserErrorEvent;
import agg.parser.ParserEvent;
import agg.parser.ParserEventListener;
import agg.parser.ParserMessageEvent;
import agg.xt_basis.Graph;
import agg.xt_basis.OrdinaryMorphism;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class ParserDesktop
implements InternalFrameListener,
ParserEventListener {
    private static final int STOP_GRAPH = 1;
    private static final int HOST_GRAPH = 2;
    private AGGParser aggparser;
    final JDesktopPane desktop = new JDesktopPane();
    private EdGraGra layout;
    private Dimension internalFrameSize;
    private ParserGUIOption option;
    private Parser parser;
    protected JInternalFrame hostFrame;
    private GraphEditor hostGraphEditor;
    private EdGraph hostGraphLayout;
    protected JInternalFrame stopFrame;
    private GraphEditor stopGraphEditor;
    private EdGraph stopGraphLayout;
    private boolean graphFramesExist;
    private Vector<StatusMessageListener> listener;
    private KeyAdapter keyAdapter;
    private String typedKey;
    private MouseListener ml;
    protected JPopupMenu graphMenu = new JPopupMenu("Graph");
    protected JMenuItem miLayoutGraph = new JMenuItem("Layout Graph");
    protected GraphPanel activeGraphPanel;

    public ParserDesktop(AGGParser aggparser, ParserGUIOption option) {
        this(aggparser, option, null, null, null);
    }

    public ParserDesktop(AGGParser aggparser, ParserGUIOption option, EdGraGra aLayout, Graph aHostGraph, Graph aStopGraph) {
        this.desktop.setBackground(Color.white);
        this.desktop.setForeground(Color.white);
        this.aggparser = aggparser;
        this.option = option;
        this.setInternalFrameSize(new Dimension(200, 200));
        this.keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ParserDesktop.this.performShortKeyEvent(e);
            }
        };
        this.desktop.addKeyListener(this.keyAdapter);
        this.makeGraphMenu();
        this.ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger() && e.getSource() instanceof GraphCanvas) {
                    ParserDesktop.this.activeGraphPanel = ((GraphCanvas)e.getSource()).getViewport();
                    ParserDesktop.this.graphMenu.show(ParserDesktop.this.activeGraphPanel, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && e.getSource() instanceof GraphCanvas) {
                    ParserDesktop.this.activeGraphPanel = ((GraphCanvas)e.getSource()).getViewport();
                    ParserDesktop.this.graphMenu.show(ParserDesktop.this.activeGraphPanel, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ParserDesktop.this.desktop.requestFocusInWindow();
            }
        };
        this.desktop.addMouseListener(this.ml);
        this.listener = new Vector();
        if (aHostGraph != null && aStopGraph != null) {
            this.makeGraphFrames();
            this.setLayout(aLayout);
            this.setStopGraph(aStopGraph);
            this.setHostGraph(aHostGraph);
        }
    }

    private void makeGraphFrames() {
        this.makeStopGraphFrame();
        this.makeHostGraphFrame();
        this.graphFramesExist = true;
    }

    private void makeStopGraphFrame() {
        if (this.stopFrame == null) {
            this.stopGraphEditor = new GraphEditor(null);
            this.stopGraphEditor.setEditMode(9);
            this.stopGraphEditor.getGraphPanel().setName("");
            this.stopGraphEditor.removeTitlePanel();
            this.stopGraphEditor.getGraphPanel().getCanvas().addMouseListener(this.ml);
            this.stopFrame = new JInternalFrame("Stop Graph", true, false, true, true);
            this.stopFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getStopIcon()));
            this.stopFrame.setBackground(Color.white);
            this.stopFrame.setForeground(Color.white);
            this.stopFrame.addInternalFrameListener(this);
            this.stopFrame.addMouseListener(this.ml);
            this.stopFrame.addKeyListener(this.keyAdapter);
            this.stopFrame.setVisible(false);
            this.stopFrame.setSize(this.internalFrameSize);
            this.stopFrame.getContentPane().add(this.stopGraphEditor);
            this.stopFrame.pack();
            this.desktop.add((Component)this.stopFrame, (Object)1);
        }
    }

    private void makeHostGraphFrame() {
        if (this.hostFrame == null) {
            this.hostGraphEditor = new GraphEditor(null);
            this.hostGraphEditor.setEditMode(9);
            this.hostGraphEditor.removeTitlePanel();
            this.hostGraphEditor.getGraphPanel().setName("");
            this.hostGraphEditor.getGraphPanel().getCanvas().addMouseListener(this.ml);
            this.hostFrame = new JInternalFrame("Host Graph", true, false, true, true);
            this.hostFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getWorkerIcon()));
            this.hostFrame.setBackground(Color.white);
            this.hostFrame.setForeground(Color.white);
            this.hostFrame.addInternalFrameListener(this);
            this.hostFrame.addMouseListener(this.ml);
            this.hostFrame.addKeyListener(this.keyAdapter);
            this.hostFrame.setVisible(false);
            this.hostFrame.setPreferredSize(new Dimension(600, 400));
            this.hostFrame.setLocation(200, 0);
            this.hostFrame.getContentPane().add(this.hostGraphEditor);
            this.hostFrame.pack();
            this.desktop.add((Component)this.hostFrame, (Object)2);
        }
    }

    boolean performShortKeyEvent(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if (e.isShiftDown() && e.isAltDown()) {
            this.typedKey = KeyEvent.getKeyText(keyCode);
            if (this.typedKey.equals("S")) {
                this.aggparser.startParser();
            } else if (this.typedKey.equals("Q")) {
                this.aggparser.stopParser();
            } else if (this.typedKey.equals("Z")) {
                this.aggparser.backToGUI();
            } else {
                return false;
            }
        }
        return true;
    }

    public Component getComponent() {
        return this.getDesktop();
    }

    public JDesktopPane getDesktop() {
        return this.desktop;
    }

    public void setLayout(EdGraGra layout) {
        this.layout = layout;
        this.hostGraphLayout = null;
    }

    public void setStopLayout(EdGraph layout) {
        this.stopGraphLayout = layout;
    }

    public void setInternalFrameSize(Dimension internalFrameSize) {
        this.internalFrameSize = internalFrameSize;
    }

    private void setGraph(Graph graph, int graphType) {
        if (graphType != 2 && graphType != 1) {
            return;
        }
        switch (graphType) {
            case 1: {
                if (this.stopGraphEditor.getGraph() != null) {
                    this.stopGraphEditor.setGraph(null);
                }
                EdGraph eg = null;
                if (this.stopGraphLayout != null) {
                    if (this.stopGraphLayout.getBasisGraph() == graph) {
                        eg = this.stopGraphLayout;
                    } else {
                        eg = new EdGraph(graph, this.layout.getTypeSet());
                        eg.doDefaultEvolutionaryGraphLayout(20);
                    }
                } else if (graph != null) {
                    eg = new EdGraph(graph, this.layout.getTypeSet());
                    eg.doDefaultEvolutionaryGraphLayout(20);
                }
                if (eg != null && this.stopGraphLayout != null) {
                    eg.setLayoutByBasisObject(this.stopGraphLayout);
                }
                if (this.option.getParserDisplay() == 3) {
                    this.stopFrame.setVisible(true);
                } else {
                    this.stopFrame.setVisible(false);
                }
                this.stopGraphEditor.setGraph(this.stopGraphLayout);
                break;
            }
            case 2: {
                if (this.hostGraphEditor.getGraph() != null) {
                    this.hostGraphEditor.setGraph(null);
                }
                if (this.hostGraphLayout == null && graph != null) {
                    this.hostGraphLayout = new EdGraph(graph, this.layout.getTypeSet());
                    this.hostGraphLayout.setTransformChangeEnabled(true);
                    this.hostGraphLayout.setLayoutByIndex(this.layout.getGraph(), false);
                }
                if (this.option.getParserDisplay() >= 1) {
                    this.hostFrame.setVisible(true);
                } else {
                    this.hostFrame.setVisible(false);
                }
                if (this.hostGraphEditor.getGraph() == null) {
                    this.hostGraphEditor.setGraph(this.hostGraphLayout);
                } else {
                    this.hostGraphEditor.getGraphPanel().setGraph(this.hostGraphLayout, false);
                }
                this.hostGraphEditor.getGraphPanel().updateGraphics();
                break;
            }
        }
    }

    protected void updateFrame(OrdinaryMorphism om, int graphType) {
        if (graphType != 2) {
            return;
        }
        if (this.hostGraphLayout.getBasisGraph() != om.getImage()) {
            EdGraph oldLayout = this.hostGraphLayout;
            this.hostGraphLayout = new EdGraph(om.getImage(), this.layout.getTypeSet());
            this.hostGraphLayout.getBasisGraph().setName("");
            if (!this.hostGraphLayout.updateLayoutByIsoMorphism(om, oldLayout)) {
                this.hostGraphLayout.setLayoutByIndex(oldLayout, false);
            }
            this.hostGraphLayout.resolveArcOverlappings(15);
        }
        this.hostGraphLayout.setTransformChangeEnabled(true);
        this.updateFrame(this.hostFrame, this.hostGraphLayout);
    }

    protected void updateFrame(JInternalFrame theFrame, EdGraph graphLayout) {
        if (theFrame == this.hostFrame) {
            this.hostFrameSetAnimationIcon();
            this.hostGraphEditor.getGraphPanel().setGraph(graphLayout, false);
        } else if (theFrame == this.stopFrame) {
            this.stopGraphEditor.getGraphPanel().setGraph(graphLayout, false);
        }
    }

    protected void updateFrame(Graph graph, int graphType) {
        if (graphType == 2) {
            if (this.hostGraphLayout.getBasisGraph() != graph) {
                EdGraph eg = new EdGraph(graph, this.layout.getTypeSet());
                eg.setLayoutByIndex(this.hostGraphLayout, false);
                eg.resolveArcOverlappings(15);
                this.hostGraphLayout = eg;
                this.hostGraphLayout.setTransformChangeEnabled(true);
                this.updateFrame(this.hostFrame, this.hostGraphLayout);
            } else {
                this.hostGraphLayout.resolveArcOverlappings(15);
                this.updateFrame(this.hostFrame, this.hostGraphLayout);
            }
        }
    }

    public void setHostGraph(Graph graph) {
        this.setGraph(graph, 2);
    }

    public void setStopGraph(Graph graph) {
        this.setGraph(graph, 1);
    }

    public void setParser(Parser parser) {
        if (!this.graphFramesExist) {
            this.makeGraphFrames();
        }
        this.parser = parser;
        this.parser.addParserEventListener(this);
        this.setStopGraph(parser.getStopGraph());
        this.setHostGraph(parser.getHostGraph());
    }

    public void setParser(Parser parser, OrdinaryMorphism om) {
        if (!this.graphFramesExist) {
            this.makeGraphFrames();
        }
        this.parser = parser;
        this.parser.addParserEventListener(this);
        this.setStopGraph(parser.getStopGraph());
        this.setHostGraph(om.getOriginal());
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        if ((JInternalFrame)e.getSource() == this.hostFrame) {
            this.hostFrame.toFront();
        } else if ((JInternalFrame)e.getSource() == this.stopFrame) {
            this.stopFrame.toFront();
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public void parserEventOccured(ParserEvent p) {
        if (p instanceof ParserMessageEvent) {
            String message = ((ParserMessageEvent)p).getMessage();
            Object source = p.getSource();
            if (message.indexOf("applied") != -1 || message.indexOf("IsoCopy") != -1) {
                this.fireStatusMessageEvent(new StatusMessageEvent(this, "", message));
                if (source instanceof Parser) {
                    this.updateFrame(((Parser)source).getHostGraph(), 2);
                } else if (source instanceof OrdinaryMorphism) {
                    this.updateFrame((OrdinaryMorphism)source, 2);
                }
            } else if (message.indexOf("Result") != -1 && source instanceof Parser) {
                this.hostFrameResetIcon();
                this.updateFrame(((Parser)source).getHostGraph(), 2);
            }
        } else if (p instanceof ParserErrorEvent) {
            String message = ((ParserErrorEvent)p).getMessage();
            this.fireStatusMessageEvent(new StatusMessageEvent(this, "ERROR", "Error: " + message));
        }
    }

    public void hostFrameSetAnimationIcon() {
        this.hostFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getWorkingIcon()));
    }

    public void hostFrameResetIcon() {
        this.hostFrame.setFrameIcon(IconResource.getIconFromURL(IconResource.getWorkerIcon()));
    }

    public void addStatusMessageListener(StatusMessageListener l) {
        if (!this.listener.contains(l)) {
            this.listener.addElement(l);
        }
    }

    private void fireStatusMessageEvent(StatusMessageEvent sme) {
        int i = 0;
        while (i < this.listener.size()) {
            this.listener.elementAt(i).newMessage(sme);
            ++i;
        }
    }

    public void disposeTestHostGraph(EdGraGra gra) {
        if (gra.getGraphOf(this.hostGraphLayout.getBasisGraph()) == null) {
            this.hostGraphLayout.dispose();
        }
    }

    private void makeGraphMenu() {
        this.graphMenu.add(this.miLayoutGraph);
        this.miLayoutGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ParserDesktop.this.activeGraphPanel != null && ParserDesktop.this.activeGraphPanel.getGraph() != null) {
                    ParserDesktop.this.makeLayout(ParserDesktop.this.activeGraphPanel.getGraph(), ParserDesktop.this.activeGraphPanel.getSize());
                    ParserDesktop.this.activeGraphPanel.updateGraphics();
                }
            }
        });
    }

    protected void makeLayout(EdGraph g, Dimension d) {
        g.updateVisibility();
        List<EdNode> visiblenodes = g.getVisibleNodes();
        g.setCurrentLayoutToDefault(false);
        g.getDefaultGraphLayouter().setEnabled(true);
        Dimension dim = g.getDefaultGraphLayouter().getNeededPanelSize(visiblenodes);
        if (dim.width < 350) {
            dim.width = 350;
        }
        if (dim.width < d.width) {
            dim.width = d.width;
        }
        if (dim.height < 250) {
            dim.height = 250;
        }
        if (dim.height < d.height) {
            dim.height = d.height;
        }
        g.getDefaultGraphLayouter().setPanelSize(dim);
        g.getDefaultGraphLayouter().allowChangePanelSize(false);
        g.getDefaultGraphLayouter().setEnabled(true);
        g.doDefaultEvolutionaryGraphLayout(g.getDefaultGraphLayouter(), 100, 10);
    }
}

