/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.attribute.view.AttrViewSetting;
import agg.editor.impl.EdArc;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdNode;
import agg.editor.impl.EdType;
import agg.gui.editor.EditorConstants;
import agg.gui.editor.GraphPanel;
import agg.xt_basis.GraphObject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Vector;

public abstract class EdGraphObject {
    protected int criticalStyle = 0;
    protected Integer itsUndoReprDataHC;
    protected EdType eType;
    protected EdGraph eGraph;
    protected int x = 0;
    protected int y = 0;
    protected int w;
    protected int h;
    double itsScale = 1.0;
    protected String contextUsage = "";
    protected boolean hasDefaultLayout;
    protected boolean elemOfTG;
    protected boolean errorMode;
    protected boolean visible = true;
    protected boolean attrVisible = true;
    protected Color backgroundColor = null;
    protected int myKey = 0;
    protected final transient Vector<String> marks;
    protected transient EdGraphObject myCopy;
    protected transient boolean selected;
    protected transient boolean weakselected;
    protected transient boolean moved;
    protected transient GraphPanel myGraphPanel;
    protected transient boolean attrObserver;
    protected transient boolean attrChanged;
    protected AttrViewSetting view;
    protected transient boolean init;

    public EdGraphObject(EdType eType) {
        this.eType = eType;
        this.marks = new Vector();
    }

    public abstract void dispose();

    public EdGraph getContext() {
        return this.eGraph;
    }

    public void setContext(EdGraph g) {
        this.eGraph = g;
    }

    public abstract GraphObject getBasisObject();

    public abstract boolean isNode();

    public abstract boolean isArc();

    public abstract EdNode getNode();

    public abstract EdArc getArc();

    public abstract void setCritical(boolean var1);

    public abstract void setDrawingStyleOfCriticalObject(int var1);

    public abstract boolean isCritical();

    public abstract Vector<Vector<String>> getAttributes();

    public abstract void refreshAttributeInstance();

    public abstract void removeFromAttributeViewObserver();

    public abstract void setGraphPanel(GraphPanel var1);

    public abstract Vector<Vector<String>> setAttributes(GraphObject var1);

    public abstract void drawGraphic(Graphics var1);

    public boolean isAttrObserver() {
        return this.attrObserver;
    }

    public void setAttrObserver(boolean obs) {
        this.attrObserver = obs;
        this.init = true;
    }

    public EdGraphObject getCopy() {
        return this.myCopy;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public EdType getType() {
        return this.eType;
    }

    public String getTypeName() {
        return this.eType.getTypeName();
    }

    public int getMyKey() {
        return this.myKey;
    }

    public String getMorphismMark() {
        StringBuffer markBuf = new StringBuffer();
        int i = 0;
        while (i < this.marks.size()) {
            if (i > 0) {
                markBuf.append(',');
            }
            markBuf.append(this.marks.elementAt(i));
            ++i;
        }
        return markBuf.toString();
    }

    public int getTextHeight(FontMetrics fm) {
        Vector<Vector<String>> attrs = this.getAttributes();
        int nn = 0;
        int h1 = 0;
        h1 = fm == null ? 17 : fm.getHeight();
        if (fm != null && fm.getFont().getSize() < 8 || !this.attrVisible) {
            return h1;
        }
        if (attrs != null) {
            nn = attrs.size();
            int i = 0;
            while (i < attrs.size()) {
                Vector<String> attr = attrs.elementAt(i);
                if (!this.elemOfTG && attr.elementAt(2).length() == 0) {
                    --nn;
                } else if (this.elemOfTG && attr.elementAt(1) == null) {
                    --nn;
                }
                ++i;
            }
        }
        int hght = h1 * nn;
        return hght += h1;
    }

    public int getTextWidth(FontMetrics fm) {
        int nn = 6;
        String typeStr = "";
        typeStr = this.getTypeString();
        if (this.isNode()) {
            if (this.getType().getBasisType().isAbstract()) {
                typeStr = !typeStr.equals("") ? "{" + typeStr + "}" : "{ }";
            }
            if (this.elemOfTG) {
                typeStr = String.valueOf(typeStr) + " " + ((EdNode)this).getMultiplicityString();
            }
        }
        int wdth = 0;
        wdth = fm == null ? nn * typeStr.length() : fm.stringWidth(typeStr);
        if (fm != null && fm.getFont().getSize() < 8 || !this.attrVisible) {
            return wdth;
        }
        Vector<Vector<String>> attrs = this.getAttributes();
        if (attrs != null) {
            int i = 0;
            while (i < attrs.size()) {
                String tstStr;
                Vector<String> attr = attrs.elementAt(i);
                if (this.elemOfTG) {
                    if (attr.elementAt(1) != null) {
                        tstStr = String.valueOf(attr.elementAt(0)) + "  " + attr.elementAt(1);
                        if (attr.elementAt(2).length() != 0) {
                            tstStr = String.valueOf(tstStr) + "=" + attr.elementAt(2);
                        }
                        if (fm == null) {
                            if (nn * tstStr.length() > wdth) {
                                wdth = nn * tstStr.length();
                            }
                        } else if (fm.stringWidth(tstStr) > wdth) {
                            wdth = fm.stringWidth(tstStr);
                        }
                    }
                } else if (attr.elementAt(2).length() != 0) {
                    tstStr = String.valueOf(attr.elementAt(1)) + "=" + attr.elementAt(2);
                    if (fm == null) {
                        if (nn * tstStr.length() > wdth) {
                            wdth = nn * tstStr.length();
                        }
                    } else if (fm.stringWidth(tstStr) > wdth) {
                        wdth = fm.stringWidth(tstStr);
                    }
                }
                ++i;
            }
        }
        return wdth;
    }

    protected String getTypeString() {
        String typeStr = this.eType.getBasisType().getStringRepr();
        if (!this.getBasisObject().getObjectName().equals("")) {
            typeStr = this.getBasisObject().getObjectName().concat(":").concat(typeStr);
        }
        if (this.getMorphismMark().length() != 0) {
            typeStr = this.getMorphismMark().concat(":").concat(typeStr);
        }
        return typeStr;
    }

    public int getShape() {
        return this.eType.shape;
    }

    public Color getColor() {
        return this.eType.color;
    }

    public Color getSelectColor() {
        return EditorConstants.selectColor;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isAttributeVisible() {
        return this.visible;
    }

    public boolean isElementOfTypeGraph() {
        return this.elemOfTG;
    }

    public boolean hasSimilarType(EdGraphObject eObj) {
        return this.eType.isParentOf(eObj.getType());
    }

    public abstract boolean inside(int var1, int var2);

    public Dimension ifOverlapFrom(EdGraphObject eObj) {
        Point p1 = new Point(this.x - this.w / 2, this.y - this.h / 2);
        Point p2 = new Point(this.x + this.w / 2, this.y - this.h / 2);
        Point p3 = new Point(this.x + this.w / 2, this.y + this.h / 2);
        Point p4 = new Point(this.x - this.w / 2, this.y + this.h / 2);
        Point p11 = new Point(eObj.getX() - eObj.getWidth() / 2, eObj.getY() - eObj.getHeight() / 2);
        Point p12 = new Point(eObj.getX() + eObj.getWidth() / 2, eObj.getY() - eObj.getHeight() / 2);
        Point p13 = new Point(eObj.getX() + eObj.getWidth() / 2, eObj.getY() + eObj.getHeight() / 2);
        Point p14 = new Point(eObj.getX() - eObj.getWidth() / 2, eObj.getY() + eObj.getHeight() / 2);
        int minDist = 10;
        Dimension overlapSize = new Dimension(p3.x + eObj.getWidth() / 2 + minDist - this.x, p3.y + eObj.getHeight() / 2 + minDist - this.y);
        boolean overlap = false;
        if (p1.equals(p11) && p2.equals(p12) && p3.equals(p13) && p4.equals(p14)) {
            overlap = true;
        } else if (this.inside(eObj.getX(), eObj.getY()) || this.inside(p11.x, p11.y) || this.inside(p12.x, p12.y) || this.inside(p13.x, p13.y) || this.inside(p14.x, p14.y) || eObj.inside(this.getX(), this.getY()) || eObj.inside(p1.x, p1.y) || eObj.inside(p2.x, p2.y) || eObj.inside(p3.x, p3.y) || eObj.inside(p4.x, p4.y)) {
            overlap = true;
        }
        if (overlap) {
            return overlapSize;
        }
        return new Dimension(0, 0);
    }

    public void markElementOfTypeGraph(boolean val) {
        this.elemOfTG = val;
    }

    public void setXY(int X, int Y) {
        this.x = X;
        this.y = Y;
    }

    public void setX(int X) {
        this.x = X;
    }

    public void setY(int Y) {
        this.y = Y;
    }

    public void setWidth(int W) {
        this.w = W;
    }

    public void setHeight(int H) {
        this.h = H;
    }

    public void setSelected(boolean sel) {
        this.selected = !this.selected && sel;
        this.weakselected = false;
    }

    public void select() {
        this.selected = true;
    }

    public void deselect() {
        this.selected = false;
    }

    public void setWeakselected(boolean weaksel) {
        this.weakselected = weaksel;
    }

    public boolean isWeakselected() {
        return this.weakselected;
    }

    public void setBackground(Color c) {
        this.backgroundColor = c;
    }

    public void setType(EdType t) {
        this.eType = t;
    }

    public void setMorphismMark(int m) {
        this.myKey = m;
    }

    public void addMorphismMark(int m) {
        this.marks.addElement(String.valueOf(m));
    }

    public void addMorphismMark(String m) {
        this.marks.addElement(m);
    }

    public boolean isMorphismMarkEmpty() {
        return this.marks.isEmpty();
    }

    public void clearMorphismMark() {
        this.marks.clear();
    }

    protected void setContextUsage(String context) {
        this.contextUsage = context;
    }

    protected void addContextUsage(String context) {
        this.contextUsage = this.contextUsage.concat(":");
        this.contextUsage = this.contextUsage.concat(context);
    }

    protected String getContextUsage() {
        return this.contextUsage;
    }

    public void setVisible(boolean vis) {
        this.visible = vis;
    }

    public void setAttributeVisible(boolean vis) {
        this.attrVisible = vis;
    }

    public void setCopy(EdGraphObject ec) {
        this.myCopy = ec;
    }

    public void setAttrViewSetting(AttrViewSetting aView) {
        this.view = aView;
        this.init = true;
    }

    protected AttrViewSetting getView() {
        return this.view;
    }

    public void setErrorMode(boolean errorMode) {
        this.errorMode = errorMode;
    }
}

