/*
 * Decompiled with CFR 0.152.
 */
package agg.cons;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrContext;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrVariableTuple;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.CondMember;
import agg.attribute.impl.CondTuple;
import agg.attribute.impl.ContextView;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.ValueTuple;
import agg.attribute.impl.VarMember;
import agg.attribute.impl.VarTuple;
import agg.cons.Evaluable;
import agg.util.XMLHelper;
import agg.util.XMLObject;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Completion_InjCSP;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.MorphCompletionStrategy;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;

public class AtomConstraint
extends OrdinaryMorphism
implements Evaluable,
XMLObject {
    private boolean valid;
    private int old_tick;
    private boolean old_val;
    private boolean evaluable;
    private String atomicName = "";
    private AtomConstraint parent;
    private final Vector<AtomConstraint> conclusions = new Vector();
    private int indxOfValidConclusion = -1;
    private MorphCompletionStrategy strategy;
    private final Vector<GraphObject> failedObjs = new Vector();

    public AtomConstraint(Graph premise, Graph conclusion, AttrContext context, String name) {
        super(premise, premise, context);
        this.parent = this;
        this.getOriginal().setAttrContext(this.getAttrManager().newLeftContext(context));
        this.getOriginal().setKind("PREMISE");
        this.old_tick = -1;
        this.old_val = false;
        if (name != null && !name.equals("")) {
            this.atomicName = name;
            this.itsName = name;
        }
        this.createNextConclusion(conclusion);
    }

    private AtomConstraint(Graph premise, Graph conclusion, AttrContext context, String name, AtomConstraint parent) {
        super(premise, conclusion, context);
        this.parent = parent;
        this.getImage().setAttrContext(this.getAttrManager().newRightContext(context));
        this.getImage().setKind("CONCLUSION");
        this.old_tick = -1;
        this.old_val = false;
        if (name != null && !name.equals("")) {
            this.atomicName = name;
        }
    }

    @Override
    public void dispose() {
        AtomConstraint atom = null;
        int i = this.conclusions.size() - 1;
        while (!this.conclusions.isEmpty()) {
            atom = this.conclusions.remove(i);
            atom.dispose(false, true);
            i = this.conclusions.size() - 1;
        }
        this.dispose(true, false);
    }

    public AtomConstraint getParent() {
        return this.parent;
    }

    public boolean isElement(Graph g) {
        int j = 0;
        while (j < this.conclusions.size()) {
            AtomConstraint atom = this.conclusions.elementAt(j);
            if (atom.getSource() == g || atom.getTarget() == g) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public boolean isValid() {
        this.failedObjs.clear();
        this.valid = true;
        int j = 0;
        while (j < this.conclusions.size() && this.valid) {
            AtomConstraint concl = this.conclusions.elementAt(j);
            this.valid = this.doIsValidCheck(concl);
            ++j;
        }
        return this.valid;
    }

    private boolean doIsValidCheck(AtomConstraint concl) {
        VarTuple lhsVars = (VarTuple)concl.getTarget().getAttrContext().getVariables();
        concl.addToAttrContext(lhsVars);
        if (!concl.isInjective() || !concl.isTotal()) {
            return false;
        }
        if (!this.doIsValidElemCheck(concl, concl.getOriginal().getNodesSet().iterator())) {
            return false;
        }
        if (!this.doIsValidElemCheck(concl, concl.getOriginal().getArcsSet().iterator())) {
            return false;
        }
        concl.markAttrConditions();
        CondTuple conds = (CondTuple)concl.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize()) {
            CondMember cond = conds.getCondMemberAt(i);
            if (!cond.isValid()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean doIsValidElemCheck(AtomConstraint concl, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject orig = (GraphObject)elems.next();
            if (orig.getAttribute() == null) continue;
            ValueTuple val = (ValueTuple)orig.getAttribute();
            ValueTuple img_val = (ValueTuple)concl.getImage(orig).getAttribute();
            int n = val.getNumberOfEntries();
            int i = 0;
            while (i < n) {
                if (val.isValueSetAt(i)) {
                    HandlerExpr expr2;
                    ValueMember value = val.getValueMemberAt(i);
                    HandlerExpr expr1 = value.getExpr();
                    if (expr1 != (expr2 = (value = img_val.getValueMemberAt(i)).getExpr())) {
                        if (expr1 != null && expr2 != null && !expr1.toString().equals(expr2.toString())) {
                            return false;
                        }
                        if (expr1 != null && !expr1.isConstant() && !expr1.isVariable()) {
                            return false;
                        }
                    }
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isEvaluable() {
        return this.evaluable;
    }

    public void setMorphismCompletionStrategy(MorphCompletionStrategy s) {
        this.strategy = s;
        int i = 0;
        while (i < this.conclusions.size()) {
            this.conclusions.get(i).setMorphismCompletionStrategy(this.strategy);
            ++i;
        }
    }

    private void setEvaluable(OrdinaryMorphism m, Graph g) {
        this.evaluable = true;
        VarTuple vars = (VarTuple)m.getAttrContext().getVariables();
        Vector<String> varnames = g.getVariableNamesOfAttributes();
        CondTuple conds = (CondTuple)m.getAttrContext().getConditions();
        int i = 0;
        while (i < conds.getSize() && this.evaluable) {
            CondMember cond = conds.getCondMemberAt(i);
            if (cond.isEnabled() && !cond.isEvaluable(vars)) {
                Vector<String> condVars = cond.getAllVariables();
                int j = 0;
                while (j < condVars.size()) {
                    String n = condVars.elementAt(j);
                    VarMember var = vars.getVarMemberAt(n);
                    if (!var.isSet() && varnames.contains(n)) {
                        this.evaluable = false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.evaluable) {
            this.doCheckConstantOfImage(m, g.getNodesSet().iterator());
        }
        if (this.evaluable) {
            this.doCheckConstantOfImage(m, g.getArcsSet().iterator());
        }
    }

    private void doCheckConstantOfImage(OrdinaryMorphism m, Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject o = (GraphObject)elems.next();
            if (o.getAttribute() == null) continue;
            GraphObject img = m.getImage(o);
            ValueTuple val = (ValueTuple)o.getAttribute();
            int i = 0;
            while (i < val.getSize()) {
                ValueTuple valImg;
                ValueMember valmImg;
                ValueMember valm = val.getValueMemberAt(i);
                if (valm.isSet() && valm.getExpr().isConstant() && img != null && (!(valmImg = (valImg = (ValueTuple)img.getAttribute()).getValueMemberAt(i)).isSet() || !valmImg.getExpr().equals(valm.getExpr()))) {
                    this.evaluable = false;
                }
                ++i;
            }
        }
    }

    @Override
    public boolean eval(Object o) {
        return this.eval(o, -1);
    }

    @Override
    public boolean eval(Object o, int tick) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = this.eval((Graph)o);
        return this.old_val;
    }

    @Override
    public boolean eval(Object o, boolean negation) {
        return this.eval(o, -1, negation);
    }

    @Override
    public boolean eval(Object o, int tick, boolean negation) {
        if (tick != -1 && tick == this.old_tick) {
            return this.old_val;
        }
        this.old_tick = tick;
        this.old_val = this.eval((Graph)o, negation);
        return this.old_val;
    }

    private boolean eval(Graph g) {
        return this.eval(g, false);
    }

    private boolean eval(Graph g, boolean negation) {
        this.failedObjs.clear();
        if (!this.valid || this.conclusions.isEmpty()) {
            return false;
        }
        Graph p = this.conclusions.get(0).getOriginal();
        if (!p.isEmpty() && g.isEmpty()) {
            return true;
        }
        Completion_InjCSP strategy1 = new Completion_InjCSP(false);
        Completion_InjCSP strategy2 = new Completion_InjCSP(false);
        this.indxOfValidConclusion = -1;
        boolean result = true;
        BaseFactory bf = BaseFactory.theFactory();
        ((AttrTupleManager)AttrTupleManager.getDefaultManager()).setVariableContext(false);
        this.adoptEntriesWhereEmpty();
        AtomConstraint conclusion0 = this.conclusions.elementAt(0);
        OrdinaryMorphism s = bf.createMorphism(conclusion0.getOriginal(), g, true);
        OrdinaryMorphism matchP = bf.createMatchfromMorph(s, conclusion0.getAttrContext());
        if (matchP.getImage().getVariableNamesOfAttributes().size() != 0) {
            ((ContextView)matchP.getAttrContext()).setVariableContext(true);
        }
        OrdinaryMorphism t = null;
        OrdinaryMorphism t2 = null;
        OrdinaryMorphism t2match = null;
        matchP.setCompletionStrategy(strategy1, true);
        while (matchP.nextCompletionWithConstantsChecking()) {
            this.setEvaluable(matchP, matchP.getSource());
            result = false;
            boolean allConclusionsOK = false;
            int i = 0;
            while (i < this.conclusions.size()) {
                boolean conclusionOK = false;
                AtomConstraint atom = this.conclusions.elementAt(i);
                if (t == null) {
                    t = matchP.completeDiagram(atom);
                    if (t != null) {
                        t.setCompletionStrategy(strategy2, true);
                    }
                } else {
                    t.clear();
                    t.setSource(atom.getImage());
                    t.getCompletionStrategy().initialize(t);
                    if (!matchP.completeDiagram(atom, t)) {
                        t = null;
                    }
                }
                if (t != null) {
                    t.adaptAttrContextValues(matchP.getAttrContext());
                    Vector<String> varNames = t.getImage().getVariableNamesOfAttributes();
                    if (varNames.size() != 0) {
                        ((ContextView)t.getAttrContext()).setVariableContext(true);
                    }
                    if (t.isTotal() || t.nextCompletionWithConstantsChecking()) {
                        conclusionOK = true;
                        if (t2 == null) {
                            t2 = matchP.completeDiagram(atom);
                        } else {
                            t2.clear();
                            t2.setSource(atom.getImage());
                            if (!matchP.completeDiagram(atom, t2)) {
                                t2 = null;
                            }
                        }
                        if (t2 != null) {
                            if (t2match == null) {
                                t2match = bf.createMatchfromMorph(t2, atom.getAttrContext());
                                if (t2match != null) {
                                    t2match.setCompletionStrategy(strategy2, true);
                                }
                            } else {
                                t2match.clear();
                                if (bf.createMatchfromMorph(t2, t2match, atom.getAttrContext())) {
                                    t2match.getCompletionStrategy().initialize(t2match);
                                } else {
                                    t2match = null;
                                }
                            }
                            if (t2match != null) {
                                AttrInstanceMember am;
                                if (t2match.getImage().getVariableNamesOfAttributes().size() != 0) {
                                    ((ContextView)t2match.getAttrContext()).setVariableContext(true);
                                }
                                AttrContext ac1 = t2match.getAttrContext();
                                int k = 0;
                                while (k < ac1.getConditions().getNumberOfEntries()) {
                                    am = (AttrInstanceMember)ac1.getConditions().getMemberAt(k);
                                    ((CondMember)am).setMark(0);
                                    ++k;
                                }
                                if (t2match.isTotal() || t2match.nextCompletionWithConstantsChecking()) {
                                    k = 0;
                                    while (k < ac1.getConditions().getNumberOfEntries()) {
                                        am = (CondMember)ac1.getConditions().getMemberAt(k);
                                        if (((CondMember)am).isEnabled() && ((CondMember)am).isDefinite() && !((CondMember)am).isTrue()) {
                                            conclusionOK = false;
                                            break;
                                        }
                                        ++k;
                                    }
                                    if (conclusionOK) {
                                        this.indxOfValidConclusion = i;
                                    }
                                    this.setEvaluable(t2match, t2match.getSource());
                                } else {
                                    conclusionOK = false;
                                }
                            } else {
                                conclusionOK = false;
                            }
                        } else {
                            conclusionOK = false;
                        }
                    } else {
                        conclusionOK = false;
                    }
                } else {
                    conclusionOK = false;
                }
                boolean bl = allConclusionsOK = allConclusionsOK || conclusionOK;
                if (conclusionOK && !negation) break;
                ++i;
            }
            result = allConclusionsOK;
            if (result) continue;
            this.fillFailedObjects(matchP);
            break;
        }
        this.unsetAllTransientAttrValuesOfOverlapGrah(matchP);
        matchP.dispose();
        matchP = null;
        bf.destroyMorphism(t);
        bf.destroyMorphism(t2);
        bf.destroyMorphism(t2match);
        t = null;
        t2 = null;
        t2match = null;
        return result;
    }

    private void fillFailedObjects(OrdinaryMorphism matchP) {
        Enumeration<GraphObject> codom = matchP.getCodomain();
        while (codom.hasMoreElements()) {
            this.failedObjs.add(codom.nextElement());
        }
    }

    public Enumeration<GraphObject> getFailedGraphObjects() {
        return this.failedObjs.elements();
    }

    public AtomConstraint createNextConclusion(Graph img) {
        AtomConstraint conclusion = new AtomConstraint(this.getOriginal(), img, AttrTupleManager.getDefaultManager().newContext(0), this.atomicName, this);
        VarTuple lhsVars = (VarTuple)conclusion.getSource().getAttrContext().getVariables();
        conclusion.addToAttrContext(lhsVars);
        conclusion.setName("Conclusion" + this.conclusions.size());
        this.conclusions.addElement(conclusion);
        return conclusion;
    }

    public boolean destroyConclusion(AtomConstraint conclusion) {
        if (this.conclusions.size() <= 1) {
            return false;
        }
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.removeElement(conclusion);
            conclusion.dispose();
            return true;
        }
        return false;
    }

    public boolean removeConclusion(AtomConstraint conclusion) {
        if (this.conclusions.size() <= 1) {
            return false;
        }
        if (this.conclusions.contains(conclusion)) {
            this.conclusions.remove(conclusion);
            return true;
        }
        return false;
    }

    public Enumeration<AtomConstraint> getConclusions() {
        return this.conclusions.elements();
    }

    public int getConclusionsSize() {
        return this.conclusions.size();
    }

    public AtomConstraint getConclusion(int indx) {
        if (indx >= 0 && indx < this.conclusions.size()) {
            return this.conclusions.elementAt(indx);
        }
        return null;
    }

    public AtomConstraint getValidConclusion() {
        if (this.indxOfValidConclusion >= 0 && this.indxOfValidConclusion < this.conclusions.size()) {
            return this.conclusions.elementAt(this.indxOfValidConclusion);
        }
        return null;
    }

    public void setAtomicName(String n) {
        this.atomicName = n;
        if (this.parent == this) {
            this.itsName = n;
        }
    }

    public String getAtomicName() {
        return this.atomicName;
    }

    public boolean compareTo(AtomConstraint a) {
        if (!this.atomicName.equals(a.getAtomicName())) {
            return false;
        }
        Enumeration<AtomConstraint> e = a.getConclusions();
        Vector<AtomConstraint> another = new Vector<AtomConstraint>(10);
        while (e.hasMoreElements()) {
            another.add(e.nextElement());
        }
        if (this.conclusions.size() != another.size()) {
            return false;
        }
        int i = 0;
        while (i < this.conclusions.size()) {
            AtomConstraint c = this.conclusions.elementAt(i);
            int j = another.size() - 1;
            while (j >= 0) {
                AtomConstraint c1 = (AtomConstraint)another.elementAt(j);
                if (c.compareTo((OrdinaryMorphism)c1)) {
                    another.remove(c1);
                    break;
                }
                --j;
            }
            ++i;
        }
        return another.size() == 0;
    }

    public void adoptEntriesWhereEmpty() {
        Enumeration<AtomConstraint> concls = this.getConclusions();
        while (concls.hasMoreElements()) {
            OrdinaryMorphism morph = concls.nextElement();
            Enumeration<GraphObject> e = morph.getDomain();
            while (e.hasMoreElements()) {
                GraphObject obj = e.nextElement();
                if (obj.getAttribute() == null) continue;
                GraphObject img = morph.getImage(obj);
                ContextView context = (ContextView)morph.getAttrContext();
                Vector<TupleMapping> mappings = context.getMappingsToTarget((ValueTuple)img.getAttribute());
                if (mappings == null) continue;
                mappings.elementAt(0).adoptEntriesWhereEmpty((ValueTuple)obj.getAttribute(), (ValueTuple)img.getAttribute());
            }
        }
    }

    public void createAttrInstanceWhereNeeded() {
        Enumeration<AtomConstraint> concls = this.getConclusions();
        if (concls.hasMoreElements()) {
            OrdinaryMorphism morph = concls.nextElement();
            morph.getSource().createAttrInstanceWhereNeeded();
            morph.getTarget().createAttrInstanceWhereNeeded();
        }
        while (concls.hasMoreElements()) {
            concls.nextElement().getTarget().createAttrInstanceWhereNeeded();
        }
    }

    public void createAttrInstanceOfTypeWhereNeeded(Type t) {
        Enumeration<AtomConstraint> concls = this.getConclusions();
        if (concls.hasMoreElements()) {
            OrdinaryMorphism morph = concls.nextElement();
            morph.getSource().createAttrInstanceOfTypeWhereNeeded(t);
            morph.getTarget().createAttrInstanceOfTypeWhereNeeded(t);
        }
        while (concls.hasMoreElements()) {
            concls.nextElement().getTarget().createAttrInstanceOfTypeWhereNeeded(t);
        }
    }

    private void unsetAllTransientAttrValuesOfOverlapGrah(OrdinaryMorphism m) {
        this.doUnsetAllTransientAttrValuesOfOverlapGrah(m.getImage().getNodesSet().iterator());
        this.doUnsetAllTransientAttrValuesOfOverlapGrah(m.getImage().getArcsSet().iterator());
    }

    private void doUnsetAllTransientAttrValuesOfOverlapGrah(Iterator<?> elems) {
        while (elems.hasNext()) {
            GraphObject obj = (GraphObject)elems.next();
            if (obj.getAttribute() == null) continue;
            ValueTuple value = (ValueTuple)obj.getAttribute();
            int i = 0;
            while (i < value.getNumberOfEntries()) {
                ValueMember valuem = value.getValueMemberAt(i);
                if (valuem.getExpr() != null && valuem.getExpr().isVariable() && valuem.isTransient()) {
                    valuem.setExpr(null);
                }
                ++i;
            }
        }
    }

    public void refreshAttributed() {
        Enumeration<AtomConstraint> concls = this.getConclusions();
        if (concls.hasMoreElements()) {
            OrdinaryMorphism morph = concls.nextElement();
            morph.getSource().refreshAttributed();
            morph.getTarget().refreshAttributed();
        }
        while (concls.hasMoreElements()) {
            concls.nextElement().getTarget().refreshAttributed();
        }
    }

    @Override
    public void trimToSize() {
        super.trimToSize();
        int i = 0;
        while (i < this.conclusions.size()) {
            this.conclusions.get(i).trimToSize();
            ++i;
        }
        this.conclusions.trimToSize();
        this.failedObjs.trimToSize();
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        h.openNewElem("Graphconstraint_Atomic", this);
        h.addAttr("name", this.getAtomicName());
        if (this.conclusions.size() > 0) {
            h.openSubTag("Premise");
            AtomConstraint atom = this.conclusions.elementAt(0);
            h.addObjectSub(atom.getOriginal());
            h.close();
            int i = 0;
            while (i < this.conclusions.size()) {
                h.openSubTag("Conclusion");
                atom = this.conclusions.elementAt(i);
                h.addObjectSub(atom.getImage());
                atom.writeMorphism(h);
                AttrConditionTuple condt = atom.getAttrContext().getConditions();
                int num = condt.getNumberOfEntries();
                if (num > 0) {
                    h.openSubTag("AttrCondition");
                    h.addObject("", condt, true);
                    h.close();
                }
                h.close();
                ++i;
            }
        }
        h.close();
    }

    @Override
    public void XreadObject(XMLHelper h) {
        if (h.isTag("Graphconstraint_Atomic", this)) {
            this.setAtomicName(h.readAttr("name"));
            if (h.readSubTag("Premise")) {
                Graph orig = (Graph)h.getObject("", this.itsOrig, true);
                orig.setName("Premise of " + this.atomicName);
                h.close();
                this.parent = this;
                this.conclusions.clear();
                Enumeration<Element> en = h.getEnumeration("", null, true, "Conclusion");
                while (en.hasMoreElements()) {
                    h.peekElement(en.nextElement());
                    Graph target = BaseFactory.theFactory().createGraph(this.getSource().getTypeSet());
                    AtomConstraint concl = this.createNextConclusion(target);
                    h.getObject("", target, true);
                    concl.readMorphism(h);
                    target.setName("Conclusion of " + this.atomicName);
                    if (h.readSubTag("AttrCondition")) {
                        AttrConditionTuple condt = concl.getAttrContext().getConditions();
                        if (condt != null) {
                            h.enrichObject(condt);
                        }
                        h.close();
                    }
                    h.close();
                }
            } else {
                h.getObject("", this.getSource(), true);
                h.getObject("", this.getTarget(), true);
                this.readMorphism(h);
            }
            h.close();
        }
    }

    private void markAttrConditions() {
        this.markUsedVariables();
        AttrVariableTuple avt = this.itsAttrContext.getVariables();
        AttrConditionTuple act = this.itsAttrContext.getConditions();
        int k = 0;
        while (k < ((CondTuple)act).getSize()) {
            CondMember cm = ((CondTuple)act).getCondMemberAt(k);
            cm.setMark(0);
            Vector<String> vars = cm.getAllVariables();
            if (!vars.isEmpty()) {
                int i = 0;
                while (i < vars.size()) {
                    VarMember var = avt.getVarMemberAt(vars.get(i));
                    if (var != null && var.getMark() == 1) {
                        cm.setMark(1);
                        break;
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private void markUsedVariables() {
        VarMember var;
        ValueMember vm;
        int k;
        ValueTuple vt;
        AttrVariableTuple avt = this.itsAttrContext.getVariables();
        for (GraphObject graphObject : this.getTarget().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(1);
                }
                ++k;
            }
        }
        for (GraphObject graphObject : this.getTarget().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(1);
                }
                ++k;
            }
        }
        for (GraphObject graphObject : this.getSource().getNodesSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(0);
                }
                ++k;
            }
        }
        for (GraphObject graphObject : this.getSource().getArcsSet()) {
            if (graphObject.getAttribute() == null) continue;
            vt = (ValueTuple)graphObject.getAttribute();
            k = 0;
            while (k < vt.getSize()) {
                vm = vt.getValueMemberAt(k);
                if (vm.isSet() && vm.getExpr().isVariable() && (var = avt.getVarMemberAt(vm.getExprAsText())) != null) {
                    var.setMark(0);
                }
                ++k;
            }
        }
    }

    @Override
    public boolean evalForall(Object o, int tick) {
        return false;
    }
}

