/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.gui.impl;

import agg.attribute.AttrConditionTuple;
import agg.attribute.AttrEvent;
import agg.attribute.AttrInstance;
import agg.attribute.AttrInstanceMember;
import agg.attribute.AttrMember;
import agg.attribute.AttrTuple;
import agg.attribute.AttrType;
import agg.attribute.AttrTypeMember;
import agg.attribute.AttrVariableMember;
import agg.attribute.gui.AttrTupleEditor;
import agg.attribute.gui.impl.TupleTableModelConstants;
import agg.attribute.handler.AttrHandler;
import agg.attribute.handler.AttrHandlerException;
import agg.attribute.handler.HandlerExpr;
import agg.attribute.handler.impl.javaExpr.JexHandler;
import agg.attribute.impl.AttrSession;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.attribute.impl.ValueMember;
import agg.attribute.impl.VerboseControl;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class TupleTableModel
extends AbstractTableModel
implements TupleTableModelConstants {
    private static final long serialVersionUID = 2201742847657275100L;
    protected static final int COLUMN_INDEX = 0;
    protected static final int COLUMN_TITLE = 1;
    protected static final int COLUMN_CLASS = 2;
    protected static final int COLUMN_EDITABLE = 3;
    protected static final int N_COLUMN_PROPERTIES = 4;
    protected boolean isExtensible = false;
    protected int[] columnArray = new int[]{3, 4};
    protected Object[][] columnData = new Object[10][4];
    protected AttrTupleEditor editor = null;
    protected AttrHandler defaultHandler = null;
    protected int currentColumn;
    protected boolean valueChanged;

    public TupleTableModel(AttrTupleEditor editor) {
        this.editor = editor;
        String handlerName = JexHandler.getLabelName();
        this.defaultHandler = editor.getAttrManager().getHandler(handlerName);
        this.initColumnProperties();
    }

    public void setColumnArray(int[] keys) {
        this.columnArray = keys == null ? new int[0] : keys;
        int i = 0;
        while (i < 10) {
            this.columnData[i][0] = new Integer(-1);
            ++i;
        }
        i = 0;
        while (i < this.columnArray.length) {
            this.columnData[this.columnArray[i]][0] = new Integer(i);
            ++i;
        }
    }

    public void setExtensible(boolean b) {
        this.isExtensible = b;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void setColumnTitle(int key, String title) {
        this.setColumnProperty(key, 1, title);
    }

    public void setColumnClass(int key, Class<?> clazz) {
        this.setColumnProperty(key, 2, clazz);
    }

    public void setColumnEditable(int key, boolean b) {
        this.setColumnProperty(key, 3, new Boolean(b));
    }

    public AttrMember getMember(AttrTuple tuple, int row) {
        return tuple.getMemberAt(this.editor.getViewSetting(), row);
    }

    public final int getItemKeyAt(int column) {
        return this.columnArray[column];
    }

    public final int getColumnAtKey(int key) {
        return (Integer)this.columnData[key][0];
    }

    public void attributeChanged(AttrEvent event) {
        if (event == null) {
            this.valueChanged = false;
        } else {
            this.fireTableDataChanged();
        }
    }

    protected void setColumnProperty(int key, int propertyKey, Object property) {
        this.columnData[key][propertyKey] = property;
    }

    protected Object getColumnProperty(int key, int propertyKey) {
        return this.columnData[key][propertyKey];
    }

    @Override
    public int getRowCount() {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return 0;
        }
        int nMembers = tuple.getNumberOfEntries(this.editor.getViewSetting());
        if (this.isExtensible()) {
            ++nMembers;
        }
        return nMembers;
    }

    protected void initColumnProperties() {
        Class<?> stringClass = "".getClass();
        Class<?> booleanClass = Boolean.TRUE.getClass();
        this.setColumnTitle(0, "???");
        this.setColumnClass(0, null);
        this.setColumnEditable(0, false);
        this.setColumnTitle(1, "Handler");
        this.setColumnClass(1, stringClass);
        this.setColumnEditable(1, false);
        this.setColumnTitle(2, "Type");
        this.setColumnClass(2, stringClass);
        this.setColumnEditable(2, true);
        this.setColumnTitle(3, "Name");
        this.setColumnClass(3, stringClass);
        this.setColumnEditable(3, true);
        this.setColumnTitle(4, "Expression");
        this.setColumnClass(4, stringClass);
        this.setColumnEditable(4, true);
        this.setColumnTitle(9, "Yields");
        this.setColumnClass(9, stringClass);
        this.setColumnEditable(9, false);
        this.setColumnTitle(8, "OK");
        this.setColumnClass(8, booleanClass);
        this.setColumnEditable(8, false);
        this.setColumnTitle(6, "In");
        this.setColumnClass(6, booleanClass);
        this.setColumnEditable(6, true);
        this.setColumnTitle(7, "Out");
        this.setColumnClass(7, booleanClass);
        this.setColumnEditable(7, true);
        this.setColumnTitle(5, "Shown");
        this.setColumnClass(5, booleanClass);
        this.setColumnEditable(5, true);
    }

    protected Object getItem(AttrMember member, int key, AttrTuple tuple, int row) {
        if (member instanceof AttrTypeMember) {
            return this.getItemOfAttrTypeMember(member, key, tuple, row);
        }
        if (member instanceof AttrInstanceMember) {
            AttrInstanceMember m = (AttrInstanceMember)member;
            switch (key) {
                case 1: {
                    return m.getDeclaration().getHandler().getName();
                }
                case 2: {
                    return m.getDeclaration().getTypeName();
                }
                case 3: {
                    return m.getDeclaration().getName();
                }
                case 5: {
                    return new Boolean(this.editor.getViewSetting().isVisible(tuple, row));
                }
                case 4: {
                    return m.getExprAsText();
                }
                case 8: {
                    return new Boolean(m.isValid() && m.getDeclaration().isValid());
                }
                case 9: {
                    return new Boolean(m.isValid() && m.getDeclaration().isValid());
                }
                case 6: {
                    return new Boolean(((AttrVariableMember)m).isInputParameter());
                }
                case 7: {
                    return new Boolean(((AttrVariableMember)m).isOutputParameter());
                }
            }
            return null;
        }
        return null;
    }

    protected Object getItemOfAttrTypeMember(AttrMember member, int key, AttrTuple tuple, int row) {
        if (member instanceof AttrTypeMember) {
            AttrTypeMember m = (AttrTypeMember)member;
            switch (key) {
                case 1: {
                    return m.getHandler().getName();
                }
                case 2: {
                    return m.getTypeName();
                }
                case 3: {
                    return m.getName();
                }
                case 5: {
                    return new Boolean(this.editor.getViewSetting().isVisible(tuple, row));
                }
            }
            return null;
        }
        return null;
    }

    protected Object getItemOfNewRow(int key, AttrTuple tuple, int row) {
        return null;
    }

    protected void setItem(Object aValue, AttrMember member, int key, AttrTuple tuple, int row) {
        if (member instanceof AttrTypeMember) {
            this.setItemOfAttrTypeMember(aValue, member, key, tuple, row);
        } else if (member instanceof AttrInstanceMember) {
            AttrInstanceMember m = (AttrInstanceMember)member;
            switch (key) {
                case 1: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Handler");
                    m.getDeclaration().setHandler((AttrHandler)aValue);
                    break;
                }
                case 2: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Type");
                    if ("".equals((String)aValue)) break;
                    m.getDeclaration().setType((String)aValue);
                    break;
                }
                case 3: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Name");
                    if ("".equals((String)aValue)) break;
                    if (((DeclTuple)((DeclMember)m.getDeclaration()).getHoldingTuple()).isClassName((String)aValue)) {
                        m.getDeclaration().setName("");
                        break;
                    }
                    if (m.getDeclaration().getHoldingTuple().getMemberAt((String)aValue) != null) break;
                    m.getDeclaration().setName((String)aValue);
                    break;
                }
                case 5: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Visibility");
                    this.editor.getViewSetting().setVisibleAt(tuple, (Boolean)aValue, row);
                    break;
                }
                case 4: {
                    if (!m.getDeclaration().isValid()) break;
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Expr");
                    HandlerExpr oldexpr = m.getExpr();
                    ((ValueMember)m).checkValidity(oldexpr);
                    String olderrorMsg = ((ValueMember)m).getErrorMsg();
                    String newText = (String)aValue;
                    if (newText.equals("")) {
                        m.setExprAsText(newText);
                        break;
                    }
                    if (((DeclTuple)((DeclMember)m.getDeclaration()).getHoldingTuple()).isClassName(newText)) {
                        m.setExprAsText("");
                        break;
                    }
                    if (oldexpr != null && newText.equals(oldexpr.toString())) break;
                    try {
                        newText = this.getStaticMethodCall((String)aValue);
                        HandlerExpr expression = ((ValueMember)m).getHandler().newHandlerExpr(((ValueMember)m).getDeclaration().getType(), newText);
                        ((ValueMember)m).checkValidity(expression);
                        String errorMsg = ((ValueMember)m).getErrorMsg();
                        if (m.isValid()) {
                            m.setExprAsText(newText);
                            break;
                        }
                        if (oldexpr != null && olderrorMsg.length() == 0) {
                            m.setExprAsText(oldexpr.toString());
                            break;
                        }
                        if (errorMsg.length() <= 0) break;
                        JOptionPane.showMessageDialog(null, errorMsg, " Attribute Parser ", 0);
                    }
                    catch (AttrHandlerException attrHandlerException) {}
                    break;
                }
                case 6: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Is_Input_Parameter");
                    ((AttrVariableMember)m).setInputParameter((Boolean)aValue);
                    break;
                }
                case 7: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Is_Out_Parameter");
                    ((AttrVariableMember)m).setOutputParameter((Boolean)aValue);
                }
            }
            AttrSession.logPrintln(VerboseControl.logTrace, "TupleTableModel:\n<-setItem");
        }
    }

    private void setItemOfAttrTypeMember(Object aValue, AttrMember member, int key, AttrTuple tuple, int row) {
        if (member instanceof AttrTypeMember) {
            AttrTypeMember m = (AttrTypeMember)member;
            switch (key) {
                case 1: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Handler");
                    m.setHandler((AttrHandler)aValue);
                    break;
                }
                case 2: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Type");
                    m.setType((String)aValue);
                    break;
                }
                case 3: {
                    AttrSession.stdoutPrintln(VerboseControl.logTrace, "Name");
                    m.setName((String)aValue);
                }
            }
            AttrSession.logPrintln(VerboseControl.logTrace, "TupleTableModel:\n<-setTypeItem");
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getStaticMethodCall(String aValue) {
        block15: {
            if (aValue.indexOf("$") == 0) {
                ind = aValue.substring(1).indexOf("$");
                if (ind > 0) {
                    clstr = aValue.substring(1, ind + 1);
                    try {
                        Class.forName(clstr);
                        tst = clstr.substring(clstr.indexOf(".") + 1);
                        while (tst.indexOf(".") != -1) {
                            clstr = tst.concat("");
                            tst = clstr.substring(clstr.indexOf(".") + 1);
                        }
                        clstr = tst.concat("");
                        result = String.valueOf(clstr) + aValue.substring(ind + 2);
                        return result;
                    }
                    catch (ClassNotFoundException ex) {
                        System.out.println("TupleTableModel: ClassNotFoundException: " + ex.getMessage());
                    }
                }
            } else {
                try {
                    if (aValue.indexOf(".") >= 0) {
                        clstr = aValue.substring(0, aValue.indexOf("."));
                        Class.forName(clstr);
                        return aValue;
                    }
                    break block15;
                }
                catch (ClassNotFoundException cex) {
                    tst = aValue;
                    pack = null;
                    tmp = "";
                    ** while (tst.indexOf((String)".") != -1)
                }
lbl-1000:
                // 1 sources

                {
                    next = tst.substring(0, tst.indexOf("."));
                    p = Package.getPackage(String.valueOf(tmp) + next);
                    if (p != null) {
                        pack = p.getName();
                        tmp = p.getName();
                    } else {
                        tmp = String.valueOf(tmp) + next + ".";
                    }
                    tst = tst.substring(tst.indexOf(".") + 1, tst.length());
                    continue;
                }
lbl40:
                // 1 sources

                if (pack != null) {
                    result = aValue.replaceFirst(String.valueOf(pack) + ".", "");
                    clstr = result.substring(0, result.indexOf("."));
                    try {
                        Class.forName(String.valueOf(pack) + "." + clstr);
                        return result;
                    }
                    catch (ClassNotFoundException ex) {
                        System.out.println("TupleTableModel: ClassNotFoundException: " + ex.getMessage());
                    }
                }
            }
        }
        return aValue;
    }

    protected void setItemOfNewRow(Object aValue, int key, AttrTuple tuple, int row) {
        if (tuple instanceof AttrConditionTuple) {
            ((AttrConditionTuple)tuple).addCondition((String)aValue);
            return;
        }
        if (tuple instanceof AttrInstance) {
            AttrTypeMember typeMember = ((AttrInstance)tuple).getType().addMember();
            typeMember.setHandler(this.defaultHandler);
            int lastIndex = tuple.getNumberOfEntries() - 1;
            AttrInstanceMember m = (AttrInstanceMember)tuple.getMemberAt(lastIndex);
            this.setItem(aValue, m, key, tuple, row);
            AttrSession.logPrintln(VerboseControl.logTrace, "TupleTableModel:\n<-setItemOfNewRow");
        } else if (tuple instanceof AttrType) {
            AttrTypeMember typeMember = ((AttrType)tuple).addMember();
            typeMember.setHandler(this.defaultHandler);
            int lastIndex = tuple.getNumberOfEntries() - 1;
            AttrTypeMember m = (AttrTypeMember)tuple.getMemberAt(lastIndex);
            this.setItem(aValue, m, key, tuple, row);
            AttrSession.logPrintln(VerboseControl.logTrace, "TupleTableModel:\n<-setItemOfNewRow");
        }
    }

    protected String getItemLabel(int key) {
        String label = (String)this.getColumnProperty(key, 1);
        return label;
    }

    protected Class<?> getItemClass(int key) {
        Class c = (Class)this.getColumnProperty(key, 2);
        return c;
    }

    protected boolean isItemEditable(AttrMember member, int key) {
        return (Boolean)this.getColumnProperty(key, 3);
    }

    protected boolean isNewRowEditable(int key) {
        return (Boolean)this.getColumnProperty(key, 3);
    }

    @Override
    public final int getColumnCount() {
        return this.columnArray.length;
    }

    @Override
    public final Object getValueAt(int row, int column) {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return null;
        }
        if (row >= tuple.getNumberOfEntries()) {
            return this.getItemOfNewRow(this.getItemKeyAt(column), tuple, row);
        }
        return this.getItem(this.getMember(tuple, row), this.getItemKeyAt(column), tuple, row);
    }

    @Override
    public final String getColumnName(int column) {
        return this.getItemLabel(this.getItemKeyAt(column));
    }

    public final int getChangedColumn() {
        return this.currentColumn;
    }

    public final boolean isColumnValueChanged() {
        return this.valueChanged;
    }

    @Override
    public final boolean isCellEditable(int row, int column) {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return false;
        }
        if (row >= tuple.getNumberOfEntries()) {
            return this.isNewRowEditable(this.getItemKeyAt(column));
        }
        return this.isItemEditable(this.getMember(tuple, row), this.getItemKeyAt(column));
    }

    @Override
    public final void setValueAt(Object aValue, int row, int column) {
        AttrTuple tuple = this.editor.getTuple();
        if (tuple == null) {
            return;
        }
        Object oldvalue = this.getValueAt(row, column);
        this.currentColumn = column;
        if (row >= tuple.getNumberOfEntries()) {
            this.valueChanged = true;
            this.setItemOfNewRow(aValue, this.getItemKeyAt(column), tuple, row);
        } else {
            this.valueChanged = oldvalue == null ? true : !oldvalue.equals(aValue);
            this.setItem(aValue, this.getMember(tuple, row), this.getItemKeyAt(column), tuple, row);
        }
        AttrSession.logPrintln(VerboseControl.logTrace, "TupleTableModel:\n<-setValueAt");
    }

    @Override
    public final Class<?> getColumnClass(int column) {
        return this.getItemClass(this.getItemKeyAt(column));
    }
}

