/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.printer;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CoreCommand {
    public void executePDFLatexCommand(String latexFilePath, String outputFolderPath) {
        String command = "pdflatex -output-directory " + outputFolderPath + " " + latexFilePath;
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", command);
        builder.redirectErrorStream(true);
        Process p = null;
        try {
            try {
                String line;
                p = builder.start();
                boolean waitFor = p.waitFor(5L, TimeUnit.SECONDS);
                BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = r.readLine()) != null) {
                    System.out.println(line);
                }
                if (!waitFor) {
                    System.err.println("Timeout: The latex file is not compiled.");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                p.destroy();
            }
        }
        finally {
            p.destroy();
        }
    }

    public void runFile(File file) {
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", file.getPath());
        builder.redirectErrorStream(true);
        try {
            String line;
            Process p = builder.start();
            BufferedReader r = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = r.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void desktopRun(File pdfFile) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(pdfFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Awt Desktop is not supported!");
        }
    }

    public void browseFile(String filePath) {
        Display display = new Display();
        Shell shell = new Shell(display);
        Browser browser = new Browser((Composite)shell, 0);
        browser.setUrl(filePath);
        shell.setLocation(100, 100);
        shell.setLayout((Layout)new FillLayout());
        shell.layout(true);
        shell.setVisible(true);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static void refreshFolders() {
        try {
            CoreCommand.getActualProject().refreshLocal(2, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IProject getActualProject() {
        IProject actualProject = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            try {
                IEditorInput input;
                IEditorPart editorPart = window.getActivePage().getActiveEditor();
                if (editorPart != null && (input = editorPart.getEditorInput()) instanceof IFileEditorInput) {
                    IFileEditorInput fileInput = (IFileEditorInput)input;
                    actualProject = fileInput.getFile().getProject();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return actualProject;
    }
}

