/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.tool.optimizer;

import graph.Node;
import java.util.Collection;
import java.util.Iterator;
import laxcondition.Condition;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.core.NestedConditionPreparer;
import org.eclipse.emf.henshin.ocl2ac.gc2ac.util.RuleClassifier;

public class IntegrationChecker {
    EList<EClass> graphsNodesTypes = new BasicEList();
    EList<EReference> graphsEdgesTypes = new BasicEList();
    EList<EAttribute> graphsAttributesTypes = new BasicEList();

    public boolean mustIntegrate(Rule rule, NestedConstraint nestedConstraint) {
        if (this.isThereOverlap(rule, nestedConstraint)) {
            System.out.println("There is an overlap.");
            NestedConditionPreparer preparer = new NestedConditionPreparer(nestedConstraint);
            preparer.eliminateForAllANotExistsC();
            NestedCondition condition = preparer.getCondition();
            RuleClassifier rc = new RuleClassifier(rule);
            if (preparer.isOfFormExistsC(condition)) {
                System.out.println("The constraint is of form Exists C.");
                if (rc.doesRuleCreateOnly()) {
                    System.out.println("The rule creates only.");
                    System.out.println("There is an overlap but no need for the integration.");
                    return false;
                }
            }
            if (preparer.isOfFormNotExistsC(condition)) {
                System.out.println("The constraint is of form Not Exists C.");
                if (rc.doesRuleDeleteOnly()) {
                    System.out.println("The rule deletes only.");
                    System.out.println("There is an overlap but no need for the integration.");
                    return false;
                }
            }
            System.out.println("Go to the integration");
            return true;
        }
        System.out.println("No overlap at all");
        return false;
    }

    private boolean isThereOverlap(Rule rule, NestedConstraint nestedConstraint) {
        EList createActionNodes = rule.getActionNodes(new Action(Action.Type.CREATE));
        EList deleteActionNodes = rule.getActionNodes(new Action(Action.Type.DELETE));
        BasicEList ruleNodes = new BasicEList();
        ruleNodes.addAll((Collection)createActionNodes);
        ruleNodes.addAll((Collection)deleteActionNodes);
        BasicEList ruleNodesTypes = new BasicEList();
        for (org.eclipse.emf.henshin.model.Node node : ruleNodes) {
            if (ruleNodesTypes.contains((Object)node.getType())) continue;
            ruleNodesTypes.add((Object)node.getType());
        }
        EList createActionEdges = rule.getActionEdges(new Action(Action.Type.CREATE));
        EList deleteActionEdges = rule.getActionEdges(new Action(Action.Type.DELETE));
        BasicEList ruleEdges = new BasicEList();
        ruleEdges.addAll((Collection)createActionEdges);
        ruleEdges.addAll((Collection)deleteActionEdges);
        BasicEList ruleEdgesTypes = new BasicEList();
        for (Edge edge : ruleEdges) {
            if (ruleEdgesTypes.contains((Object)edge.getType())) continue;
            ruleEdgesTypes.add((Object)edge.getType());
        }
        BasicEList createActionAttribute = new BasicEList();
        for (org.eclipse.emf.henshin.model.Node node : rule.getRhs().getNodes()) {
            for (Iterator attr : node.getAttributes()) {
                if (attr.getAction() == null || attr.getAction().getType() != Action.Type.CREATE) continue;
                createActionAttribute.add((Object)attr);
            }
        }
        BasicEList deleteActionAttribute = new BasicEList();
        for (org.eclipse.emf.henshin.model.Node node : rule.getLhs().getNodes()) {
            for (Attribute attr : node.getAttributes()) {
                if (attr.getAction().getType() != Action.Type.DELETE) continue;
                deleteActionAttribute.add((Object)attr);
            }
        }
        BasicEList ruleAttributes = new BasicEList();
        ruleAttributes.addAll((Collection)createActionAttribute);
        ruleAttributes.addAll((Collection)deleteActionAttribute);
        BasicEList ruleAttributeTypes = new BasicEList();
        for (Attribute attr : ruleAttributes) {
            if (ruleAttributeTypes.contains((Object)attr.getType())) continue;
            ruleAttributeTypes.add((Object)attr.getType());
        }
        this.fillNodesTypesAndEdgesTypes(nestedConstraint);
        return !this.areClanDisjoint((EList<EClass>)ruleNodesTypes, this.graphsNodesTypes) || !this.areEdgeDisjoint((EList<EReference>)ruleEdgesTypes, this.graphsEdgesTypes) || !this.areAttibuteDisjoint((EList<EAttribute>)ruleAttributeTypes, this.graphsAttributesTypes);
    }

    public boolean mustIntegrateWithoutAttribute(Rule rule, Condition condition) {
        EList createActionNodes = rule.getActionNodes(new Action(Action.Type.CREATE));
        EList deleteActionNodes = rule.getActionNodes(new Action(Action.Type.DELETE));
        BasicEList ruleNodes = new BasicEList();
        ruleNodes.addAll((Collection)createActionNodes);
        ruleNodes.addAll((Collection)deleteActionNodes);
        BasicEList ruleNodesTypes = new BasicEList();
        for (org.eclipse.emf.henshin.model.Node node : ruleNodes) {
            if (ruleNodesTypes.contains((Object)node.getType())) continue;
            ruleNodesTypes.add((Object)node.getType());
        }
        EList createActionEdges = rule.getActionEdges(new Action(Action.Type.CREATE));
        EList deleteActionEdges = rule.getActionEdges(new Action(Action.Type.DELETE));
        BasicEList ruleEdges = new BasicEList();
        ruleEdges.addAll((Collection)createActionEdges);
        ruleEdges.addAll((Collection)deleteActionEdges);
        BasicEList ruleEdgesTypes = new BasicEList();
        for (Edge edge : ruleEdges) {
            if (ruleEdgesTypes.contains((Object)edge.getType())) continue;
            ruleEdgesTypes.add((Object)edge.getType());
        }
        this.fillNodesTypesAndEdgesTypes(condition);
        return !this.areClanDisjoint((EList<EClass>)ruleNodesTypes, this.graphsNodesTypes) || !this.areEdgeDisjoint((EList<EReference>)ruleEdgesTypes, this.graphsEdgesTypes);
    }

    private void fillNodesTypesAndEdgesTypes(NestedConstraint nestedConstraint) {
        this.graphsNodesTypes.clear();
        this.graphsEdgesTypes.clear();
        TreeIterator iter = nestedConstraint.eAllContents();
        while (iter.hasNext()) {
            graph.Attribute attribute;
            graph.Edge edge;
            Node node;
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof Node && !this.graphsNodesTypes.contains((Object)(node = (Node)eObject).getType())) {
                this.graphsNodesTypes.add((Object)node.getType());
            }
            if (eObject instanceof graph.Edge && !this.graphsEdgesTypes.contains((Object)(edge = (graph.Edge)eObject).getType())) {
                this.graphsEdgesTypes.add((Object)edge.getType());
            }
            if (!(eObject instanceof graph.Attribute) || this.graphsAttributesTypes.contains((Object)(attribute = (graph.Attribute)eObject).getType())) continue;
            this.graphsAttributesTypes.add((Object)attribute.getType());
        }
    }

    private void fillNodesTypesAndEdgesTypes(Condition condition) {
        this.graphsNodesTypes.clear();
        this.graphsEdgesTypes.clear();
        TreeIterator iter = condition.eAllContents();
        while (iter.hasNext()) {
            graph.Attribute attribute;
            graph.Edge edge;
            Node node;
            EObject eObject = (EObject)iter.next();
            if (eObject instanceof Node && !this.graphsNodesTypes.contains((Object)(node = (Node)eObject).getType())) {
                this.graphsNodesTypes.add((Object)node.getType());
            }
            if (eObject instanceof graph.Edge && !this.graphsEdgesTypes.contains((Object)(edge = (graph.Edge)eObject).getType())) {
                this.graphsEdgesTypes.add((Object)edge.getType());
            }
            if (!(eObject instanceof graph.Attribute) || this.graphsAttributesTypes.contains((Object)(attribute = (graph.Attribute)eObject).getType())) continue;
            this.graphsAttributesTypes.add((Object)attribute.getType());
        }
    }

    private boolean areClanDisjoint(EList<EClass> typesList1, EList<EClass> typesList2) {
        for (EClass type1 : typesList1) {
            EList<EClass> clan1 = this.getClan(type1);
            for (EClass type2 : typesList2) {
                if (!clan1.contains((Object)type2)) continue;
                return false;
            }
        }
        for (EClass type2 : typesList2) {
            EList<EClass> clan2 = this.getClan(type2);
            for (EClass type1 : typesList1) {
                if (!clan2.contains((Object)type1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areEdgeDisjoint(EList<EReference> typesList1, EList<EReference> typesList2) {
        if (typesList1.size() <= typesList2.size()) {
            for (EReference type1 : typesList1) {
                if (!typesList2.contains((Object)type1)) continue;
                return false;
            }
        } else {
            for (EReference type2 : typesList2) {
                if (!typesList1.contains((Object)type2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areAttibuteDisjoint(EList<EAttribute> typesList1, EList<EAttribute> typesList2) {
        if (typesList1.size() <= typesList2.size()) {
            for (EAttribute type1 : typesList1) {
                if (!typesList2.contains((Object)type1)) continue;
                return false;
            }
        } else {
            for (EAttribute type2 : typesList2) {
                if (!typesList1.contains((Object)type2)) continue;
                return false;
            }
        }
        return true;
    }

    private EList<EClass> getClan(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        eClasses.add((Object)eClass);
        eClasses.addAll(this.getAllSubclasses(eClass));
        return eClasses;
    }

    private EList<EClass> getAllSubclasses(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        EPackage ePackage = eClass.getEPackage();
        TreeIterator iter = ePackage.eAllContents();
        while (iter.hasNext()) {
            EClass clazz;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof EClass) || !(clazz = (EClass)eObject).getEAllSuperTypes().contains((Object)eClass)) continue;
            eClasses.add((Object)clazz);
        }
        return eClasses;
    }
}

