/*
 * Decompiled with CFR 0.152.
 */
package nestedcondition.util;

import java.util.Map;
import nestedcondition.EdgeMapping;
import nestedcondition.Formula;
import nestedcondition.Morphism;
import nestedcondition.NestedCondition;
import nestedcondition.NestedConstraint;
import nestedcondition.NestedconditionPackage;
import nestedcondition.NodeMapping;
import nestedcondition.QuantifiedCondition;
import nestedcondition.True;
import nestedcondition.Variable;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class NestedconditionValidator
extends EObjectValidator {
    public static final NestedconditionValidator INSTANCE = new NestedconditionValidator();
    public static final String DIAGNOSTIC_SOURCE = "nestedcondition";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String NESTED_CONSTRAINT__CONSTRAINT_DOMAIN_IS_EMPTY__EEXPRESSION = "self.domain.nodes -> isEmpty() and self.domain.edges -> isEmpty()";
    protected static final String NESTED_CONSTRAINT__ROOT_CONDITION_DOMAIN_IS_CONATRAINT_DOMAIN__EEXPRESSION = "self.condition.domain = self.domain";
    protected static final String NESTED_CONSTRAINT__TYPE_GRAPH_CONSISTENCY__EEXPRESSION = "graph::Graph.allInstances() -> forAll(g|g.typegraph = self.typeGraph)";
    protected static final String NESTED_CONSTRAINT__HOST_GRAPH_CONSISTENCY__EEXPRESSION = "graph::Graph.allInstances() -> forAll(g|g.edges -> forAll(e|g.nodes -> includes(e.source) and g.nodes -> includes(e.target)))";
    protected static final String QUANTIFIED_CONDITION__NESTED_DOMAIN_IS_CO_DOMAIN__EEXPRESSION = "self.condition.domain = self.codomain";
    protected static final String QUANTIFIED_CONDITION__MORPHISM_IS_FROM_DOMAIN_TO_CO_DOMAIN__EEXPRESSION = "self.morphism.from = self.domain and self.morphism.to = self.codomain";
    protected static final String FORMULA__ARGUMENTS_DOMAIN_CONSISTENCY__EEXPRESSION = "self.arguments -> forAll(cond|cond.domain = self.domain)";
    protected static final String FORMULA__ONE_ARGUMENT_FOR_NOT__EEXPRESSION = "(self.operator = laxcondition::Operator::NOT) implies (self.arguments -> size() = 1)";
    protected static final String FORMULA__AT_LEAST_TWO_ARGUMENT_FOR_ANDOR__EEXPRESSION = "((self.operator = laxcondition::Operator::AND) or (self.operator = laxcondition::Operator::OR)) implies (self.arguments -> size() > 1)";
    protected static final String FORMULA__TWO_ARGUMENT_FOR_IMPLEQUALXOR__EEXPRESSION = "((self.operator = laxcondition::Operator::IMPLIES) or (self.operator = laxcondition::Operator::EQUIVALENT) or (self.operator = laxcondition::Operator::XOR)) implies (self.arguments -> size() = 2)";
    protected static final String MORPHISM__NODE_MAPPING_IS_FROM_DOMAIN_TO_CO_DOMAIN__EEXPRESSION = "self.nodeMappings -> forAll(m|self.from.nodes -> includes(m.origin) and self.to.nodes -> includes(m.image))";
    protected static final String MORPHISM__EDGE_MAPPING_IS_FROM_DOMAIN_TO_CO_DOMAIN__EEXPRESSION = "self.edgeMappings -> forAll(m|self.from.edges -> includes(m.origin) and self.to.edges -> includes(m.image))";
    protected static final String MORPHISM__EDGE_MAPPING_CONSISTENCY__EEXPRESSION = "self.edgeMappings -> forAll(em|self.nodeMappings -> exists(nm|nm.origin = em.origin.source and nm.image = em.image.source) and self.nodeMappings -> exists(nm|nm.origin = em.origin.target and nm.image = em.image.target))";

    protected EPackage getEPackage() {
        return NestedconditionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateNestedConstraint((NestedConstraint)value, diagnostics, context);
            }
            case 1: {
                return this.validateNestedCondition((NestedCondition)value, diagnostics, context);
            }
            case 2: {
                return this.validateVariable((Variable)value, diagnostics, context);
            }
            case 3: {
                return this.validateQuantifiedCondition((QuantifiedCondition)value, diagnostics, context);
            }
            case 4: {
                return this.validateTrue((True)value, diagnostics, context);
            }
            case 5: {
                return this.validateFormula((Formula)value, diagnostics, context);
            }
            case 6: {
                return this.validateMorphism((Morphism)value, diagnostics, context);
            }
            case 7: {
                return this.validateNodeMapping((NodeMapping)value, diagnostics, context);
            }
            case 8: {
                return this.validateEdgeMapping((EdgeMapping)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateNestedConstraint(NestedConstraint nestedConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(nestedConstraint, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(nestedConstraint, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedConstraint_ConstraintDomainIsEmpty(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedConstraint_RootConditionDomainIsConatraintDomain(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedConstraint_TypeGraphConsistency(nestedConstraint, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateNestedConstraint_HostGraphConsistency(nestedConstraint, diagnostics, context);
        }
        return result;
    }

    public boolean validateNestedConstraint_ConstraintDomainIsEmpty(NestedConstraint nestedConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.NESTED_CONSTRAINT, nestedConstraint, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "ConstraintDomainIsEmpty", NESTED_CONSTRAINT__CONSTRAINT_DOMAIN_IS_EMPTY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNestedConstraint_RootConditionDomainIsConatraintDomain(NestedConstraint nestedConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.NESTED_CONSTRAINT, nestedConstraint, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "RootConditionDomainIsConatraintDomain", NESTED_CONSTRAINT__ROOT_CONDITION_DOMAIN_IS_CONATRAINT_DOMAIN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNestedConstraint_TypeGraphConsistency(NestedConstraint nestedConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.NESTED_CONSTRAINT, nestedConstraint, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "TypeGraphConsistency", NESTED_CONSTRAINT__TYPE_GRAPH_CONSISTENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNestedConstraint_HostGraphConsistency(NestedConstraint nestedConstraint, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.NESTED_CONSTRAINT, nestedConstraint, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "HostGraphConsistency", NESTED_CONSTRAINT__HOST_GRAPH_CONSISTENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNestedCondition(NestedCondition nestedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nestedCondition, diagnostics, context);
    }

    public boolean validateVariable(Variable variable, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(variable, diagnostics, context);
    }

    public boolean validateQuantifiedCondition(QuantifiedCondition quantifiedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(quantifiedCondition, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(quantifiedCondition, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateQuantifiedCondition_NestedDomainIsCoDomain(quantifiedCondition, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateQuantifiedCondition_MorphismIsFromDomainToCoDomain(quantifiedCondition, diagnostics, context);
        }
        return result;
    }

    public boolean validateQuantifiedCondition_NestedDomainIsCoDomain(QuantifiedCondition quantifiedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.QUANTIFIED_CONDITION, quantifiedCondition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "NestedDomainIsCoDomain", QUANTIFIED_CONDITION__NESTED_DOMAIN_IS_CO_DOMAIN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateQuantifiedCondition_MorphismIsFromDomainToCoDomain(QuantifiedCondition quantifiedCondition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.QUANTIFIED_CONDITION, quantifiedCondition, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "MorphismIsFromDomainToCoDomain", QUANTIFIED_CONDITION__MORPHISM_IS_FROM_DOMAIN_TO_CO_DOMAIN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateTrue(True true_, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(true_, diagnostics, context);
    }

    public boolean validateFormula(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(formula, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(formula, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_ArgumentsDomainConsistency(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_OneArgumentForNOT(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_AtLeastTwoArgumentForANDOR(formula, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormula_TwoArgumentForIMPLEQUALXOR(formula, diagnostics, context);
        }
        return result;
    }

    public boolean validateFormula_ArgumentsDomainConsistency(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "ArgumentsDomainConsistency", FORMULA__ARGUMENTS_DOMAIN_CONSISTENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFormula_OneArgumentForNOT(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "OneArgumentForNOT", FORMULA__ONE_ARGUMENT_FOR_NOT__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFormula_AtLeastTwoArgumentForANDOR(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "AtLeastTwoArgumentForANDOR", FORMULA__AT_LEAST_TWO_ARGUMENT_FOR_ANDOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateFormula_TwoArgumentForIMPLEQUALXOR(Formula formula, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.FORMULA, formula, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "TwoArgumentForIMPLEQUALXOR", FORMULA__TWO_ARGUMENT_FOR_IMPLEQUALXOR__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMorphism(Morphism morphism, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(morphism, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(morphism, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMorphism_NodeMappingIsFromDomainToCoDomain(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMorphism_EdgeMappingIsFromDomainToCoDomain(morphism, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMorphism_EdgeMappingConsistency(morphism, diagnostics, context);
        }
        return result;
    }

    public boolean validateMorphism_NodeMappingIsFromDomainToCoDomain(Morphism morphism, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.MORPHISM, morphism, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "NodeMappingIsFromDomainToCoDomain", MORPHISM__NODE_MAPPING_IS_FROM_DOMAIN_TO_CO_DOMAIN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMorphism_EdgeMappingIsFromDomainToCoDomain(Morphism morphism, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.MORPHISM, morphism, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "EdgeMappingIsFromDomainToCoDomain", MORPHISM__EDGE_MAPPING_IS_FROM_DOMAIN_TO_CO_DOMAIN__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateMorphism_EdgeMappingConsistency(Morphism morphism, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(NestedconditionPackage.Literals.MORPHISM, morphism, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "EdgeMappingConsistency", MORPHISM__EDGE_MAPPING_CONSISTENCY__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateNodeMapping(NodeMapping nodeMapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(nodeMapping, diagnostics, context);
    }

    public boolean validateEdgeMapping(EdgeMapping edgeMapping, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(edgeMapping, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

