/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda.units;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.henshin.multicda.cda.conflict.ConflictReason;
import org.eclipse.emf.henshin.multicda.cda.dependency.DependencyReason;
import org.eclipse.emf.henshin.multicda.cda.units.Reason;
import org.eclipse.emf.henshin.multicda.cda.units.Span;

public class SymmetricReason
extends Reason {
    private Reason s1;
    private Set<Reason> s2;

    public SymmetricReason(Reason reason, Set<Reason> reasons) {
        super(reason, String.valueOf(reason.tag) + reasons.iterator().next().tag + (reason instanceof ConflictReason ? "CR" : "DR"), String.valueOf(reason.NAME.split(" ")[0]) + " - " + reasons.iterator().next().NAME.split(" ")[0] + reason.NAME.split(reason.NAME.split(" ")[0])[1]);
        if (reason instanceof DependencyReason.DeleteEdgeDeleteNodeDependencyReason || reason instanceof ConflictReason.CreateEdgeDeleteNodeConflictReason) {
            System.err.println(reason + " is not a valid reason!");
        }
        this.s1 = reason;
        this.s2 = reasons;
        this.tag = reason.tag;
        this.sortID = this.s1.sortID;
    }

    public final Reason getS1() {
        return this.s1;
    }

    public final Set<Reason> getS2() {
        return this.s2;
    }

    @Override
    public String toString() {
        return this.toSymetricString(true);
    }

    public String toSymetricString(boolean complete) {
        String result = String.valueOf(this.isMinimalReason() ? "M" : "") + this.getFullID() + ": " + this.getS1().toString().split(String.valueOf(this.getS1().ID) + ": ")[1] + " -> ";
        if (!complete) {
            int size = this.s2.size() - 1;
            Reason s2R = this.s2.iterator().next();
            result = String.valueOf(result) + s2R.toString() + (size > 0 ? "... " + size + " more" : "");
        } else {
            String s2String = "";
            for (Reason s2R : this.s2) {
                s2String = String.valueOf(s2String) + ", " + s2R.toString();
            }
            result = String.valueOf(result) + s2String.substring(2);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SymmetricReason) || !super.equals(obj)) {
            return false;
        }
        Set<Reason> oS2 = ((SymmetricReason)obj).getS2();
        Set<Reason> S2 = this.getS2();
        if (oS2.size() != S2.size()) {
            return false;
        }
        HashSet<Reason> checked = new HashSet<Reason>();
        for (Reason reason1 : S2) {
            boolean found = false;
            for (Reason reason2 : oS2) {
                found = reason1.equals(reason2) && checked.add(reason2);
                if (found) break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Span o) {
        int value = this.getS1().compareTo(o instanceof SymmetricReason ? ((SymmetricReason)o).getS1() : o);
        if (value != 0) {
            return value;
        }
        if (o instanceof SymmetricReason) {
            SymmetricReason T = this;
            SymmetricReason O = (SymmetricReason)o;
            String no1 = T.getS2().toString();
            String no2 = O.getS2().toString();
            String ed1 = T.getS2().toString();
            String ed2 = O.getS2().toString();
            value = ed1.length() - ed2.length();
            if (value != 0) {
                return value;
            }
            value = no1.length() - no2.length();
            if (value != 0) {
                return value;
            }
            value = ed1.compareTo(ed2);
            if (value != 0) {
                return value;
            }
            value = no1.compareTo(no2);
            if (value != 0) {
                return value;
            }
        }
        return -1;
    }
}

