/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.matching.conditions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.script.ScriptException;
import org.eclipse.emf.henshin.model.util.ScriptEngineWrapper;

public class AttributeCondition {
    public final String conditionText;
    public final Set<String> parameters;
    final ScriptEngineWrapper scriptEngine;
    private final List<String> localJavaImports;

    public AttributeCondition(String condition, Collection<String> conditionParameters, ScriptEngineWrapper engine, List<String> localJavaImports) {
        this.conditionText = condition;
        this.parameters = new HashSet<String>(conditionParameters);
        this.scriptEngine = engine;
        this.localJavaImports = localJavaImports;
    }

    public boolean eval() {
        if (this.parameters.isEmpty()) {
            try {
                return (Boolean)this.scriptEngine.eval(this.conditionText, this.localJavaImports);
            }
            catch (ScriptException ex) {
                throw new RuntimeException(ex.getMessage());
            }
            catch (ClassCastException classCastException) {
                throw new RuntimeException("Warning: Attribute condition did not return a boolean value");
            }
        }
        return true;
    }
}

