/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.parts;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.henshin.diagram.edit.helpers.ColorModeHelper;
import org.eclipse.emf.henshin.diagram.edit.helpers.RuleEditHelper;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeActionEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeTypeEditPart;
import org.eclipse.emf.henshin.diagram.edit.policies.EdgeItemSemanticEditPolicy;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.provider.util.HenshinColorMode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;

public class EdgeEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int VISUAL_ID = 4001;
    private RuleEditHelper.RuleListener ruleListener;

    public EdgeEditPart(View view) {
        super(view);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        View view = this.getNotationView();
        if (view == null) {
            return;
        }
        Edge edge = (Edge)this.getNotationView().getElement();
        if (edge == null) {
            return;
        }
        this.ruleListener = new RuleEditHelper.RuleListener((EObject)edge){

            public void notifyChanged(Notification event) {
                super.notifyChanged(event);
                if (event.getEventType() == 8) {
                    return;
                }
                if (EdgeEditPart.this.isActive() && EdgeEditPart.this.getNotationView().getElement() instanceof Edge && EdgeEditPart.this.getParent() != null) {
                    EdgeEditPart.this.refreshVisuals();
                }
            }
        };
    }

    public void removeSemanticListeners() {
        super.removeSemanticListeners();
        if (this.ruleListener != null) {
            this.ruleListener.dispose();
            this.ruleListener = null;
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new EdgeItemSemanticEditPolicy());
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EdgeTypeEditPart) {
            ((EdgeTypeEditPart)childEditPart).setLabel(this.getPrimaryShape().getEdgeTypeLabel());
            return true;
        }
        if (childEditPart instanceof EdgeActionEditPart) {
            ((EdgeActionEditPart)childEditPart).setLabel(this.getPrimaryShape().getEdgeActionLabel());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, index);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof EdgeTypeEditPart) {
            return true;
        }
        return childEditPart instanceof EdgeActionEditPart;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Connection createConnectionFigure() {
        return new EdgeFigure();
    }

    public EdgeFigure getPrimaryShape() {
        return (EdgeFigure)this.getFigure();
    }

    public void refreshForegroundColor() {
        HenshinColorMode.Color color = ColorModeHelper.getActionColor(this.getNotationView(), true);
        if (color != null) {
            this.setForegroundColor(ColorModeHelper.getSWTColor(color));
        } else {
            super.refreshForegroundColor();
        }
    }

    public void refreshVisuals() {
        EObject elem = this.getNotationView().getElement();
        if (!(elem instanceof Edge)) {
            return;
        }
        super.refreshVisuals();
        Edge edge = (Edge)elem;
        EReference type = edge.getType();
        if (type != null) {
            if (type.isContainment()) {
                this.getPrimaryShape().setSourceDecoration(this.createDiamondDecoration());
            } else if (type.getEOpposite() != null) {
                this.getPrimaryShape().setSourceDecoration(null);
            } else {
                this.getPrimaryShape().setSourceDecoration(null);
            }
            this.getPrimaryShape().setTargetDecoration(this.createArrowDecoration());
        } else {
            this.getPrimaryShape().setSourceDecoration(null);
            this.getPrimaryShape().setTargetDecoration(null);
        }
    }

    private RotatableDecoration createDiamondDecoration() {
        PolygonDecoration df = new PolygonDecoration();
        PointList pl = new PointList();
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        pl.addPoint(this.getMapMode().DPtoLP(0), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(-1));
        pl.addPoint(this.getMapMode().DPtoLP(-2), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-1), this.getMapMode().DPtoLP(1));
        df.setTemplate(pl);
        df.setScale((double)this.getMapMode().DPtoLP(7), (double)this.getMapMode().DPtoLP(3));
        return df;
    }

    private RotatableDecoration createArrowDecoration() {
        PolylineDecoration df = new PolylineDecoration();
        df.setLineWidth(1);
        return df;
    }

    public class EdgeFigure
    extends PolylineConnectionEx {
        private WrappingLabel fEdgeTypeLabel;
        private WrappingLabel fEdgeActionLabel;

        public EdgeFigure() {
            this.createContents();
        }

        private void createContents() {
            this.fEdgeTypeLabel = new WrappingLabel();
            this.fEdgeTypeLabel.setText("unknown");
            this.add((IFigure)this.fEdgeTypeLabel);
            this.fEdgeActionLabel = new WrappingLabel();
            this.fEdgeActionLabel.setText("unknown");
            this.add((IFigure)this.fEdgeActionLabel);
        }

        public WrappingLabel getEdgeTypeLabel() {
            return this.fEdgeTypeLabel;
        }

        public WrappingLabel getEdgeActionLabel() {
            return this.fEdgeActionLabel;
        }
    }
}

