/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.AttrType;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.impl.AttrTupleManager;
import agg.attribute.impl.DeclMember;
import agg.attribute.impl.DeclTuple;
import agg.util.XMLHelper;
import agg.xt_basis.Arc;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import agg.xt_basis.TypeError;
import agg.xt_basis.TypeGraph;
import agg.xt_basis.TypeGraphArc;
import agg.xt_basis.TypeGraphNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class NodeTypeImpl
implements Type {
    String comment = "";
    boolean isAbstract = false;
    String itsStringRepr;
    final Vector<Type> itsParents = new Vector(1);
    final Vector<Type> itsChildren = new Vector(1);
    AttrType itsAttrType = null;
    String additionalRepr;
    String imageFileName = "";
    boolean typeGraphObjectDefined;
    TypeGraphNode typeGraphNode;
    String keyStr = null;

    protected NodeTypeImpl() {
        this.itsStringRepr = "";
        this.additionalRepr = ":RECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:";
        this.resetKey();
    }

    protected NodeTypeImpl(String name) {
        this.itsStringRepr = name;
        this.additionalRepr = ":RECT:java.awt.Color[r=0,g=0,b=0]::[NODE]:";
        this.resetKey();
    }

    protected NodeTypeImpl(AttrType at, String name) {
        this(name);
        this.itsAttrType = at;
    }

    protected NodeTypeImpl(AttrType at) {
        this();
        this.itsAttrType = at;
    }

    @Override
    public void dispose() {
        this.itsAttrType = null;
        this.itsChildren.clear();
        this.itsParents.clear();
        if (this.typeGraphNode != null) {
            this.typeGraphNode.dispose();
            this.typeGraphNode = null;
        }
        this.typeGraphObjectDefined = false;
    }

    public void finalize() {
    }

    @Override
    public void createAttributeType() {
        this.itsAttrType = AttrTupleManager.getDefaultManager().newType();
        int i = 0;
        while (i < this.getParents().size()) {
            NodeTypeImpl t = (NodeTypeImpl)this.getParents().get(i);
            if (t.getAttrType() == null) {
                t.createAttributeType();
            }
            ((DeclTuple)this.itsAttrType).addParent((DeclTuple)t.getAttrType());
            ++i;
        }
    }

    public void setAttributeType(AttrType at) {
        this.itsAttrType = at;
        if (this.itsAttrType != null) {
            int i = 0;
            while (i < this.getParents().size()) {
                NodeTypeImpl t = (NodeTypeImpl)this.getParents().get(i);
                if (t.getAttrType() == null) {
                    t.createAttributeType();
                }
                ((DeclTuple)this.itsAttrType).addParent((DeclTuple)t.getAttrType());
                ++i;
            }
        }
    }

    @Override
    public void removeAttributeType() {
        if (this.itsAttrType != null) {
            ((DeclTuple)this.itsAttrType).dispose();
            this.itsAttrType = null;
        }
    }

    @Override
    public boolean isAttrTypeEmpty() {
        return this.getAttrType() == null;
    }

    @Override
    public boolean isParentAttrTypeEmpty() {
        Vector<Type> list = this.getAllParents();
        int i = 1;
        while (i < list.size()) {
            NodeTypeImpl t = (NodeTypeImpl)list.get(i);
            if (t.getAttrType() != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean hasAnyAttrMember() {
        Vector<Type> list = this.getAllParents();
        int i = 0;
        while (i < list.size()) {
            NodeTypeImpl t = (NodeTypeImpl)list.get(i);
            if (t.getAttrType() != null && t.getAttrType().getNumberOfEntries() != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isNodeType() {
        return true;
    }

    @Override
    public boolean isArcType() {
        return false;
    }

    @Override
    public String convertToKey() {
        if (this.keyStr == null) {
            this.keyStr = this.itsStringRepr.concat("%").concat(this.additionalRepr);
        }
        return this.keyStr;
    }

    @Override
    public String resetKey() {
        this.keyStr = this.itsStringRepr.concat("%").concat(this.additionalRepr);
        return this.keyStr;
    }

    @Override
    public void adaptTypeAttribute(Type type) {
        if (type.getAttrType() == null) {
            return;
        }
        if (this.itsAttrType == null) {
            this.itsAttrType = AttrTupleManager.getDefaultManager().newType();
        }
        DeclTuple declTuple = (DeclTuple)this.itsAttrType;
        DeclTuple otherTuple = (DeclTuple)type.getAttrType();
        int i = 0;
        while (i < otherTuple.getSize()) {
            DeclMember otherMem = (DeclMember)otherTuple.getMemberAt(i);
            if (otherMem.getHoldingTuple() == otherTuple) {
                String otherName = otherMem.getName();
                String otherType = otherMem.getTypeName();
                boolean nameFound = false;
                boolean conflict = false;
                DeclMember mem = null;
                int j = 0;
                while (j < declTuple.getSize()) {
                    mem = (DeclMember)declTuple.getMemberAt(j);
                    if (mem.getHoldingTuple() == declTuple) {
                        if (mem.getName().equals(otherName)) {
                            nameFound = true;
                            if (!mem.getTypeName().equals(otherType)) {
                                conflict = true;
                                break;
                            }
                            mem = null;
                            break;
                        }
                        mem = null;
                    }
                    ++j;
                }
                if (nameFound && conflict && mem != null && mem.getHoldingTuple() == declTuple) {
                    mem.setName(String.valueOf(mem.getName()) + "?");
                    declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherType, otherName);
                } else if (!nameFound) {
                    declTuple.addMember(DefaultInformationFacade.self().getJavaHandler(), otherType, otherName);
                }
            }
            ++i;
        }
    }

    @Override
    public void checkDoubleAttributeType() {
        if (this.itsAttrType == null) {
            return;
        }
        DeclTuple declTuple = (DeclTuple)this.itsAttrType;
        int i = 0;
        while (i < declTuple.getSize()) {
            DeclMember memi = (DeclMember)declTuple.getMemberAt(i);
            String n = memi.getName();
            boolean nameFound = false;
            boolean conflict = false;
            DeclMember memj = null;
            int j = i + 1;
            while (j < declTuple.getSize()) {
                memj = (DeclMember)declTuple.getMemberAt(j);
                if (memj.getName().equals(n)) {
                    nameFound = true;
                    conflict = true;
                }
                if (nameFound && conflict) {
                    memj.setName(String.valueOf(memj.getName()) + "?");
                }
                nameFound = false;
                conflict = false;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public boolean compareTo(Type t) {
        if (!this.getStringRepr().equals(t.getStringRepr())) {
            return false;
        }
        if (!this.getAdditionalRepr().equals(t.getAdditionalRepr())) {
            return false;
        }
        if (this.itsAttrType != null) {
            return t.getAttrType() != null && ((DeclTuple)this.itsAttrType).getSize() == ((DeclTuple)t.getAttrType()).getSize() && ((DeclTuple)this.itsAttrType).weakcompareTo(t.getAttrType());
        }
        return t.getAttrType() == null;
    }

    public boolean differentTo(Type t, Vector<String> difference) {
        String diff = "";
        if (!this.getStringRepr().equals(t.getStringRepr())) {
            diff = "Type name# " + this.getStringRepr() + " != " + t.getStringRepr();
            difference.add(diff);
        }
        if (!this.getAdditionalRepr().equals(t.getAdditionalRepr())) {
            diff = "Type graphical repr# " + this.getAdditionalRepr() + " != " + t.getAdditionalRepr();
            difference.add(diff);
        }
        if (this.itsAttrType != null) {
            if (t.getAttrType() == null) {
                diff = "Attribute Type# defined (is not null) != not defined (is null)";
                difference.add(diff);
            } else if (((DeclTuple)this.itsAttrType).getSize() != ((DeclTuple)t.getAttrType()).getSize()) {
                diff = "Attr member count# " + ((DeclTuple)this.itsAttrType).getSize() + " != " + ((DeclTuple)t.getAttrType()).getSize();
                difference.add(diff);
            } else if (!this.itsAttrType.compareTo(t.getAttrType())) {
                DeclTuple dt1 = (DeclTuple)this.itsAttrType;
                DeclTuple dt2 = (DeclTuple)t.getAttrType();
                int i = 0;
                while (i < dt1.getSize()) {
                    DeclMember dm2;
                    DeclMember dm1 = (DeclMember)dt1.getMemberAt(i);
                    if (!dm1.compareTo(dm2 = (DeclMember)dt2.getMemberAt(i))) {
                        diff = String.valueOf(i) + ". " + "Member decl(type:name)# " + dm1.getTypeName() + ":" + dm1.getName() + " != " + dm2.getTypeName() + ":" + dm2.getName();
                        difference.add(diff);
                    }
                    ++i;
                }
            }
        } else if (t.getAttrType() != null) {
            diff = "Attribute Type# not defined (is null) != defined (is not null)";
            difference.add(diff);
        }
        return !difference.isEmpty();
    }

    @Override
    public void setAbstract(boolean b) {
        this.isAbstract = b;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isChildOf(Type t) {
        Vector<Type> allParents = this.getAllParents();
        int i = 1;
        while (i < allParents.size()) {
            if (allParents.get(i).compareTo(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isParentOf(Type t) {
        if (this.compareTo(t)) {
            return true;
        }
        int i = 0;
        while (i < t.getParents().size()) {
            Type tAncestor = t.getParents().get(i);
            if (this.isParentOf(tAncestor)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isRelatedTo(Type t) {
        if (this.compareTo(t) || this.isParentOf(t)) {
            return true;
        }
        Vector<Type> allparents = this.getAllParents();
        int i = 1;
        while (i < allparents.size()) {
            Type oldestAncestor = allparents.get(i);
            if (oldestAncestor.isParentOf(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public List<Type> getClan() {
        return this.getAllChildren();
    }

    @Override
    public boolean isInClanOf(Type t) {
        return t.hasCommonParentWith(this) || this.isChildOf(t);
    }

    @Override
    public boolean hasCommonParentWith(Type t) {
        return !this.getCommonParentWith(t).isEmpty();
    }

    @Override
    public List<Type> getCommonParentWith(Type t) {
        Vector<Type> list = new Vector<Type>();
        Vector<Type> allparents = this.getAllParents();
        int i = 0;
        while (i < allparents.size()) {
            Type anAncestor = allparents.get(i);
            if (anAncestor.isParentOf(t)) {
                list.add(anAncestor);
            }
            ++i;
        }
        return list;
    }

    @Override
    public Vector<Type> getAllParents() {
        Vector<Type> myAllParents = new Vector<Type>();
        myAllParents.add(this);
        int i = 0;
        while (i < this.itsParents.size()) {
            Type currentAncestor = this.itsParents.get(i);
            Vector<Type> moreParents = currentAncestor.getAllParents();
            int j = 0;
            while (j < moreParents.size()) {
                Type p = moreParents.get(j);
                if (!myAllParents.contains(p)) {
                    myAllParents.add(p);
                }
                ++j;
            }
            ++i;
        }
        return myAllParents;
    }

    @Override
    public Vector<Type> getAllChildren() {
        Vector<Type> myAllChildren = new Vector<Type>();
        myAllChildren.add(this);
        int i = 0;
        while (i < this.itsChildren.size()) {
            Type ch = this.itsChildren.get(i);
            Vector<Type> moreChildren = ch.getAllChildren();
            int j = 0;
            while (j < moreChildren.size()) {
                Type p = moreChildren.get(j);
                if (!myAllChildren.contains(p)) {
                    myAllChildren.add(p);
                }
                ++j;
            }
            ++i;
        }
        return myAllChildren;
    }

    @Override
    public int getMaxMultiplicityOfAllChildren() {
        if (this.typeGraphNode == null) {
            return -1;
        }
        int count = -1;
        int i = 0;
        while (i < this.getChildren().size()) {
            Type chi = this.getChildren().get(i);
            if (chi.getSourceMax() != -1) {
                count += chi.getSourceMax();
            }
            Vector<Type> moreChildren = chi.getAllChildren();
            int j = 1;
            while (j < moreChildren.size()) {
                Type chj = moreChildren.get(j);
                if (chj.getSourceMax() != -1) {
                    count += chj.getSourceMax();
                }
                ++j;
            }
            ++i;
        }
        if (count > -1) {
            ++count;
        }
        return count;
    }

    @Override
    public int getMinMultiplicityOfAllChildren() {
        if (this.typeGraphNode == null) {
            return -1;
        }
        int count = -1;
        int i = 0;
        while (i < this.getChildren().size()) {
            Type chi = this.getChildren().get(i);
            if (chi.getSourceMin() != -1) {
                count += chi.getSourceMin();
            }
            Vector<Type> moreChildren = chi.getAllChildren();
            int j = 1;
            while (j < moreChildren.size()) {
                Type chj = moreChildren.get(j);
                if (chj.getSourceMin() != -1) {
                    count += chj.getSourceMin();
                }
                ++j;
            }
            ++i;
        }
        if (count > -1) {
            ++count;
        }
        return count;
    }

    public void showRelatives() {
        System.out.println("Type Relatives of  \"" + this.getName() + "\"   size: " + this.itsParents.size());
        int i = 0;
        while (i < this.itsParents.size()) {
            Type p = this.itsParents.get(i);
            System.out.print("\"" + p.getName() + "\", ");
            ++i;
        }
        System.out.println("\n***************************");
    }

    public void showAllRelatives() {
        Vector<Type> v = this.getAllParents();
        System.out.println("Type Relatives of  \"" + this.getName() + "\"   size: " + v.size());
        int i = 0;
        while (i < v.size()) {
            Type p = v.get(i);
            System.out.print("\"" + p.getName() + "\", ");
            ++i;
        }
        System.out.println("\n***************************");
    }

    @Override
    public final String getStringRepr() {
        return this.itsStringRepr;
    }

    @Override
    public final void setStringRepr(String n) {
        this.itsStringRepr = n;
        this.resetKey();
    }

    @Override
    public void setTextualComment(String text) {
        this.comment = text;
    }

    @Override
    public String getTextualComment() {
        return this.comment;
    }

    @Override
    public Type getParent() {
        return this.itsParents.isEmpty() ? null : this.itsParents.lastElement();
    }

    @Override
    public Vector<Type> getParents() {
        return this.itsParents;
    }

    @Override
    public void setParent(Type t) {
        if (t == null && !this.itsParents.isEmpty()) {
            this.removeParent(this.itsParents.lastElement());
            return;
        }
        this.addParent(t);
    }

    @Override
    public void addParent(Type t) {
        if (t != null && !this.itsParents.contains(t)) {
            if (t.getAttrType() != null && this.itsAttrType == null) {
                this.createAttributeType();
            } else if (t.getAttrType() == null && this.itsAttrType != null) {
                ((NodeTypeImpl)t).createAttributeType();
            }
            if (this.itsAttrType != null) {
                DeclTuple myDeclTuple = (DeclTuple)this.itsAttrType;
                myDeclTuple.addParent((DeclTuple)t.getAttrType());
            }
            this.itsParents.add(t);
            ((NodeTypeImpl)t).addChild(this);
        }
    }

    @Override
    public void addChild(Type t) {
        if (!this.itsChildren.contains(t)) {
            this.itsChildren.add(t);
        }
    }

    @Override
    public Vector<Type> getChildren() {
        return this.itsChildren;
    }

    public Vector<String> checkDoubleAttributeName(Type otherType) {
        Vector<String> v = new Vector<String>(5, 5);
        if (this.itsAttrType == null || otherType.getAttrType() == null) {
            return v;
        }
        DeclTuple myDecl = (DeclTuple)this.itsAttrType;
        DeclTuple otherDecl = (DeclTuple)otherType.getAttrType();
        int i = 0;
        while (i < otherDecl.getNumberOfEntries()) {
            DeclMember mem = (DeclMember)otherDecl.getMemberAt(i);
            if (myDecl.isLegalName(mem.getName()) > 0 && mem.getHoldingTuple() != myDecl.getMemberAt(mem.getName()).getHoldingTuple()) {
                v.add(otherDecl.getNameAsString(i));
            }
            ++i;
        }
        return v;
    }

    @Override
    public void removeParent(Type t) {
        if (t != null && this.itsParents.contains(t)) {
            this.itsParents.remove(t);
            ((NodeTypeImpl)t).removeChild(this);
            if (this.itsAttrType != null) {
                DeclTuple myDeclTuple = (DeclTuple)this.itsAttrType;
                myDeclTuple.removeParent((DeclTuple)t.getAttrType());
            }
        }
    }

    @Override
    public void removeChild(Type t) {
        this.itsChildren.remove(t);
    }

    @Override
    public boolean hasInheritedAttribute() {
        int i = 0;
        while (i < this.getParents().size()) {
            Type pi = this.getParents().get(i);
            if (pi.getAttrType() != null) {
                return true;
            }
            Vector<Type> moreParents = pi.getAllParents();
            int j = 0;
            while (j < moreParents.size()) {
                Type pj = moreParents.get(j);
                if (pj.getAttrType() != null) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    @Override
    public final AttrType getAttrType() {
        return this.itsAttrType;
    }

    @Override
    public String getAdditionalRepr() {
        return this.additionalRepr;
    }

    @Override
    public String getImageFilename() {
        return this.imageFileName;
    }

    @Override
    public void setImageFilename(String imageFilename) {
        this.imageFileName = imageFilename;
    }

    @Override
    public void setAdditionalRepr(String repr) {
        this.additionalRepr = repr.equals("NODE") || repr.equals("[NODE]") ? ":RECT:java.awt.Color[r=0,g=0,b=0]:[NODE]:" : repr;
        this.resetKey();
    }

    @Override
    public void XwriteObject(XMLHelper h) {
        int idx;
        String n = this.getStringRepr();
        if (this.additionalRepr != null && !this.additionalRepr.equals("")) {
            n = String.valueOf(n) + "%" + this.additionalRepr;
        }
        if ((idx = n.indexOf("[NODE]")) >= 0) {
            h.addEnumeration("", this.itsParents.elements(), true);
            if (this.imageFileName.length() > 0) {
                n = n.substring(0, idx).concat(this.imageFileName).concat(":").concat("[NODE]:");
            }
            h.openNewElem("NodeType", this);
        } else {
            h.openNewElem("Type", this);
        }
        h.addAttr("name", n);
        if (!this.comment.equals("")) {
            h.addAttr("comment", this.comment);
        }
        h.addAttr("abstract", String.valueOf(this.isAbstract));
        if (n.indexOf("[NODE]") >= 0) {
            int i = 0;
            while (i < this.itsParents.size()) {
                h.openSubTag("Parent");
                h.addObject("pID", this.itsParents.get(i), false);
                h.close();
                ++i;
            }
        }
        if (this.itsAttrType != null && this.itsAttrType.getNumberOfEntries() > 0) {
            h.addObject("", this.itsAttrType, true);
        }
        h.close();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void XreadObject(XMLHelper h) {
        block9: {
            block10: {
                block11: {
                    block12: {
                        if (!h.isTag("NodeType", this) && !h.isTag("Type", this)) break block9;
                        n = h.readAttr("name");
                        str = h.readAttr("comment");
                        if (!str.equals("")) {
                            this.comment = str.toString();
                        }
                        this.isAbstract = false;
                        abs = h.readAttr("abstract");
                        if (!"".equals(abs)) {
                            this.isAbstract = Boolean.valueOf(abs);
                        }
                        if ((i = n.indexOf(37)) != -1) {
                            test = n.substring(0, i);
                            this.itsStringRepr = test = XMLHelper.checkNameDueToSpecialCharacters(test);
                        } else {
                            this.itsStringRepr = test = XMLHelper.checkNameDueToSpecialCharacters(n);
                        }
                        tmpAttr = AttrTupleManager.getDefaultManager().newType();
                        h.enrichObject(tmpAttr);
                        this.itsAttrType = tmpAttr.getNumberOfEntries() != 0 ? tmpAttr : null;
                        if (i == -1) break block10;
                        a = n.substring(i + 1);
                        a = a.replaceAll("::", ":");
                        if (n.indexOf("[NODE]") == -1) break block11;
                        p = (Type)h.getObjectRef("parent", null);
                        if (p == null) ** GOTO lbl35
                        this.addParent(p);
                        pi = 1;
                        while ((p = (Type)h.getObjectRef("parent" + pi, null)) != null) {
                            this.addParent(p);
                            ++pi;
                        }
                        break block12;
lbl-1000:
                        // 1 sources

                        {
                            pi = (Type)h.getObjectRef("pID", null);
                            if (pi != null) {
                                this.addParent(pi);
                            }
                            h.close();
lbl35:
                            // 2 sources

                            ** while (h.readSubTag((String)"Parent"))
                        }
                    }
                    a = this.extractImageFileName(a);
                }
                n = n.substring(0, i);
                this.setAdditionalRepr(a);
            }
            if (this.itsAttrType != null && this.itsAttrType.getNumberOfEntries() != 0) {
                myDeclTuple = (DeclTuple)this.itsAttrType;
                p = 0;
                while (p < this.itsParents.size()) {
                    t = this.itsParents.get(p);
                    myDeclTuple.addParent((DeclTuple)t.getAttrType());
                    ++p;
                }
            }
            h.close();
        }
    }

    private String extractImageFileName(String str) {
        String[] test = str.split(":");
        int indx = -1;
        int i = 0;
        while (i < test.length) {
            String s = test[i];
            if (s.indexOf(".jpg") >= 0 || s.indexOf(".gif") >= 0 || s.indexOf(".xpm") >= 0) {
                this.imageFileName = s;
                indx = i;
                break;
            }
            ++i;
        }
        String out = ":";
        if (indx != -1) {
            int i2 = 0;
            while (i2 < test.length) {
                if (i2 != indx && !"".equals(test[i2])) {
                    String s = test[i2];
                    out = out.concat(s);
                    out = out.concat(":");
                }
                ++i2;
            }
        } else {
            out = str;
        }
        return out;
    }

    @Override
    public String getName() {
        String stringRepr = this.getStringRepr();
        if ("".equals(stringRepr)) {
            return "unnamed";
        }
        return stringRepr;
    }

    @Override
    public TypeError check(GraphObject node, int level) {
        if (level == 0) {
            return null;
        }
        if (node instanceof Node) {
            return this.check((Node)node, level);
        }
        throw new IllegalArgumentException("parameter must be of Node type.");
    }

    public TypeError check(Node node, int level) {
        if (this.typeGraphNode != null) {
            if (level >= 10) {
                int sourceMin;
                int sourceMax;
                int count;
                List<Node> list = node.getContext().getNodes(node.getType());
                int n = count = list != null ? list.size() : 0;
                if (!node.getContext().isNode(node)) {
                    ++count;
                }
                if ((level == 20 || level == 30) && (sourceMax = this.typeGraphNode.getSourceMax()) != -1 && count > sourceMax) {
                    return new TypeError(25, "- Too many (" + count + ") nodes of type \"" + this.getName() + "\".\nThere are only " + sourceMax + " allowed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
                if (level == 30 && (sourceMin = this.typeGraphNode.getSourceMin()) > 0 && count < sourceMin) {
                    return new TypeError(24, "- Not enough (" + count + ") nodes of type \"" + this.getName() + "\".\nThere are at least " + sourceMin + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
                }
                return null;
            }
            return null;
        }
        if (level > 5) {
            return new TypeError(21, "The type graph does not contain a node type with name \"" + this.getName() + "\".", node, this);
        }
        return null;
    }

    @Override
    public boolean addTypeGraphObject(GraphObject node) {
        if (!node.getContext().isTypeGraph()) {
            return false;
        }
        if (node instanceof Node) {
            if (this.typeGraphNode == null) {
                this.typeGraphNode = new TypeGraphNode();
            }
            this.typeGraphNode.addTypeGraphObject((Node)node);
            this.typeGraphObjectDefined = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTypeGraphObject(GraphObject node, boolean forceToRemove) {
        if (node == null || !node.isNode() || node.getContext() == null || !node.getContext().isTypeGraph()) {
            return true;
        }
        boolean allowedToRemove = false;
        allowedToRemove = node.getContext().getTypeSet().getLevelOfTypeGraphCheck() <= 5 || forceToRemove;
        if (allowedToRemove) {
            if (this.typeGraphNode == null) {
                return true;
            }
            if (forceToRemove) {
                this.typeGraphNode.forceRemoveTypeGraphObject();
            } else if (!this.typeGraphNode.removeTypeGraphObject()) {
                return false;
            }
            this.typeGraphObjectDefined = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTypeGraphObject(GraphObject node) {
        return this.removeTypeGraphObject(node, false);
    }

    @Override
    public void disableTypeGraphObject() {
        if (this.typeGraphNode != null) {
            this.typeGraphNode.forceRemoveTypeGraphObject();
            this.typeGraphObjectDefined = false;
        }
    }

    @Override
    public void setSourceMin(int value) {
        if (this.typeGraphNode != null) {
            this.typeGraphNode.setSourceMin(value);
        }
    }

    @Override
    public void setSourceMax(int value) {
        if (this.typeGraphNode != null) {
            this.typeGraphNode.setSourceMax(value);
        }
    }

    @Override
    public int getSourceMin() {
        if (this.typeGraphNode != null) {
            return this.typeGraphNode.getSourceMin();
        }
        return -1;
    }

    @Override
    public int getSourceMax() {
        if (this.typeGraphNode != null) {
            return this.typeGraphNode.getSourceMax();
        }
        return -1;
    }

    @Override
    public void setVisibilityOfObjectsOfTypeGraphNode(boolean vis) {
        if (this.typeGraphNode != null) {
            this.typeGraphNode.setVisible(vis);
        }
    }

    @Override
    public boolean isObjectOfTypeGraphNodeVisible() {
        return this.typeGraphNode == null || this.typeGraphNode.isVisible();
    }

    @Override
    public TypeGraphNode getTypeGraphNode() {
        if (this.typeGraphNode == null) {
            this.typeGraphNode = new TypeGraphNode();
        }
        return this.typeGraphNode;
    }

    @Override
    public boolean hasTypeGraphNode() {
        return this.typeGraphNode != null && this.typeGraphNode.getNode() != null;
    }

    @Override
    public Node getTypeGraphNodeObject() {
        return this.typeGraphNode == null ? null : this.typeGraphNode.getNode();
    }

    @Override
    public Vector<Type> getOwnOutgoingArcTypes() {
        Vector<Type> result = new Vector<Type>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            Iterator<Arc> outs = this.typeGraphNode.getNode().getOutgoingArcs();
            while (outs.hasNext()) {
                result.add(outs.next().getType());
            }
        }
        return result;
    }

    public Vector<Type> getOutgoingArcTypes() {
        Vector<Type> result = new Vector<Type>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            result.addAll(this.getOwnOutgoingArcTypes());
            Vector<Type> myparents = this.getAllParents();
            int i = 0;
            while (i < myparents.size()) {
                result.addAll(((NodeTypeImpl)myparents.get(i)).getOwnOutgoingArcTypes());
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Arc> getOwnOutgoingArcs() {
        Vector<Arc> result = new Vector<Arc>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            result.addAll(this.typeGraphNode.getNode().getOutgoingArcsSet());
        }
        return result;
    }

    public Vector<Arc> getOutgoingArcs() {
        Vector<Arc> result = new Vector<Arc>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            result.addAll(this.typeGraphNode.getNode().getOutgoingArcsSet());
            Vector<Type> myparents = this.getAllParents();
            int i = 0;
            while (i < myparents.size()) {
                result.addAll(((NodeTypeImpl)myparents.get(i)).getOwnOutgoingArcs());
                ++i;
            }
        }
        return result;
    }

    @Override
    public Vector<Type> getOwnIncomingArcTypes() {
        Vector<Type> result = new Vector<Type>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            Iterator<Arc> arcs = this.typeGraphNode.getNode().getIncomingArcs();
            while (arcs.hasNext()) {
                result.add(arcs.next().getType());
            }
        }
        return result;
    }

    public Vector<Type> getIncomingArcTypes() {
        Vector<Type> result = new Vector<Type>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            result.addAll(this.getOwnIncomingArcTypes());
            Vector<Type> myparents = this.getAllParents();
            int i = 0;
            while (i < myparents.size()) {
                result.addAll(((NodeTypeImpl)myparents.get(i)).getOwnIncomingArcTypes());
                ++i;
            }
        }
        return result;
    }

    @Override
    public List<Arc> getOwnIncomingArcs() {
        Vector<Arc> result = new Vector<Arc>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            result.addAll(this.typeGraphNode.getNode().getIncomingArcsSet());
        }
        return result;
    }

    public Vector<Arc> getIncomingArcs() {
        Vector<Arc> result = new Vector<Arc>();
        if (this.typeGraphNode != null && this.typeGraphNode.getNode() != null) {
            result.addAll(this.typeGraphNode.getNode().getIncomingArcsSet());
            Vector<Type> myparents = this.getAllParents();
            int i = 0;
            while (i < myparents.size()) {
                result.addAll(((NodeTypeImpl)myparents.get(i)).getOwnIncomingArcs());
                ++i;
            }
        }
        return result;
    }

    @Override
    public boolean isTypeGraphObjectDefined() {
        return this.typeGraphObjectDefined;
    }

    @Override
    public TypeError checkIfRemovable(Node node, int level) {
        if (node.getType() != this || level != 30 || node.getContext() instanceof TypeGraph) {
            return null;
        }
        return this.checkMinMultiplicityOfNodeType(node);
    }

    private TypeError checkMinMultiplicityOfNodeType(Node node) {
        if (this.typeGraphNode == null) {
            return null;
        }
        int minValue = this.typeGraphNode.getSourceMin();
        if (minValue != -1) {
            int count;
            List<Node> list = node.getContext().getNodes(this);
            int n = count = list != null ? list.size() : 0;
            if (count - 1 < minValue) {
                return new TypeError(24, "Not enough nodes of type \"" + this.getName() + "\"" + " .\nThere are at least " + minValue + " needed ( graph \"" + node.getContext().getName() + "\" ).", node, this);
            }
        }
        return null;
    }

    @Override
    public TypeError checkIfNodeCreatable(Graph g, int level) {
        if (level != 30 || g instanceof TypeGraph) {
            return null;
        }
        return this.checkMaxMultiplicityOfNodeType(g);
    }

    private TypeError checkMaxMultiplicityOfNodeType(Graph g) {
        if (this.typeGraphNode == null) {
            return null;
        }
        int maxValue = this.typeGraphNode.getSourceMax();
        if (maxValue != -1) {
            int count;
            List<Node> list = g.getNodes(this);
            int n = count = list != null ? list.size() : 0;
            if (count + 1 > maxValue) {
                return new TypeError(25, "Too many nodes of type \"" + this.getName() + "\"" + " .\nThere are at most " + maxValue + " allowed ( graph \"" + g.getName() + "\" ).", this);
            }
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromSource(GraphObject node, Arc arc, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkSourceMin(node, arc, false, false);
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromSource(GraphObject node, Arc arc, boolean deleteSrc, boolean deleteTar, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkSourceMin(node, arc, deleteSrc, deleteTar);
        }
        return null;
    }

    private TypeError checkSourceMin(GraphObject srcnode, Arc arc, boolean deleteSrc, boolean deleteTar) {
        int count;
        int sourceMin = arc.getType().getSourceMin(this, arc.getTarget().getType());
        if (sourceMin != -1 && (count = ((Node)arc.getTarget()).getNumberOfIncomingArcs(arc.getType(), srcnode.getType())) - 1 < sourceMin && !deleteTar) {
            return new TypeError(23, "Too few edges of type \"" + arc.getType().getName() + "\"" + " (would) start at the source node  " + "\"" + arc.getSource().getType().getName() + "\"." + "\nThere are at least " + sourceMin + " needed ( graph \"" + srcnode.getContext().getName() + "\" ).", arc, this);
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromTarget(GraphObject node, Arc arc, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkTargetMin(node, arc, false, false);
        }
        return null;
    }

    @Override
    public TypeError checkIfRemovableFromTarget(GraphObject node, Arc arc, boolean deleteSrc, boolean deleteTar, int level) {
        if (arc.getContext().isCompleteGraph() && level == 30) {
            return this.checkTargetMin(node, arc, deleteSrc, deleteTar);
        }
        return null;
    }

    private TypeError checkTargetMin(GraphObject tarnode, Arc arc, boolean deleteSrc, boolean deleteTar) {
        int count;
        int targetMin = arc.getType().getTargetMin(arc.getSource().getType(), this);
        if (targetMin != -1 && (count = ((Node)arc.getSource()).getNumberOfOutgoingArcs(arc.getType(), tarnode.getType())) - 1 < targetMin && !deleteSrc) {
            return new TypeError(23, "Too few edges of type \"" + arc.getType().getName() + "\"" + " (would) end at the target node  " + "\"" + arc.getTarget().getType().getName() + "\"." + "\nThere are at least " + targetMin + " needed ( graph \"" + tarnode.getContext().getName() + "\" ).", arc, this);
        }
        return null;
    }

    @Override
    public int getSourceMax(Type sourceType, Type targetType) {
        return 0;
    }

    @Override
    public int getSourceMin(Type sourceType, Type targetType) {
        return 0;
    }

    @Override
    public int getTargetMax(Type sourceType, Type targetType) {
        return 0;
    }

    @Override
    public int getTargetMin(Type sourceType, Type targetType) {
        return 0;
    }

    @Override
    public Arc getTypeGraphArcObject(Type sourceType, Type targetType) {
        return null;
    }

    @Override
    public boolean hasTypeGraphArc() {
        return false;
    }

    @Override
    public boolean isObjectOfTypeGraphArcVisible(Type sourceType, Type targetType) {
        return false;
    }

    @Override
    public void setSourceMax(Type sourceType, Type targetType, int value) {
    }

    @Override
    public void setSourceMin(Type sourceType, Type targetType, int value) {
    }

    @Override
    public void setTargetMax(Type sourceType, Type targetType, int value) {
    }

    @Override
    public void setTargetMin(Type sourceType, Type targetType, int value) {
    }

    @Override
    public void setVisibityOfObjectsOfTypeGraphArc(Type sourceType, Type targetType, boolean vis) {
    }

    @Override
    public boolean hasTypeGraphArc(GraphObject sourceType, GraphObject targetType) {
        return false;
    }

    @Override
    public boolean hasTypeGraphArc(Type sourceType) {
        return false;
    }

    @Override
    public boolean hasTypeGraphArc(Type sourceType, Type targetType) {
        return false;
    }

    @Override
    public boolean isEdgeCreatable(Type sourceType, Type targetType, int level) {
        return false;
    }

    @Override
    public Vector<Type> getTargetsOfArc(Type sourceType) {
        return new Vector<Type>(0);
    }

    public boolean isTypeGraphArcUsed(Arc arc) {
        return false;
    }

    @Override
    public HashMap<Type, HashMap<Type, TypeGraphArc>> getArcTypeGraphObjects() {
        return null;
    }

    @Override
    public TypeGraphArc getSimilarTypeGraphArc(Type sourceType, Type targetType) {
        return null;
    }

    @Override
    public TypeGraphArc getTypeGraphArc(Type sourceType, Type targetType) {
        return null;
    }

    @Override
    public TypeError checkIfEdgeCreatable(Node src, Node tar, int level) {
        return null;
    }

    @Override
    public TypeError checkIfEdgeCreatable(Graph g, Node src, Node tar, int level) {
        return null;
    }

    @Override
    public TypeError checkSourceMax(Graph g, Node src, Node tar) {
        return null;
    }

    @Override
    public TypeError checkTargetMax(Graph g, Node src, Node tar) {
        return null;
    }

    @Override
    public boolean compareTypeGraphArcs(Type t) {
        return false;
    }

    @Override
    public boolean compareTypeGraphArcsMultiplicity(Type t) {
        return false;
    }

    @Override
    public boolean hasChild() {
        return !this.itsChildren.isEmpty();
    }

    @Override
    public boolean hasParent() {
        return !this.itsParents.isEmpty();
    }
}

