/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.dialog;

import agg.editor.impl.EdType;
import agg.editor.impl.EdTypeSet;
import agg.gui.icons.CircleShapeIcon;
import agg.gui.icons.OvalShapeIcon;
import agg.gui.icons.RectShapeIcon;
import agg.gui.icons.RoundRectShapeIcon;
import agg.xt_basis.Type;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;

public class SelectChildOfNodeTypeDialog
extends JDialog
implements ActionListener {
    final JTree typeTree;
    final DefaultTreeModel treeModel;
    final EdTypeSet typeSet;
    final EdType nodeType;
    final Hashtable<DefaultMutableTreeNode, EdType> treeNode2NodeType = new Hashtable();
    final JButton Ok;
    final JButton cancel;
    final JPanel dialogPanel;
    JFrame f;

    public SelectChildOfNodeTypeDialog(JFrame parent, EdTypeSet typeset, EdType nodetype) {
        super(parent, " Node type: <" + nodetype.getName() + "> ", true);
        this.typeSet = typeset;
        this.nodeType = nodetype;
        this.typeTree = new JTree();
        this.typeTree.setCellRenderer(new MyTreeCellRenderer());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.nodeType.getName(), true);
        this.treeNode2NodeType.put(top, this.nodeType);
        this.treeModel = new DefaultTreeModel(top);
        this.typeTree.setModel(this.treeModel);
        this.typeTree.getSelectionModel().setSelectionMode(1);
        this.initTypeTree(top, this.nodeType);
        JLabel text = new JLabel("Please select a child type to be created.");
        this.Ok = new JButton("Ok");
        this.Ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel buttons = new JPanel(new FlowLayout());
        buttons.add(this.Ok);
        buttons.add(this.cancel);
        JPanel below = new JPanel(new BorderLayout());
        below.add((Component)text, "Center");
        below.add((Component)buttons, "South");
        this.dialogPanel = new JPanel(new BorderLayout());
        this.dialogPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.dialogPanel.add((Component)new JScrollPane(this.typeTree), "Center");
        this.dialogPanel.add((Component)below, "South");
        this.dialogPanel.setPreferredSize(new Dimension(300, 200));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.dialogPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocation(100, 100);
        this.setVisible(true);
    }

    private void initTypeTree(DefaultMutableTreeNode treetypenode, EdType nodetype) {
        Vector<Type> children = nodetype.getBasisType().getChildren();
        int i = 0;
        while (i < children.size()) {
            Type childType = children.get(i);
            EdType edchildType = this.typeSet.getNodeType(childType);
            DefaultMutableTreeNode childnode = new DefaultMutableTreeNode(edchildType.getName(), true);
            this.treeNode2NodeType.put(childnode, edchildType);
            this.treeModel.insertNodeInto(childnode, treetypenode, i);
            if (!this.typeTree.isExpanded(this.typeTree.getPathForRow(0))) {
                this.typeTree.expandPath(this.typeTree.getPathForRow(0));
            }
            this.initTypeTree(childnode, edchildType);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            if (this.typeTree.getSelectionPath() == null) {
                String msg = "Please select a child type or cancel this dialog.";
                JOptionPane.showMessageDialog(this, msg);
                return;
            }
            this.setVisible(false);
        } else {
            this.setVisible(false);
        }
    }

    public EdType getSelectedChildType() {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.typeTree.getSelectionPath().getLastPathComponent();
        EdType t = this.treeNode2NodeType.get(treeNode);
        return t;
    }

    public class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        boolean selected;
        final Color SelectedBackgroundColor = new Color(153, 153, 255);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            EdType userObject = SelectChildOfNodeTypeDialog.this.treeNode2NodeType.get(value);
            if (userObject != null) {
                this.setIconTextGap(5);
                Icon icon = this.getNodeTypeIcon(userObject.getShape(), userObject.getColor());
                this.setIcon(icon);
            }
            this.selected = sel;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Color bColor = Color.WHITE;
            Color fColor = Color.BLACK;
            Icon currentI = this.getIcon();
            bColor = this.selected ? this.SelectedBackgroundColor : Color.WHITE;
            g.setColor(bColor);
            this.setForeground(fColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }

        private Icon getNodeTypeIcon(int shape, Color color) {
            Icon icon = null;
            switch (shape) {
                case 51: {
                    icon = new RectShapeIcon(color);
                    break;
                }
                case 54: {
                    icon = new RoundRectShapeIcon(color);
                    break;
                }
                case 52: {
                    icon = new CircleShapeIcon(color);
                    break;
                }
                case 53: {
                    icon = new OvalShapeIcon(color);
                    break;
                }
            }
            return icon;
        }
    }
}

