/*
 * Decompiled with CFR 0.152.
 */
package agg.editor.impl;

import agg.editor.impl.Line;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Arrow
extends Line {
    private double angle;
    private Point top;
    private Point leftEnd;
    private Point rightEnd;
    private Polygon head;
    private int headLength = 12;
    private double headAngle = 0.45;
    private double itsScale = 1.0;
    private int tarH;
    private int tarW;

    public Arrow(Point begin, Point end, int targetWidth, int targetHeight) {
        super(begin.x, begin.y, end.x, end.y);
        this.tarW = targetWidth;
        this.tarH = targetHeight;
        this.head = this.getHeadPolygon();
    }

    public Arrow(int x1, int y1, int x2, int y2, int targetHeight, int targetWidth) {
        this(new Point(x1, y1), new Point(x2, y2), targetHeight, targetWidth);
    }

    public Arrow(int x1, int y1, int x2, int y2) {
        this(new Point(x1, y1), new Point(x2, y2), 0, 0);
    }

    public Arrow(double scale, Point begin, Point end, int targetWidth, int targetHeight, int headSize) {
        super(begin.x, begin.y, end.x, end.y);
        this.tarW = targetWidth;
        this.tarH = targetHeight;
        if (headSize > 0) {
            this.headLength = headSize;
        }
        this.headLength = (int)((double)this.headLength / this.itsScale * scale);
        this.head = this.getHeadPolygon();
        this.itsScale = scale;
    }

    public Arrow(double scale, int x1, int y1, int x2, int y2, int targetHeight, int targetWidth, int headSize) {
        this(scale, new Point(x1, y1), new Point(x2, y2), targetHeight, targetWidth, headSize);
    }

    public Arrow(double scale, int x1, int y1, int x2, int y2) {
        this(scale, new Point(x1, y1), new Point(x2, y2), 0, 0, 0);
    }

    public void draw(Graphics g) {
        if (g == null || this.head == null) {
            return;
        }
        g.fillPolygon(this.head);
    }

    public void draw(Graphics g, boolean filled) {
        if (g == null || this.head == null) {
            return;
        }
        if (filled) {
            g.fillPolygon(this.head);
        } else {
            Color col = g.getColor();
            g.setColor(Color.WHITE);
            g.fillPolygon(this.head);
            g.setColor(col);
            g.drawPolygon(this.head);
        }
    }

    public Point getHeadEnd() {
        return this.top;
    }

    public Point getLeftEnd() {
        return this.leftEnd;
    }

    public Point getRightEnd() {
        return this.rightEnd;
    }

    private double getAngle() {
        double dX = Math.abs(this.x2 - this.x1);
        double dY = Math.abs(this.y2 - this.y1);
        double winkel = Math.atan(dY / dX);
        return winkel;
    }

    private Point getTopOfHead(int factorX, int factorY) {
        this.angle = this.getAngle();
        int halfW = this.tarW / 2;
        int ext = 3;
        int halfH = this.tarH / 2;
        Rectangle tarRect = new Rectangle(this.x2 - halfW - ext, this.y2 - halfH - ext, this.tarW + ext * 2, this.tarH + ext * 2);
        int topX = this.x2 + halfW * factorX;
        int d = (int)(Math.tan(this.angle) * (double)halfW);
        int topY = this.y2 + d * factorY;
        if (!tarRect.contains(new Point(topX, topY)) && !tarRect.contains(new Point(topX = this.x2 + (d = (int)((double)halfH / Math.tan(this.angle))) * factorX, topY = this.y2 + halfH * factorY))) {
            return null;
        }
        return new Point(topX, topY);
    }

    private Point getLeftEndOfHead() {
        if (this.top == null) {
            return null;
        }
        int xLE = this.top.x - (int)(Math.cos(this.angle - this.headAngle) * (double)this.headLength);
        int yLE = this.top.y - (int)(Math.sin(this.angle - this.headAngle) * (double)this.headLength);
        return new Point(xLE, yLE);
    }

    private Point getRightEndOfHead() {
        if (this.top == null) {
            return null;
        }
        int xRE = this.top.x - (int)(Math.cos(this.angle + this.headAngle) * (double)this.headLength);
        int yRE = this.top.y - (int)(Math.sin(this.angle + this.headAngle) * (double)this.headLength);
        return new Point(xRE, yRE);
    }

    private Polygon getHeadPolygon() {
        if (this.x2 > this.x1 && this.y2 == this.y1) {
            this.angle = 0.0;
            this.top = new Point(this.x2 - this.tarW / 2, this.y2);
        } else if (this.x2 < this.x1 && this.y2 == this.y1) {
            this.angle = Math.PI;
            this.top = new Point(this.x2 + this.tarW / 2, this.y2);
        } else if (this.x2 == this.x1 && this.y2 > this.y1) {
            this.angle = 1.5707963267948966;
            this.top = new Point(this.x2, this.y2 - this.tarH / 2);
        } else if (this.x2 == this.x1 && this.y2 < this.y1) {
            this.angle = 4.71238898038469;
            this.top = new Point(this.x2, this.y2 + this.tarH / 2);
        } else if (this.x2 > this.x1 && this.y2 > this.y1) {
            this.top = this.getTopOfHead(-1, -1);
        } else if (this.x2 < this.x1 && this.y2 < this.y1) {
            this.top = this.getTopOfHead(1, 1);
            this.angle = Math.PI + this.angle;
        } else if (this.x2 < this.x1 && this.y2 > this.y1) {
            this.top = this.getTopOfHead(1, -1);
            this.angle = Math.PI - this.angle;
        } else if (this.x2 > this.x1 && this.y2 < this.y1) {
            this.top = this.getTopOfHead(-1, 1);
            this.angle = Math.PI * 2 - this.angle;
        } else if (this.x2 == this.x1 && this.y2 == this.y1) {
            this.angle = 0.0;
            this.top = new Point(0, 0);
        }
        this.leftEnd = this.getLeftEndOfHead();
        this.rightEnd = this.getRightEndOfHead();
        if (this.top == null || this.leftEnd == null || this.rightEnd == null) {
            return null;
        }
        int[] xArray = new int[]{this.top.x, this.leftEnd.x, this.rightEnd.x};
        int[] yArray = new int[]{this.top.y, this.leftEnd.y, this.rightEnd.y};
        Polygon polygon = new Polygon(xArray, yArray, 3);
        return polygon;
    }
}

