/*
 * Decompiled with CFR 0.152.
 */
package agg.attribute.view.impl;

import agg.attribute.impl.AttrObject;
import agg.util.Disposable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class SlotSequence
extends AttrObject
implements Disposable {
    protected Vector<Slot> slots = new Vector(10, 10);
    static final long serialVersionUID = 3923744045591286915L;
    private static transient int COUNTER = 0;

    public SlotSequence() {
        ++COUNTER;
    }

    protected void finalize() {
        --COUNTER;
    }

    @Override
    public void dispose() {
        System.out.println("SlotSequence.dispose  ");
    }

    public synchronized int getSize() {
        return this.slots.size();
    }

    public synchronized int getIndexAt(int slot) {
        if (slot == -1 || slot >= this.getSize()) {
            return this.getSize() - 1;
        }
        return this.slots.elementAt(slot).getIndex();
    }

    public int getSlotForIndex(int index) {
        Enumeration<Slot> en = this.slots.elements();
        int slot = 0;
        while (en.hasMoreElements()) {
            int in = en.nextElement().getIndex();
            if (in == index) {
                return slot;
            }
            ++slot;
        }
        return -1;
    }

    public synchronized void addSlot(int index) {
        Slot newSlot = new Slot(index);
        this.slots.addElement(newSlot);
    }

    public void incrementAllGreaterThan(int index) {
        Enumeration<Slot> en = this.slots.elements();
        while (en.hasMoreElements()) {
            Slot slot = en.nextElement();
            int in = slot.getIndex();
            if (in <= index) continue;
            slot.setIndex(in + 1);
        }
    }

    public synchronized void deleteSlot(int slot) {
        if (slot >= this.getSize()) {
            this.warn("deleteSlot(): slot=" + slot + " >= size=" + this.getSize(), true);
            return;
        }
        this.slots.removeElementAt(slot);
    }

    public void decrementAllGreaterThan(int index) {
        Enumeration<Slot> en = this.slots.elements();
        while (en.hasMoreElements()) {
            Slot slot = en.nextElement();
            int in = slot.getIndex();
            if (in <= index) continue;
            slot.setIndex(in - 1);
        }
    }

    public void deleteSlotForIndex(int index) {
        int slot = this.getSlotForIndex(index);
        if (slot != -1) {
            this.deleteSlot(slot);
        }
    }

    public void moveSlotInserting(int srcSlot, int destSlot) {
        if (srcSlot == destSlot || srcSlot == destSlot - 1) {
            return;
        }
        int sSlot = srcSlot;
        Slot slotObj = this.slots.elementAt(sSlot);
        if (destSlot >= this.getSize()) {
            this.slots.addElement(slotObj);
        } else {
            this.slots.insertElementAt(slotObj, destSlot);
        }
        if (sSlot > destSlot) {
            ++sSlot;
        }
        this.slots.removeElementAt(sSlot);
    }

    @Override
    public String toString() {
        String log = null;
        try {
            log = "(";
            int i = 0;
            while (i < this.slots.size()) {
                Slot slot = this.slots.get(i);
                log = String.valueOf(log) + slot.getIndex() + ",";
                ++i;
            }
        }
        catch (NullPointerException e) {
            log = "(???)";
        }
        return log;
    }

    class Slot
    implements Serializable {
        protected int index;
        static final long serialVersionUID = -6821223290051933180L;

        public Slot(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

